/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import zeus.actors.Server;
import zeus.concepts.Performative;
import zeus.concepts.PerformativeParser;
import zeus.util.Core;

class Connection {
    protected static int BUF_SIZ = 1000;
    private static Integer token;
    protected Socket client;
    protected Server server;
    protected BufferedInputStream ins;
    String id = null;

    public Connection() {
    }

    public Connection(Socket socket, Server server, String string) {
        this.id = string;
        if (token == null) {
            token = new Integer(0);
        }
        this.client = socket;
        this.server = server;
        try {
            this.ins = new BufferedInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            System.err.println("Exception while getting socket streams: " + iOException);
            iOException.printStackTrace();
            try {
                socket.close();
                socket = null;
            }
            catch (IOException iOException2) {
                System.err.println("Exception while closing client: " + iOException2);
                iOException2.printStackTrace();
            }
            return;
        }
        this.run();
    }

    public void run() {
        boolean bl = false;
        while (!bl) {
            int n = 0;
            boolean bl2 = true;
            byte[] byArray = new byte[BUF_SIZ];
            String string = new String("");
            while (!bl) {
                try {
                    Thread.yield();
                    n = this.ins.read(byArray);
                }
                catch (IOException iOException) {
                    Core.DEBUG(1, "IOException: " + iOException);
                    iOException.printStackTrace();
                    this.server.updateCount(-1);
                    try {
                        this.ins.close();
                        this.ins = null;
                        this.client.close();
                        this.client = null;
                    }
                    catch (IOException iOException2) {
                        System.err.println(iOException2);
                        iOException2.printStackTrace();
                    }
                    return;
                }
                if (n == -1) {
                    bl = true;
                    this.debug("x was -1 (done)");
                    continue;
                }
                if (n < BUF_SIZ) {
                    bl = true;
                    string = string + new String(byArray, 0, n);
                    this.debug(n + " bytes read (less than BUF_SIZ), " + "assuming end of buffer.");
                    continue;
                }
                string = string + new String(byArray, 0, n);
                this.debug(n + " bytes read (BUF_SIZ), continuing.");
            }
            byArray = null;
            if (string.equals("")) {
                System.err.println("No data read from stream");
                return;
            }
            try {
                PerformativeParser performativeParser = new PerformativeParser(new ByteArrayInputStream(string.getBytes()));
                Performative performative = performativeParser.Message();
                this.debug("trying test");
                if (!performative.isValid()) {
                    this.debug("not valid");
                    return;
                }
                this.debug("Sending message to mhandler");
                this.server.newMsg(performative);
            }
            catch (Exception exception) {
                this.debug("in exception handler");
                return;
            }
            catch (Error error) {
                error.printStackTrace();
                this.debug("in error handler");
                return;
            }
            this.debug("after try catch block");
        }
        try {
            this.server = null;
            if (this.ins != null) {
                this.ins.close();
                this.ins = null;
            }
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            this.id = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isEncrypted(String string) {
        return string.startsWith("encrypted");
    }

    protected void finalize() {
        try {
            if (this.ins != null) {
                this.ins.close();
            }
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return " connected to: " + this.client.getInetAddress().getHostName() + ":" + this.client.getPort();
    }

    private void debug(String string) {
        System.out.println("Connection>> " + string);
    }
}

