/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.event.AbilityEvent;
import zeus.actors.event.AbilityMonitor;
import zeus.concepts.AbilityDbItem;
import zeus.concepts.AbilitySpec;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.HSet;

public class AbilityDb
extends Hashtable {
    private HSet[] eventMonitor = new HSet[4];
    private static final int ADD = 0;
    private static final int MODIFY = 1;
    private static final int DELETE = 2;
    private static final int ACCESS = 3;
    protected Vector knownAgents = new Vector(100);
    protected AgentContext context = null;
    protected GenSym gensym = null;
    protected String agentName = null;

    public AbilityDb() {
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
    }

    public AbilityDb(AgentContext agentContext) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        this.gensym = agentContext.getGenSym();
        this.agentName = agentContext.whoami();
        for (int i = 0; i < this.eventMonitor.length; ++i) {
            this.eventMonitor[i] = new HSet();
        }
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    protected boolean addItem(String string, Vector vector) {
        if (!vector.contains(string)) {
            vector.addElement(string);
            return true;
        }
        return false;
    }

    private boolean member(AbilityDbItem abilityDbItem, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            AbilityDbItem abilityDbItem2 = (AbilityDbItem)vector.elementAt(i);
            this.notifyMonitors(abilityDbItem2, 3);
            if (!abilityDbItem.equals(abilityDbItem2)) continue;
            return true;
        }
        return false;
    }

    public void add(String string, AbilityDbItem abilityDbItem) {
        AbilityDbItem abilityDbItem2 = abilityDbItem.duplicate("var", this.gensym);
        this.addItem(abilityDbItem2.getAgent(), this.knownAgents);
        Vector<AbilityDbItem> vector = (Vector<AbilityDbItem>)this.get(string);
        if (vector == null) {
            vector = new Vector<AbilityDbItem>(10);
            this.put(string, vector);
        }
        if (!this.member(abilityDbItem2, vector)) {
            vector.addElement(abilityDbItem2);
            this.notifyMonitors(abilityDbItem2, 0);
        }
    }

    public void add(String string, AbilitySpec abilitySpec) {
        String string2 = abilitySpec.getType();
        AbilityDbItem abilityDbItem = new AbilityDbItem(string, abilitySpec);
        this.add(string2, abilityDbItem);
    }

    public void add(String string, Vector vector) {
        block4: {
            Object e;
            block3: {
                if (vector.isEmpty()) {
                    return;
                }
                e = vector.elementAt(0);
                if (!(e instanceof AbilityDbItem)) break block3;
                for (int i = 0; i < vector.size(); ++i) {
                    this.add(string, (AbilityDbItem)vector.elementAt(i));
                }
                break block4;
            }
            if (!(e instanceof AbilitySpec)) break block4;
            for (int i = 0; i < vector.size(); ++i) {
                this.add(string, (AbilitySpec)vector.elementAt(i));
            }
        }
    }

    public void add(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            AbilityDbItem abilityDbItem = (AbilityDbItem)vector.elementAt(i);
            String string = abilityDbItem.getAbility().getType();
            this.add(string, abilityDbItem);
        }
    }

    public void add(AbilityDbItem abilityDbItem) {
        String string = abilityDbItem.getAbility().getType();
        this.add(string, abilityDbItem);
    }

    public void modify(AbilityDbItem abilityDbItem, AbilityDbItem abilityDbItem2) {
        this.del(abilityDbItem.getAbility().getType(), abilityDbItem);
        this.add(abilityDbItem2);
    }

    public void del(String string, AbilityDbItem abilityDbItem) {
        Vector vector = (Vector)this.get(string);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbilityDbItem abilityDbItem2 = (AbilityDbItem)vector.elementAt(i);
            if (!abilityDbItem2.equals(abilityDbItem)) continue;
            vector.removeElementAt(i--);
            this.notifyMonitors(abilityDbItem2, 2);
        }
        if (vector.isEmpty()) {
            this.remove(string);
        }
    }

    public void del(String string, AbilitySpec abilitySpec) {
        String string2 = abilitySpec.getType();
        AbilityDbItem abilityDbItem = new AbilityDbItem(string, abilitySpec);
        this.del(string2, abilityDbItem);
    }

    public void del(String string, Vector vector) {
        block4: {
            Object e;
            block3: {
                if (vector.isEmpty()) {
                    return;
                }
                e = vector.elementAt(0);
                if (!(e instanceof AbilityDbItem)) break block3;
                for (int i = 0; i < vector.size(); ++i) {
                    this.del(string, (AbilityDbItem)vector.elementAt(i));
                }
                break block4;
            }
            if (!(e instanceof AbilitySpec)) break block4;
            for (int i = 0; i < vector.size(); ++i) {
                this.del(string, (AbilitySpec)vector.elementAt(i));
            }
        }
    }

    public AbilityDbItem findOne(AbilitySpec abilitySpec) {
        AbilityDbItem abilityDbItem = null;
        Vector vector = (Vector)this.get(abilitySpec.getType());
        if (vector == null) {
            return null;
        }
        Vector vector2 = this.reduce(vector, abilitySpec);
        if (vector2 == null) {
            return null;
        }
        if (vector2.size() > 0) {
            int n = (int)(Math.random() * (double)vector2.size());
            abilityDbItem = (AbilityDbItem)vector2.elementAt(n);
            this.notifyMonitors(abilityDbItem, 3);
        }
        vector2 = null;
        return abilityDbItem;
    }

    public Vector findAll(AbilitySpec abilitySpec) {
        Vector vector = (Vector)this.get(abilitySpec.getType());
        if (vector == null) {
            return new Vector(100);
        }
        Core.DEBUG(3, "AbilityDb findAll: " + abilitySpec + "\n" + vector);
        Vector vector2 = this.reduce(vector, abilitySpec);
        return vector2;
    }

    public Vector abilitiesOf(String string) {
        Vector<AbilitySpec> vector = new Vector<AbilitySpec>(100);
        Vector vector2 = null;
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            vector2 = (Vector)this.get(string2);
            for (int i = 0; i < vector2.size(); ++i) {
                AbilityDbItem abilityDbItem = (AbilityDbItem)vector2.elementAt(i);
                this.notifyMonitors(abilityDbItem, 3);
                if (!abilityDbItem.getAgent().equals(string)) continue;
                vector.addElement(new AbilitySpec(abilityDbItem.getAbility()));
            }
        }
        return vector;
    }

    protected Vector reduce(Vector vector, AbilitySpec abilitySpec) {
        Vector<AbilityDbItem> vector2 = new Vector<AbilityDbItem>(100);
        Bindings bindings = new Bindings(this.agentName);
        Fact fact = abilitySpec.getFact();
        int n = abilitySpec.getTime();
        double d = abilitySpec.getCost();
        for (int i = 0; i < vector.size(); ++i) {
            AbilityDbItem abilityDbItem = (AbilityDbItem)vector.elementAt(i);
            this.notifyMonitors(abilityDbItem, 3);
            AbilitySpec abilitySpec2 = abilityDbItem.getAbility();
            Fact fact2 = abilitySpec2.getFact();
            int n2 = abilitySpec2.getTime();
            double d3 = abilitySpec2.getCost();
            if ((n == 0 || n2 <= n) && (d == 0.0 || d3 <= d) && fact2.unifiesWith(fact, bindings)) {
                vector2.addElement(abilityDbItem);
            } else {
                Core.DEBUG(3, "Cannot unify abilities:\n" + abilitySpec + "\n" + abilityDbItem);
            }
            bindings.clear();
        }
        return vector2;
    }

    public void addAbilityMonitor(AbilityMonitor abilityMonitor, long l, boolean bl) {
        this.addAbilityMonitor(abilityMonitor, l);
        if (!bl) {
            return;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                AbilityDbItem abilityDbItem = (AbilityDbItem)vector.elementAt(i);
                AbilityEvent abilityEvent = new AbilityEvent(this, abilityDbItem, 8L);
                abilityMonitor.abilityAccessedEvent(abilityEvent);
                abilityEvent = new AbilityEvent(this, abilityDbItem, 1L);
                abilityMonitor.abilityAddedEvent(abilityEvent);
            }
        }
    }

    public void addAbilityMonitor(AbilityMonitor abilityMonitor, long l) {
        Assert.notNull(abilityMonitor);
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(abilityMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].add(abilityMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(abilityMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].add(abilityMonitor);
        }
    }

    public void removeAbilityMonitor(AbilityMonitor abilityMonitor, long l) {
        Assert.notNull(abilityMonitor);
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(abilityMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].remove(abilityMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(abilityMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].remove(abilityMonitor);
        }
    }

    private void notifyMonitors(AbilityDbItem abilityDbItem, int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 0: {
                AbilityEvent abilityEvent = new AbilityEvent(this, abilityDbItem, 1L);
                while (enumeration.hasMoreElements()) {
                    AbilityMonitor abilityMonitor = (AbilityMonitor)enumeration.nextElement();
                    abilityMonitor.abilityAddedEvent(abilityEvent);
                }
                break;
            }
            case 1: {
                AbilityEvent abilityEvent = new AbilityEvent(this, abilityDbItem, 2L);
                while (enumeration.hasMoreElements()) {
                    AbilityMonitor abilityMonitor = (AbilityMonitor)enumeration.nextElement();
                    abilityMonitor.abilityModifiedEvent(abilityEvent);
                }
                break;
            }
            case 2: {
                AbilityEvent abilityEvent = new AbilityEvent(this, abilityDbItem, 4L);
                while (enumeration.hasMoreElements()) {
                    AbilityMonitor abilityMonitor = (AbilityMonitor)enumeration.nextElement();
                    abilityMonitor.abilityDeletedEvent(abilityEvent);
                }
                break;
            }
            case 3: {
                AbilityEvent abilityEvent = new AbilityEvent(this, abilityDbItem, 8L);
                while (enumeration.hasMoreElements()) {
                    AbilityMonitor abilityMonitor = (AbilityMonitor)enumeration.nextElement();
                    abilityMonitor.abilityAccessedEvent(abilityEvent);
                }
                break;
            }
        }
    }
}

