/*
 * Decompiled with CFR 0.152.
 */
package sl;

import java.util.ArrayList;
import java.util.List;
import sl.CaseInsensitiveString;

public class SlotDescriptor {
    private CaseInsensitiveString name;
    private int category;
    private String type;
    private boolean optionality;
    static final List primitiveTypes = new ArrayList(12);

    public SlotDescriptor(String string, int n, String string2, boolean bl) {
        this.name = new CaseInsensitiveString(string);
        this.category = n;
        this.type = string2;
        this.optionality = bl;
    }

    public SlotDescriptor(int n, String string, boolean bl) {
        this("", n, string, bl);
    }

    public String getName() {
        return this.name.toString();
    }

    public int getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasPrimitiveType() {
        return primitiveTypes.contains(this.type);
    }

    public boolean isOptional() {
        return this.optionality;
    }

    public boolean isComplex() {
        return this.category == 12;
    }

    public boolean isSet() {
        return this.category == 13 || this.category == 14;
    }

    public boolean isPrimitive() {
        return this.category == 15;
    }

    void setName(String string) {
        this.name = new CaseInsensitiveString(string);
    }

    public String toString() {
        return this.name.toString() + " of category " + this.category + " and type " + this.type + " and optionality " + this.optionality;
    }

    static {
        primitiveTypes.add("java.lang.Boolean");
        primitiveTypes.add("java.lang.Byte");
        primitiveTypes.add("java.lang.Character");
        primitiveTypes.add("java.lang.Double");
        primitiveTypes.add("java.lang.Float");
        primitiveTypes.add("java.lang.Integer");
        primitiveTypes.add("java.lang.Long");
        primitiveTypes.add("java.lang.Short");
        primitiveTypes.add("java.lang.String");
        primitiveTypes.add("java.lang.Byte[]");
        primitiveTypes.add("java.util.Date");
        primitiveTypes.add("java.lang.Object");
    }
}

