/*
 * Decompiled with CFR 0.152.
 */
package sl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sl.CaseInsensitiveString;
import sl.Frame;
import sl.Ontology;
import sl.OntologyException;
import sl.SlotDescriptor;

class FrameSchema
implements Cloneable,
Serializable {
    private Ontology myOntology;
    private CaseInsensitiveString myName;
    private List slots;

    public FrameSchema(Ontology ontology, String string) {
        this.myOntology = ontology;
        this.myName = new CaseInsensitiveString(string);
        this.slots = new ArrayList();
    }

    public String getName() {
        return this.myName.toString();
    }

    public void addSlot(SlotDescriptor slotDescriptor) {
        this.slots.add(slotDescriptor);
    }

    private boolean isGoodPrimitiveType(String string, Object object) {
        try {
            return Class.forName(string).isInstance(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void checkAgainst(Frame frame) throws OntologyException {
        for (int i = 0; i < this.slots.size(); ++i) {
            SlotDescriptor slotDescriptor = (SlotDescriptor)this.slots.get(i);
            String string = slotDescriptor.getName();
            if (slotDescriptor.isOptional()) continue;
            Object object = frame.getSlot(string);
            if (slotDescriptor.isPrimitive()) {
                if (this.isGoodPrimitiveType(slotDescriptor.getType(), object)) continue;
                throw new WrongSlotTypeException(frame.getName(), string, slotDescriptor.getType());
            }
            if (!(object instanceof Frame)) {
                throw new WrongSlotTypeException(frame.getName(), string, "Frame");
            }
            this.myOntology.check((Frame)object);
        }
    }

    Iterator subSchemas() {
        return this.slots.iterator();
    }

    SlotDescriptor[] slotsArray() {
        Object[] objectArray = this.slots.toArray();
        SlotDescriptor[] slotDescriptorArray = new SlotDescriptor[objectArray.length];
        System.arraycopy(objectArray, 0, slotDescriptorArray, 0, objectArray.length);
        return slotDescriptorArray;
    }

    static class WrongSlotTypeException
    extends OntologyException {
        public WrongSlotTypeException(String string, String string2, String string3) {
            super("No slot of type " + string3 + " named " + string2 + " in functor " + string);
        }
    }
}

