/*
 * Decompiled with CFR 0.152.
 */
package sl;

import java.util.ArrayList;
import java.util.List;
import sl.CaseInsensitiveString;
import sl.OntologyException;

public class Frame {
    private String myName;
    private List slotNames;
    private List slotValues;
    public static String UNNAMEDPREFIX = "_JADE.UNNAMED";

    public Frame(String string) {
        this.myName = string;
        this.slotNames = new ArrayList();
        this.slotValues = new ArrayList();
    }

    public String getName() {
        return this.myName;
    }

    public void putSlot(String string, Object object) {
        this.slotNames.add(new CaseInsensitiveString(string));
        this.slotValues.add(object);
    }

    public void putSlot(Object object) {
        String string = UNNAMEDPREFIX + Integer.toString(this.slotValues.size());
        while (this.slotNames.contains(string)) {
            string = string + "_";
        }
        this.putSlot(string, object);
    }

    public Object getSlot(String string) throws OntologyException {
        int n = this.slotNames.indexOf(new CaseInsensitiveString(string));
        if (n < 0) {
            throw new NoSuchSlotException(this.myName, string);
        }
        return this.getSlot(n);
    }

    public Object getSlot(int n) throws OntologyException {
        try {
            return this.slotValues.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchSlotException(this.myName, "@" + n);
        }
    }

    public int size() {
        return this.slotNames.size();
    }

    public String getSlotName(int n) throws OntologyException {
        try {
            return ((CaseInsensitiveString)this.slotNames.get(n)).toString();
        }
        catch (Exception exception) {
            throw new NoSuchSlotException(this.myName, "at position" + n);
        }
    }

    public String toString() {
        String string = "(" + this.getName() + " ";
        try {
            for (int i = 0; i < this.size(); ++i) {
                string = string + ':' + this.getSlotName(i) + " " + this.getSlot(i).toString() + " ";
            }
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
        }
        return string + ") ";
    }

    static class NoSuchSlotException
    extends OntologyException {
        public NoSuchSlotException(String string, String string2) {
            super("No slot named " + string2 + " in frame " + string);
        }
    }
}

