/*
 * Decompiled with CFR 0.152.
 */
package sl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sl.AnOntology;
import sl.CaseInsensitiveString;
import sl.CodecException;
import sl.Frame;
import sl.FrameSchema;
import sl.JADEMetaOntology;
import sl.Ontology;
import sl.OntologyException;
import sl.Role;
import sl.SL0Codec;
import sl.Slot;
import sl.SlotDescriptor;

public final class DefaultOntology
implements Ontology {
    private Map schemas = new HashMap();
    private Map roleClasses = new HashMap();
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class array$Ljava$lang$Byte;

    FrameSchema lookupSchema(String string) {
        return (FrameSchema)this.schemas.get(new CaseInsensitiveString(string));
    }

    public void addRole(String string, SlotDescriptor[] slotDescriptorArray) throws OntologyException {
        if (this.lookupSchema(string) != null) {
            throw new OntologyException("A role with name \"" + string + "\" already exists in the ontology");
        }
        FrameSchema frameSchema = new FrameSchema(this, string);
        for (int i = 0; i < slotDescriptorArray.length; ++i) {
            String string2 = slotDescriptorArray[i].getName();
            if (string2.length() == 0) {
                slotDescriptorArray[i].setName(Frame.UNNAMEDPREFIX + "_" + i);
            }
            frameSchema.addSlot(slotDescriptorArray[i]);
        }
        this.addSchemaToTable(string, frameSchema);
    }

    public void addRole(String string, SlotDescriptor[] slotDescriptorArray, Class clazz) throws OntologyException {
        if (this.roleClasses.containsValue(clazz)) {
            throw new OntologyException("The class \"" + clazz.getName() + "\" already represents a role in this ontology");
        }
        this.addRole(string, slotDescriptorArray);
        this.checkClass(string, clazz);
        this.roleClasses.put(new CaseInsensitiveString(string), clazz);
    }

    public void joinOntology(Ontology ontology) throws OntologyException {
        Iterator iterator = ontology.getVocabulary().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SlotDescriptor[] slotDescriptorArray = ontology.getSlots(string);
            Class clazz = ontology.getClassForRole(string);
            if (clazz != null) {
                this.addRole(string, slotDescriptorArray, clazz);
                continue;
            }
            this.addRole(string, slotDescriptorArray);
        }
    }

    public List createObject(List list) throws OntologyException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.createSingleObject((Frame)list.get(i)));
        }
        return arrayList;
    }

    private Object createSingleObject(Frame frame) throws OntologyException {
        String string = frame.getName();
        Class clazz = this.getClassForRole(string);
        if (clazz == null) {
            throw new OntologyException("No class able to represent " + string + " role. Check the definition of the ontology.");
        }
        Object object = this.create(frame);
        return this.initObject(frame, object, clazz);
    }

    public Frame createFrame(Object object, String string) throws OntologyException {
        Class clazz = this.getClassForRole(string);
        if (clazz == null) {
            throw new OntologyException("No class able to represent " + string + " role. Check the definition of the ontology.");
        }
        if (!clazz.isInstance(object)) {
            throw new OntologyException("The object <" + object + "> is not an instance of " + clazz.getName() + " class.");
        }
        FrameSchema frameSchema = this.lookupSchema(string);
        if (frameSchema == null) {
            throw new OntologyException("Internal error: inconsistency between schema and class table");
        }
        Frame frame = new Frame(string);
        this.buildFromObject(frame, frameSchema, object, clazz);
        return frame;
    }

    public void check(Frame frame) throws OntologyException {
        String string = frame.getName();
        FrameSchema frameSchema = this.lookupSchema(string);
        frameSchema.checkAgainst(frame);
    }

    public void check(Object object, String string) throws OntologyException {
        Class clazz = this.getClassForRole(string);
        if (clazz == null) {
            throw new OntologyException("No class able to represent " + string + " role.");
        }
        if (!clazz.isInstance(object)) {
            throw new OntologyException("The object is not an instance of " + clazz.getName() + " class.");
        }
        FrameSchema frameSchema = this.lookupSchema(string);
        Iterator iterator = frameSchema.subSchemas();
        while (iterator.hasNext()) {
            SlotDescriptor slotDescriptor = (SlotDescriptor)iterator.next();
            Method method = this.findMethodCaseInsensitive("get" + this.translateName(slotDescriptor.getName()), clazz);
            try {
                Object object2 = method.invoke(object, new Object[0]);
                if (!slotDescriptor.isOptional() && object2 == null) {
                    throw new OntologyException("The given object has a 'null' value for the mandatory term " + slotDescriptor.getName());
                }
                if (!slotDescriptor.isComplex() && !slotDescriptor.isSet()) continue;
                this.check(object2, slotDescriptor.getType());
            }
            catch (InvocationTargetException invocationTargetException) {
                String string2 = invocationTargetException.getTargetException().getMessage();
                throw new OntologyException("Internal error: a reflected method threw an exception.\nMessage was " + string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new OntologyException("Internal error: the required method is not accessible [" + illegalAccessException.getMessage() + "]");
            }
            catch (SecurityException securityException) {
                throw new OntologyException("Wrong class: some required method is not accessible.");
            }
        }
    }

    public boolean isRole(String string) throws OntologyException {
        FrameSchema frameSchema = this.lookupSchema(string);
        return frameSchema != null;
    }

    public SlotDescriptor[] getSlots(String string) throws OntologyException {
        FrameSchema frameSchema = this.lookupSchema(string);
        return frameSchema.slotsArray();
    }

    public String getRoleName(Class clazz) throws OntologyException {
        Iterator iterator = this.roleClasses.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!clazz.equals((Class)entry.getValue())) continue;
            return ((CaseInsensitiveString)entry.getKey()).toString();
        }
        throw new OntologyException("No rolename registered in this ontology for class " + clazz.getName());
    }

    public List getVocabulary() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.schemas.keySet().iterator();
        while (iterator.hasNext()) {
            String string = ((CaseInsensitiveString)iterator.next()).toString();
            arrayList.add(string);
        }
        return arrayList;
    }

    public Class getClassForRole(String string) {
        return (Class)this.roleClasses.get(new CaseInsensitiveString(string));
    }

    private String translateName(String string) {
        StringBuffer stringBuffer = string.startsWith(Frame.UNNAMEDPREFIX) ? new StringBuffer(string.substring(Frame.UNNAMEDPREFIX.length())) : new StringBuffer(string);
        block4: for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case ':': {
                    stringBuffer.deleteCharAt(i);
                    --i;
                    continue block4;
                }
                case '-': {
                    stringBuffer.deleteCharAt(i);
                    stringBuffer.setCharAt(i, Character.toUpperCase(stringBuffer.charAt(i)));
                    --i;
                }
            }
        }
        return new String(stringBuffer);
    }

    private Class checkGetAndSet(String string, Class clazz) throws OntologyException {
        Method method = this.findMethodCaseInsensitive("get" + string, clazz);
        Method method2 = this.findMethodCaseInsensitive("set" + string, clazz);
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length > 0) {
            throw new OntologyException("Wrong class: method " + method.getName() + "() must take no arguments.");
        }
        Class<?> clazz2 = method.getReturnType();
        Class<?>[] classArray2 = method2.getParameterTypes();
        if (classArray2.length != 1 || !classArray2[0].equals(clazz2)) {
            throw new OntologyException("Wrong class: method " + method2.getName() + "() must take a single argument of type " + clazz2.getName() + ".");
        }
        Class<?> clazz3 = method2.getReturnType();
        if (!clazz3.equals(Void.TYPE)) {
            throw new OntologyException("Wrong class: method " + method2.getName() + "() must return void.");
        }
        return clazz2;
    }

    private int getArgumentLength(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        return classArray.length;
    }

    private Class getReturnType(Method method) {
        return method.getReturnType();
    }

    private Class getArgumentType(Method method, int n) {
        Class<?>[] classArray = method.getParameterTypes();
        return classArray[n];
    }

    private Class checkGetAndSet2(String string, Class clazz) throws OntologyException {
        Method method = this.findMethodCaseInsensitive("getAll" + string, clazz);
        Method method2 = this.findMethodCaseInsensitive("add" + string, clazz);
        Class clazz2 = this.getArgumentType(method2, 0);
        if (this.getArgumentLength(method) != 0) {
            throw new OntologyException("Wrong class: method " + method.getName() + "() must take no arguments.");
        }
        if (!this.getReturnType(method).equals(class$java$util$Iterator == null ? (class$java$util$Iterator = DefaultOntology.class$("java.util.Iterator")) : class$java$util$Iterator)) {
            throw new OntologyException("Wrong class: method " + method.getName() + "() must return a java.util.Iterator." + this.getReturnType(method).toString());
        }
        if (this.getArgumentLength(method2) != 1) {
            throw new OntologyException("Wrong class: method " + method2.getName() + "() must take one argument.");
        }
        if (!this.getArgumentType(method2, 0).equals(clazz2)) {
            throw new OntologyException("Wrong class: method " + method2.getName() + "() has the wrong argument type.");
        }
        if (!this.getReturnType(method2).equals(Void.TYPE)) {
            throw new OntologyException("Wrong class: method " + method2.getName() + "() must return a void.");
        }
        return clazz2;
    }

    private void checkClass(String string, Class clazz) throws OntologyException {
        FrameSchema frameSchema = this.lookupSchema(string);
        if (frameSchema == null) {
            throw new OntologyException("No schema was found for " + string + "role.");
        }
        Iterator iterator = frameSchema.subSchemas();
        while (iterator.hasNext()) {
            SlotDescriptor slotDescriptor = (SlotDescriptor)iterator.next();
            String string2 = this.translateName(slotDescriptor.getName());
            try {
                Class<?> clazz2;
                Class clazz3 = slotDescriptor.isSet() ? this.checkGetAndSet2(string2, clazz) : this.checkGetAndSet(string2, clazz);
                if (slotDescriptor.isComplex() || slotDescriptor.isSet()) {
                    clazz2 = this.getClassForRole(slotDescriptor.getType());
                    if (clazz2 == null || clazz3.isAssignableFrom(clazz2)) continue;
                    throw new OntologyException("Wrong class: the " + slotDescriptor.getName() + " role is represented by " + clazz2 + " class, which is not a subtype of " + clazz3 + " class.");
                }
                clazz2 = null;
                try {
                    clazz2 = Class.forName(slotDescriptor.getType());
                    if (clazz3.isAssignableFrom(clazz2)) continue;
                    throw new OntologyException("1 Wrong class: the primitive slot " + slotDescriptor.getName() + " is of type " + clazz3 + ", but must be a subtype of " + clazz2 + ".");
                }
                catch (Exception exception) {
                    try {
                        String string3 = slotDescriptor.getType();
                        Class<?> clazz4 = clazz3.getComponentType();
                        if (string3.endsWith("[]") && clazz4 != null) {
                            String string4 = string3.substring(0, string3.length() - 2);
                            clazz2 = Class.forName(string4);
                            if (clazz4.isAssignableFrom(clazz2)) continue;
                            throw new OntologyException("2 Wrong class: the primitive slot " + slotDescriptor.getName() + " is of type " + clazz4 + "[], but must be a subtype of " + clazz2 + "[].");
                        }
                        throw new OntologyException("3 Wrong class: the primitive slot " + slotDescriptor.getName() + " is of type " + clazz3 + ", but must be a subtype of " + clazz2 + ".");
                    }
                    catch (Exception exception2) {
                        throw new OntologyException("4 Wrong class: the primitive slot " + slotDescriptor.getName() + " is of type " + clazz3 + ", but must be a subtype of " + slotDescriptor.getType() + ".");
                    }
                }
            }
            catch (SecurityException securityException) {
                throw new OntologyException("Wrong class: some required method is not accessible.");
            }
        }
    }

    private Object initObject(Frame frame, Object object, Class clazz) throws OntologyException {
        String string = frame.getName();
        FrameSchema frameSchema = this.lookupSchema(string);
        Iterator iterator = frameSchema.subSchemas();
        int n = 0;
        while (iterator.hasNext()) {
            Object object2;
            SlotDescriptor slotDescriptor = (SlotDescriptor)iterator.next();
            String string2 = slotDescriptor.getName();
            String string3 = slotDescriptor.isSet() ? "add" + this.translateName(string2) : "set" + this.translateName(string2);
            Method method = this.findMethodCaseInsensitive(string3, clazz);
            try {
                Object object3 = string2.startsWith(Frame.UNNAMEDPREFIX) ? frame.getSlot(n) : frame.getSlot(string2);
                if (slotDescriptor.isComplex()) {
                    object3 = this.createSingleObject((Frame)object3);
                    method.invoke(object, object3);
                } else if (slotDescriptor.isSet()) {
                    Object object4;
                    int n2;
                    object2 = (Frame)object3;
                    if (slotDescriptor.getType().equalsIgnoreCase("java.lang.Object")) {
                        for (n2 = 0; n2 < ((Frame)object2).size(); ++n2) {
                            try {
                                object4 = this.createSingleObject((Frame)((Frame)object2).getSlot(n2));
                                method.invoke(object, object4);
                                continue;
                            }
                            catch (Exception exception) {
                                method.invoke(object, ((Frame)object2).getSlot(n2));
                            }
                        }
                    } else if (slotDescriptor.hasPrimitiveType()) {
                        for (n2 = 0; n2 < ((Frame)object2).size(); ++n2) {
                            method.invoke(object, this.castPrimitiveValue(((Frame)object2).getSlot(n2), slotDescriptor.getType()));
                        }
                    } else {
                        for (n2 = 0; n2 < ((Frame)object2).size(); ++n2) {
                            object4 = this.createSingleObject((Frame)((Frame)object2).getSlot(n2));
                            method.invoke(object, object4);
                        }
                    }
                } else {
                    method.invoke(object, this.castPrimitiveValue(object3, slotDescriptor.getType()));
                }
                ++n;
            }
            catch (Frame.NoSuchSlotException noSuchSlotException) {
                if (slotDescriptor.isOptional()) continue;
                throw noSuchSlotException;
            }
            catch (InvocationTargetException invocationTargetException) {
                object2 = invocationTargetException.getTargetException();
                ((Throwable)object2).printStackTrace();
                throw new OntologyException("Internal error: a reflected method threw an exception.\n e.getMessage()", invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new OntologyException("Internal error: the required method is not accessible [" + illegalAccessException.getMessage() + "]", illegalAccessException);
            }
            catch (SecurityException securityException) {
                throw new OntologyException("Wrong class: some required method is not accessible.", securityException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OntologyException("Possible mismatch between the type returned by the parser and the type declared in the ontology [" + illegalArgumentException.getMessage() + "]. For role " + string + " and slot " + string2, illegalArgumentException);
            }
            catch (ClassCastException classCastException) {
                throw new OntologyException("Possibly a primitive value has been used instead of a Frame slot", classCastException);
            }
        }
        return object;
    }

    private Object castPrimitiveValue(Object object, String string) throws IllegalArgumentException {
        String string2 = object.toString();
        Object object2 = null;
        try {
            if (string.equalsIgnoreCase("java.lang.Integer")) {
                object2 = new Integer(string2);
            } else if (string.equalsIgnoreCase("java.lang.Short")) {
                object2 = new Short(string2);
            } else if (string.equalsIgnoreCase("java.lang.Float")) {
                object2 = new Float(string2);
            } else if (string.equalsIgnoreCase("java.lang.Character")) {
                if (string2.length() != 1) {
                    throw new IllegalArgumentException("Type mismatch for value " + string2 + " and type " + string);
                }
                object2 = new Character(string2.charAt(0));
            } else if (string.equalsIgnoreCase("java.lang.Byte")) {
                object2 = new Byte(string2);
            } else if (string.equalsIgnoreCase("java.lang.String")) {
                if (!object.getClass().equals(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = DefaultOntology.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte)) {
                    object2 = string2;
                }
            } else {
                object2 = object;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Format mismatch between value " + string2 + " and type " + string);
        }
        return object2;
    }

    private void buildFromObject(Frame frame, FrameSchema frameSchema, Object object, Class clazz) throws OntologyException {
        Iterator iterator = frameSchema.subSchemas();
        while (iterator.hasNext()) {
            Object object2;
            SlotDescriptor slotDescriptor = (SlotDescriptor)iterator.next();
            String string = slotDescriptor.getName();
            String string2 = slotDescriptor.isSet() ? "getAll" + this.translateName(string) : "get" + this.translateName(string);
            Method method = this.findMethodCaseInsensitive(string2, clazz);
            try {
                Object object3 = method.invoke(object, new Object[0]);
                if (object3 == null) {
                    if (slotDescriptor.isOptional()) continue;
                    throw new OntologyException("Slot " + string + " has a null value and it is mandatory");
                }
                if (!slotDescriptor.isComplex() && !slotDescriptor.isSet()) {
                    frame.putSlot(string, object3);
                    continue;
                }
                if (slotDescriptor.isComplex()) {
                    object2 = slotDescriptor.getType();
                    if (((String)object2).equalsIgnoreCase("java.lang.Object")) {
                        object2 = this.getRoleName(object3.getClass());
                    }
                    frame.putSlot(string, this.createFrame(object3, (String)object2));
                    continue;
                }
                if (!slotDescriptor.isSet()) continue;
                object2 = slotDescriptor.getCategory() == 13 ? new Frame("set") : new Frame("sequence");
                Iterator iterator2 = (Iterator)object3;
                if (slotDescriptor.getType().equalsIgnoreCase("java.lang.Object")) {
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        try {
                            ((Frame)object2).putSlot(this.createFrame(e, this.getRoleName(e.getClass())));
                        }
                        catch (Exception exception) {
                            ((Frame)object2).putSlot(e);
                        }
                    }
                } else if (slotDescriptor.hasPrimitiveType()) {
                    while (iterator2.hasNext()) {
                        ((Frame)object2).putSlot(iterator2.next());
                    }
                } else {
                    while (iterator2.hasNext()) {
                        ((Frame)object2).putSlot(this.createFrame(iterator2.next(), slotDescriptor.getType()));
                    }
                }
                frame.putSlot(string, object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                object2 = invocationTargetException.getTargetException().getMessage();
                throw new OntologyException("Internal error: a reflected method threw an exception.\nMessage was " + (String)object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new OntologyException("Internal error: the required method is not accessible [" + illegalAccessException.getMessage() + "]");
            }
            catch (SecurityException securityException) {
                throw new OntologyException("Wrong class: some required method is not accessible.");
            }
        }
    }

    private void addSchemaToTable(String string, FrameSchema frameSchema) {
        this.schemas.put(new CaseInsensitiveString(string), frameSchema);
    }

    private Method findMethodCaseInsensitive(String string, Class clazz) throws OntologyException {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string2 = methodArray[i].getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return methodArray[i];
        }
        throw new OntologyException("Method " + string + " not found in class " + clazz.getName());
    }

    public String fromSL0String(String string) throws CodecException, OntologyException {
        Ontology ontology = JADEMetaOntology.instance();
        this.schemas.clear();
        this.roleClasses.clear();
        List list = new SL0Codec().decode(string, ontology);
        AnOntology anOntology = (AnOntology)ontology.createObject(list).get(0);
        this.fromMetaOntologyRepresentation(anOntology);
        return anOntology.getName();
    }

    public void fromMetaOntologyRepresentation(AnOntology anOntology) throws OntologyException {
        Iterator iterator = anOntology.getAllRoles();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            ArrayList<SlotDescriptor> arrayList = new ArrayList<SlotDescriptor>();
            SlotDescriptor[] slotDescriptorArray = role.getAllSlots();
            while (slotDescriptorArray.hasNext()) {
                Slot slot = (Slot)slotDescriptorArray.next();
                SlotDescriptor slotDescriptor = slot.getName() != null ? new SlotDescriptor(slot.getName(), slot.getCategory().intValue(), slot.getType(), slot.getPresence()) : new SlotDescriptor(slot.getCategory().intValue(), slot.getType(), slot.getPresence());
                arrayList.add(slotDescriptor);
            }
            slotDescriptorArray = new SlotDescriptor[arrayList.size()];
            arrayList.toArray(slotDescriptorArray);
            if (role.getClassName() == null) {
                this.addRole(role.getName(), slotDescriptorArray);
                continue;
            }
            try {
                this.addRole(role.getName(), slotDescriptorArray, Class.forName(role.getClassName()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("WARNING: ClassNotFoundException in adding role " + role.getName() + " to the ontology. The role has been then added without any class");
                this.addRole(role.getName(), slotDescriptorArray);
            }
        }
    }

    public String toString() {
        try {
            return this.toSL0String("unknownOntologyName");
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
            return null;
        }
    }

    public AnOntology toMetaOntologyRepresentation(String string) {
        AnOntology anOntology = new AnOntology();
        if (string == null || string.trim().equals("")) {
            anOntology.setName("unknownOntologyName");
        } else {
            anOntology.setName(string);
        }
        Iterator iterator = this.schemas.values().iterator();
        while (iterator.hasNext()) {
            FrameSchema frameSchema = (FrameSchema)iterator.next();
            String string2 = frameSchema.getName();
            Role role = new Role();
            role.setName(string2);
            Class clazz = this.getClassForRole(string2);
            if (clazz != null) {
                role.setClassName(clazz.getName());
            }
            Iterator iterator2 = frameSchema.subSchemas();
            while (iterator2.hasNext()) {
                SlotDescriptor slotDescriptor = (SlotDescriptor)iterator2.next();
                Slot slot = new Slot();
                if (!slotDescriptor.getName().equals("") && !slotDescriptor.getName().startsWith(Frame.UNNAMEDPREFIX)) {
                    slot.setName(slotDescriptor.getName());
                }
                slot.setCategory(new Long(slotDescriptor.getCategory()));
                slot.setType(slotDescriptor.getType());
                slot.setPresence(new Boolean(slotDescriptor.isOptional()));
                role.addSlots(slot);
            }
            anOntology.addRoles(role);
        }
        return anOntology;
    }

    public String toSL0String(String string) throws OntologyException {
        AnOntology anOntology = this.toMetaOntologyRepresentation(string);
        Ontology ontology = JADEMetaOntology.instance();
        ArrayList<Frame> arrayList = new ArrayList<Frame>(1);
        arrayList.add(ontology.createFrame(anOntology, ontology.getRoleName(anOntology.getClass())));
        String string2 = new SL0Codec().encode(arrayList, ontology);
        return string2;
    }

    public Object create(Frame frame) throws OntologyException {
        try {
            return this.getClassForRole(frame.getName()).newInstance();
        }
        catch (Exception exception) {
            throw new OntologyException(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

