/*
 * Decompiled with CFR 0.152.
 */
package sl;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class AID
implements Cloneable,
Comparable,
Serializable {
    private String name = new String();
    private List addresses = new ArrayList();
    private List resolvers = new ArrayList();
    private Properties userDefSlots = new Properties();

    public AID() {
        this("");
    }

    public AID(String string) {
        this.name = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addAddresses(String string) {
        this.addresses.add(string);
    }

    public boolean removeAddresses(String string) {
        return this.addresses.remove(string);
    }

    public void clearAllAddresses() {
        this.addresses.clear();
    }

    public Iterator getAllAddresses() {
        return this.addresses.iterator();
    }

    public void addResolvers(AID aID) {
        this.resolvers.add(aID);
    }

    public boolean removeResolvers(AID aID) {
        return this.resolvers.remove(aID);
    }

    public void clearAllResolvers() {
        this.resolvers.clear();
    }

    public Iterator getAllResolvers() {
        return this.resolvers.iterator();
    }

    public void addUserDefinedSlot(String string, String string2) {
        this.userDefSlots.setProperty(string, string2);
    }

    public String[] getAddressesArray() {
        Object[] objectArray = this.addresses.toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    public AID[] getResolversArray() {
        Object[] objectArray = this.resolvers.toArray();
        AID[] aIDArray = new AID[objectArray.length];
        System.arraycopy(objectArray, 0, aIDArray, 0, objectArray.length);
        return aIDArray;
    }

    public Properties getAllUserDefinedSlot() {
        return this.userDefSlots;
    }

    public void toText(Writer writer) {
        try {
            int n;
            writer.write("( agent-identifier ");
            if (this.name != null && this.name.length() > 0) {
                writer.write(" :name " + this.name);
            }
            if (this.addresses.size() > 0) {
                writer.write(" :addresses (sequence ");
            }
            for (n = 0; n < this.addresses.size(); ++n) {
                try {
                    writer.write((String)this.addresses.get(n) + " ");
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    indexOutOfBoundsException.printStackTrace();
                }
            }
            if (this.addresses.size() > 0) {
                writer.write(")");
            }
            if (this.resolvers.size() > 0) {
                writer.write(" :resolvers (sequence ");
            }
            for (n = 0; n < this.resolvers.size(); ++n) {
                try {
                    ((AID)this.resolvers.get(n)).toText(writer);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    indexOutOfBoundsException.printStackTrace();
                }
                writer.write(" ");
            }
            if (this.resolvers.size() > 0) {
                writer.write(")");
            }
            Enumeration<?> enumeration = this.userDefSlots.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                writer.write(" " + string + " " + this.userDefSlots.getProperty(string));
            }
            writer.write(")");
            writer.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String toString() {
        return this.name;
    }

    public synchronized Object clone() {
        AID aID;
        try {
            aID = (AID)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            aID = new AID();
        }
        return aID;
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.name.equalsIgnoreCase((String)object);
        }
        try {
            AID aID = (AID)object;
            return this.name.equalsIgnoreCase(aID.name);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int compareTo(Object object) {
        AID aID = (AID)object;
        return this.name.compareToIgnoreCase(aID.name);
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    String getLocalName() {
        int n = this.name.lastIndexOf(64);
        if (n == -1) {
            return this.name;
        }
        return this.name.substring(0, n);
    }

    String getHap() {
        int n = this.name.lastIndexOf(64);
        if (n == -1) {
            return this.name;
        }
        return this.name.substring(n + 1);
    }
}

