/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.schema.facets;

import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsObject;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import JADE_SL.schema.Facet;

public class CardinalityFacet
implements Facet {
    private int cardMin;
    private int cardMax;

    public CardinalityFacet(int n, int n2) {
        this.cardMin = n;
        this.cardMax = n2;
    }

    public void validate(AbsObject absObject, Ontology ontology) throws OntologyException {
        if (!(absObject instanceof AbsAggregate)) {
            throw new OntologyException(absObject + " is not an AbsAggregate");
        }
        int n = ((AbsAggregate)absObject).size();
        if (n < this.cardMin) {
            throw new OntologyException(absObject + " includes less elements than required (" + this.cardMin + ")");
        }
        if (this.cardMax != -1 && n > this.cardMax) {
            throw new OntologyException(absObject + " includes more elements than allowed (" + this.cardMax + ")");
        }
    }
}

