/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.schema;

import JADE_SL.abs.AbsObject;
import JADE_SL.onto.BasicOntology;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import JADE_SL.schema.Facet;
import JADE_SL.schema.facets.CardinalityFacet;
import JADE_SL.schema.facets.TypedAggregateFacet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectSchema {
    public static final int MANDATORY = 0;
    public static final int OPTIONAL = 1;
    public static final int UNLIMITED = -1;
    private Hashtable slots = new Hashtable();
    private Vector superSchemas = new Vector();
    private String typeName = null;
    private Hashtable facets = new Hashtable();
    public static final String BASE_NAME = "Object";
    private static ObjectSchema baseSchema = new ObjectSchema();

    private ObjectSchema() {
        this(BASE_NAME);
    }

    protected ObjectSchema(String string) {
        this.typeName = string;
    }

    public static ObjectSchema getBaseSchema() {
        return baseSchema;
    }

    protected void add(String string, ObjectSchema objectSchema, int n) {
        this.slots.put(string.toUpperCase(), new SlotDescriptor(string, objectSchema, n));
    }

    protected void add(String string, ObjectSchema objectSchema) {
        this.add(string, objectSchema, 0);
    }

    protected void add(String string, ObjectSchema objectSchema, int n, int n2) {
        int n3 = n == 0 ? 1 : 0;
        try {
            this.add(string, BasicOntology.getInstance().getSchema("sequence"), n3);
            this.addFacet(string, new TypedAggregateFacet(objectSchema));
            this.addFacet(string, new CardinalityFacet(n, n2));
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
        }
    }

    protected void addSuperSchema(ObjectSchema objectSchema) {
        this.superSchemas.addElement(objectSchema);
    }

    protected void addFacet(String string, Facet facet) throws OntologyException {
        Vector<Facet> vector;
        if (this.containsSlot(string = string.toUpperCase())) {
            vector = (Vector<Facet>)this.facets.get(string);
            if (vector == null) {
                vector = new Vector<Facet>();
                this.facets.put(string, vector);
            }
        } else {
            throw new OntologyException(string + " is not a valid slot in this schema");
        }
        vector.addElement(facet);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String[] getNames() {
        Vector vector = new Vector();
        this.getAllSlotDescriptors(vector);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public ObjectSchema getSchema(String string) throws OntologyException {
        SlotDescriptor slotDescriptor = (SlotDescriptor)this.slots.get(string = string.toUpperCase());
        if (slotDescriptor == null) {
            Enumeration enumeration = this.superSchemas.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ObjectSchema objectSchema = (ObjectSchema)enumeration.nextElement();
                    return objectSchema.getSchema(string);
                }
                catch (OntologyException ontologyException) {
                }
            }
            throw new OntologyException("No slot named: " + string);
        }
        return slotDescriptor.schema;
    }

    public boolean containsSlot(String string) {
        SlotDescriptor slotDescriptor = (SlotDescriptor)this.slots.get(string = string.toUpperCase());
        if (slotDescriptor != null) {
            return true;
        }
        Enumeration enumeration = this.superSchemas.elements();
        while (enumeration.hasMoreElements()) {
            ObjectSchema objectSchema = (ObjectSchema)enumeration.nextElement();
            if (!objectSchema.containsSlot(string)) continue;
            return true;
        }
        return false;
    }

    public AbsObject newInstance() throws OntologyException {
        throw new OntologyException("AbsObject cannot be instantiated");
    }

    private void getAllSlotDescriptors(Vector vector) {
        Object object;
        Enumeration enumeration = this.superSchemas.elements();
        while (enumeration.hasMoreElements()) {
            object = (ObjectSchema)enumeration.nextElement();
            ((ObjectSchema)object).getAllSlotDescriptors(vector);
        }
        int n = vector.size() + this.slots.size() - 1;
        vector.setSize(vector.size() + this.slots.size());
        object = this.slots.keys();
        while (object.hasMoreElements()) {
            vector.setElementAt(object.nextElement(), n);
            --n;
        }
    }

    public void validate(AbsObject absObject, Ontology ontology) throws OntologyException {
        this.validateSlots(absObject, ontology);
    }

    protected void validateSlots(AbsObject absObject, Ontology ontology) throws OntologyException {
        String[] stringArray = this.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            AbsObject absObject2 = absObject.getAbsObject(stringArray[i]);
            this.validate(stringArray[i], absObject2, ontology);
        }
    }

    private boolean validate(String string, AbsObject absObject, Ontology ontology) throws OntologyException {
        Object object;
        Object object2;
        boolean bl = false;
        SlotDescriptor slotDescriptor = (SlotDescriptor)this.slots.get(string);
        if (slotDescriptor != null) {
            if (absObject == null) {
                if (slotDescriptor.optionality == 0) {
                    throw new OntologyException("Missing value for mandatory slot " + string);
                }
                return true;
            }
            object2 = ontology.getSchema(absObject.getTypeName());
            if (object2 == null) {
                throw new OntologyException("No schema found for type " + absObject.getTypeName());
            }
            if (!((ObjectSchema)object2).isCompatibleWith(slotDescriptor.schema)) {
                throw new OntologyException("Schema " + object2 + " for element " + absObject + " is not compatible with schema " + slotDescriptor.schema + " for slot " + string);
            }
            ((ObjectSchema)object2).validate(absObject, ontology);
            bl = true;
        } else {
            object2 = this.superSchemas.elements();
            while (object2.hasMoreElements()) {
                object = (ObjectSchema)object2.nextElement();
                if (!((ObjectSchema)object).validate(string, absObject, ontology)) continue;
                bl = true;
                break;
            }
        }
        if (bl && (object2 = (Vector)this.facets.get(string)) != null) {
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                Facet facet = (Facet)object.nextElement();
                facet.validate(absObject, ontology);
            }
        }
        return bl;
    }

    public boolean isCompatibleWith(ObjectSchema objectSchema) {
        if (this.equals(objectSchema)) {
            return true;
        }
        if (this.isSubSchemaOf(objectSchema)) {
            return true;
        }
        return this.descendsFrom(objectSchema);
    }

    protected boolean descendsFrom(ObjectSchema objectSchema) {
        if (objectSchema != null) {
            return objectSchema.equals(ObjectSchema.getBaseSchema());
        }
        return false;
    }

    private boolean isSubSchemaOf(ObjectSchema objectSchema) {
        Enumeration enumeration = this.superSchemas.elements();
        while (enumeration.hasMoreElements()) {
            ObjectSchema objectSchema2 = (ObjectSchema)enumeration.nextElement();
            if (objectSchema2.equals(objectSchema)) {
                return true;
            }
            if (!objectSchema2.isSubSchemaOf(objectSchema)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "-" + this.getTypeName();
    }

    public boolean equals(Object object) {
        if (object != null) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    private class SlotDescriptor {
        private String name = null;
        private ObjectSchema schema = null;
        private int optionality = 0;

        private SlotDescriptor(String string, ObjectSchema objectSchema2, int n) {
            this.name = string;
            this.schema = objectSchema2;
            this.optionality = n;
        }
    }
}

