/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.onto;

import JADE_SL.CaseInsensitiveString;
import JADE_SL.Term;
import JADE_SL.abs.AbsAgentAction;
import JADE_SL.abs.AbsConcept;
import JADE_SL.abs.AbsIRE;
import JADE_SL.abs.AbsObject;
import JADE_SL.abs.AbsPredicate;
import JADE_SL.abs.AbsPrimitive;
import JADE_SL.abs.AbsTerm;
import JADE_SL.abs.AbsVariable;
import JADE_SL.onto.Introspector;
import JADE_SL.onto.OntologyException;
import JADE_SL.onto.UngroundedException;
import JADE_SL.onto.UnknownSchemaException;
import JADE_SL.schema.ObjectSchema;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class Ontology {
    private static final String DEFAULT_INTROSPECTOR_CLASS = "JADE_SL.onto.ReflectiveIntrospector";
    private Ontology[] base;
    private String name;
    private Introspector introspector;
    private Hashtable elements;
    private Hashtable classes;
    private Hashtable schemas;

    public Ontology(String string, Ontology ontology) {
        this(string, ontology, null);
        try {
            this.introspector = (Introspector)Class.forName(DEFAULT_INTROSPECTOR_CLASS).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Class JADE_SL.onto.ReflectiveIntrospectorfor default Introspector not found");
        }
    }

    public Ontology(String string, Introspector introspector) {
        this(string, new Ontology[0], introspector);
    }

    public Ontology(String string, Ontology ontology, Introspector introspector) {
        Ontology[] ontologyArray;
        if (ontology != null) {
            Ontology[] ontologyArray2 = new Ontology[1];
            ontologyArray = ontologyArray2;
            ontologyArray2[0] = ontology;
        } else {
            ontologyArray = new Ontology[]{};
        }
        this(string, ontologyArray, introspector);
    }

    public Ontology(String string, Ontology[] ontologyArray, Introspector introspector) {
        this.base = new Ontology[0];
        this.name = null;
        this.introspector = null;
        this.elements = new Hashtable();
        this.classes = new Hashtable();
        this.schemas = new Hashtable();
        this.name = string;
        this.introspector = introspector;
        this.base = ontologyArray != null ? ontologyArray : new Ontology[]{};
    }

    public String getName() {
        return this.name;
    }

    public void add(ObjectSchema objectSchema) throws OntologyException {
        this.add(objectSchema, null);
    }

    public void add(ObjectSchema objectSchema, Class clazz) throws OntologyException {
        if (objectSchema.getTypeName() == null) {
            throw new OntologyException("Invalid schema identifier");
        }
        if (this.introspector != null) {
            this.introspector.checkClass(objectSchema, clazz);
        }
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(objectSchema.getTypeName());
        this.elements.put(caseInsensitiveString, objectSchema);
        if (clazz != null) {
            this.classes.put(caseInsensitiveString, clazz);
            this.schemas.put(clazz, objectSchema);
        }
    }

    public ObjectSchema getSchema(String string) throws OntologyException {
        return this.getSchema(string, true);
    }

    public Object toObject(AbsObject absObject) throws OntologyException, UngroundedException {
        if (absObject == null) {
            return null;
        }
        try {
            return this.toObject(absObject, this);
        }
        catch (UnknownSchemaException unknownSchemaException) {
            throw new OntologyException("No schema found for type " + absObject.getTypeName());
        }
    }

    public AbsObject fromObject(Object object) throws OntologyException {
        if (object == null) {
            return null;
        }
        try {
            return this.fromObject(object, this);
        }
        catch (UnknownSchemaException unknownSchemaException) {
            throw new OntologyException("No schema found for class " + object.getClass().getName());
        }
    }

    ObjectSchema getSchema(String string, boolean bl) throws OntologyException {
        if (string == null) {
            throw new OntologyException("Null schema identifier");
        }
        ObjectSchema objectSchema = (ObjectSchema)this.elements.get(string.toLowerCase());
        if (objectSchema == null && bl) {
            for (int i = 0; i < this.base.length; ++i) {
                try {
                    if (this.base[i] == null) {
                        System.out.println("Base ontology # " + i + " for ontology " + this.getName() + " is null");
                    }
                    if ((objectSchema = this.base[i].getSchema(string)) != null) {
                        return objectSchema;
                    }
                    continue;
                }
                catch (OntologyException ontologyException) {
                    // empty catch block
                }
            }
        }
        return objectSchema;
    }

    ObjectSchema getSchema(Class clazz) throws OntologyException {
        if (clazz == null) {
            throw new OntologyException("Null schema identifier");
        }
        return (ObjectSchema)this.schemas.get(clazz);
    }

    Class getClassForElement(String string) throws OntologyException {
        if (string == null) {
            throw new OntologyException("Null schema identifier");
        }
        return (Class)this.classes.get(string.toLowerCase());
    }

    private Object toObject(AbsObject absObject, Ontology ontology) throws UngroundedException, OntologyException {
        try {
            if (this.introspector != null) {
                return this.introspector.internalise(this, ontology, absObject);
            }
            throw new UnknownSchemaException();
        }
        catch (UnknownSchemaException unknownSchemaException) {
            for (int i = 0; i < this.base.length; ++i) {
                try {
                    return this.base[i].toObject(absObject, ontology);
                }
                catch (UnknownSchemaException unknownSchemaException2) {
                    continue;
                }
            }
            throw unknownSchemaException;
        }
    }

    private AbsObject fromObject(Object object, Ontology ontology) throws UnknownSchemaException, OntologyException {
        try {
            if (this.introspector != null) {
                return this.introspector.externalise(this, ontology, object);
            }
            throw new UnknownSchemaException();
        }
        catch (UnknownSchemaException unknownSchemaException) {
            for (int i = 0; i < this.base.length; ++i) {
                try {
                    return this.base[i].fromObject(object, ontology);
                }
                catch (UnknownSchemaException unknownSchemaException2) {
                    continue;
                }
            }
            throw unknownSchemaException;
        }
    }

    public static void checkIsTerm(Object object) throws OntologyException {
        if (object instanceof String || object instanceof Boolean || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Date || object instanceof Term) {
            return;
        }
        if (object instanceof List) {
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                Ontology.checkIsTerm(iterator.next());
            }
            return;
        }
        throw new OntologyException("Object " + object + " is not a term");
    }

    public static void setAttribute(AbsObject absObject, String string, AbsObject absObject2) throws OntologyException {
        if (absObject instanceof AbsAgentAction) {
            if (absObject2 instanceof AbsTerm) {
                ((AbsAgentAction)absObject).set(string, (AbsTerm)absObject2);
                return;
            }
            if (absObject2 instanceof AbsPredicate) {
                ((AbsAgentAction)absObject).set(string, (AbsPredicate)absObject2);
                return;
            }
        }
        if (absObject instanceof AbsConcept) {
            if (absObject2 instanceof AbsTerm) {
                ((AbsConcept)absObject).set(string, (AbsTerm)absObject2);
                return;
            }
        } else {
            if (absObject instanceof AbsPredicate) {
                ((AbsPredicate)absObject).set(string, absObject2);
                return;
            }
            if (absObject instanceof AbsIRE) {
                if (absObject2 instanceof AbsVariable && CaseInsensitiveString.equalsIgnoreCase(string, "Variable")) {
                    ((AbsIRE)absObject).setVariable((AbsVariable)absObject2);
                    return;
                }
                if (absObject2 instanceof AbsPredicate && CaseInsensitiveString.equalsIgnoreCase(string, "Proposition")) {
                    ((AbsIRE)absObject).setProposition((AbsPredicate)absObject2);
                    return;
                }
            } else if (absObject instanceof AbsVariable) {
                if (absObject2 instanceof AbsPrimitive && CaseInsensitiveString.equalsIgnoreCase(string, "Name")) {
                    ((AbsVariable)absObject).setName(((AbsPrimitive)absObject2).getString());
                    return;
                }
                if (absObject2 instanceof AbsPrimitive && CaseInsensitiveString.equalsIgnoreCase(string, "ValueType")) {
                    ((AbsVariable)absObject).setType(((AbsPrimitive)absObject2).getString());
                    return;
                }
            }
        }
        throw new OntologyException("Type incompatibility: attribute " + string + " of " + absObject + " is of type " + absObject2);
    }
}

