/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.onto;

import JADE_SL.abs.AbsObject;
import JADE_SL.onto.Introspectable;
import JADE_SL.onto.Introspector;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import JADE_SL.onto.UngroundedException;
import JADE_SL.onto.UnknownSchemaException;
import JADE_SL.schema.IRESchema;
import JADE_SL.schema.ObjectSchema;
import JADE_SL.schema.VariableSchema;

public class MicroIntrospector
implements Introspector {
    public AbsObject externalise(Ontology ontology, Ontology ontology2, Object object) throws UnknownSchemaException, OntologyException {
        try {
            Class<?> clazz = object.getClass();
            ObjectSchema objectSchema = ontology.getSchema(clazz);
            if (objectSchema == null) {
                throw new UnknownSchemaException();
            }
            AbsObject absObject = objectSchema.newInstance();
            Introspectable introspectable = (Introspectable)object;
            introspectable.externalise(absObject, ontology2);
            return absObject;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Object " + object + " is not Introspectable");
        }
        catch (Exception exception) {
            throw new OntologyException("Unexpected error");
        }
    }

    public Object internalise(Ontology ontology, Ontology ontology2, AbsObject absObject) throws UngroundedException, UnknownSchemaException, OntologyException {
        try {
            String string = absObject.getTypeName();
            ObjectSchema objectSchema = ontology.getSchema(string, false);
            if (objectSchema == null) {
                throw new UnknownSchemaException();
            }
            if (objectSchema instanceof IRESchema || objectSchema instanceof VariableSchema) {
                throw new UngroundedException();
            }
            Class clazz = ontology.getClassForElement(string);
            if (clazz == null) {
                throw new OntologyException("No java class associated to type " + string);
            }
            Object t = clazz.newInstance();
            Introspectable introspectable = (Introspectable)t;
            introspectable.internalise(absObject, ontology2);
            return introspectable;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Class for type " + absObject.getTypeName() + " is not Introspectable");
        }
        catch (Exception exception) {
            throw new OntologyException("Unexpected error");
        }
    }

    public void checkClass(ObjectSchema objectSchema, Class clazz) throws OntologyException {
    }
}

