/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.onto;

import JADE_SL.ACLMessage;
import JADE_SL.AID;
import JADE_SL.AgentAction;
import JADE_SL.CaseInsensitiveString;
import JADE_SL.ContentElementList;
import JADE_SL.abs.AbsAgentAction;
import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsConcept;
import JADE_SL.abs.AbsContentElementList;
import JADE_SL.abs.AbsHelper;
import JADE_SL.abs.AbsObject;
import JADE_SL.abs.AbsPredicate;
import JADE_SL.abs.AbsPrimitive;
import JADE_SL.abs.AbsTerm;
import JADE_SL.onto.Introspector;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import JADE_SL.onto.UngroundedException;
import JADE_SL.onto.UnknownSchemaException;
import JADE_SL.onto.basic.Action;
import JADE_SL.onto.basic.Done;
import JADE_SL.onto.basic.Equals;
import JADE_SL.onto.basic.Result;
import JADE_SL.onto.basic.TrueProposition;
import JADE_SL.schema.ObjectSchema;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

class BasicIntrospector
implements Introspector {
    BasicIntrospector() {
    }

    public AbsObject externalise(Ontology ontology, Ontology ontology2, Object object) throws UnknownSchemaException, OntologyException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof String) {
                return AbsPrimitive.wrap((String)object);
            }
            if (object instanceof Boolean) {
                return AbsPrimitive.wrap((Boolean)object);
            }
            if (object instanceof Integer) {
                return AbsPrimitive.wrap((Integer)object);
            }
            if (object instanceof Long) {
                return AbsPrimitive.wrap((Long)object);
            }
            if (object instanceof Float) {
                return AbsPrimitive.wrap(((Float)object).floatValue());
            }
            if (object instanceof Double) {
                return AbsPrimitive.wrap((Double)object);
            }
            if (object instanceof Date) {
                return AbsPrimitive.wrap((Date)object);
            }
            if (object instanceof byte[]) {
                return AbsPrimitive.wrap((byte[])object);
            }
            if (object instanceof List) {
                return AbsHelper.externaliseList((List)object, ontology2);
            }
            if (object instanceof Iterator) {
                return AbsHelper.externaliseIterator((Iterator)object, ontology2);
            }
            if (object instanceof AID) {
                return AbsHelper.externaliseAID((AID)object);
            }
            if (object instanceof ContentElementList) {
                return AbsHelper.externaliseContentElementList((ContentElementList)object, ontology2);
            }
            if (object instanceof TrueProposition) {
                AbsPredicate absPredicate = new AbsPredicate("TRUE");
                return absPredicate;
            }
            if (object instanceof Done) {
                AbsPredicate absPredicate = new AbsPredicate("DONE");
                absPredicate.set("action", (AbsAgentAction)ontology2.fromObject(((Done)object).getAction()));
                return absPredicate;
            }
            if (object instanceof Result) {
                AbsPredicate absPredicate = new AbsPredicate("RESULT");
                absPredicate.set("action", (AbsAgentAction)ontology2.fromObject(((Result)object).getAction()));
                absPredicate.set("items", (AbsAggregate)ontology2.fromObject(((Result)object).getItems()));
                return absPredicate;
            }
            if (object instanceof Equals) {
                AbsPredicate absPredicate = new AbsPredicate("EQUALS");
                absPredicate.set("Left", (AbsTerm)ontology2.fromObject(((Equals)object).getLeft()));
                absPredicate.set("Right", (AbsTerm)ontology2.fromObject(((Equals)object).getRight()));
                return absPredicate;
            }
            if (object instanceof Action) {
                AbsAgentAction absAgentAction = new AbsAgentAction("ACTION");
                ((Action)object).externalise(absAgentAction, ontology2);
                return absAgentAction;
            }
            if (object instanceof ACLMessage) {
                return AbsHelper.externaliseACLMessage((ACLMessage)object, ontology2);
            }
            throw new UnknownSchemaException();
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    public Object internalise(Ontology ontology, Ontology ontology2, AbsObject absObject) throws UngroundedException, UnknownSchemaException, OntologyException {
        try {
            if (absObject == null) {
                return null;
            }
            if (absObject instanceof AbsPrimitive) {
                return ((AbsPrimitive)absObject).getObject();
            }
            if (absObject instanceof AbsAggregate) {
                return AbsHelper.internaliseList((AbsAggregate)absObject, ontology2);
            }
            if (absObject instanceof AbsContentElementList) {
                return AbsHelper.internaliseContentElementList((AbsContentElementList)absObject, ontology2);
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "agent-identifier")) {
                return AbsHelper.internaliseAID((AbsConcept)absObject);
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "TRUE")) {
                TrueProposition trueProposition = new TrueProposition();
                return trueProposition;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "DONE")) {
                Done done = new Done();
                done.setAction((AgentAction)ontology2.toObject(absObject.getAbsObject("action")));
                return done;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "RESULT")) {
                Result result = new Result();
                result.setAction((AgentAction)ontology2.toObject(absObject.getAbsObject("action")));
                result.setItems((List)ontology2.toObject(absObject.getAbsObject("items")));
                return result;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "EQUALS")) {
                Equals equals = new Equals();
                equals.setLeft(ontology2.toObject(absObject.getAbsObject("Left")));
                equals.setRight(ontology2.toObject(absObject.getAbsObject("Right")));
                return equals;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "ACTION")) {
                Action action = new Action();
                action.internalise(absObject, ontology2);
                return action;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(absObject.getTypeName(), "acl-message")) {
                return AbsHelper.internaliseACLMessage((AbsAgentAction)absObject, ontology2);
            }
            throw new UnknownSchemaException();
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    public void checkClass(ObjectSchema objectSchema, Class clazz) throws OntologyException {
    }
}

