/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.onto;

import JADE_SL.CaseInsensitiveString;
import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsObject;
import JADE_SL.onto.Introspector;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import JADE_SL.onto.UngroundedException;
import JADE_SL.onto.UnknownSchemaException;
import JADE_SL.schema.AggregateSchema;
import JADE_SL.schema.IRESchema;
import JADE_SL.schema.ObjectSchema;
import JADE_SL.schema.VariableSchema;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

public class BCReflectiveIntrospector
implements Introspector {
    public AbsObject externalise(Ontology ontology, Ontology ontology2, Object object) throws UnknownSchemaException, OntologyException {
        try {
            Class<?> clazz = object.getClass();
            ObjectSchema objectSchema = ontology.getSchema(clazz);
            if (objectSchema == null) {
                throw new UnknownSchemaException();
            }
            AbsObject absObject = objectSchema.newInstance();
            String[] stringArray = objectSchema.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                ObjectSchema objectSchema2 = objectSchema.getSchema(string);
                String string2 = objectSchema2 instanceof AggregateSchema ? "getAll" + this.translateName(string) : "get" + this.translateName(string);
                Method method = this.findMethodCaseInsensitive(string2, clazz);
                AbsObject absObject2 = this.invokeGetMethod(ontology2, method, object);
                if (absObject2 == null) continue;
                Ontology.setAttribute(absObject, string, absObject2);
            }
            return absObject;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    private AbsObject invokeGetMethod(Ontology ontology, Method method, Object object) throws OntologyException {
        Object object2 = null;
        try {
            object2 = method.invoke(object, null);
            if (object2 == null) {
                return null;
            }
            return ontology.fromObject(object2);
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking get method", exception);
        }
    }

    public Object internalise(Ontology ontology, Ontology ontology2, AbsObject absObject) throws UngroundedException, UnknownSchemaException, OntologyException {
        try {
            String string = absObject.getTypeName();
            ObjectSchema objectSchema = ontology.getSchema(string, false);
            if (objectSchema == null) {
                throw new UnknownSchemaException();
            }
            if (objectSchema instanceof IRESchema || objectSchema instanceof VariableSchema) {
                throw new UngroundedException();
            }
            Class clazz = ontology.getClassForElement(string);
            if (clazz == null) {
                throw new OntologyException("No java class associated to type " + string);
            }
            Object t = clazz.newInstance();
            String[] stringArray = objectSchema.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Method method;
                String string2;
                String string3 = stringArray[i];
                AbsObject absObject2 = absObject.getAbsObject(string3);
                if (absObject2 == null) continue;
                ObjectSchema objectSchema2 = objectSchema.getSchema(string3);
                if (objectSchema2 instanceof AggregateSchema) {
                    string2 = "add" + this.translateName(string3);
                    method = this.findMethodCaseInsensitive(string2, clazz);
                    this.invokeAddMethod(ontology2, method, t, (AbsAggregate)absObject2);
                    continue;
                }
                string2 = "set" + this.translateName(string3);
                method = this.findMethodCaseInsensitive(string2, clazz);
                this.invokeSetMethod(ontology2, method, t, absObject2);
            }
            return t;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    private void invokeSetMethod(Ontology ontology, Method method, Object object, AbsObject absObject) throws OntologyException {
        try {
            Object object2 = ontology.toObject(absObject);
            if (object2 == null) {
                return;
            }
            Object[] objectArray = new Object[]{object2};
            try {
                method.invoke(object, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (object2 instanceof Long) {
                    Integer n = new Integer((int)((Long)object2).longValue());
                    objectArray[0] = n;
                } else if (object2 instanceof Double) {
                    Float f = new Float((float)((Double)object2).doubleValue());
                    objectArray[0] = f;
                }
                method.invoke(object, objectArray);
            }
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking set method", exception);
        }
    }

    private void invokeAddMethod(Ontology ontology, Method method, Object object, AbsAggregate absAggregate) throws OntologyException {
        try {
            List list = (List)ontology.toObject(absAggregate);
            if (list == null) {
                return;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object[] objectArray = new Object[]{e};
                try {
                    method.invoke(object, objectArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Number number;
                    if (e instanceof Long) {
                        number = new Integer((int)((Long)e).longValue());
                        objectArray[0] = number;
                    } else if (e instanceof Double) {
                        number = new Float((float)((Double)e).doubleValue());
                        objectArray[0] = number;
                    }
                    method.invoke(object, objectArray);
                }
            }
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking add method", exception);
        }
    }

    public void checkClass(ObjectSchema objectSchema, Class clazz) throws OntologyException {
    }

    private Method findMethodCaseInsensitive(String string, Class clazz) throws OntologyException {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string2 = methodArray[i].getName();
            if (!CaseInsensitiveString.equalsIgnoreCase(string2, string)) continue;
            return methodArray[i];
        }
        throw new OntologyException("Method " + string + " not found in class " + clazz.getName());
    }

    private String translateName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ':': {
                    continue block4;
                }
                case '-': {
                    bl = true;
                    continue block4;
                }
                default: {
                    if (bl) {
                        stringBuffer.append(Character.toUpperCase(c));
                        bl = false;
                        continue block4;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

