/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL;

import JADE_SL.AID;
import JADE_SL.ISO8601;
import JADE_SL.StringACLCodec;
import JADE_SL.UnreadableException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.agent.Envelope;

public class ACLMessage {
    private static final long serialVersionUID = 3945353187608998130L;
    public static final int ACCEPT_PROPOSAL = 0;
    public static final int AGREE = 1;
    public static final int CANCEL = 2;
    public static final int CFP = 3;
    public static final int CONFIRM = 4;
    public static final int DISCONFIRM = 5;
    public static final int FAILURE = 6;
    public static final int INFORM = 7;
    public static final int INFORM_IF = 8;
    public static final int INFORM_REF = 9;
    public static final int NOT_UNDERSTOOD = 10;
    public static final int PROPOSE = 11;
    public static final int QUERY_IF = 12;
    public static final int QUERY_REF = 13;
    public static final int REFUSE = 14;
    public static final int REJECT_PROPOSAL = 15;
    public static final int REQUEST = 16;
    public static final int REQUEST_WHEN = 17;
    public static final int REQUEST_WHENEVER = 18;
    public static final int SUBSCRIBE = 19;
    public static final int PROXY = 20;
    public static final int PROPAGATE = 21;
    public static final int UNKNOWN = -1;
    private int performative;
    private static List performatives = new ArrayList(22);
    private AID source = null;
    private ArrayList dests = new ArrayList();
    private ArrayList reply_to = new ArrayList();
    private StringBuffer content = null;
    private byte[] byteSequenceContent = null;
    private StringBuffer reply_with = null;
    private StringBuffer in_reply_to = null;
    private StringBuffer encoding = null;
    private StringBuffer language = null;
    private StringBuffer ontology = null;
    private long reply_byInMillisec = 0L;
    private StringBuffer protocol = null;
    private StringBuffer conversation_id = null;
    private Properties userDefProps = new Properties();
    private Envelope messageEnvelope;

    public static List getAllPerformatives() {
        return performatives;
    }

    public static String[] getAllPerformativeNames() {
        String[] stringArray = new String[performatives.size()];
        int n = 0;
        Iterator iterator = performatives.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public ACLMessage() {
        this.performative = 10;
    }

    public ACLMessage(int n) {
        this.performative = n;
    }

    public void setSender(AID aID) {
        this.source = aID != null ? (AID)aID.clone() : null;
    }

    public void addReceiver(AID aID) {
        if (aID != null) {
            this.dests.add(aID);
        }
    }

    public boolean removeReceiver(AID aID) {
        if (aID != null) {
            return this.dests.remove(aID);
        }
        return false;
    }

    public void clearAllReceiver() {
        this.dests.clear();
    }

    public void addReplyTo(AID aID) {
        if (aID != null) {
            this.reply_to.add(aID);
        }
    }

    public boolean removeReplyTo(AID aID) {
        if (aID != null) {
            return this.reply_to.remove(aID);
        }
        return false;
    }

    public void clearAllReplyTo() {
        this.reply_to.clear();
    }

    public void setPerformative(int n) {
        this.performative = n;
    }

    public void setContent(String string) {
        this.byteSequenceContent = null;
        this.content = string != null ? new StringBuffer(string) : null;
    }

    public void setByteSequenceContent(byte[] byArray) {
        this.content = null;
        this.byteSequenceContent = byArray;
    }

    public void setContentObject(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        this.setByteSequenceContent(byteArrayOutputStream.toByteArray());
    }

    public Serializable getContentObject() throws UnreadableException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(this.getByteSequenceContent()));
            Serializable serializable = (Serializable)objectInputStream.readObject();
            return serializable;
        }
        catch (Error error) {
            throw new UnreadableException(error.getMessage());
        }
        catch (IOException iOException) {
            throw new UnreadableException(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnreadableException(classNotFoundException.getMessage());
        }
    }

    public void setReplyWith(String string) {
        this.reply_with = string != null ? new StringBuffer(string) : null;
    }

    public void setInReplyTo(String string) {
        this.in_reply_to = string != null ? new StringBuffer(string) : null;
    }

    public void setEncoding(String string) {
        this.encoding = string != null ? new StringBuffer(string) : null;
    }

    public void setLanguage(String string) {
        this.language = string != null ? new StringBuffer(string) : null;
    }

    public void setOntology(String string) {
        this.ontology = string != null ? new StringBuffer(string) : null;
    }

    public void setReplyBy(String string) {
        if (string != null) {
            try {
                this.reply_byInMillisec = ISO8601.toDate(string).getTime();
            }
            catch (Exception exception) {
                this.reply_byInMillisec = 0L;
            }
        } else {
            this.reply_byInMillisec = 0L;
        }
    }

    public void setReplyByDate(Date date) {
        this.reply_byInMillisec = date == null ? 0L : date.getTime();
    }

    public void setProtocol(String string) {
        this.protocol = string != null ? new StringBuffer(string) : null;
    }

    public void setConversationId(String string) {
        this.conversation_id = string != null ? new StringBuffer(string) : null;
    }

    public Iterator getAllReceiver() {
        return this.dests.iterator();
    }

    public Iterator getAllReplyTo() {
        return this.reply_to.iterator();
    }

    public AID getSender() {
        if (this.source != null) {
            return (AID)this.source.clone();
        }
        return null;
    }

    public static String getPerformative(int n) {
        try {
            return new String((String)performatives.get(n));
        }
        catch (Exception exception) {
            return new String((String)performatives.get(10));
        }
    }

    public static int getInteger(String string) {
        return performatives.indexOf(string.toUpperCase());
    }

    public int getPerformative() {
        return this.performative;
    }

    public boolean hasByteSequenceContent() {
        return this.byteSequenceContent != null;
    }

    public String getContent() {
        if (this.content != null) {
            return new String(this.content);
        }
        if (this.byteSequenceContent != null) {
            return new String(this.byteSequenceContent);
        }
        return null;
    }

    public byte[] getByteSequenceContent() {
        if (this.content != null) {
            return this.content.toString().getBytes();
        }
        if (this.byteSequenceContent != null) {
            return this.byteSequenceContent;
        }
        return null;
    }

    public String getReplyWith() {
        if (this.reply_with != null) {
            return new String(this.reply_with);
        }
        return null;
    }

    public String getInReplyTo() {
        if (this.in_reply_to != null) {
            return new String(this.in_reply_to);
        }
        return null;
    }

    public String getEncoding() {
        if (this.encoding != null) {
            return new String(this.encoding);
        }
        return null;
    }

    public String getLanguage() {
        if (this.language != null) {
            return new String(this.language);
        }
        return null;
    }

    public String getOntology() {
        if (this.ontology != null) {
            return new String(this.ontology);
        }
        return null;
    }

    public String getReplyBy() {
        if (this.reply_byInMillisec != 0L) {
            return ISO8601.toString(new Date(this.reply_byInMillisec));
        }
        return null;
    }

    public Date getReplyByDate() {
        if (this.reply_byInMillisec != 0L) {
            return new Date(this.reply_byInMillisec);
        }
        return null;
    }

    public String getProtocol() {
        if (this.protocol != null) {
            return new String(this.protocol);
        }
        return null;
    }

    public String getConversationId() {
        if (this.conversation_id != null) {
            return new String(this.conversation_id);
        }
        return null;
    }

    public void addUserDefinedParameter(String string, String string2) {
        this.userDefProps.setProperty(string, string2);
    }

    public String getUserDefinedParameter(String string) {
        return this.userDefProps.getProperty(string);
    }

    public Properties getAllUserDefinedParameters() {
        return (Properties)this.userDefProps.clone();
    }

    public boolean removeUserDefinedParameter(String string) {
        return this.userDefProps.remove(string) != null;
    }

    public void setEnvelope(Envelope envelope) {
        this.messageEnvelope = envelope;
    }

    public Envelope getEnvelope() {
        return this.messageEnvelope;
    }

    public void toText(Writer writer) {
        try {
            writer.write(this.toString());
            writer.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized Object clone() {
        ACLMessage aCLMessage;
        try {
            aCLMessage = (ACLMessage)super.clone();
            aCLMessage.dests = (ArrayList)this.dests.clone();
            aCLMessage.reply_to = (ArrayList)this.reply_to.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return aCLMessage;
    }

    public String toString() {
        return StringACLCodec.toString(this);
    }

    public void reset() {
        this.source = null;
        this.dests.clear();
        this.reply_to.clear();
        this.performative = 10;
        this.content = null;
        this.byteSequenceContent = null;
        this.reply_with = null;
        this.in_reply_to = null;
        this.encoding = null;
        this.language = null;
        this.ontology = null;
        this.reply_byInMillisec = 0L;
        this.protocol = null;
        this.conversation_id = null;
        this.userDefProps.clear();
    }

    static {
        performatives.add("ACCEPT-PROPOSAL");
        performatives.add("AGREE");
        performatives.add("CANCEL");
        performatives.add("CFP");
        performatives.add("CONFIRM");
        performatives.add("DISCONFIRM");
        performatives.add("FAILURE");
        performatives.add("INFORM");
        performatives.add("INFORM-IF");
        performatives.add("INFORM-REF");
        performatives.add("NOT-UNDERSTOOD");
        performatives.add("PROPOSE");
        performatives.add("QUERY-IF");
        performatives.add("QUERY-REF");
        performatives.add("REFUSE");
        performatives.add("REJECT-PROPOSAL");
        performatives.add("REQUEST");
        performatives.add("REQUEST-WHEN");
        performatives.add("REQUEST-WHENEVER");
        performatives.add("SUBSCRIBE");
        performatives.add("PROXY");
        performatives.add("PROPAGATE");
    }
}

