/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.common.StatementImpl;
import com.hp.hpl.mesa.rdf.jena.model.AnonId;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.rdb.HasRDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;

public class StatementImplRDB
extends StatementImpl
implements HasRDBID {
    protected IDBID m_rdbId = null;
    protected IDBID m_rdbNSId = null;
    protected IDBID m_rdbStatementId = null;
    protected boolean isOnlyReified = false;

    public StatementImplRDB(Resource resource, Property property, RDFNode rDFNode) {
        super(resource, property, rDFNode);
    }

    public StatementImplRDB(Resource resource, Property property, RDFNode rDFNode, Model model) throws RDFException {
        super(resource, property, rDFNode, model);
    }

    public StatementImplRDB(Resource resource, Property property, RDFNode rDFNode, AnonId anonId, Model model) throws RDFException {
        super(resource, property, rDFNode, anonId, model);
    }

    public StatementImplRDB(Resource resource, Property property, RDFNode rDFNode, String string, Model model) throws RDFException {
        super(resource, property, rDFNode, string, model);
    }

    public static StatementImplRDB createFrom(Statement statement, Model model) throws RDFException {
        if (statement.isAnon()) {
            return new StatementImplRDB(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getId(), model);
        }
        return new StatementImplRDB(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getURI(), model);
    }

    public IDBID getRDBStatementId() {
        return this.m_rdbStatementId;
    }

    public void setRDBStatementId(IDBID iDBID) {
        this.m_rdbStatementId = iDBID;
    }

    public IDBID getRDBId() {
        return this.m_rdbId;
    }

    public void setRDBId(IDBID iDBID) {
        this.m_rdbId = iDBID;
    }

    public IDBID getRDBNSId() {
        return this.m_rdbNSId;
    }

    public void setRDBNSId(IDBID iDBID) {
        this.m_rdbNSId = iDBID;
    }

    public boolean getIsReifiedOnly() {
        return this.isOnlyReified;
    }

    public void setIsReifiedOnly(boolean bl) {
        this.isOnlyReified = bl;
    }

    public void setURI(Resource resource) {
        if (resource.isAnon()) {
            try {
                this.id = resource.getId();
            }
            catch (RDFException rDFException) {
                Log.finest("error during statement setURI", rDFException);
            }
        } else {
            this.nameSpace = resource.getNameSpace();
            this.localName = resource.getLocalName();
            this.uri = resource.getURI();
        }
    }

    protected void setSPO(Resource resource, Property property, RDFNode rDFNode) {
        this.subject = resource;
        this.predicate = property;
        this.object = rDFNode;
    }
}

