/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.StatementImplRDB;
import java.sql.SQLException;

public class ResultSetStatementIterator
extends ResultSetIterator {
    protected ModelRDB m_model;
    protected IRDBDriver m_driver;
    protected int m_nrows = -1;
    protected StatementImplRDB m_row;

    public ResultSetStatementIterator(ModelRDB modelRDB, IRDBDriver iRDBDriver) {
        this.m_model = modelRDB;
        this.m_driver = iRDBDriver;
    }

    protected void extractRow() throws SQLException, RDFException {
        IDBID iDBID;
        Object object;
        Object object2;
        if (this.m_nrows == -1) {
            this.m_nrows = this.m_resultSet.getMetaData().getColumnCount();
        }
        boolean bl = this.m_nrows >= 8;
        int n = 1;
        Resource resource = null;
        IDBID iDBID2 = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
        if (bl) {
            object2 = this.m_resultSet.getString(n++);
            object = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
            if (resource == null) {
                if (this.m_model.supportsJenaReification()) {
                    iDBID = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
                    resource = this.m_driver.makeResource(iDBID2, (String)object2, (IDBID)object, this.m_model, iDBID);
                } else {
                    resource = this.m_driver.makeResource(iDBID2, (String)object2, (IDBID)object, this.m_model);
                }
            }
        } else {
            resource = this.m_driver.getResource(iDBID2, this.m_model);
        }
        object2 = null;
        iDBID2 = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
        if (bl) {
            object = this.m_resultSet.getString(n++);
            iDBID = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
            object2 = this.m_driver.makeProperty(iDBID2, (String)object, iDBID, this.m_model);
        } else {
            object2 = this.m_driver.getProperty(iDBID2, this.m_model);
        }
        object = null;
        iDBID = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
        int n2 = this.m_resultSet.getInt(n++);
        object = n2 == 1 ? this.m_driver.getLiteral(iDBID) : this.m_driver.getResource(iDBID, this.m_model);
        if (this.m_model.supportsJenaReification()) {
            Object object3;
            IDBID iDBID3 = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
            int n4 = this.m_resultSet.getInt(n++);
            if ((object3 = this.m_resultSet.getObject(n++)) != null) {
                this.m_row = this.m_driver.getBareStatementResource(this.m_driver.wrapDBID(object3), this.m_model);
                this.m_row.setSPO(resource, (Property)object2, (RDFNode)object);
            } else {
                this.m_row = new StatementImplRDB(resource, (Property)object2, (RDFNode)object, this.m_model);
            }
            this.m_row.setRDBStatementId(iDBID3);
            this.m_row.setIsReifiedOnly(n4 == 1);
        } else {
            this.m_row = new StatementImplRDB(resource, (Property)object2, (RDFNode)object, this.m_model);
        }
    }

    protected Object getRow() {
        return this.m_row;
    }

    public void remove() {
        if (!this.m_finished && this.m_row != null) {
            try {
                this.m_model.remove(this.m_row);
            }
            catch (RDFException rDFException) {
                throw new IllegalStateException("Error during remove(): " + rDFException);
            }
        }
    }
}

