/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.common.ModelCom;
import com.hp.hpl.mesa.rdf.jena.common.ModelI;
import com.hp.hpl.mesa.rdf.jena.common.StmtIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.Store;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Selector;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.IConstraints;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.PropertyImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResourceImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.StatementImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.StoreRDB;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ModelRDB
extends ModelCom
implements Model,
ModelI {
    protected String m_name = "default";
    protected IDBID m_dbid;

    public ModelRDB(IDBConnection iDBConnection) throws RDFRDBException {
        this(new StoreRDB(iDBConnection.getDriver()));
    }

    protected ModelRDB(Store store) throws RDFRDBException {
        this.store = store;
        if (store instanceof StoreRDB) {
            ((StoreRDB)store).attachModel(this);
        }
        this.m_dbid = ((StoreRDB)store).getDriver().allocateModelID(this.m_name);
    }

    protected ModelRDB(Store store, String string, IDBID iDBID) {
        this.store = store;
        this.m_name = string;
        this.m_dbid = iDBID;
        if (store instanceof StoreRDB) {
            ((StoreRDB)store).attachModel(this);
        }
    }

    public static ModelRDB open(IDBConnection iDBConnection, String string) throws RDFRDBException {
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        if (iRDBDriver == null) {
            throw new RDFRDBException("Failed to open RDB driver, probably an unformatted database");
        }
        IDBID iDBID = iRDBDriver.getModelID(string);
        return new ModelRDB(new StoreRDB(iRDBDriver), string, iDBID);
    }

    public static ModelRDB open(IDBConnection iDBConnection) throws RDFRDBException {
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        if (iRDBDriver == null) {
            throw new RDFRDBException("Failed to open RDB driver, probably an unformatted database");
        }
        return new ModelRDB(StoreRDB.openDB(iRDBDriver));
    }

    public static ModelRDB createModel(IDBConnection iDBConnection, String string) throws RDFRDBException {
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        if (iRDBDriver == null) {
            throw new RDFRDBException("Failed to open RDB driver, probably an unformatted database");
        }
        IDBID iDBID = iRDBDriver.allocateModelID(string);
        return new ModelRDB(new StoreRDB(iRDBDriver), string, iDBID);
    }

    public static void deleteModel(IDBConnection iDBConnection, String string) throws RDFRDBException {
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        if (iRDBDriver == null) {
            throw new RDFRDBException("Failed to open RDB driver, probably an unformatted database");
        }
        iRDBDriver.deleteModel(string);
    }

    public static Iterator listModels(IDBConnection iDBConnection) throws RDFRDBException {
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        if (iRDBDriver == null) {
            throw new RDFRDBException("Failed to open RDB driver, probably an unformatted database");
        }
        return iRDBDriver.listModels();
    }

    public static ModelRDB create(IDBConnection iDBConnection, String string, String string2) throws RDFRDBException {
        IRDBDriver iRDBDriver = iDBConnection.getDriver(string, string2);
        if (iRDBDriver.isDBFormatOK()) {
            iDBConnection.reloadProperties();
        }
        return new ModelRDB(StoreRDB.createDB(iRDBDriver));
    }

    public static ModelRDB create(IDBConnection iDBConnection, String string) throws RDFRDBException {
        IRDBDriver iRDBDriver = iDBConnection.getDriver("MMGeneric", string);
        return new ModelRDB(StoreRDB.createDB(iRDBDriver));
    }

    public void close() {
        this.store.close();
        this.store = null;
    }

    protected void finalize() {
    }

    public StoreRDB getStore() {
        return (StoreRDB)this.store;
    }

    public IDBID getDBID() {
        return this.m_dbid;
    }

    public void clear() throws RDFRDBException {
        ((StoreRDB)this.store).clear();
    }

    public Model loadAll() throws RDFException {
        ModelMem modelMem = new ModelMem();
        this.getStore().getDriver().preloadCaches(this);
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        StmtIterator stmtIterator = this.listStatements();
        while (stmtIterator.hasNext()) {
            arrayList.add(stmtIterator.next());
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            modelMem.add((Statement)iterator.next());
        }
        return modelMem;
    }

    public StmtIterator listStatements(IConstraints iConstraints) throws RDFException {
        return new StmtIteratorImpl(((StoreRDB)this.store).listStatements(iConstraints, this), null);
    }

    public IConstraints createConstraints() {
        return ((StoreRDB)this.store).createConstraints(this);
    }

    public Resource convert(Resource resource) throws RDFException {
        if (resource == null) {
            return null;
        }
        if (resource.getModel() == this && (resource instanceof ResourceImplRDB || resource instanceof StatementImplRDB)) {
            return resource;
        }
        if (this.supportsJenaReification() && resource instanceof Statement) {
            return StatementImplRDB.createFrom((Statement)resource, this);
        }
        return new ResourceImplRDB(resource, (Model)this);
    }

    public Property convert(Property property) throws RDFException {
        if (property == null) {
            return null;
        }
        if (property.getModel() == this && property instanceof PropertyImplRDB) {
            return property;
        }
        return new PropertyImplRDB(property, (Model)this);
    }

    public RDFNode convert(RDFNode rDFNode) throws RDFException {
        if (rDFNode == null) {
            return null;
        }
        if (rDFNode instanceof Property) {
            return this.convert((Property)rDFNode);
        }
        if (rDFNode instanceof Resource) {
            return this.convert((Resource)rDFNode);
        }
        return rDFNode;
    }

    public boolean supportsJenaReification() {
        return ((StoreRDB)this.store).supportsJenaReification();
    }

    public StmtIterator listReifiedStatements() throws RDFException {
        if (this.supportsJenaReification()) {
            return new StmtIteratorImpl(((StoreRDB)this.store).listReifiedStatements(this), null);
        }
        return super.listReifiedStatements();
    }

    public Model add(Statement statement) throws RDFException {
        if (!(statement instanceof StatementImplRDB) || ((StatementImplRDB)statement).getModel() != this) {
            statement = StatementImplRDB.createFrom(statement, this);
        }
        this.store.add(statement);
        return this;
    }

    public boolean contains(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        return this.contains(new StatementImplRDB(resource, property, rDFNode));
    }

    public Statement createStatement(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        return new StatementImplRDB(resource, property, rDFNode, this);
    }

    public Model begin() throws RDFException {
        ((StoreRDB)this.store).begin();
        return this;
    }

    public Model abort() throws RDFException {
        ((StoreRDB)this.store).abort();
        return this;
    }

    public Model commit() throws RDFException {
        ((StoreRDB)this.store).commit();
        return this;
    }

    public boolean independent() {
        return true;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsSetOperations() {
        return true;
    }

    public Model query(Selector selector) throws RDFException {
        ModelMem modelMem;
        ModelMem modelMem2 = new ModelMem();
        StmtIterator stmtIterator = null;
        try {
            stmtIterator = this.listStatements(selector);
            while (stmtIterator.hasNext()) {
                modelMem2.add(stmtIterator.next());
            }
            modelMem = modelMem2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return modelMem;
    }

    public Model union(Model model) throws RDFException {
        return new ModelMem().add(this).add(model);
    }

    public Model intersection(Model model) throws RDFException {
        ModelMem modelMem;
        Model model2 = this;
        Model model3 = model;
        ModelMem modelMem2 = new ModelMem();
        StmtIterator stmtIterator = null;
        if (model.size() > this.size()) {
            model2 = model;
            model3 = this;
        }
        try {
            stmtIterator = model3.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.next();
                if (!model2.contains(statement)) continue;
                modelMem2.add(statement);
            }
            modelMem = modelMem2;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return modelMem;
    }

    public Model difference(Model model) throws RDFException {
        ModelMem modelMem;
        ModelMem modelMem2 = new ModelMem();
        StmtIterator stmtIterator = null;
        try {
            stmtIterator = this.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.next();
                if (model.contains(statement)) continue;
                modelMem2.add(statement);
            }
            modelMem = modelMem2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return modelMem;
    }
}

