/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.rdb.DBIDHash;
import com.hp.hpl.mesa.rdf.jena.rdb.DriverGenericGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.SQLCache;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import sun.misc.BASE64Encoder;

public class DriverGenericHash
extends DriverGenericGeneric {
    protected static MessageDigest m_hashGenerator;
    protected static BASE64Encoder m_base64Encoder;
    protected static Properties m_defaultHashSQL;
    protected static final String HASHSQL_DEFAULT_FILE = "etc/generic_hash.sql";

    public DriverGenericHash() {
        this.LAYOUT_TYPE = "Hash";
        this.DATABASE_TYPE = "Generic";
        this.SQL_FILE = HASHSQL_DEFAULT_FILE;
        try {
            m_hashGenerator = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.severe("Failed to find an MD5 provider", noSuchAlgorithmException);
        }
        this.m_anonNSId = this.uniqueHash("_");
        this.cacheNamespaceId("_", this.m_anonNSId);
        this.SKIP_ALLOCATE_ID = false;
        this.INSERT_BY_PROCEDURE = false;
        this.ID_SQL_TYPE = "CHAR(24)";
    }

    protected Properties getDefaultSQL() throws IOException {
        if (m_defaultHashSQL == null) {
            m_defaultHashSQL = SQLCache.loadSQLFile(HASHSQL_DEFAULT_FILE, null, this.ID_SQL_TYPE);
        }
        return m_defaultHashSQL;
    }

    public IDBID wrapDBID(Object object) throws RDFRDBException {
        if (object instanceof String) {
            return new DBIDHash((String)object);
        }
        if (object == null) {
            return null;
        }
        throw new RDFRDBException("Unexpected DB identifier type: " + object);
    }

    protected synchronized IDBID uniqueHash(String string) {
        m_hashGenerator.update(string.getBytes());
        byte[] byArray = m_hashGenerator.digest();
        m_hashGenerator.reset();
        return new DBIDHash(m_base64Encoder.encode(byArray));
    }

    protected IDBID allocateNamespaceID(String string) throws RDFRDBException {
        if (this.m_namespaceIDMap.containsKey(string)) {
            return (IDBID)this.m_namespaceIDMap.get(string);
        }
        return this.uniqueHash(string);
    }

    protected IDBID allocateResourceID(Resource resource) throws RDFException {
        String string = resource.isAnon() ? "_" : resource.getNameSpace();
        IDBID iDBID = this.getNamespaceID(string);
        if (iDBID == null) {
            iDBID = this.allocateNamespaceID(string);
        }
        String string2 = resource.isAnon() ? resource.getId().toString() : resource.getLocalName();
        return this.uniqueHash(string2 + iDBID.getID().toString());
    }

    protected IDBID allocateLiteralID(Literal literal) throws RDFRDBException {
        return this.uniqueHash(literal.toString() + literal.getLanguage());
    }

    protected IDBID allocateStatementID(Statement statement, IDBID iDBID) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.allocateResourceID(statement.getSubject()).getID().toString());
        stringBuffer.append("|");
        stringBuffer.append(this.allocateResourceID(statement.getPredicate()).getID().toString());
        stringBuffer.append("|");
        RDFNode rDFNode = statement.getObject();
        if (rDFNode instanceof Literal) {
            stringBuffer.append(this.allocateLiteralID((Literal)rDFNode).getID().toString());
        } else {
            stringBuffer.append(this.allocateResourceID((Resource)rDFNode).getID().toString());
        }
        stringBuffer.append("|");
        stringBuffer.append(iDBID.toString());
        return this.uniqueHash(stringBuffer.toString());
    }

    static {
        m_base64Encoder = new BASE64Encoder();
        m_defaultHashSQL = null;
    }
}

