/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.model.AnonId;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.rdb.ConstraintsGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.DBIDInt;
import com.hp.hpl.mesa.rdf.jena.rdb.HasRDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.ICache;
import com.hp.hpl.mesa.rdf.jena.rdb.IConstraints;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.PropertyImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResourceImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetResourceIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetStatementIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetStringIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.SQLCache;
import com.hp.hpl.mesa.rdf.jena.rdb.SimpleCache;
import com.hp.hpl.mesa.rdf.jena.rdb.StatementImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.StoreRDB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;

public class DriverGenericGeneric
implements IRDBDriver {
    protected String DRIVER_NAME = "java.lang.Class";
    protected String LAYOUT_TYPE = "Generic";
    protected String DATABASE_TYPE = "Generic";
    protected int MAX_LITERAL = 32000;
    protected String SQL_FILE = "etc/generic_generic.sql";
    protected String ID_SQL_TYPE = "INTEGER";
    protected boolean SKIP_DUPLICATE_CHECK = false;
    protected boolean SKIP_ALLOCATE_ID = false;
    protected boolean INSERT_BY_PROCEDURE = false;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected boolean SUPPORTS_JENA_REIFICATION = false;
    protected IDBConnection m_dbcon = null;
    protected SQLCache m_sql = null;
    protected List m_clientStores = new ArrayList();
    protected IDBID m_anonNSId = new DBIDInt(0);
    public static final String ANON_NAMESPACE = "_";
    protected static final String SQL_DEFAULT_FILE = "etc/generic_generic.sql";
    protected static Properties m_defaultSQL = null;
    protected static final int NS_BLOCKSIZE = 50;
    protected Map m_namespaceMap = new HashMap(50);
    protected Map m_namespaceIDMap = new HashMap(50);
    protected static final int DEFAULT_CACHE = 1000;
    protected ICache literalCache = new SimpleCache(1000);
    protected ICache resourceCache = new SimpleCache(1000);

    public DriverGenericGeneric() {
        this.cacheNamespaceId(ANON_NAMESPACE, this.m_anonNSId);
    }

    public void setConnection(IDBConnection iDBConnection) throws RDFRDBException {
        this.m_dbcon = iDBConnection;
        try {
            this.m_sql = new SQLCache(this.SQL_FILE, this.getDefaultSQL(), iDBConnection, this.ID_SQL_TYPE);
            this.m_sql.setCachePreparedStatements(this.CACHE_PREPARED_STATEMENTS);
            try {
                Class.forName(this.DRIVER_NAME);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (IOException iOException) {
            throw new RDFRDBException("Internal error loading sql defintion file: " + this.SQL_FILE, (Exception)iOException);
        }
    }

    protected Properties getDefaultSQL() throws IOException {
        if (m_defaultSQL == null) {
            m_defaultSQL = SQLCache.loadSQLFile(SQL_DEFAULT_FILE, null, this.ID_SQL_TYPE);
        }
        return m_defaultSQL;
    }

    public void close() throws RDFRDBException {
        try {
            this.m_sql.close();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Problem closing RDB driver", (Exception)sQLException);
        }
    }

    public Connection getConnection() throws RDFRDBException {
        try {
            return this.m_dbcon.getConnection();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Problem opening database connection: " + sQLException);
        }
    }

    public SQLCache getSQLCache() {
        return this.m_sql;
    }

    public boolean isDBFormatOK() throws RDFRDBException {
        try {
            Connection connection = this.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, null, "RDF%", stringArray);
            ArrayList<String> arrayList = new ArrayList<String>(10);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("TABLE_NAME").toUpperCase());
            }
            resultSet.close();
            boolean bl = true;
            bl &= arrayList.contains("RDF_RESOURCES");
            bl &= arrayList.contains("RDF_STATEMENTS");
            return bl &= arrayList.contains("RDF_LAYOUT_INFO");
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal SQL error in driver", (Exception)sQLException);
        }
    }

    public void formatDB() throws RDFRDBException {
        try {
            this.m_sql.runSQLGroup("initDBtables");
            this.m_sql.runSQLGroup("initDBgenerators");
            this.m_sql.runSQLGroup("initDBprocedures");
            this.m_dbcon.addProperty("databaseType", this.DATABASE_TYPE);
            this.m_dbcon.addProperty("layoutType", this.LAYOUT_TYPE);
            this.m_dbcon.addProperty("driverClassname", this.getClass().getName());
            this.saveProperties();
        }
        catch (SQLException sQLException) {
            Log.warning("Problem formatting database", sQLException);
            throw new RDFRDBException("Failed to format database", (Exception)sQLException);
        }
    }

    public void cleanDB() {
        Object var1_1 = null;
        try {
            this.m_sql.runSQLGroup("cleanDBprocedures");
        }
        catch (SQLException sQLException) {
            Log.finest("Problem during database clean up", sQLException);
        }
        try {
            this.m_sql.runSQLGroup("cleanDBtables");
        }
        catch (SQLException sQLException) {
            Log.finest("Problem during database clean up", sQLException);
        }
        try {
            this.m_sql.runSQLGroup("cleanDBgenerators");
        }
        catch (SQLException sQLException) {
            Log.finest("Problem during database clean up", sQLException);
        }
    }

    public void loadProperties(Properties properties) {
        this.SUPPORTS_JENA_REIFICATION = false;
        String string = properties.getProperty("jdbcDriver");
        if (string != null) {
            this.DRIVER_NAME = string;
        }
        if ((string = properties.getProperty("sqlFile")) != null) {
            this.SQL_FILE = string;
        }
        if ((string = properties.getProperty("layout")) != null) {
            this.LAYOUT_TYPE = string;
        }
        if ((string = properties.getProperty("database")) != null) {
            this.DATABASE_TYPE = string;
        }
        if ((string = properties.getProperty("idType")) != null) {
            this.ID_SQL_TYPE = string;
        }
        if ((string = properties.getProperty("maxLiteral")) != null) {
            this.MAX_LITERAL = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("allocateID")) != null) {
            boolean bl = this.SKIP_ALLOCATE_ID = !string.equals("true");
        }
        if ((string = properties.getProperty("checkDuplicates")) != null) {
            boolean bl = this.SKIP_DUPLICATE_CHECK = !string.equals("true");
        }
        if ((string = properties.getProperty("insertByProcedure")) != null) {
            this.INSERT_BY_PROCEDURE = string.equals("true");
        }
        if ((string = properties.getProperty("supportsJenaReification")) != null) {
            this.SUPPORTS_JENA_REIFICATION = string.equals("true");
        }
    }

    public void saveProperties() throws SQLException {
        this.m_dbcon.addProperty("jdbcDriver", this.DRIVER_NAME);
        this.m_dbcon.addProperty("sqlFile", this.SQL_FILE);
        this.m_dbcon.addProperty("layout", this.LAYOUT_TYPE);
        this.m_dbcon.addProperty("database", this.DATABASE_TYPE);
        this.m_dbcon.addProperty("idType", this.ID_SQL_TYPE);
        this.m_dbcon.addProperty("maxLiteral", Integer.toString(this.MAX_LITERAL));
        this.m_dbcon.addProperty("allocateID", this.SKIP_ALLOCATE_ID ? "false" : "true");
        this.m_dbcon.addProperty("checkDuplicates", this.SKIP_DUPLICATE_CHECK ? "false" : "true");
        this.m_dbcon.addProperty("insertByProcedure", this.INSERT_BY_PROCEDURE ? "true" : "false");
        this.m_dbcon.addProperty("supportsJenaReification", this.SUPPORTS_JENA_REIFICATION ? "true" : "false");
        this.m_dbcon.addProperty("cachePreparedStatements", this.CACHE_PREPARED_STATEMENTS ? "true" : "false");
    }

    public String toString() {
        return "jena.rdb.Driver" + this.LAYOUT_TYPE + this.DATABASE_TYPE + "(" + this.SQL_FILE + ")";
    }

    public void setCacheLimits(int n, int n2) {
        this.literalCache.setLimit(n);
        this.resourceCache.setLimit(n2);
    }

    public void preloadCaches(ModelRDB modelRDB) throws RDFException {
        this.resourceCache.setLimit(-1);
        this.literalCache.setLimit(-1);
        try {
            IDBID iDBID;
            Object object;
            Object object2;
            Object object3;
            Object[] objectArray = null;
            if (this.supportsMultipleModels()) {
                objectArray = new Object[]{modelRDB.getDBID().getID()};
            }
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("listResources", objectArray);
            Resource resource = null;
            while (resultSetIterator.hasNext()) {
                object3 = (List)resultSetIterator.next();
                object2 = this.wrapDBID(object3.get(0));
                object = (String)object3.get(1);
                iDBID = this.wrapDBID(object3.get(2));
                if (this.supportsJenaReification()) {
                    IDBID iDBID2 = this.wrapDBID(object3.get(3));
                    if (iDBID2 == null || iDBID2.getID() == null) {
                        resource = this.makeResource((IDBID)object2, (String)object, iDBID, modelRDB);
                        continue;
                    }
                    StatementImplRDB statementImplRDB = new StatementImplRDB(null, null, null, modelRDB);
                    statementImplRDB.setRDBId((IDBID)object2);
                    statementImplRDB.setRDBNSId(iDBID);
                    statementImplRDB.setURI(this.makeResource((IDBID)object2, (String)object, iDBID, modelRDB));
                    this.resourceCache.put((IDBID)object2, statementImplRDB);
                    continue;
                }
                resource = this.makeResource((IDBID)object2, (String)object, iDBID, modelRDB);
            }
            object3 = this.m_sql.getPreparedSQLStatement("listLiterals");
            if (this.supportsMultipleModels()) {
                object3.setObject(1, modelRDB.getDBID().getID());
            }
            object2 = object3.executeQuery();
            while (object2.next()) {
                object = this.extractLiteralFromRow((ResultSet)object2);
                iDBID = this.wrapDBID(object2.getObject(5));
                this.literalCache.put(iDBID, object);
            }
            object2.close();
            this.m_sql.returnPreparedSQLStatement((PreparedStatement)object3, "listLiterals");
        }
        catch (Exception exception) {
            throw new RDFRDBException("Internal sql error", exception);
        }
    }

    public synchronized void attachStore(StoreRDB storeRDB) {
        this.m_clientStores.add(storeRDB);
    }

    public synchronized void detachStore(StoreRDB storeRDB) {
        this.m_clientStores.remove(storeRDB);
        if (this.m_clientStores.isEmpty()) {
            try {
                this.close();
            }
            catch (RDFRDBException rDFRDBException) {
                Log.warning("Error which cleaning up RDB store", rDFRDBException);
            }
        }
    }

    public void addStatement(Statement statement, ModelRDB modelRDB) throws RDFException {
        try {
            Object object;
            if (!this.SKIP_DUPLICATE_CHECK && (object = this.getStatementStatus(statement.getSubject(), statement.getPredicate(), statement.getObject(), modelRDB)) != null) {
                if (((StatementStatus)object).isReified) {
                    this.m_sql.runSQLQuery("assertReifiedStatement", new Object[]{((StatementStatus)object).statementID.getID()});
                }
                return;
            }
            object = this.addResource(statement.getPredicate());
            IDBID iDBID = this.addResource(statement.getSubject());
            RDFNode rDFNode = statement.getObject();
            IDBID iDBID2 = null;
            boolean bl = rDFNode instanceof Literal;
            iDBID2 = bl ? this.addLiteral((Literal)rDFNode) : this.addResource((Resource)rDFNode);
            Object[] objectArray = null;
            if (this.supportsJenaReification()) {
                Object object2;
                IDBID iDBID3 = null;
                if (!this.SKIP_ALLOCATE_ID) {
                    iDBID3 = this.allocateStatementID(statement, modelRDB.getDBID());
                }
                if (!statement.isAnon()) {
                    object2 = this.addResource(statement);
                    iDBID3 = ((StatementImplRDB)statement).getRDBId();
                    this.m_sql.runSQLQuery("assertReifiedStatement", new Object[]{iDBID3.getID()});
                } else {
                    objectArray = this.SKIP_ALLOCATE_ID ? new Object[]{iDBID.getID(), object.getID(), iDBID2.getID(), this.wrapFlag(bl), modelRDB.getDBID().getID()} : new Object[]{iDBID.getID(), object.getID(), iDBID2.getID(), this.wrapFlag(bl), modelRDB.getDBID().getID(), iDBID3.getID()};
                    this.m_sql.runSQLQuery("insertStatement", objectArray);
                }
                if (statement instanceof StatementImplRDB && this.supportsJenaReification()) {
                    if (iDBID3 != null) {
                        ((StatementImplRDB)statement).setRDBStatementId(iDBID3);
                    } else {
                        object2 = this.getStatementStatus(statement.getSubject(), statement.getPredicate(), statement.getObject(), modelRDB);
                        ((StatementImplRDB)statement).setRDBStatementId(((StatementStatus)object2).statementID);
                    }
                }
            } else {
                objectArray = new Object[]{iDBID.getID(), object.getID(), iDBID2.getID(), this.wrapFlag(bl), modelRDB.getDBID().getID()};
                this.m_sql.runSQLQuery(this.INSERT_BY_PROCEDURE ? "insertStatementProc" : "insertStatement", objectArray);
            }
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to register statement", (Exception)sQLException);
        }
    }

    public ResultSetIterator listSubjects(ModelRDB modelRDB) throws RDFRDBException {
        try {
            Object[] objectArray = null;
            if (this.supportsMultipleModels()) {
                objectArray = new Object[]{modelRDB.getDBID().getID()};
            }
            ResultSetResourceIterator resultSetResourceIterator = new ResultSetResourceIterator(modelRDB, this);
            return this.m_sql.runSQLQuery("listSubjects", objectArray, resultSetResourceIterator);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failure in listSubjects", (Exception)sQLException);
        }
    }

    public ResultSetIterator listNamespaces(ModelRDB modelRDB) throws RDFRDBException {
        try {
            ResultSetStringIterator resultSetStringIterator = new ResultSetStringIterator();
            Object[] objectArray = null;
            if (this.supportsMultipleModels()) {
                objectArray = new Object[]{modelRDB.getDBID().getID()};
            }
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("listNamespaces", objectArray, resultSetStringIterator);
            return resultSetIterator;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failure in listNamespaces", (Exception)sQLException);
        }
    }

    public ResultSetIterator listStatements(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        String string = "list";
        if (resource != null) {
            string = string + "S";
        }
        if (property != null) {
            string = string + "P";
        }
        if (rDFNode != null) {
            string = string + "O";
        }
        try {
            Object[] objectArray = this.statementArgs(resource, property, rDFNode, modelRDB);
            if (objectArray == null) {
                return new ResultSetIterator();
            }
            return this.m_sql.runSQLQuery(string, objectArray, new ResultSetStatementIterator(modelRDB, this));
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in " + string, (Exception)sQLException);
        }
    }

    public boolean isStatementPresent(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        StatementStatus statementStatus = this.getStatementStatus(resource, property, rDFNode, modelRDB);
        return statementStatus != null && !statementStatus.isReified;
    }

    protected StatementStatus getStatementStatus(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        try {
            Object[] objectArray = this.statementArgs(resource, property, rDFNode, modelRDB);
            if (objectArray == null) {
                return null;
            }
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("checkStatement", objectArray);
            StatementStatus statementStatus = null;
            if (resultSetIterator.hasNext()) {
                statementStatus = new StatementStatus();
                if (this.supportsJenaReification()) {
                    List list = (List)resultSetIterator.next();
                    statementStatus.isReified = ((Number)list.get(0)).intValue() == 1;
                    statementStatus.statementID = this.wrapDBID(list.get(1));
                    statementStatus.reificationID = this.wrapDBID(list.get(2));
                } else {
                    statementStatus.isReified = false;
                }
            }
            resultSetIterator.close();
            return statementStatus;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in isStatementPresent", (Exception)sQLException);
        }
    }

    public ResultSetIterator listStatements(IConstraints iConstraints, ModelRDB modelRDB) throws RDFException {
        return iConstraints.runQuery(this, modelRDB);
    }

    public IConstraints createConstraints(ModelRDB modelRDB) {
        return new ConstraintsGeneric(modelRDB);
    }

    public boolean deleteStatement(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        try {
            if (resource == null || rDFNode == null) {
                return false;
            }
            Object[] objectArray = this.statementArgs(resource, property, rDFNode, modelRDB);
            if (objectArray == null) {
                return false;
            }
            return this.m_sql.runSQLUpdate("deleteStatement", objectArray) > 0;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in deleteStatement", (Exception)sQLException);
        }
    }

    public boolean deleteStatement(IDBID iDBID, ModelRDB modelRDB) throws RDFException {
        try {
            if (this.supportsMultipleModels()) {
                return this.m_sql.runSQLUpdate("deleteStatementID", new Object[]{iDBID.getID(), modelRDB.getDBID().getID()}) > 0;
            }
            return this.m_sql.runSQLUpdate("deleteStatementID", new Object[]{iDBID.getID()}) > 0;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in deleteStatement", (Exception)sQLException);
        }
    }

    public void clear(ModelRDB modelRDB) throws RDFRDBException {
        try {
            if (this.supportsMultipleModels()) {
                this.m_sql.runSQLQuery("deleteAllStatements", new Object[]{modelRDB.getDBID().getID()});
            } else {
                this.m_sql.runSQLQuery("deleteAllStatements", new Object[0]);
            }
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in deleteAllStatements", (Exception)sQLException);
        }
    }

    public Resource getResource(String string, ModelRDB modelRDB) throws RDFException {
        ResourceImplRDB resourceImplRDB = new ResourceImplRDB(string, (Model)modelRDB);
        return resourceImplRDB;
    }

    public Property getProperty(String string, ModelRDB modelRDB) throws RDFException {
        PropertyImplRDB propertyImplRDB = new PropertyImplRDB(string, (Model)modelRDB);
        return propertyImplRDB;
    }

    public boolean supportsJenaReification() {
        return this.SUPPORTS_JENA_REIFICATION;
    }

    public ResultSetIterator listReifiedStatements(ModelRDB modelRDB) throws RDFException {
        try {
            Object[] objectArray = this.statementArgs(null, null, null, modelRDB);
            return this.m_sql.runSQLQuery("listReifiedStatements", objectArray, new ResultSetStatementIterator(modelRDB, this));
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in listReifiedStatements", (Exception)sQLException);
        }
    }

    public boolean supportsMultipleModels() {
        return false;
    }

    public IDBID allocateModelID(String string) throws RDFRDBException {
        return new DBIDInt(0);
    }

    public IDBID getModelID(String string) throws RDFRDBException {
        throw new RDFRDBException("Generic driver does not support multiple models in one database.\nCaught attempting to access model: " + string);
    }

    public void deleteModel(String string) throws RDFRDBException {
        throw new RDFRDBException("Generic driver does not support multiple models in one database.\nCaught attempting to delete model: " + string);
    }

    public Iterator listModels() throws RDFRDBException {
        return ((AbstractList)new ArrayList()).iterator();
    }

    protected IDBID allocateID(String string) throws RDFRDBException {
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery(string, new Object[0]);
            if (resultSetIterator.hasNext()) {
                return this.wrapDBID(resultSetIterator.getSingleton());
            }
            throw new RDFRDBException("Failed to allocate ID");
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    public String getNamespace(IDBID iDBID) throws RDFRDBException {
        String string = (String)this.m_namespaceMap.get(iDBID);
        if (string == null) {
            try {
                ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getNamespace", new Object[]{iDBID.getID()});
                if (resultSetIterator.hasNext()) {
                    string = (String)resultSetIterator.getSingleton();
                } else {
                    string = null;
                    resultSetIterator.close();
                }
                if (string != null) {
                    this.cacheNamespaceId(string, iDBID);
                }
            }
            catch (SQLException sQLException) {
                throw new RDFRDBException("Internal error fetching namespace name", (Exception)sQLException);
            }
        }
        return string;
    }

    protected IDBID getNamespaceID(String string) throws RDFRDBException {
        if (this.m_namespaceIDMap.containsKey(string)) {
            return (IDBID)this.m_namespaceIDMap.get(string);
        }
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getNamespaceID", new Object[]{string});
            if (resultSetIterator.hasNext()) {
                IDBID iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                this.cacheNamespaceId(string, iDBID);
                return iDBID;
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    protected IDBID allocateNamespaceID(String string) throws RDFRDBException {
        if (this.m_namespaceIDMap.containsKey(string)) {
            return (IDBID)this.m_namespaceIDMap.get(string);
        }
        return this.allocateID("allocateNamespaceID");
    }

    protected IDBID addNamespace(String string) throws RDFRDBException {
        if (this.m_namespaceIDMap.containsKey(string)) {
            return (IDBID)this.m_namespaceIDMap.get(string);
        }
        Object[] objectArray = null;
        IDBID iDBID = null;
        if (!this.SKIP_DUPLICATE_CHECK && (iDBID = this.getNamespaceID(string)) != null) {
            return iDBID;
        }
        if (!this.SKIP_ALLOCATE_ID) {
            iDBID = this.allocateNamespaceID(string);
            objectArray = new Object[]{iDBID.getID(), string};
        } else {
            objectArray = new Object[]{string};
        }
        try {
            if (this.INSERT_BY_PROCEDURE) {
                ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("insertNamespaceProc", objectArray);
                if (resultSetIterator != null && resultSetIterator.hasNext()) {
                    iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                }
            } else {
                this.m_sql.runSQLQuery("insertNamespace", objectArray);
            }
            if (iDBID == null) {
                iDBID = this.getNamespaceID(string);
            }
            this.cacheNamespaceId(string, iDBID);
            return iDBID;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    public Literal getLiteral(IDBID iDBID) throws RDFException {
        Literal literal = this.getLiteralFromCache(iDBID);
        if (literal != null) {
            return literal;
        }
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("getLiteral");
            preparedStatement.setObject(1, iDBID.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                this.m_sql.returnPreparedSQLStatement(preparedStatement, "getLiteral");
                return null;
            }
            literal = this.extractLiteralFromRow(resultSet);
            resultSet.close();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, "getLiteral");
            this.literalCache.put(iDBID, literal);
            return literal;
        }
        catch (Exception exception) {
            throw new RDFRDBException("Internal sql error", exception);
        }
    }

    public Literal getLiteralFromCache(IDBID iDBID) {
        return (Literal)this.literalCache.get(iDBID);
    }

    private Literal extractLiteralFromRow(ResultSet resultSet) throws SQLException, IOException, RDFException, UnsupportedEncodingException {
        int n;
        Object object;
        Object object2 = resultSet.getObject(1);
        String string = null;
        if (object2 == null) {
            string = resultSet.getString(2);
        } else {
            object = null;
            object = object instanceof InputStream ? (InputStream)object2 : resultSet.getBinaryStream(1);
            n = ((InputStream)object).read() & 0xFF;
            n |= (((InputStream)object).read() & 0xFF) << 8;
            n |= (((InputStream)object).read() & 0xFF) << 16;
            byte[] byArray = new byte[n |= (((InputStream)object).read() & 0xFF) << 24];
            int n2 = 0;
            while (n2 < n) {
                int n4 = ((InputStream)object).read(byArray, n2, n - n2);
                if (n4 == -1) {
                    throw new RDFRDBException("Premature end of blob in large literal, got " + n2);
                }
                n2 += n4;
            }
            ((InputStream)object).close();
            string = new String(byArray, "UTF-8");
        }
        object = resultSet.getString(3);
        n = resultSet.getInt(4);
        return new LiteralImpl(string, (String)object, n == 1);
    }

    protected IDBID addLiteral(Literal literal) throws RDFRDBException {
        IDBID iDBID = null;
        if (!this.SKIP_DUPLICATE_CHECK && (iDBID = this.getLiteralID(literal)) != null) {
            return iDBID;
        }
        try {
            Object object;
            String string;
            int n;
            String string2;
            int n2 = 0;
            boolean bl = false;
            try {
                n2 = Integer.parseInt(literal.toString());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            String string3 = string2 = bl ? "insertLiteralInt" : "insertLiteral";
            if (this.INSERT_BY_PROCEDURE) {
                string2 = string2 + "Proc";
            }
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2);
            int n4 = 1;
            if (!this.SKIP_ALLOCATE_ID) {
                iDBID = this.allocateLiteralID(literal);
                preparedStatement.setObject(n4++, iDBID.getID());
            }
            if ((n = (string = literal.toString()).length()) >= this.MAX_LITERAL) {
                preparedStatement.setString(n4++, this.getLiteralIdx(string));
                object = string.getBytes("UTF-8");
                int n5 = ((byte[])object).length;
                byte[] byArray = new byte[n5 + 4];
                byArray[0] = (byte)(n5 & 0xFF);
                byArray[1] = (byte)(n5 >> 8 & 0xFF);
                byArray[2] = (byte)(n5 >> 16 & 0xFF);
                byArray[3] = (byte)(n5 >> 24 & 0xFF);
                System.arraycopy(object, 0, byArray, 4, n5);
                preparedStatement.setBinaryStream(n4++, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            } else {
                preparedStatement.setString(n4++, string);
                preparedStatement.setNull(n4++, 2004);
            }
            preparedStatement.setString(n4++, literal.getLanguage());
            preparedStatement.setInt(n4++, literal.getWellFormed() ? 1 : 0);
            if (bl) {
                preparedStatement.setInt(n4++, n2);
            }
            if (this.INSERT_BY_PROCEDURE) {
                object = preparedStatement.executeQuery();
                ResultSetIterator resultSetIterator = new ResultSetIterator((ResultSet)object, preparedStatement, this.m_sql, string2);
                if (resultSetIterator != null && resultSetIterator.hasNext()) {
                    iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                }
            } else {
                preparedStatement.executeUpdate();
                this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
            }
            if (iDBID == null) {
                iDBID = this.getLiteralID(literal);
            }
            return iDBID;
        }
        catch (Exception exception) {
            System.out.println("Problem on literal (l=" + literal.toString().length() + ") ");
            System.out.println("ID is: " + iDBID);
            throw new RDFRDBException("Failed to register literal", exception);
        }
    }

    public IDBID getLiteralID(Literal literal) throws RDFRDBException {
        try {
            ResultSetIterator resultSetIterator;
            String string = literal.toString();
            if (string.length() >= this.MAX_LITERAL) {
                string = this.getLiteralIdx(string);
            }
            if ((resultSetIterator = this.m_sql.runSQLQuery("getLiteralID", new Object[]{string, literal.getLanguage()})).hasNext()) {
                return this.wrapDBID(resultSetIterator.getSingleton());
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find literal", (Exception)sQLException);
        }
    }

    protected IDBID allocateLiteralID(Literal literal) throws RDFRDBException {
        return this.allocateID("allocateLiteralID");
    }

    protected IDBID addResource(Resource resource) throws RDFException {
        Object object;
        String string;
        boolean bl;
        IDBID iDBID;
        boolean bl2 = resource instanceof HasRDBID;
        HasRDBID hasRDBID = bl2 ? (HasRDBID)((Object)resource) : null;
        IDBID iDBID2 = iDBID = resource instanceof HasRDBID ? ((HasRDBID)((Object)resource)).getRDBId() : null;
        if (iDBID != null) {
            return iDBID;
        }
        Object[] objectArray = null;
        int n = 0;
        if (!this.SKIP_DUPLICATE_CHECK && (iDBID = this.getResourceID(resource)) != null) {
            return iDBID;
        }
        int n2 = 2;
        boolean bl3 = bl = this.supportsJenaReification() && resource instanceof StatementImplRDB;
        if (bl) {
            ++n2;
        }
        if (!this.SKIP_ALLOCATE_ID) {
            iDBID = this.allocateResourceID(resource);
            objectArray = new Object[n2 + 1];
            objectArray[n++] = iDBID.getID();
        } else {
            objectArray = new Object[n2];
        }
        String string2 = resource.isAnon() ? ANON_NAMESPACE : resource.getNameSpace();
        String string3 = string = resource.isAnon() ? resource.getId().toString() : resource.getLocalName();
        if (string.equals("")) {
            object = resource.getURI();
            int n4 = DriverGenericGeneric.splitNamespace((String)object);
            string2 = ((String)object).substring(0, n4);
            string = ((String)object).substring(n4);
        }
        objectArray[n++] = string;
        Object object2 = object = bl2 ? hasRDBID.getRDBNSId() : null;
        if (object == null) {
            Object object3 = object = resource.isAnon() ? this.m_anonNSId : this.addNamespace(string2);
            if (bl2) {
                hasRDBID.setRDBNSId((IDBID)object);
            }
        }
        objectArray[n++] = object.getID();
        IDBID iDBID3 = null;
        if (bl) {
            iDBID3 = this.addReifiedStatement((StatementImplRDB)resource, (ModelRDB)resource.getModel(), iDBID);
            objectArray[n++] = iDBID3.getID();
        }
        try {
            Object object4;
            if (this.INSERT_BY_PROCEDURE) {
                object4 = this.m_sql.runSQLQuery("insertResourceProc", objectArray);
                if (object4 != null && ((ResultSetIterator)object4).hasNext()) {
                    iDBID = this.wrapDBID(((ResultSetIterator)object4).getSingleton());
                }
            } else if (bl) {
                this.m_sql.runSQLQuery("insertResourceAsStatement", objectArray);
            } else {
                this.m_sql.runSQLQuery("insertResource", objectArray);
            }
            if (this.supportsJenaReification() && bl && this.SKIP_ALLOCATE_ID) {
                if (iDBID == null) {
                    object4 = null;
                    object4 = resource.isAnon() ? new ResourceImplRDB(resource.getId(), resource.getModel()) : new ResourceImplRDB(string2, string);
                    iDBID = this.getResourceID((Resource)object4);
                }
                this.m_sql.runSQLQuery("setStatementReification", new Object[]{iDBID.getID(), iDBID3.getID()});
            } else if (iDBID == null) {
                iDBID = this.getResourceID(resource);
            }
            if (bl2) {
                hasRDBID.setRDBId(iDBID);
            }
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to register resource", (Exception)sQLException);
        }
        return iDBID;
    }

    public IDBID getResourceID(Resource resource) throws RDFException {
        try {
            Object object;
            String string;
            if (this.supportsJenaReification() && resource instanceof Statement) {
                return this.getReifiedStatementID((Statement)resource, (ModelRDB)resource.getModel());
            }
            HasRDBID hasRDBID = (HasRDBID)((Object)resource);
            IDBID iDBID = hasRDBID.getRDBId();
            if (iDBID != null) {
                return iDBID;
            }
            String string2 = resource.isAnon() ? ANON_NAMESPACE : resource.getNameSpace();
            String string3 = string = resource.isAnon() ? resource.getId().toString() : resource.getLocalName();
            if (string.equals("")) {
                object = resource.getURI();
                int n = DriverGenericGeneric.splitNamespace((String)object);
                string2 = ((String)object).substring(0, n);
                string = ((String)object).substring(n);
            }
            if ((object = this.getNamespaceID(string2)) == null) {
                return null;
            }
            hasRDBID.setRDBNSId((IDBID)object);
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getResourceID", new Object[]{string, object.getID()});
            if (resultSetIterator.hasNext()) {
                iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                hasRDBID.setRDBId(iDBID);
                return iDBID;
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find resource", (Exception)sQLException);
        }
    }

    protected IDBID getReifiedStatementID(Statement statement, ModelRDB modelRDB) throws RDFException {
        StatementStatus statementStatus = this.getStatementStatus(statement.getSubject(), statement.getPredicate(), statement.getObject(), modelRDB);
        if (statementStatus != null) {
            return statementStatus.reificationID;
        }
        return null;
    }

    protected IDBID addReifiedStatement(StatementImplRDB statementImplRDB, ModelRDB modelRDB, IDBID iDBID) throws RDFException {
        try {
            StatementStatus statementStatus = this.getStatementStatus(statementImplRDB.getSubject(), statementImplRDB.getPredicate(), statementImplRDB.getObject(), modelRDB);
            if (statementStatus != null && statementStatus.statementID != null) {
                if (statementStatus.reificationID == null && iDBID != null) {
                    this.m_sql.runSQLQuery("setStatementReification", new Object[]{iDBID.getID(), statementStatus.statementID.getID()});
                }
                return statementStatus.statementID;
            }
            IDBID iDBID2 = this.addResource(statementImplRDB.getPredicate());
            IDBID iDBID3 = this.addResource(statementImplRDB.getSubject());
            RDFNode rDFNode = statementImplRDB.getObject();
            IDBID iDBID4 = null;
            boolean bl = rDFNode instanceof Literal;
            iDBID4 = bl ? this.addLiteral((Literal)rDFNode) : this.addResource((Resource)rDFNode);
            IDBID iDBID5 = null;
            Object[] objectArray = null;
            if (!this.SKIP_ALLOCATE_ID) {
                iDBID5 = this.allocateStatementID(statementImplRDB, modelRDB.getDBID());
                objectArray = new Object[]{iDBID3.getID(), iDBID2.getID(), iDBID4.getID(), this.wrapFlag(bl), modelRDB.getDBID().getID(), iDBID5.getID(), this.wrapFlag(true), iDBID.getID()};
            } else {
                objectArray = new Object[]{iDBID3.getID(), iDBID2.getID(), iDBID4.getID(), this.wrapFlag(bl), modelRDB.getDBID().getID(), this.wrapFlag(true)};
            }
            this.m_sql.runSQLQuery("insertReifiedStatement", objectArray);
            if (iDBID5 == null) {
                statementStatus = this.getStatementStatus(statementImplRDB.getSubject(), statementImplRDB.getPredicate(), statementImplRDB.getObject(), modelRDB);
                iDBID5 = statementStatus.statementID;
            }
            statementImplRDB.setRDBStatementId(iDBID5);
            return iDBID5;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to register reified statement", (Exception)sQLException);
        }
    }

    protected IDBID allocateResourceID(Resource resource) throws RDFException {
        return this.allocateID("allocateResourceID");
    }

    protected IDBID allocateStatementID(Statement statement, IDBID iDBID) throws RDFException {
        return this.allocateID("allocateStatementID");
    }

    public Resource getResource(IDBID iDBID, ModelRDB modelRDB) throws RDFException {
        Resource resource = this.getResourceFromCache(iDBID, modelRDB);
        if (resource != null) {
            return resource;
        }
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getResource", new Object[]{iDBID.getID()});
            if (resultSetIterator.hasNext()) {
                List list = (List)resultSetIterator.next();
                String string = (String)list.get(0);
                IDBID iDBID2 = this.wrapDBID(list.get(1));
                if (this.supportsJenaReification()) {
                    IDBID iDBID3 = this.wrapDBID(list.get(2));
                    resultSetIterator.close();
                    resource = this.makeResource(iDBID, string, iDBID2, modelRDB, iDBID3);
                } else {
                    resultSetIterator.close();
                    resource = this.makeResource(iDBID, string, iDBID2, modelRDB);
                }
                return resource;
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    public Resource getResourceFromCache(IDBID iDBID, ModelRDB modelRDB) throws RDFException {
        Resource resource = (Resource)this.resourceCache.get(iDBID);
        if (resource != null && resource.getModel() != modelRDB) {
            return modelRDB.convert(resource);
        }
        return resource;
    }

    public Property getPropertyFromCache(IDBID iDBID, ModelRDB modelRDB) throws RDFException {
        Resource resource = (Resource)this.resourceCache.get(iDBID);
        if (resource instanceof Property) {
            return (Property)resource;
        }
        if (resource instanceof HasRDBID) {
            Object object;
            String string;
            HasRDBID hasRDBID = (HasRDBID)((Object)resource);
            String string2 = resource.isAnon() ? ANON_NAMESPACE : resource.getNameSpace();
            String string3 = string = resource.isAnon() ? resource.getId().toString() : resource.getLocalName();
            if (string.equals("")) {
                object = resource.getURI();
                int n = DriverGenericGeneric.splitNamespace((String)object);
                string2 = ((String)object).substring(0, n);
                string = ((String)object).substring(n);
            }
            object = new PropertyImplRDB(string2, string, modelRDB);
            ((ResourceImplRDB)object).setRDBId(hasRDBID.getRDBId());
            ((ResourceImplRDB)object).setRDBNSId(hasRDBID.getRDBNSId());
            this.resourceCache.put(iDBID, object);
            return object;
        }
        return null;
    }

    public StatementImplRDB getBareStatementResource(IDBID iDBID, ModelRDB modelRDB) throws RDFException {
        Object object;
        Object object2;
        Resource resource = this.getResourceFromCache(iDBID, modelRDB);
        if (resource == null) {
            try {
                object2 = this.m_sql.runSQLQuery("getResource", new Object[]{iDBID.getID()});
                if (!((ResultSetIterator)object2).hasNext()) {
                    return null;
                }
                object = (List)((ResultSetIterator)object2).next();
                String string = (String)object.get(0);
                IDBID iDBID2 = this.wrapDBID(object.get(1));
                ((ResultSetIterator)object2).close();
                resource = this.makeResource(iDBID, string, iDBID2, modelRDB);
            }
            catch (SQLException sQLException) {
                throw new RDFRDBException("Internal sql error", (Exception)sQLException);
            }
        }
        if (!(resource instanceof StatementImplRDB)) {
            object2 = new StatementImplRDB(null, null, null, modelRDB);
            object = (HasRDBID)((Object)resource);
            ((StatementImplRDB)object2).setRDBId(object.getRDBId());
            ((StatementImplRDB)object2).setRDBNSId(object.getRDBNSId());
            ((StatementImplRDB)object2).setURI(resource);
            this.resourceCache.put(iDBID, object2);
            return object2;
        }
        return (StatementImplRDB)resource;
    }

    public Property getProperty(IDBID iDBID, ModelRDB modelRDB) throws RDFException {
        Property property = this.getPropertyFromCache(iDBID, modelRDB);
        if (property != null) {
            return property;
        }
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getResource", new Object[]{iDBID.getID()});
            if (resultSetIterator.hasNext()) {
                List list = (List)resultSetIterator.next();
                String string = (String)list.get(0);
                IDBID iDBID2 = this.wrapDBID(list.get(1));
                resultSetIterator.close();
                return this.makeProperty(iDBID, string, iDBID2, modelRDB);
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    protected String getLiteralIdx(String string) {
        String string2 = string;
        if (string.length() > this.MAX_LITERAL - 16) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(string.getBytes());
            string2 = string.substring(0, this.MAX_LITERAL - 16) + Long.toHexString(cRC32.getValue());
        }
        return string2;
    }

    public IDBID wrapDBID(Object object) throws RDFRDBException {
        if (object instanceof Number) {
            return new DBIDInt(((Number)object).intValue());
        }
        if (object == null) {
            return null;
        }
        throw new RDFRDBException("Unexpected DB identifier type: " + object);
    }

    public Object wrapFlag(boolean bl) {
        return bl ? new Short(1) : new Short(0);
    }

    protected void cacheNamespaceId(String string, IDBID iDBID) {
        if (!this.m_namespaceMap.containsKey(iDBID)) {
            this.m_namespaceMap.put(iDBID, string);
            this.m_namespaceIDMap.put(string, iDBID);
        }
    }

    public Property makeProperty(IDBID iDBID, String string, IDBID iDBID2, ModelRDB modelRDB) throws RDFException {
        Property property = this.getPropertyFromCache(iDBID, modelRDB);
        if (property == null) {
            PropertyImplRDB propertyImplRDB = new PropertyImplRDB(this.getNamespace(iDBID2), string, modelRDB);
            propertyImplRDB.setRDBId(iDBID);
            propertyImplRDB.setRDBNSId(iDBID2);
            this.resourceCache.put(iDBID, propertyImplRDB);
            property = propertyImplRDB;
        }
        return property;
    }

    public Resource makeResource(IDBID iDBID, String string, IDBID iDBID2, ModelRDB modelRDB) throws RDFException {
        Resource resource = this.getResourceFromCache(iDBID, modelRDB);
        if (resource != null) {
            return resource;
        }
        ResourceImplRDB resourceImplRDB = null;
        resourceImplRDB = iDBID2.equals(this.m_anonNSId) ? new ResourceImplRDB(new AnonId(string), (Model)modelRDB) : (string == null ? new ResourceImplRDB(this.getNamespace(iDBID2), (Model)modelRDB) : new ResourceImplRDB(this.getNamespace(iDBID2) + string, (Model)modelRDB));
        resourceImplRDB.setRDBId(iDBID);
        resourceImplRDB.setRDBNSId(iDBID2);
        this.resourceCache.put(iDBID, resourceImplRDB);
        return resourceImplRDB;
    }

    public Resource makeResource(IDBID iDBID, String string, IDBID iDBID2, ModelRDB modelRDB, IDBID iDBID3) throws RDFException {
        if (iDBID3 == null || iDBID3.getID() == null) {
            return this.makeResource(iDBID, string, iDBID2, modelRDB);
        }
        Resource resource = this.getResourceFromCache(iDBID, modelRDB);
        if (resource != null && resource instanceof StatementImplRDB) {
            return resource;
        }
        try {
            Object[] objectArray = null;
            objectArray = this.supportsMultipleModels() ? new Object[]{iDBID3.getID(), modelRDB.getDBID().getID()} : new Object[]{iDBID3.getID()};
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getReifiedStatement", objectArray, new ResultSetStatementIterator(modelRDB, this));
            if (resultSetIterator.hasNext()) {
                StatementImplRDB statementImplRDB = (StatementImplRDB)resultSetIterator.next();
                resultSetIterator.close();
                statementImplRDB.setRDBId(iDBID);
                statementImplRDB.setRDBNSId(iDBID2);
                statementImplRDB.setURI(this.makeResource(iDBID, string, iDBID2, modelRDB));
                this.resourceCache.put(iDBID, statementImplRDB);
                return statementImplRDB;
            }
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("error in makeresource", (Exception)sQLException);
        }
        return null;
    }

    public void loadDatabaseDriver() throws RDFRDBException {
        try {
            Class.forName(this.DRIVER_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RDFRDBException("Unable to load driver: " + this.DRIVER_NAME);
        }
    }

    protected Object[] statementArgs(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        IDBID iDBID;
        int n = 0;
        int n2 = 0;
        if (resource != null) {
            ++n2;
        }
        if (property != null) {
            ++n2;
        }
        if (rDFNode != null) {
            n2 += 2;
        }
        if (this.supportsMultipleModels()) {
            ++n2;
        }
        Object[] objectArray = new Object[n2];
        if (resource != null) {
            iDBID = this.getResourceID(resource);
            if (iDBID == null) {
                return null;
            }
            objectArray[n++] = iDBID.getID();
        }
        if (property != null) {
            iDBID = this.getResourceID(property);
            if (iDBID == null) {
                return null;
            }
            objectArray[n++] = iDBID.getID();
        }
        if (rDFNode != null) {
            if (rDFNode instanceof Literal) {
                iDBID = this.getLiteralID((Literal)rDFNode);
                if (iDBID == null) {
                    return null;
                }
                objectArray[n++] = iDBID.getID();
                objectArray[n++] = this.wrapFlag(true);
            } else {
                iDBID = this.getResourceID((Resource)rDFNode);
                if (iDBID == null) {
                    return null;
                }
                objectArray[n++] = iDBID.getID();
                objectArray[n++] = this.wrapFlag(false);
            }
        }
        if (this.supportsMultipleModels()) {
            objectArray[n++] = modelRDB.getDBID().getID();
        }
        return objectArray;
    }

    public void hintPropertyTable(Property property) throws RDFException {
    }

    public static int splitNamespace(String string) {
        if (string.length() == 0) {
            return 0;
        }
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (!('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '_' || c == '.' || c == ':')) {
                return n + 1;
            }
            --n;
        }
        return 0;
    }

    static class StatementStatus {
        boolean isReified = false;
        IDBID statementID = null;
        IDBID reificationID = null;

        StatementStatus() {
        }
    }
}

