/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.regression;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.common.EnhResource;
import com.hp.hpl.mesa.rdf.jena.common.ErrorHelper;
import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.common.regression.ResTestObj;
import com.hp.hpl.mesa.rdf.jena.common.regression.ResourceReader;
import com.hp.hpl.mesa.rdf.jena.model.Alt;
import com.hp.hpl.mesa.rdf.jena.model.Bag;
import com.hp.hpl.mesa.rdf.jena.model.Container;
import com.hp.hpl.mesa.rdf.jena.model.JenaConfig;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.NsIterator;
import com.hp.hpl.mesa.rdf.jena.model.ObjectF;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.ResourceF;
import com.hp.hpl.mesa.rdf.jena.model.Seq;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Vector;

public class Regression {
    protected boolean errors = false;

    public static void doTest(Model model, Model model2, Model model3, Model model4) {
        new Regression().test(model, model2, model3, model4);
    }

    public void test(Model model, Model model2, Model model3, Model model4) {
        try {
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.next();
                stmtIterator.remove();
            }
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.next();
                stmtIterator.remove();
            }
            stmtIterator = model3.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.next();
                stmtIterator.remove();
            }
            stmtIterator = model4.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.next();
                stmtIterator.remove();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.errors = true;
        }
        this.test1(model);
        this.test2(model);
        this.test3(model);
        this.test4(model);
        this.test5(model);
        this.test6(model);
        this.test7(model, model2);
        this.test8(model);
        this.test9(model2);
        this.test10(model3);
        this.test11(model, model2);
        this.test12(model);
        this.test13(model);
        this.test14(model);
        this.test15(model);
        this.test16(model);
        this.test17(model);
        this.test18(model4);
        this.test19(model2, model3);
        this.test97(model4);
    }

    public void test1(Model model) {
        String string = "Test1";
        int n = 0;
        try {
            n = 100;
            ++n;
            if (!model.createLiteral(true).getBoolean()) {
                this.error(string, n);
            }
            ++n;
            if (model.createLiteral(false).getBoolean()) {
                this.error(string, n);
            }
            n = 200;
            byte by = 0;
            Literal literal = model.createLiteral(by);
            ++n;
            if (literal.getByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != by) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != by) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by) {
                this.error(string, n);
            }
            byte l = -1;
            literal = model.createLiteral(l);
            ++n;
            if (literal.getByte() != l) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != l) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != l) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)l) {
                this.error(string, n);
            }
            byte f2 = -128;
            literal = model.createLiteral(f2);
            ++n;
            if (literal.getByte() != f2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != f2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != f2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)f2) {
                this.error(string, n);
            }
            byte d2 = 127;
            literal = model.createLiteral(d2);
            ++n;
            if (literal.getByte() != d2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != d2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != d2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)d2) {
                this.error(string, n);
            }
            n = 300;
            byte c = 0;
            literal = model.createLiteral(c);
            ++n;
            if (literal.getByte() != c) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != c) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != c) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)c) {
                this.error(string, n);
            }
            byte object = -1;
            literal = model.createLiteral(object);
            ++n;
            if (literal.getByte() != object) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != object) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != object) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)object) {
                this.error(string, n);
            }
            byte exception = Short.MIN_VALUE;
            literal = model.createLiteral(exception);
            try {
                ++n;
                if (literal.getByte() != exception) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getShort() != exception) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != exception) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)exception) {
                this.error(string, n);
            }
            byte by2 = Short.MAX_VALUE;
            literal = model.createLiteral(by2);
            try {
                ++n;
                if (literal.getByte() != by2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getShort() != by2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != by2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by2) {
                this.error(string, n);
            }
            n = 400;
            byte by3 = 0;
            literal = model.createLiteral(by3);
            ++n;
            if (literal.getByte() != by3) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != by3) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != by3) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by3) {
                this.error(string, n);
            }
            byte by4 = -1;
            literal = model.createLiteral(by4);
            ++n;
            if (literal.getByte() != by4) {
                this.error(string, n);
            }
            ++n;
            if (literal.getShort() != by4) {
                this.error(string, n);
            }
            ++n;
            if (literal.getInt() != by4) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by4) {
                this.error(string, n);
            }
            byte by5 = Integer.MIN_VALUE;
            literal = model.createLiteral(by5);
            try {
                ++n;
                if (literal.getByte() != by5) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if (literal.getShort() != by5) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getInt() != by5) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by5) {
                this.error(string, n);
            }
            byte by6 = Integer.MAX_VALUE;
            literal = model.createLiteral(by6);
            try {
                ++n;
                if (literal.getByte() != by6) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if (literal.getShort() != by6) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getInt() != by6) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != (long)by6) {
                this.error(string, n);
            }
            n = 500;
            long l2 = 0L;
            literal = model.createLiteral(l2);
            ++n;
            if ((long)literal.getByte() != l2) {
                this.error(string, n);
            }
            ++n;
            if ((long)literal.getShort() != l2) {
                this.error(string, n);
            }
            ++n;
            if ((long)literal.getInt() != l2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != l2) {
                this.error(string, n);
            }
            l2 = -1L;
            literal = model.createLiteral(l2);
            ++n;
            if ((long)literal.getByte() != l2) {
                this.error(string, n);
            }
            ++n;
            if ((long)literal.getShort() != l2) {
                this.error(string, n);
            }
            ++n;
            if ((long)literal.getInt() != l2) {
                this.error(string, n);
            }
            ++n;
            if (literal.getLong() != l2) {
                this.error(string, n);
            }
            l2 = Long.MIN_VALUE;
            literal = model.createLiteral(l2);
            try {
                ++n;
                if ((long)literal.getByte() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)literal.getShort() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)literal.getInt() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getLong() != l2) {
                this.error(string, n);
            }
            l2 = Long.MAX_VALUE;
            literal = model.createLiteral(l2);
            try {
                ++n;
                if ((long)literal.getByte() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)literal.getShort() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)literal.getInt() != l2) {
                    this.error(string, n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
            if (literal.getLong() != l2) {
                this.error(string, n);
            }
            float f = 5.0E-5f;
            n = 600;
            float f3 = 0.0f;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            f3 = -1.0f;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            f3 = 12345.679f;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            f3 = Float.MAX_VALUE;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            f3 = Float.MIN_VALUE;
            literal = model.createLiteral(f3);
            ++n;
            if (Math.abs(literal.getFloat() - f3) >= f) {
                this.error(string, n);
            }
            double d = 5.0E-9;
            n = 700;
            double d3 = 0.0;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            d3 = -1.0;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            d3 = 12345.6789;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            d3 = Double.MAX_VALUE;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            d3 = Double.MIN_VALUE;
            literal = model.createLiteral(d3);
            ++n;
            if (Math.abs(literal.getDouble() - d3) >= d) {
                this.error(string, n);
            }
            n = 800;
            char c2 = 'A';
            ++n;
            if (model.createLiteral(c2).getChar() != c2) {
                this.error(string, n);
            }
            char c3 = 'a';
            ++n;
            if (model.createLiteral(c3).getChar() != c3) {
                this.error(string, n);
            }
            char c4 = '#';
            ++n;
            if (model.createLiteral(c4).getChar() != c4) {
                this.error(string, n);
            }
            char c5 = '@';
            ++n;
            if (model.createLiteral(c5).getChar() != c5) {
                this.error(string, n);
            }
            String string2 = "en";
            n = 900;
            Object object2 = "";
            ++n;
            if (!model.createLiteral((String)object2).getString().equals(object2)) {
                this.error(string, n);
            }
            object2 = "A test string";
            ++n;
            if (!model.createLiteral((String)object2).getString().equals(object2)) {
                this.error(string, n);
            }
            object2 = "Another test string";
            ++n;
            literal = model.createLiteral((String)object2);
            ++n;
            if (!literal.getString().equals(object2)) {
                this.error(string, n);
            }
            ++n;
            if (!literal.getLanguage().equals("")) {
                this.error(string, n);
            }
            ++n;
            literal = model.createLiteral((String)object2, string2);
            ++n;
            if (!literal.getString().equals(object2)) {
                this.error(string, n);
            }
            ++n;
            if (!literal.getLanguage().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!literal.equals(model.createLiteral((String)object2, string2))) {
                this.error(string, n);
            }
            ++n;
            if (literal.equals(model.createLiteral((String)object2))) {
                this.error(string, n);
            }
            String string3 = "foo";
            n = 950;
            object2 = model.createLiteral(string3);
            Literal literal2 = model.createLiteral(string3, "", true);
            ++n;
            if (object2.equals(null)) {
                this.error(string, n);
            }
            ++n;
            if (object2.equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (object2.equals(literal2)) {
                this.error(string, n);
            }
            JenaConfig.setOldLiteralCompare(true);
            ++n;
            if (!object2.equals(literal2)) {
                this.error(string, n);
            }
            ++n;
            if (!object2.equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (!JenaConfig.getOldLiteralCompare()) {
                this.error(string, n);
            }
            JenaConfig.setOldLiteralCompare(false);
            object2 = new LitTestObjF();
            n = 1000;
            LitTestObj litTestObj = new LitTestObj(0L);
            ++n;
            if (!model.createLiteral(litTestObj).getObject((ObjectF)object2).equals(litTestObj)) {
                this.error(string, n);
            }
            LitTestObj litTestObj2 = new LitTestObj(12345L);
            ++n;
            if (!model.createLiteral(litTestObj2).getObject((ObjectF)object2).equals(litTestObj2)) {
                this.error(string, n);
            }
            LitTestObj litTestObj3 = new LitTestObj(-67890L);
            ++n;
            if (!model.createLiteral(litTestObj3).getObject((ObjectF)object2).equals(litTestObj3)) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test2(Model model) {
        String string = "Test2";
        int n = 0;
        try {
            String string2;
            Object object;
            Statement statement;
            byte by;
            String string3;
            Object object2;
            block134: {
                block133: {
                    block132: {
                        n = 100;
                        try {
                            n = 110;
                            ++n;
                            object2 = model.createResource();
                            ++n;
                            if (!object2.isAnon()) {
                                this.error(string, n);
                            }
                            ++n;
                            if (object2.getURI() != null) {
                                this.error(string, n);
                            }
                            ++n;
                            if (object2.getNameSpace() != null) {
                                this.error(string, n);
                            }
                            ++n;
                            if (object2.getLocalName() != null) {
                                this.error(string, n);
                            }
                        }
                        catch (RDFException rDFException) {
                            this.error(string, n, rDFException);
                        }
                        try {
                            n = 120;
                            ++n;
                            object2 = model.createResource((String)null);
                            ++n;
                            if (!object2.isAnon()) {
                                this.error(string, n);
                            }
                            ++n;
                            if (object2.getURI() != null) {
                                this.error(string, n);
                            }
                        }
                        catch (RDFException rDFException) {
                            this.error(string, n, rDFException);
                        }
                        try {
                            n = 140;
                            string3 = "http://aldabaran.hpl.hp.com/foo";
                            ++n;
                            object2 = model.createResource(string3);
                            ++n;
                            if (!object2.getURI().equals(string3)) {
                                this.error(string, n);
                            }
                        }
                        catch (RDFException rDFException) {
                            this.error(string, n, rDFException);
                        }
                        try {
                            n = 150;
                            ++n;
                            object2 = model.createResource(RDF.Property);
                            ++n;
                            if (!object2.isAnon()) {
                                this.error(string, n);
                            }
                        }
                        catch (RDFException rDFException) {
                            this.error(string, n, rDFException);
                        }
                        try {
                            n = 160;
                            string3 = "http://aldabaran.hpl.hp.com/foo";
                            ++n;
                            object2 = model.createResource(string3, RDF.Property);
                            ++n;
                            if (!object2.getURI().equals(string3)) {
                                this.error(string, n);
                            }
                        }
                        catch (RDFException rDFException) {
                            this.error(string, n, rDFException);
                        }
                        try {
                            n = 170;
                            ++n;
                            object2 = model.createResource(new ResTestObjF());
                            ++n;
                            if (!object2.isAnon()) {
                                this.error(string, n);
                            }
                        }
                        catch (RDFException rDFException) {
                            this.error(string, n, rDFException);
                        }
                        try {
                            n = 180;
                            string3 = "http://aldabaran.hpl.hp.com/foo";
                            ++n;
                            object2 = model.createResource(string3, new ResTestObjF());
                            ++n;
                            if (!object2.getURI().equals(string3)) {
                                this.error(string, n);
                            }
                        }
                        catch (RDFException rDFException) {
                            this.error(string, n, rDFException);
                        }
                        n = 200;
                        try {
                            object2 = model.createProperty(null);
                            this.error(string, ++n);
                        }
                        catch (RDFException rDFException) {
                            if (rDFException.getErrorCode() == 2) break block132;
                            this.error(string, n, rDFException);
                        }
                    }
                    try {
                        object2 = model.createProperty("");
                        this.error(string, ++n);
                    }
                    catch (RDFException rDFException) {
                        if (rDFException.getErrorCode() == 2) break block133;
                        this.error(string, n, rDFException);
                    }
                }
                try {
                    object2 = model.createProperty("abc");
                    this.error(string, ++n);
                }
                catch (RDFException rDFException) {
                    if (rDFException.getErrorCode() == 2) break block134;
                    this.error(string, n, rDFException);
                }
            }
            try {
                ++n;
                object2 = model.createProperty("abc/def");
                ++n;
                if (!object2.getNameSpace().equals("abc/")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getLocalName().equals("def")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getURI().equals("abc/def")) {
                    this.error(string, n);
                }
            }
            catch (RDFException rDFException) {
                this.error(string, n, rDFException);
            }
            try {
                ++n;
                object2 = model.createProperty("abc/", "def");
                ++n;
                if (!object2.getNameSpace().equals("abc/")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getLocalName().equals("def")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getURI().equals("abc/def")) {
                    this.error(string, n);
                }
            }
            catch (RDFException rDFException) {
                this.error(string, n, rDFException);
            }
            try {
                ++n;
                object2 = model.createProperty(RDF.getURI() + "_345");
                ++n;
                if (!object2.getNameSpace().equals(RDF.getURI())) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getLocalName().equals("_345")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getURI().equals(RDF.getURI() + "_345")) {
                    this.error(string, n);
                }
            }
            catch (RDFException rDFException) {
                this.error(string, n, rDFException);
            }
            try {
                ++n;
                object2 = model.createProperty(RDF.getURI(), "_345");
                ++n;
                if (!object2.getNameSpace().equals(RDF.getURI())) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getLocalName().equals("_345")) {
                    this.error(string, n);
                }
                ++n;
                if (!object2.getURI().equals(RDF.getURI() + "_345")) {
                    this.error(string, n);
                }
            }
            catch (RDFException rDFException) {
                this.error(string, n, rDFException);
            }
            object2 = "http://aldabaran.hpl.hp.com/foo";
            String string4 = "http://aldabaran.hpl.hp.com/bar";
            Resource resource = model.createResource((String)object2);
            Property property = model.createProperty(string4);
            n = 300;
            try {
                by = 1;
                n = 310;
                ++n;
                statement = model.createStatement(resource, property, by != 0);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getBoolean()) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                by = 127;
                n = 320;
                ++n;
                statement = model.createStatement(resource, property, by);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getByte() != by) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                short s = Short.MAX_VALUE;
                n = 330;
                ++n;
                statement = model.createStatement(resource, property, s);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getShort() != s) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                int n2 = Integer.MAX_VALUE;
                n = 340;
                ++n;
                statement = model.createStatement(resource, property, n2);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getInt() != n2) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                long l = Long.MAX_VALUE;
                n = 350;
                ++n;
                statement = model.createStatement(resource, property, l);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getLong() != l) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                char c = '$';
                n = 360;
                ++n;
                statement = model.createStatement(resource, property, c);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getChar() != c) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                float f = 123.456f;
                n = 370;
                ++n;
                statement = model.createStatement(resource, property, f);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!((double)(statement.getFloat() - f) < 5.0E-4)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                double d = 12345.6789;
                n = 380;
                ++n;
                statement = model.createStatement(resource, property, d);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!(statement.getDouble() - d < 5.0E-7)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                object = "this is a test string";
                string2 = "en";
                n = 390;
                ++n;
                statement = model.createStatement(resource, property, (String)object);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getString().equals(object)) {
                    this.error(string, n);
                }
                ++n;
                statement = model.createStatement(resource, property, (String)object, string2);
                ++n;
                if (!statement.getLanguage().equals(string2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                object = new LitTestObj(Long.MIN_VALUE);
                string2 = "fr";
                n = 400;
                ++n;
                statement = model.createStatement(resource, property, object);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getObject(new LitTestObjF()).equals(object)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                object = model.createResource();
                n = 410;
                ++n;
                statement = model.createStatement(resource, property, (RDFNode)object);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getResource().equals(object)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                object = model.createLiteral(true);
                n = 420;
                ++n;
                statement = model.createStatement(resource, property, (RDFNode)object);
                ++n;
                if (!statement.getSubject().getURI().equals(object2)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getPredicate().getURI().equals(string4)) {
                    this.error(string, n);
                }
                ++n;
                if (!statement.getBoolean()) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 500;
                ++n;
                object2 = model.createBag();
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Bag)) {
                    this.error(string, n);
                }
                string3 = "http://aldabaran/foo";
                ++n;
                object2 = model.createBag(string3);
                ++n;
                if (!object2.getURI().equals(string3)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Bag)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 510;
                ++n;
                object2 = model.createAlt();
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Alt)) {
                    this.error(string, n);
                }
                string3 = "http://aldabaran/foo";
                ++n;
                object2 = model.createAlt(string3);
                ++n;
                if (!object2.getURI().equals(string3)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Alt)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 520;
                ++n;
                object2 = model.createSeq();
                ++n;
                if (!object2.isAnon()) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Seq)) {
                    this.error(string, n);
                }
                string3 = "http://aldabaran/foo";
                ++n;
                object2 = model.createSeq(string3);
                ++n;
                if (!object2.getURI().equals(string3)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains((Resource)object2, RDF.type, RDF.Seq)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test3(Model model) {
        String string = "Test3";
        int n = 0;
        try {
            boolean bl = true;
            int n2 = 1;
            int n4 = 2;
            int n5 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test string";
            String string3 = "en";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test string 2");
            Resource resource = model.createResource();
            Resource resource2 = model.createResource();
            try {
                n = 100;
                ++n;
                model.add(resource2, RDF.value, resource);
                ++n;
                if (!model.contains(resource2, RDF.value, resource)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 110;
                ++n;
                model.add(resource2, RDF.value, literal);
                ++n;
                if (!model.contains(resource2, RDF.value, literal)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 120;
                ++n;
                model.add(resource2, RDF.value, n2);
                ++n;
                if (!model.contains(resource2, RDF.value, n2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 130;
                ++n;
                model.add(resource2, RDF.value, n4);
                ++n;
                if (!model.contains(resource2, RDF.value, n4)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 140;
                ++n;
                model.add(resource2, RDF.value, n5);
                ++n;
                if (!model.contains(resource2, RDF.value, n5)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 150;
                ++n;
                model.add(resource2, RDF.value, l);
                ++n;
                if (!model.contains(resource2, RDF.value, l)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 160;
                ++n;
                model.add(resource2, RDF.value, c);
                ++n;
                if (!model.contains(resource2, RDF.value, c)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 170;
                ++n;
                model.add(resource2, RDF.value, f);
                ++n;
                if (!model.contains(resource2, RDF.value, f)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 180;
                ++n;
                model.add(resource2, RDF.value, d);
                ++n;
                if (!model.contains(resource2, RDF.value, d)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 190;
                ++n;
                model.add(resource2, RDF.value, litTestObj);
                ++n;
                if (!model.contains(resource2, RDF.value, litTestObj)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 200;
                ++n;
                model.add(resource2, RDF.value, string2);
                ++n;
                if (!model.contains(resource2, RDF.value, string2)) {
                    this.error(string, n);
                }
                ++n;
                if (model.contains(resource2, RDF.value, string2, string3)) {
                    this.error(string, n);
                }
                ++n;
                model.add(resource2, RDF.value, string2, string3);
                ++n;
                if (!model.contains(resource2, RDF.value, string2, string3)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 210;
                literal = model.createLiteral(++n);
                ++n;
                Statement statement = model.createStatement(resource2, RDF.value, literal);
                ++n;
                model.add(statement);
                ++n;
                if (!model.contains(statement)) {
                    this.error(string, n);
                }
                ++n;
                long l2 = model.size();
                ++n;
                model.add(statement);
                ++n;
                if (model.size() != l2) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains(resource2, RDF.value)) {
                    this.error(string, n);
                }
                ++n;
                if (model.contains(resource2, RDF.subject)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test4(Model model) {
        String string = "Test4";
        int n = 0;
        try {
            Resource resource;
            String string2;
            try {
                n = 110;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/a" + Integer.toString(n);
                ++n;
                resource = model.getResource(string2);
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 120;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/a" + Integer.toString(n);
                ++n;
                resource = model.getResource(string2, new ResTestObjF());
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 130;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/a" + Integer.toString(n);
                ++n;
                resource = model.getProperty(string2);
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 140;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n) + "/";
                String string3 = "foo";
                ++n;
                resource = model.getProperty(string2, string3);
                ++n;
                if (!resource.getURI().equals(string2 + string3)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 150;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n);
                ++n;
                model.createBag(string2);
                ++n;
                resource = model.getBag(string2);
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains(resource, RDF.type, RDF.Bag)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 160;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n);
                ++n;
                model.createAlt(string2);
                ++n;
                resource = model.getAlt(string2);
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains(resource, RDF.type, RDF.Alt)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 170;
                string2 = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n);
                ++n;
                model.createSeq(string2);
                ++n;
                resource = model.getSeq(string2);
                ++n;
                if (!resource.getURI().equals(string2)) {
                    this.error(string, n);
                }
                ++n;
                if (!model.contains(resource, RDF.type, RDF.Seq)) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test5(Model model) {
        String string = "Test5";
        int n = 0;
        try {
            try {
                n = 100;
                ++n;
                StmtIterator stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.next();
                    ++n;
                    stmtIterator.remove();
                }
                ++n;
                stmtIterator.close();
                ++n;
                if (model.size() != 0L) {
                    this.error(string, 999);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
        }
    }

    public void test6(Model model) {
        String string = "Test6";
        int n = 0;
        int n2 = 5;
        Resource[] resourceArray = new Resource[n2];
        Property[] propertyArray = new Property[n2];
        Statement[] statementArray = new Statement[n2 * n2];
        String string2 = "http://aldabaran/test6/s";
        String string3 = "http://aldabaran/test6/";
        try {
            int n4;
            int n5;
            Object object;
            int n6;
            Object object2;
            int n7;
            int n8 = 0;
            while (n8 < n2) {
                resourceArray[n8] = model.createResource(string2 + Integer.toString(n8));
                propertyArray[n8] = model.createProperty(string3 + Integer.toString(n8), "p");
                ++n8;
            }
            n = 50;
            if (model.size() != 0L) {
                this.error(string, n);
            }
            int n9 = 0;
            while (n9 < n2) {
                n7 = 0;
                while (n7 < n2) {
                    object2 = model.createStatement(resourceArray[n9], propertyArray[n7], model.createLiteral(n9 * n2 + n7));
                    model.add((Statement)object2);
                    model.add((Statement)object2);
                    statementArray[n9 * n2 + n7] = object2;
                    ++n7;
                }
                ++n9;
            }
            n7 = n2 * n2;
            object2 = new boolean[n7];
            boolean[] blArray = new boolean[n2];
            boolean[] blArray2 = new boolean[n2];
            n = 100;
            ++n;
            if (model.size() != (long)n7) {
                this.error(string, n);
            }
            int n10 = 0;
            while (n10 < n7) {
                object2[n10] = false;
                ++n10;
            }
            int n11 = 0;
            while (n11 < n2) {
                blArray[n11] = false;
                blArray2[n11] = false;
                ++n11;
            }
            boolean bl = false;
            ResIterator resIterator = model.listSubjects();
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                int n12 = 0;
                while (n12 < n2) {
                    if (resource.equals(resourceArray[n12])) {
                        bl = true;
                        if (blArray[n12]) {
                            this.error(string, 110);
                        }
                        blArray[n12] = true;
                    }
                    ++n12;
                }
                if (bl) continue;
                this.error(string, 120);
            }
            int n13 = 0;
            while (n13 < n2) {
                if (!blArray[n13]) {
                    this.error(string, 120 + n13);
                }
                ++n13;
            }
            NsIterator nsIterator = model.listNameSpaces();
            while (nsIterator.hasNext()) {
                String string4 = nsIterator.next();
                bl = false;
                int n14 = 0;
                while (n14 < n2) {
                    if (string4.equals(propertyArray[n14].getNameSpace())) {
                        bl = true;
                        if (blArray2[n14]) {
                            this.error(string, 130);
                        }
                        blArray2[n14] = true;
                    }
                    ++n14;
                }
                if (bl) continue;
                this.error(string, 140);
            }
            int n15 = 0;
            while (n15 < n2) {
                if (!blArray2[n15]) {
                    this.error(string, 140 + n15);
                }
                ++n15;
            }
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.next();
                bl = false;
                n6 = 0;
                while (n6 < n7) {
                    if (statement.equals(statementArray[n6])) {
                        bl = true;
                        if (object2[n6]) {
                            this.error(string, 150);
                        }
                        object2[n6] = true;
                    }
                    ++n6;
                }
                if (bl) continue;
                this.error(string, 160);
            }
            int n16 = 0;
            while (n16 < n7) {
                if (!object2[n16]) {
                    this.error(string, 160 + n16);
                }
                ++n16;
            }
            n6 = 0;
            while (n6 < n2) {
                object2[n6] = false;
                model.add((Resource)statementArray[n6], propertyArray[n6], n6);
                ++n6;
            }
            stmtIterator = model.listReifiedStatements();
            while (stmtIterator.hasNext()) {
                object = stmtIterator.next();
                bl = false;
                n5 = 0;
                while (n5 < n2) {
                    if (object.equals(statementArray[n5])) {
                        bl = true;
                        if (object2[n5]) {
                            this.error(string, 200);
                        }
                        object2[n5] = true;
                    }
                    ++n5;
                }
                if (bl) continue;
                this.error(string, 210);
            }
            object = new boolean[n2 * n2];
            n = 300;
            n5 = 0;
            while (n5 < n2 * n2) {
                object[n5] = false;
                ++n5;
            }
            NodeIterator nodeIterator = model.listObjectsOfProperty(propertyArray[0]);
            while (nodeIterator.hasNext()) {
                Literal literal = (Literal)nodeIterator.next();
                n4 = literal.getInt();
                object[n4] = true;
            }
            int n17 = 0;
            while (n17 < n2 * n2) {
                if (n17 % n2 == 0) {
                    if (object[n17] == false) {
                        this.error(string, 300 + n17);
                    }
                } else if (object[n17] != false) {
                    this.error(string, 350 + n17);
                }
                ++n17;
            }
            object = new boolean[n2];
            n = 400;
            Resource resource = model.createResource();
            n17 = 0;
            while (n17 < n2) {
                model.add(resource, RDF.value, n17);
                object[n17] = false;
                ++n17;
            }
            nodeIterator = model.listObjectsOfProperty(resource, RDF.value);
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.next()).getInt();
                object[n4] = true;
            }
            n4 = 0;
            while (n4 < n2) {
                if (object[n4] == false) {
                    this.error(string, n + n4);
                }
                ++n4;
            }
            int n18 = 0;
            n = 500;
            object = model.listObjects();
            while (object.hasNext()) {
                object.next();
                ++n18;
            }
            if (n18 != 25) {
                this.error(string, n + n18);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test7(Model model, Model model2) {
        String string = "Test7";
        int n = 0;
        try {
            StmtIterator stmtIterator;
            try {
                n = 100;
                ++n;
                stmtIterator = model.listStatements();
                ++n;
                model2.add(stmtIterator);
                stmtIterator.close();
                ++n;
                if (model.size() != model2.size()) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator = model.listStatements();
                n = 110;
                while (stmtIterator.hasNext()) {
                    ++n;
                    if (model2.contains(stmtIterator.next())) continue;
                    this.error(string, n);
                }
                n = 200;
                stmtIterator = model2.listStatements();
                while (stmtIterator.hasNext()) {
                    ++n;
                    if (model.contains(stmtIterator.next())) continue;
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 300;
                model.add(model.createResource(), RDF.value, model.createResource());
                model.add(model.createResource(), RDF.value, model.createResource());
                model.add(model.createResource(), RDF.value, model.createResource());
                ++n;
                stmtIterator = model.listStatements();
                ++n;
                model2.remove(stmtIterator.next());
                ++n;
                model2.remove(stmtIterator);
                stmtIterator.close();
                ++n;
                if (model2.size() != 0L) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 400;
                ++n;
                model2.add(model);
                ++n;
                if (model.size() != model2.size()) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator = model.listStatements();
                n = 410;
                while (stmtIterator.hasNext()) {
                    ++n;
                    if (model2.contains(stmtIterator.next())) continue;
                    this.error(string, n);
                }
                n = 500;
                stmtIterator = model2.listStatements();
                while (stmtIterator.hasNext()) {
                    ++n;
                    if (model.contains(stmtIterator.next())) continue;
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 600;
                ++n;
                model2.remove(model);
                ++n;
                if (model2.size() != 0L) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test8(Model model) {
        String string = "Test8";
        int n = 0;
        int n2 = 5;
        Resource[] resourceArray = new Resource[n2];
        Property[] propertyArray = new Property[n2];
        Vector vector = new Vector();
        String string2 = "http://aldabaran/test8/s";
        String string3 = "http://aldabaran/test8/";
        boolean[] blArray = new boolean[]{false, true};
        long[] lArray = new long[]{123L, 321L};
        char[] cArray = new char[]{'@', ';'};
        float[] fArray = new float[]{456.789f, 789.456f};
        double[] dArray = new double[]{123.456, 456.123};
        String[] stringArray = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] stringArray2 = new String[]{"en", "fr"};
        boolean[] blArray2 = new boolean[n2];
        boolean[] blArray3 = new boolean[n2];
        int n4 = 9;
        boolean[] blArray4 = new boolean[n4];
        RDFNode[] rDFNodeArray = new RDFNode[n4];
        try {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            int n29;
            int n30;
            Resource[] resourceArray2;
            Literal[] literalArray;
            block236: {
                Statement statement;
                literalArray = new Literal[]{model.createLiteral(new LitTestObjF()), model.createLiteral(new LitTestObjF())};
                resourceArray2 = new Resource[]{model.createResource(new ResTestObjF()), model.createResource(new ResTestObjF())};
                int n31 = 0;
                while (n31 < n2) {
                    resourceArray[n31] = model.createResource(string2 + Integer.toString(n31));
                    propertyArray[n31] = model.createProperty(string3 + Integer.toString(n31), "p");
                    ++n31;
                }
                int n32 = 0;
                while (n32 < n2) {
                    model.add(resourceArray[n32], propertyArray[4], false);
                    ++n32;
                }
                int n33 = 0;
                while (n33 < 2) {
                    int n34 = 0;
                    while (n34 < 2) {
                        statement = model.createStatement(resourceArray[n33], propertyArray[n34], blArray[n34]);
                        model.add(statement);
                        statement = model.createStatement(resourceArray[n33], propertyArray[n34], lArray[n34]);
                        model.add(statement);
                        statement = model.createStatement(resourceArray[n33], propertyArray[n34], cArray[n34]);
                        model.add(statement);
                        statement = model.createStatement(resourceArray[n33], propertyArray[n34], fArray[n34]);
                        model.add(statement);
                        statement = model.createStatement(resourceArray[n33], propertyArray[n34], dArray[n34]);
                        model.add(statement);
                        statement = model.createStatement(resourceArray[n33], propertyArray[n34], stringArray[n34]);
                        model.add(statement);
                        statement = model.createStatement(resourceArray[n33], propertyArray[n34], stringArray[n34], stringArray2[n34]);
                        model.add(statement);
                        statement = model.createStatement(resourceArray[n33], propertyArray[n34], literalArray[n34]);
                        model.add(statement);
                        statement = model.createStatement(resourceArray[n33], propertyArray[n34], resourceArray2[n34]);
                        model.add(statement);
                        ++n34;
                    }
                    ++n33;
                }
                rDFNodeArray[0] = model.createLiteral(blArray[1]);
                rDFNodeArray[1] = model.createLiteral(lArray[1]);
                rDFNodeArray[2] = model.createLiteral(cArray[1]);
                rDFNodeArray[3] = model.createLiteral(fArray[1]);
                rDFNodeArray[4] = model.createLiteral(dArray[1]);
                rDFNodeArray[5] = model.createLiteral(stringArray[1]);
                rDFNodeArray[6] = model.createLiteral(stringArray[1], stringArray2[1]);
                rDFNodeArray[7] = literalArray[1];
                rDFNodeArray[8] = resourceArray2[1];
                n = 100;
                ++n;
                statement = model.getProperty(resourceArray[1], propertyArray[1]);
                ++n;
                try {
                    statement = model.getProperty(resourceArray[1], RDF.value);
                    this.error(string, n);
                }
                catch (RDFException rDFException) {
                    if (rDFException.getErrorCode() == 6) break block236;
                    this.error(string, n);
                }
            }
            int n35 = 0;
            while (n35 < n2) {
                blArray2[n35] = false;
                ++n35;
            }
            boolean bl = false;
            ResIterator resIterator = model.listSubjectsWithProperty(propertyArray[4]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n30 = 0;
                while (n30 < n2) {
                    if (resource.equals(resourceArray[n30])) {
                        bl = true;
                        if (blArray2[n30]) {
                            this.error(string, 110);
                        }
                        blArray2[n30] = true;
                    }
                    ++n30;
                }
                if (bl) continue;
                this.error(string, 120);
            }
            int n36 = 0;
            while (n36 < n2) {
                if (!blArray2[n36]) {
                    this.error(string, 130 + n36);
                }
                ++n36;
            }
            n30 = 0;
            while (n30 < n2) {
                blArray2[n30] = false;
                ++n30;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n29 = 0;
                while (n29 < n2) {
                    if (resource.equals(resourceArray[n29])) {
                        bl = true;
                        if (blArray2[n29]) {
                            this.error(string, 150);
                        }
                        blArray2[n29] = true;
                    }
                    ++n29;
                }
                if (bl) continue;
                this.error(string, 160);
            }
            int n37 = 0;
            while (n37 < n2) {
                if (blArray2[n37]) {
                    if (n37 > 1) {
                        this.error(string, 170 + n37);
                    }
                } else if (n37 < 2) {
                    this.error(string, 190 + n37);
                }
                ++n37;
            }
            n = 200;
            n29 = 0;
            while (n29 < n2) {
                blArray2[n29] = false;
                ++n29;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], blArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n28 = 0;
                while (n28 < n2) {
                    if (resource.equals(resourceArray[n28])) {
                        bl = true;
                        if (blArray2[n28]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n28] = true;
                    }
                    ++n28;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n38 = 0;
            while (n38 < n2) {
                if (blArray2[n38]) {
                    if (n38 > 1) {
                        this.error(string, n + 30 + n38);
                    }
                } else if (n38 < 2) {
                    this.error(string, n + 40 + n38);
                }
                ++n38;
            }
            n28 = 0;
            while (n28 < n2) {
                blArray2[n28] = false;
                ++n28;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], blArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n27 = 0;
                while (n27 < n2) {
                    if (resource.equals(resourceArray[n27])) {
                        bl = true;
                        if (blArray2[n27]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n27] = true;
                    }
                    ++n27;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n39 = 0;
            while (n39 < n2) {
                if (blArray2[n39]) {
                    this.error(string, n + 70 + n39);
                }
                ++n39;
            }
            n = 300;
            n27 = 0;
            while (n27 < n2) {
                blArray2[n27] = false;
                ++n27;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (byte)lArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n26 = 0;
                while (n26 < n2) {
                    if (resource.equals(resourceArray[n26])) {
                        bl = true;
                        if (blArray2[n26]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n26] = true;
                    }
                    ++n26;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n40 = 0;
            while (n40 < n2) {
                if (blArray2[n40]) {
                    if (n40 > 1) {
                        this.error(string, n + 30 + n40);
                    }
                } else if (n40 < 2) {
                    this.error(string, n + 40 + n40);
                }
                ++n40;
            }
            n26 = 0;
            while (n26 < n2) {
                blArray2[n26] = false;
                ++n26;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (byte)lArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n25 = 0;
                while (n25 < n2) {
                    if (resource.equals(resourceArray[n25])) {
                        bl = true;
                        if (blArray2[n25]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n25] = true;
                    }
                    ++n25;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n41 = 0;
            while (n41 < n2) {
                if (blArray2[n41]) {
                    this.error(string, n + 70 + n41);
                }
                ++n41;
            }
            n = 400;
            n25 = 0;
            while (n25 < n2) {
                blArray2[n25] = false;
                ++n25;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (short)lArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n24 = 0;
                while (n24 < n2) {
                    if (resource.equals(resourceArray[n24])) {
                        bl = true;
                        if (blArray2[n24]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n24] = true;
                    }
                    ++n24;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n42 = 0;
            while (n42 < n2) {
                if (blArray2[n42]) {
                    if (n42 > 1) {
                        this.error(string, n + 30 + n42);
                    }
                } else if (n42 < 2) {
                    this.error(string, n + 40 + n42);
                }
                ++n42;
            }
            n24 = 0;
            while (n24 < n2) {
                blArray2[n24] = false;
                ++n24;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (short)lArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n23 = 0;
                while (n23 < n2) {
                    if (resource.equals(resourceArray[n23])) {
                        bl = true;
                        if (blArray2[n23]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n23] = true;
                    }
                    ++n23;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n43 = 0;
            while (n43 < n2) {
                if (blArray2[n43]) {
                    this.error(string, n + 70 + n43);
                }
                ++n43;
            }
            n = 500;
            n23 = 0;
            while (n23 < n2) {
                blArray2[n23] = false;
                ++n23;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (int)lArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n22 = 0;
                while (n22 < n2) {
                    if (resource.equals(resourceArray[n22])) {
                        bl = true;
                        if (blArray2[n22]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n22] = true;
                    }
                    ++n22;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n44 = 0;
            while (n44 < n2) {
                if (blArray2[n44]) {
                    if (n44 > 1) {
                        this.error(string, n + 30 + n44);
                    }
                } else if (n44 < 2) {
                    this.error(string, n + 40 + n44);
                }
                ++n44;
            }
            n22 = 0;
            while (n22 < n2) {
                blArray2[n22] = false;
                ++n22;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], (int)lArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n21 = 0;
                while (n21 < n2) {
                    if (resource.equals(resourceArray[n21])) {
                        bl = true;
                        if (blArray2[n21]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n21] = true;
                    }
                    ++n21;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n45 = 0;
            while (n45 < n2) {
                if (blArray2[n45]) {
                    this.error(string, n + 70 + n45);
                }
                ++n45;
            }
            n = 600;
            n21 = 0;
            while (n21 < n2) {
                blArray2[n21] = false;
                ++n21;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], lArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n20 = 0;
                while (n20 < n2) {
                    if (resource.equals(resourceArray[n20])) {
                        bl = true;
                        if (blArray2[n20]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n20] = true;
                    }
                    ++n20;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n46 = 0;
            while (n46 < n2) {
                if (blArray2[n46]) {
                    if (n46 > 1) {
                        this.error(string, n + 30 + n46);
                    }
                } else if (n46 < 2) {
                    this.error(string, n + 40 + n46);
                }
                ++n46;
            }
            n20 = 0;
            while (n20 < n2) {
                blArray2[n20] = false;
                ++n20;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], lArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n19 = 0;
                while (n19 < n2) {
                    if (resource.equals(resourceArray[n19])) {
                        bl = true;
                        if (blArray2[n19]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n19] = true;
                    }
                    ++n19;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n47 = 0;
            while (n47 < n2) {
                if (blArray2[n47]) {
                    this.error(string, n + 70 + n47);
                }
                ++n47;
            }
            n = 700;
            n19 = 0;
            while (n19 < n2) {
                blArray2[n19] = false;
                ++n19;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], cArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n18 = 0;
                while (n18 < n2) {
                    if (resource.equals(resourceArray[n18])) {
                        bl = true;
                        if (blArray2[n18]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n18] = true;
                    }
                    ++n18;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n48 = 0;
            while (n48 < n2) {
                if (blArray2[n48]) {
                    if (n48 > 1) {
                        this.error(string, n + 30 + n48);
                    }
                } else if (n48 < 2) {
                    this.error(string, n + 40 + n48);
                }
                ++n48;
            }
            n18 = 0;
            while (n18 < n2) {
                blArray2[n18] = false;
                ++n18;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], cArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n17 = 0;
                while (n17 < n2) {
                    if (resource.equals(resourceArray[n17])) {
                        bl = true;
                        if (blArray2[n17]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n17] = true;
                    }
                    ++n17;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n49 = 0;
            while (n49 < n2) {
                if (blArray2[n49]) {
                    this.error(string, n + 70 + n49);
                }
                ++n49;
            }
            n = 800;
            n17 = 0;
            while (n17 < n2) {
                blArray2[n17] = false;
                ++n17;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], dArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n16 = 0;
                while (n16 < n2) {
                    if (resource.equals(resourceArray[n16])) {
                        bl = true;
                        if (blArray2[n16]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n16] = true;
                    }
                    ++n16;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n50 = 0;
            while (n50 < n2) {
                if (blArray2[n50]) {
                    if (n50 > 1) {
                        this.error(string, n + 30 + n50);
                    }
                } else if (n50 < 2) {
                    this.error(string, n + 40 + n50);
                }
                ++n50;
            }
            n16 = 0;
            while (n16 < n2) {
                blArray2[n16] = false;
                ++n16;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], dArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n15 = 0;
                while (n15 < n2) {
                    if (resource.equals(resourceArray[n15])) {
                        bl = true;
                        if (blArray2[n15]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n15] = true;
                    }
                    ++n15;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n51 = 0;
            while (n51 < n2) {
                if (blArray2[n51]) {
                    this.error(string, n + 70 + n51);
                }
                ++n51;
            }
            n = 900;
            n15 = 0;
            while (n15 < n2) {
                blArray2[n15] = false;
                ++n15;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], dArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n14 = 0;
                while (n14 < n2) {
                    if (resource.equals(resourceArray[n14])) {
                        bl = true;
                        if (blArray2[n14]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n14] = true;
                    }
                    ++n14;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n52 = 0;
            while (n52 < n2) {
                if (blArray2[n52]) {
                    if (n52 > 1) {
                        this.error(string, n + 30 + n52);
                    }
                } else if (n52 < 2) {
                    this.error(string, n + 40 + n52);
                }
                ++n52;
            }
            n14 = 0;
            while (n14 < n2) {
                blArray2[n14] = false;
                ++n14;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], dArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n13 = 0;
                while (n13 < n2) {
                    if (resource.equals(resourceArray[n13])) {
                        bl = true;
                        if (blArray2[n13]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n13] = true;
                    }
                    ++n13;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n53 = 0;
            while (n53 < n2) {
                if (blArray2[n53]) {
                    this.error(string, n + 70 + n53);
                }
                ++n53;
            }
            n = 1000;
            n13 = 0;
            while (n13 < n2) {
                blArray2[n13] = false;
                ++n13;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], stringArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n12 = 0;
                while (n12 < n2) {
                    if (resource.equals(resourceArray[n12])) {
                        bl = true;
                        if (blArray2[n12]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n12] = true;
                    }
                    ++n12;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n54 = 0;
            while (n54 < n2) {
                if (blArray2[n54]) {
                    if (n54 > 1) {
                        this.error(string, n + 30 + n54);
                    }
                } else if (n54 < 2) {
                    this.error(string, n + 40 + n54);
                }
                ++n54;
            }
            n12 = 0;
            while (n12 < n2) {
                blArray2[n12] = false;
                ++n12;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], stringArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n11 = 0;
                while (n11 < n2) {
                    if (resource.equals(resourceArray[n11])) {
                        bl = true;
                        if (blArray2[n11]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n11] = true;
                    }
                    ++n11;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n55 = 0;
            while (n55 < n2) {
                if (blArray2[n55]) {
                    this.error(string, n + 70 + n55);
                }
                ++n55;
            }
            n = 1100;
            n11 = 0;
            while (n11 < n2) {
                blArray2[n11] = false;
                ++n11;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], stringArray[0], stringArray2[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n10 = 0;
                while (n10 < n2) {
                    if (resource.equals(resourceArray[n10])) {
                        bl = true;
                        if (blArray2[n10]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n10] = true;
                    }
                    ++n10;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n56 = 0;
            while (n56 < n2) {
                if (blArray2[n56]) {
                    if (n56 > 1) {
                        this.error(string, n + 30 + n56);
                    }
                } else if (n56 < 2) {
                    this.error(string, n + 40 + n56);
                }
                ++n56;
            }
            n10 = 0;
            while (n10 < n2) {
                blArray2[n10] = false;
                ++n10;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], stringArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n9 = 0;
                while (n9 < n2) {
                    if (resource.equals(resourceArray[n9])) {
                        bl = true;
                        if (blArray2[n9]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n9] = true;
                    }
                    ++n9;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n57 = 0;
            while (n57 < n2) {
                if (blArray2[n57]) {
                    this.error(string, n + 70 + n57);
                }
                ++n57;
            }
            n = 1200;
            n9 = 0;
            while (n9 < n2) {
                blArray2[n9] = false;
                ++n9;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], literalArray[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n8 = 0;
                while (n8 < n2) {
                    if (resource.equals(resourceArray[n8])) {
                        bl = true;
                        if (blArray2[n8]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n8] = true;
                    }
                    ++n8;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n58 = 0;
            while (n58 < n2) {
                if (blArray2[n58]) {
                    if (n58 > 1) {
                        this.error(string, n + 30 + n58);
                    }
                } else if (n58 < 2) {
                    this.error(string, n + 40 + n58);
                }
                ++n58;
            }
            n8 = 0;
            while (n8 < n2) {
                blArray2[n8] = false;
                ++n8;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], literalArray[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n7 = 0;
                while (n7 < n2) {
                    if (resource.equals(resourceArray[n7])) {
                        bl = true;
                        if (blArray2[n7]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n7] = true;
                    }
                    ++n7;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n59 = 0;
            while (n59 < n2) {
                if (blArray2[n59]) {
                    this.error(string, n + 70 + n59);
                }
                ++n59;
            }
            n = 1300;
            n7 = 0;
            while (n7 < n2) {
                blArray2[n7] = false;
                ++n7;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], resourceArray2[0]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n6 = 0;
                while (n6 < n2) {
                    if (resource.equals(resourceArray[n6])) {
                        bl = true;
                        if (blArray2[n6]) {
                            this.error(string, n + 10);
                        }
                        blArray2[n6] = true;
                    }
                    ++n6;
                }
                if (bl) continue;
                this.error(string, n + 20);
            }
            int n60 = 0;
            while (n60 < n2) {
                if (blArray2[n60]) {
                    if (n60 > 1) {
                        this.error(string, n + 30 + n60);
                    }
                } else if (n60 < 2) {
                    this.error(string, n + 40 + n60);
                }
                ++n60;
            }
            n6 = 0;
            while (n6 < n2) {
                blArray2[n6] = false;
                ++n6;
            }
            bl = false;
            resIterator = model.listSubjectsWithProperty(propertyArray[0], resourceArray2[1]);
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                bl = false;
                n5 = 0;
                while (n5 < n2) {
                    if (resource.equals(resourceArray[n5])) {
                        bl = true;
                        if (blArray2[n5]) {
                            this.error(string, n + 50);
                        }
                        blArray2[n5] = true;
                    }
                    ++n5;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n61 = 0;
            while (n61 < n2) {
                if (blArray2[n61]) {
                    this.error(string, n + 70 + n61);
                }
                ++n61;
            }
            n = 1400;
            n5 = 0;
            while (n5 < n2) {
                blArray2[n5] = false;
                ++n5;
            }
            NodeIterator nodeIterator = model.listObjectsOfProperty(propertyArray[1]);
            while (nodeIterator.hasNext()) {
                RDFNode rDFNode = nodeIterator.next();
                bl = false;
                int n62 = 0;
                while (n62 < n4) {
                    if (rDFNode.equals(rDFNodeArray[n62])) {
                        bl = true;
                        if (blArray4[n62]) {
                            this.error(string, n + 50);
                        }
                        blArray4[n62] = true;
                    }
                    ++n62;
                }
                if (bl) continue;
                this.error(string, n + 60);
            }
            int n63 = 0;
            while (n63 < n4) {
                if (!blArray4[n63]) {
                    this.error(string, n + 70 + n63);
                }
                ++n63;
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test9(Model model) {
        String string = "Test9";
        int n = 0;
        int n2 = 2;
        Resource[] resourceArray = new Resource[n2];
        Property[] propertyArray = new Property[n2];
        Vector vector = new Vector();
        String string2 = "http://aldabaran/test9/s";
        String string3 = "http://aldabaran/test9/";
        boolean[] blArray = new boolean[]{false, true};
        long[] lArray = new long[]{123L, 321L};
        char[] cArray = new char[]{'@', ';'};
        double[] dArray = new double[]{123.456, 456.123};
        String[] stringArray = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] stringArray2 = new String[]{"en", "fr"};
        try {
            Statement statement;
            Literal[] literalArray = new Literal[]{model.createLiteral(new LitTestObjF()), model.createLiteral(new LitTestObjF())};
            Resource[] resourceArray2 = new Resource[]{model.createResource(new ResTestObjF()), model.createResource(new ResTestObjF())};
            int n4 = 0;
            while (n4 < n2) {
                resourceArray[n4] = model.createResource(string2 + Integer.toString(n4));
                propertyArray[n4] = model.createProperty(string3 + Integer.toString(n4), "p");
                ++n4;
            }
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n2) {
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], blArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], lArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], cArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], dArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], stringArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], stringArray[n6], stringArray2[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], literalArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], resourceArray2[n6]);
                    model.add(statement);
                    ++n6;
                }
                ++n5;
            }
            n = 100;
            int n7 = 0;
            ++n;
            StmtIterator stmtIterator = model.listStatements(new SelectorImpl(null, null, (RDFNode)null));
            while (stmtIterator.hasNext()) {
                stmtIterator.next();
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != n2 * n2 * 8) {
                this.error(string, n);
                System.err.println(n7);
            }
            n = 110;
            n7 = 0;
            ++n;
            stmtIterator = model.listStatements(new SelectorImpl(resourceArray[0], null, (RDFNode)null));
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getSubject().equals(resourceArray[0])) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != n2 * 8) {
                this.error(string, n);
            }
            n = 120;
            n7 = 0;
            ++n;
            stmtIterator = model.listStatements(new SelectorImpl(null, propertyArray[1], (RDFNode)null));
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getPredicate().equals(propertyArray[1])) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != n2 * 8) {
                this.error(string, n);
            }
            n = 130;
            n7 = 0;
            ++n;
            stmtIterator = model.listStatements(new SelectorImpl(null, null, resourceArray2[1]));
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getObject().equals(resourceArray2[1])) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != 2) {
                this.error(string, n);
            }
            n = 140;
            n7 = 0;
            ++n;
            stmtIterator = model.listStatements(new SelectorImpl(null, null, false));
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (statement.getBoolean()) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != 2) {
                this.error(string, n);
            }
            n = 150;
            n7 = 0;
            ++n;
            stmtIterator = model.listStatements(new SelectorImpl(null, null, stringArray[1], stringArray2[1]));
            ++n;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getLanguage().equals(stringArray2[1])) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != 2) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test10(Model model) {
        String string = "Test10";
        int n = 0;
        int n2 = 2;
        Resource[] resourceArray = new Resource[n2];
        Property[] propertyArray = new Property[n2];
        Vector vector = new Vector();
        String string2 = "http://aldabaran/test10/s";
        String string3 = "http://aldabaran/test10/";
        boolean[] blArray = new boolean[]{false, true};
        long[] lArray = new long[]{123L, 321L};
        char[] cArray = new char[]{'@', ';'};
        double[] dArray = new double[]{123.456, 456.123};
        String[] stringArray = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] stringArray2 = new String[]{"en", "fr"};
        try {
            Statement statement;
            Literal[] literalArray = new Literal[]{model.createLiteral(new LitTestObj(1L)), model.createLiteral(new LitTestObj(2L))};
            Resource[] resourceArray2 = new Resource[]{model.createResource(new ResTestObjF()), model.createResource(new ResTestObjF())};
            int n4 = 0;
            while (n4 < n2) {
                resourceArray[n4] = model.createResource(string2 + Integer.toString(n4));
                propertyArray[n4] = model.createProperty(string3 + Integer.toString(n4), "p");
                ++n4;
            }
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n2) {
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], blArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], lArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], cArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], dArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], stringArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], stringArray[n6], stringArray2[n5]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], literalArray[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], resourceArray2[n6]);
                    model.add(statement);
                    statement = model.createStatement(resourceArray[n5], propertyArray[n6], resourceArray2[n6]);
                    model.add(statement);
                    ++n6;
                }
                ++n5;
            }
            n = 100;
            int n7 = 0;
            ++n;
            Model model2 = model.query(new SelectorImpl(null, null, (RDFNode)null));
            ++n;
            StmtIterator stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.next();
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != n2 * n2 * 8) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n7) {
                this.error(string, n);
            }
            n = 110;
            n7 = 0;
            ++n;
            model2 = model.query(new SelectorImpl(resourceArray[0], null, (RDFNode)null));
            ++n;
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getSubject().equals(resourceArray[0])) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != n2 * 8) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n7) {
                this.error(string, n);
            }
            n = 120;
            n7 = 0;
            ++n;
            model2 = model.query(new SelectorImpl(null, propertyArray[1], (RDFNode)null));
            ++n;
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getPredicate().equals(propertyArray[1])) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != n2 * 8) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n7) {
                this.error(string, n);
            }
            n = 130;
            n7 = 0;
            ++n;
            model2 = model.query(new SelectorImpl(null, null, resourceArray2[1]));
            ++n;
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getObject().equals(resourceArray2[1])) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != 2) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n7) {
                this.error(string, n);
            }
            n = 140;
            n7 = 0;
            ++n;
            model2 = model.query(new SelectorImpl(null, null, false));
            ++n;
            stmtIterator = model2.listStatements();
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (statement.getBoolean()) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            stmtIterator.close();
            ++n;
            if (n7 != 2) {
                this.error(string, n);
            }
            ++n;
            if (model2.size() != (long)n7) {
                this.error(string, n);
            }
            n = 150;
            ++n;
            model2 = model.query(new SelectorImpl(null, null, stringArray[1], stringArray2[0]));
            ++n;
            if (model2.size() != 1L) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = model2.listStatements();
            ++n;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (statement.getLanguage().equals(stringArray2[0])) continue;
                this.error(string, n);
            }
            stmtIterator.close();
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test11(Model model, Model model2) {
        String string = "Test11";
        int n = 0;
        Model model3 = null;
        Model model4 = null;
        Model model5 = null;
        if (!model.supportsSetOperations() || !model2.supportsSetOperations()) {
            return;
        }
        try {
            Statement statement;
            StmtIterator stmtIterator;
            try {
                n = 100;
                model2.add(model2.createResource(new ResTestObjF()), RDF.value, 1L);
                if (model.containsAll(model2)) {
                    this.error(string, n);
                }
                ++n;
                model3 = model.union(model2);
                ++n;
                stmtIterator = model3.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.next();
                    if (model.contains(statement) || model2.contains(statement)) continue;
                    System.out.println(statement.toString());
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.next();
                    if (model3.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model2.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.next();
                    if (model3.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                if (!model3.containsAll(model)) {
                    this.error(string, n);
                }
                ++n;
                if (!model3.containsAll(model2)) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator = model.listStatements();
                ++n;
                if (!model3.containsAll(stmtIterator)) {
                    this.error(string, n);
                }
                stmtIterator.close();
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 200;
                model4 = model3.intersection(model);
                ++n;
                stmtIterator = model4.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.next();
                    if (model3.contains(statement) && model.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model3.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.next();
                    if (!model.contains(statement) || model4.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.next();
                    if (!model.contains(statement) || model4.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
            try {
                n = 300;
                model5 = model3.difference(model2);
                ++n;
                stmtIterator = model5.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.next();
                    if (model3.contains(statement) && !model2.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model3.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.next();
                    if (model2.contains(statement)) {
                        if (!model5.contains(statement)) continue;
                        this.error(string, n);
                        continue;
                    }
                    if (model5.contains(statement)) continue;
                    this.error(string, 1000 + n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                stmtIterator = model2.listStatements();
                while (stmtIterator.hasNext()) {
                    statement = stmtIterator.next();
                    if (!model5.contains(statement)) continue;
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
                ++n;
                if (model5.containsAny(model2)) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator = model2.listStatements();
                ++n;
                if (model5.containsAny(stmtIterator)) {
                    this.error(string, n);
                }
                ++n;
                stmtIterator.close();
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test12(Model model) {
        String string = "Test12";
        int n = 0;
        try {
            Statement statement;
            Resource resource;
            block27: {
                resource = model.createResource();
                boolean bl = true;
                int n2 = 1;
                int n4 = 2;
                int n5 = -1;
                long l = -2L;
                char c = '!';
                float f = 123.456f;
                double d = -123.456;
                String string2 = "test 12 string";
                LitTestObj litTestObj = new LitTestObj(12345L);
                Literal literal = model.createLiteral("test 12 string 2");
                Resource resource2 = model.createResource();
                String string3 = "en";
                n = 100;
                ++n;
                if (!resource.addProperty(RDF.value, n2).hasProperty(RDF.value, n2)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, n4).hasProperty(RDF.value, n4)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, n5).hasProperty(RDF.value, n5)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, l).hasProperty(RDF.value, l)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, c).hasProperty(RDF.value, c)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, f).hasProperty(RDF.value, f)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, d).hasProperty(RDF.value, d)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, string2).hasProperty(RDF.value, string2)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, string2, string3).hasProperty(RDF.value, string2, string3)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, litTestObj).hasProperty(RDF.value, litTestObj)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, literal).hasProperty(RDF.value, literal)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, resource2).hasProperty(RDF.value, resource2)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.getProperty(RDF.value).getSubject().equals(resource)) {
                    this.error(string, n);
                }
                ++n;
                try {
                    resource.getProperty(RDF.type);
                    this.error(string, n);
                }
                catch (RDFException rDFException) {
                    if (rDFException.getErrorCode() == 6) break block27;
                    this.error(string, n);
                }
            }
            ++n;
            StmtIterator stmtIterator = resource.listProperties(RDF.value);
            int n6 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getSubject().equals(resource)) {
                    this.error(string, n);
                }
                ++n6;
            }
            ++n;
            if (n6 != 12) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = resource.listProperties(RDF.type);
            n6 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getSubject().equals(resource)) {
                    this.error(string, n);
                }
                ++n6;
            }
            ++n;
            if (n6 != 0) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = resource.listProperties();
            n6 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getSubject().equals(resource)) {
                    this.error(string, n);
                }
                ++n6;
            }
            ++n;
            if (n6 != 12) {
                this.error(string, n);
            }
            ++n;
            resource.removeProperties();
            ++n;
            Model model2 = model.query(new SelectorImpl(resource, null, (RDFNode)null));
            if (model2.size() != 0L) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test13(Model model) {
        String string = "Test13";
        int n = 0;
        try {
            String string2;
            Seq seq;
            Alt alt;
            Bag bag;
            LitTestObj litTestObj;
            Resource resource;
            String string3;
            double d;
            float f;
            char c;
            long l;
            int n2;
            short s;
            byte by;
            boolean bl;
            Resource resource2;
            block62: {
                block61: {
                    resource2 = model.createResource();
                    bl = true;
                    by = 1;
                    s = 2;
                    n2 = -1;
                    l = -2L;
                    c = '!';
                    f = 123.456f;
                    d = -123.456;
                    string3 = "test 12 string";
                    LitTestObj litTestObj2 = new LitTestObj(12345L);
                    Literal literal = model.createLiteral("test 12 string 2");
                    resource = model.createResource(new ResTestObjF());
                    litTestObj = new LitTestObj(1234L);
                    bag = model.createBag();
                    alt = model.createAlt();
                    seq = model.createSeq();
                    Resource resource3 = model.createResource();
                    string2 = "fr";
                    n = 100;
                    ++n;
                    if (!model.createStatement(resource2, RDF.value, resource2).getResource().equals(resource2)) {
                        this.error(string, n);
                    }
                    ++n;
                    try {
                        model.createStatement(resource2, RDF.value, false).getResource();
                        this.error(string, n);
                    }
                    catch (RDFException rDFException) {
                        if (rDFException.getErrorCode() == 4) break block61;
                        this.error(string, n);
                    }
                }
                ++n;
                if (!model.createStatement(resource2, RDF.value, true).getLiteral().getBoolean()) {
                    this.error(string, n);
                }
                ++n;
                try {
                    model.createStatement(resource2, RDF.value, resource2).getLiteral();
                    this.error(string, n);
                }
                catch (RDFException rDFException) {
                    if (rDFException.getErrorCode() == 5) break block62;
                    this.error(string, n);
                }
            }
            n = 200;
            ++n;
            if (!model.createStatement(resource2, RDF.value, true).getBoolean()) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource2, RDF.value, by).getByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource2, RDF.value, s).getShort() != s) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource2, RDF.value, n2).getInt() != n2) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource2, RDF.value, l).getLong() != l) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource2, RDF.value, c).getChar() != c) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource2, RDF.value, f).getFloat() != f) {
                this.error(string, n);
            }
            ++n;
            if (model.createStatement(resource2, RDF.value, d).getDouble() != d) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource2, RDF.value, string3).getString().equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource2, RDF.value, string3, string2).getString().equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource2, RDF.value, string3, string2).getLanguage().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource2, RDF.value, resource).getResource(new ResTestObjF()).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource2, RDF.value, litTestObj).getObject(new LitTestObjF()).equals(litTestObj)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource2, RDF.value, bag).getBag().equals(bag)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource2, RDF.value, alt).getAlt().equals(alt)) {
                this.error(string, n);
            }
            ++n;
            if (!model.createStatement(resource2, RDF.value, seq).getSeq().equals(seq)) {
                this.error(string, n);
            }
            n = 300;
            ++n;
            Statement statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(!bl);
            ++n;
            if (statement.getBoolean() != !bl) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, !bl)) {
                this.error(string, n);
            }
            n = 310;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(by);
            ++n;
            if (statement.getByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, by)) {
                this.error(string, n);
            }
            n = 320;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(s);
            ++n;
            if (statement.getShort() != s) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, s)) {
                this.error(string, n);
            }
            n = 330;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(n2);
            ++n;
            if (statement.getInt() != n2) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, n2)) {
                this.error(string, n);
            }
            n = 340;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(l);
            ++n;
            if (statement.getLong() != l) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, l)) {
                this.error(string, n);
            }
            n = 350;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(c);
            ++n;
            if (statement.getChar() != c) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, c)) {
                this.error(string, n);
            }
            n = 360;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(f);
            ++n;
            if (!((double)(statement.getFloat() - f) < 5.0E-5)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, f)) {
                this.error(string, n);
            }
            n = 370;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(d);
            ++n;
            if (!(statement.getDouble() - d < 5.0E-4)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, d)) {
                this.error(string, n);
            }
            n = 380;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(string3);
            ++n;
            if (!statement.getString().equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, string3)) {
                this.error(string, n);
            }
            ++n;
            statement.set(string3, string2);
            ++n;
            if (!statement.getString().equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, string3)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, string3, string2)) {
                this.error(string, n);
            }
            n = 390;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(resource);
            ++n;
            if (!statement.getResource().equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, resource)) {
                this.error(string, n);
            }
            n = 400;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            statement.set(litTestObj);
            ++n;
            if (!statement.getObject(new LitTestObjF()).equals(litTestObj)) {
                this.error(string, n);
            }
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
            ++n;
            if (!model.contains(statement.getSubject(), RDF.value, litTestObj)) {
                this.error(string, n);
            }
            n = 500;
            ++n;
            statement = model.createStatement(model.createResource(), RDF.value, bl);
            ++n;
            model.add(statement);
            ++n;
            model.remove(statement);
            ++n;
            if (model.contains(statement.getSubject(), RDF.value, bl)) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test14(Model model) {
        String string = "Test14";
        int n = 0;
        try {
            int n2;
            int n4;
            boolean bl = true;
            int n5 = 1;
            int n6 = 2;
            int n7 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt = model.createAlt();
            Seq seq = model.createSeq();
            int n8 = 10;
            n = 100;
            ++n;
            Bag bag2 = model.createBag();
            ++n;
            if (!model.contains((Resource)bag2, RDF.type, RDF.Bag)) {
                this.error(string, n);
            }
            ++n;
            if (bag2.size() != 0) {
                this.error(string, n);
            }
            n = 200;
            ++n;
            bag2.add(bl);
            ++n;
            if (!bag2.contains(bl)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(n5);
            ++n;
            if (!bag2.contains(n5)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(n6);
            ++n;
            if (!bag2.contains(n6)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(n7);
            ++n;
            if (!bag2.contains(n7)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(l);
            ++n;
            if (!bag2.contains(l)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(c);
            ++n;
            if (!bag2.contains(c)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(f);
            ++n;
            if (!bag2.contains(f)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(d);
            ++n;
            if (!bag2.contains(d)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(string2);
            ++n;
            if (!bag2.contains(string2)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(literal);
            ++n;
            if (!bag2.contains(literal)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(resource);
            ++n;
            if (!bag2.contains(resource)) {
                this.error(string, n);
            }
            ++n;
            bag2.add(litTestObj2);
            ++n;
            if (!bag2.contains(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (bag2.size() != 12) {
                this.error(string, n);
            }
            n = 300;
            ++n;
            bag2 = model.createBag();
            int n9 = 0;
            while (n9 < n8) {
                bag2.add(n9);
                ++n9;
            }
            ++n;
            if (bag2.size() != n8) {
                this.error(string, n);
            }
            ++n;
            NodeIterator nodeIterator = bag2.iterator();
            int n10 = 0;
            while (n10 < n8) {
                if (((Literal)nodeIterator.next()).getInt() != n10) {
                    this.error(string, 320 + n10);
                }
                ++n10;
            }
            nodeIterator.close();
            boolean[] blArray = new boolean[n8];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = 400;
            ++n;
            nodeIterator = bag2.iterator();
            int n11 = 0;
            while (n11 < n8) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n11]) {
                    nodeIterator.remove();
                }
                blArray[n11] = false;
                ++n11;
            }
            ++n;
            nodeIterator.close();
            n = 450;
            ++n;
            nodeIterator = bag2.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = 480;
            n4 = 0;
            while (n4 < n8) {
                ++n;
                if (blArray[n4] != blArray2[n4]) {
                    this.error(string, n);
                }
                ++n4;
            }
            blArray = new boolean[n8];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = 500;
            ++n;
            bag2 = model.createBag();
            n11 = 0;
            while (n11 < n8) {
                bag2.add(n11);
                ++n11;
            }
            ++n;
            nodeIterator = bag2.iterator();
            n4 = 0;
            while (n4 < n8) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
                ++n4;
            }
            ++n;
            nodeIterator.close();
            n = 550;
            ++n;
            nodeIterator = bag2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 580;
            n2 = 0;
            while (n2 < n8) {
                ++n;
                if (blArray[n2] != blArray2[n2]) {
                    this.error(string, n);
                }
                ++n2;
            }
            blArray = new boolean[n8];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = 600;
            ++n;
            bag2 = model.createBag();
            n11 = 0;
            while (n11 < n8) {
                bag2.add(n11);
                ++n11;
            }
            ++n;
            nodeIterator = bag2.iterator();
            n4 = 0;
            while (n4 < n8) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
                ++n4;
            }
            ++n;
            nodeIterator.close();
            n = 650;
            ++n;
            nodeIterator = bag2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 680;
            n2 = 0;
            while (n2 < n8) {
                ++n;
                if (blArray[n2] != blArray2[n2]) {
                    this.error(string, n);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test15(Model model) {
        String string = "Test15";
        int n = 0;
        try {
            int n2;
            int n4;
            boolean bl = true;
            byte by = 1;
            short s = 2;
            int n5 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource();
            Resource resource2 = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt = model.createAlt();
            Seq seq = model.createSeq();
            int n6 = 10;
            n = 100;
            ++n;
            Alt alt2 = model.createAlt();
            ++n;
            if (!model.contains((Resource)alt2, RDF.type, RDF.Alt)) {
                this.error(string, n);
            }
            ++n;
            if (alt2.size() != 0) {
                this.error(string, n);
            }
            n = 200;
            ++n;
            alt2.add(bl);
            ++n;
            if (!alt2.contains(bl)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(by);
            ++n;
            if (!alt2.contains(by)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(s);
            ++n;
            if (!alt2.contains(s)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(n5);
            ++n;
            if (!alt2.contains(n5)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(l);
            ++n;
            if (!alt2.contains(l)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(c);
            ++n;
            if (!alt2.contains(c)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(f);
            ++n;
            if (!alt2.contains(f)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(d);
            ++n;
            if (!alt2.contains(d)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(string2);
            ++n;
            if (!alt2.contains(string2)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(literal);
            ++n;
            if (!alt2.contains(literal)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(resource2);
            ++n;
            if (!alt2.contains(resource2)) {
                this.error(string, n);
            }
            ++n;
            alt2.add(litTestObj2);
            ++n;
            if (!alt2.contains(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (alt2.size() != 12) {
                this.error(string, n);
            }
            n = 300;
            ++n;
            alt2 = model.createAlt();
            int n7 = 0;
            while (n7 < n6) {
                alt2.add(n7);
                ++n7;
            }
            ++n;
            if (alt2.size() != n6) {
                this.error(string, n);
            }
            ++n;
            NodeIterator nodeIterator = alt2.iterator();
            int n8 = 0;
            while (n8 < n6) {
                if (((Literal)nodeIterator.next()).getInt() != n8) {
                    this.error(string, 320 + n8);
                }
                ++n8;
            }
            nodeIterator.close();
            boolean[] blArray = new boolean[n6];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = 400;
            ++n;
            nodeIterator = alt2.iterator();
            int n9 = 0;
            while (n9 < n6) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n9]) {
                    nodeIterator.remove();
                }
                blArray[n9] = false;
                ++n9;
            }
            ++n;
            nodeIterator.close();
            n = 450;
            ++n;
            nodeIterator = alt2.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = 480;
            n4 = 0;
            while (n4 < n6) {
                ++n;
                if (blArray[n4] != blArray2[n4]) {
                    this.error(string, n);
                }
                ++n4;
            }
            blArray = new boolean[n6];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = 500;
            ++n;
            alt2 = model.createAlt();
            n9 = 0;
            while (n9 < n6) {
                alt2.add(n9);
                ++n9;
            }
            ++n;
            nodeIterator = alt2.iterator();
            n4 = 0;
            while (n4 < n6) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
                ++n4;
            }
            ++n;
            nodeIterator.close();
            n = 550;
            ++n;
            nodeIterator = alt2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 580;
            n2 = 0;
            while (n2 < n6) {
                ++n;
                if (blArray[n2] != blArray2[n2]) {
                    this.error(string, n);
                }
                ++n2;
            }
            blArray = new boolean[n6];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = 600;
            ++n;
            alt2 = model.createAlt();
            n9 = 0;
            while (n9 < n6) {
                alt2.add(n9);
                ++n9;
            }
            ++n;
            nodeIterator = alt2.iterator();
            n4 = 0;
            while (n4 < n6) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n4]) {
                    nodeIterator.remove();
                }
                blArray[n4] = false;
                ++n4;
            }
            ++n;
            nodeIterator.close();
            n = 650;
            ++n;
            nodeIterator = alt2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 680;
            n2 = 0;
            while (n2 < n6) {
                ++n;
                if (blArray[n2] != blArray2[n2]) {
                    this.error(string, n);
                }
                ++n2;
            }
            n = 700;
            ++n;
            alt2 = model.createAlt();
            ++n;
            if (!alt2.setDefault(literal).getDefault().equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(literal).getDefaultLiteral().equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(resource).getDefaultResource().equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(by).getDefaultByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(s).getDefaultShort() != s) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(n5).getDefaultInt() != n5) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(l).getDefaultLong() != l) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(c).getDefaultChar() != c) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(f).getDefaultFloat() != f) {
                this.error(string, n);
            }
            ++n;
            if (alt2.setDefault(d).getDefaultDouble() != d) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(string2).getDefaultString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(resource2).getDefaultResource(new ResTestObjF()).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(litTestObj2).getDefaultObject(new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(alt).getDefaultAlt().equals(alt)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(bag).getDefaultBag().equals(bag)) {
                this.error(string, n);
            }
            ++n;
            if (!alt2.setDefault(seq).getDefaultSeq().equals(seq)) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test16(Model model) {
        String string = "Test16";
        int n = 0;
        try {
            int n2;
            int n4;
            Seq seq;
            int n5;
            LitTestObj litTestObj;
            Resource resource;
            Resource resource2;
            Literal literal;
            String string2;
            double d;
            float f;
            char c;
            long l;
            int n6;
            short s;
            byte by;
            boolean bl;
            block149: {
                block148: {
                    block147: {
                        block146: {
                            int n7;
                            bl = true;
                            by = 1;
                            s = 2;
                            n6 = -1;
                            l = -2L;
                            c = '!';
                            f = 123.456f;
                            d = -123.456;
                            string2 = "test 12 string";
                            LitTestObj litTestObj2 = new LitTestObj(12345L);
                            literal = model.createLiteral("test 12 string 2");
                            resource2 = model.createResource();
                            resource = model.createResource(new ResTestObjF());
                            litTestObj = new LitTestObj(1234L);
                            Bag bag = model.createBag();
                            Alt alt = model.createAlt();
                            Seq seq2 = model.createSeq();
                            n5 = 10;
                            n = 100;
                            ++n;
                            seq = model.createSeq();
                            ++n;
                            if (!model.contains((Resource)seq, RDF.type, RDF.Seq)) {
                                this.error(string, n);
                            }
                            ++n;
                            if (seq.size() != 0) {
                                this.error(string, n);
                            }
                            n = 200;
                            ++n;
                            seq.add(bl);
                            ++n;
                            if (!seq.contains(bl)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(by);
                            ++n;
                            if (!seq.contains(by)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(s);
                            ++n;
                            if (!seq.contains(s)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(n6);
                            ++n;
                            if (!seq.contains(n6)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(l);
                            ++n;
                            if (!seq.contains(l)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(c);
                            ++n;
                            if (!seq.contains(c)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(f);
                            ++n;
                            if (!seq.contains(f)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(d);
                            ++n;
                            if (!seq.contains(d)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(string2);
                            ++n;
                            if (!seq.contains(string2)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(literal);
                            ++n;
                            if (!seq.contains(literal)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(resource);
                            ++n;
                            if (!seq.contains(resource)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(litTestObj);
                            ++n;
                            if (!seq.contains(litTestObj)) {
                                this.error(string, n);
                            }
                            ++n;
                            if (seq.size() != 12) {
                                this.error(string, n);
                            }
                            n = 300;
                            ++n;
                            seq = model.createSeq();
                            int n8 = 0;
                            while (n8 < n5) {
                                seq.add(n8);
                                ++n8;
                            }
                            ++n;
                            if (seq.size() != n5) {
                                this.error(string, n);
                            }
                            ++n;
                            NodeIterator nodeIterator = seq.iterator();
                            int n9 = 0;
                            while (n9 < n5) {
                                if (((Literal)nodeIterator.next()).getInt() != n9) {
                                    this.error(string, 320 + n9);
                                }
                                ++n9;
                            }
                            nodeIterator.close();
                            boolean[] blArray = new boolean[n5];
                            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
                            n = 400;
                            ++n;
                            nodeIterator = seq.iterator();
                            n4 = 0;
                            while (n4 < n5) {
                                ++n;
                                nodeIterator.next();
                                ++n;
                                if (!blArray2[n4]) {
                                    nodeIterator.remove();
                                }
                                blArray[n4] = false;
                                ++n4;
                            }
                            ++n;
                            nodeIterator.close();
                            n = 450;
                            ++n;
                            nodeIterator = seq.iterator();
                            while (nodeIterator.hasNext()) {
                                n2 = ((Literal)nodeIterator.next()).getInt();
                                ++n;
                                if (blArray[n2]) {
                                    this.error(string, n);
                                }
                                blArray[n2] = true;
                            }
                            ++n;
                            nodeIterator.close();
                            n = 480;
                            n2 = 0;
                            while (n2 < n5) {
                                ++n;
                                if (blArray[n2] != blArray2[n2]) {
                                    this.error(string, n);
                                }
                                ++n2;
                            }
                            blArray = new boolean[n5];
                            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
                            n = 500;
                            ++n;
                            seq = model.createSeq();
                            n4 = 0;
                            while (n4 < n5) {
                                seq.add(n4);
                                ++n4;
                            }
                            ++n;
                            nodeIterator = seq.iterator();
                            n2 = 0;
                            while (n2 < n5) {
                                ++n;
                                nodeIterator.next();
                                ++n;
                                if (!blArray2[n2]) {
                                    nodeIterator.remove();
                                }
                                blArray[n2] = false;
                                ++n2;
                            }
                            ++n;
                            nodeIterator.close();
                            n = 550;
                            ++n;
                            nodeIterator = seq.iterator();
                            while (nodeIterator.hasNext()) {
                                n7 = ((Literal)nodeIterator.next()).getInt();
                                ++n;
                                if (blArray[n7]) {
                                    this.error(string, n);
                                }
                                blArray[n7] = true;
                            }
                            ++n;
                            nodeIterator.close();
                            n = 580;
                            n7 = 0;
                            while (n7 < n5) {
                                ++n;
                                if (blArray[n7] != blArray2[n7]) {
                                    this.error(string, n);
                                }
                                ++n7;
                            }
                            blArray = new boolean[n5];
                            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
                            n = 600;
                            ++n;
                            seq = model.createSeq();
                            n4 = 0;
                            while (n4 < n5) {
                                seq.add(n4);
                                ++n4;
                            }
                            ++n;
                            nodeIterator = seq.iterator();
                            n2 = 0;
                            while (n2 < n5) {
                                ++n;
                                nodeIterator.next();
                                ++n;
                                if (!blArray2[n2]) {
                                    nodeIterator.remove();
                                }
                                blArray[n2] = false;
                                ++n2;
                            }
                            ++n;
                            nodeIterator.close();
                            n = 650;
                            ++n;
                            nodeIterator = seq.iterator();
                            while (nodeIterator.hasNext()) {
                                n7 = ((Literal)nodeIterator.next()).getInt();
                                ++n;
                                if (blArray[n7]) {
                                    this.error(string, n);
                                }
                                blArray[n7] = true;
                            }
                            ++n;
                            nodeIterator.close();
                            n = 680;
                            n7 = 0;
                            while (n7 < n5) {
                                ++n;
                                if (blArray[n7] != blArray2[n7]) {
                                    this.error(string, n);
                                }
                                ++n7;
                            }
                            n = 700;
                            seq = model.createSeq();
                            ++n;
                            seq.add(bl);
                            ++n;
                            if (seq.getBoolean(1) != bl) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(by);
                            ++n;
                            if (seq.getByte(2) != by) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(s);
                            ++n;
                            if (seq.getShort(3) != s) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(n6);
                            ++n;
                            if (seq.getInt(4) != n6) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(l);
                            ++n;
                            if (seq.getLong(5) != l) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(c);
                            ++n;
                            if (seq.getChar(6) != c) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(f);
                            ++n;
                            if (seq.getFloat(7) != f) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(d);
                            ++n;
                            if (seq.getDouble(8) != d) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(string2);
                            ++n;
                            if (!seq.getString(9).equals(string2)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(litTestObj);
                            ++n;
                            if (!seq.getObject(10, new LitTestObjF()).equals(litTestObj)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(resource2);
                            ++n;
                            if (!seq.getResource(11).equals(resource2)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(literal);
                            ++n;
                            if (!seq.getLiteral(12).equals(literal)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(resource);
                            ++n;
                            if (!seq.getResource(13, new ResTestObjF()).equals(resource)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(bag);
                            ++n;
                            if (!seq.getBag(14).equals(bag)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(alt);
                            ++n;
                            if (!seq.getAlt(15).equals(alt)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq.add(seq2);
                            ++n;
                            if (!seq.getSeq(16).equals(seq2)) {
                                this.error(string, n);
                            }
                            ++n;
                            try {
                                seq.getInt(17);
                                this.error(string, n);
                            }
                            catch (RDFException rDFException) {
                                ++n;
                                if (rDFException.getErrorCode() == 18) break block146;
                                this.error(string, n);
                            }
                        }
                        ++n;
                        try {
                            seq.getInt(0);
                            this.error(string, n);
                        }
                        catch (RDFException rDFException) {
                            ++n;
                            if (rDFException.getErrorCode() == 18) break block147;
                            this.error(string, n);
                        }
                    }
                    n = 800;
                    seq = model.createSeq();
                    int n10 = 0;
                    while (n10 < n5) {
                        seq.add(n10);
                        ++n10;
                    }
                    try {
                        seq.add(0, false);
                        this.error(string, ++n);
                    }
                    catch (RDFException rDFException) {
                        ++n;
                        if (rDFException.getErrorCode() == 18) break block148;
                        this.error(string, n);
                    }
                }
                seq.add(n5 + 1, false);
                if (seq.size() != n5 + 1) {
                    this.error(string, n);
                }
                seq.remove(n5 + 1);
                try {
                    seq.add(n5 + 2, false);
                    this.error(string, ++n);
                }
                catch (RDFException rDFException) {
                    ++n;
                    if (rDFException.getErrorCode() == 18) break block149;
                    this.error(string, n);
                }
            }
            n = 820;
            int n11 = seq.size();
            n4 = 1;
            while (n4 <= n5 - 1) {
                ++n;
                seq.add(n4, 1000 + n4);
                ++n;
                if (seq.getInt(n4) != 1000 + n4) {
                    this.error(string, n);
                }
                ++n;
                if (seq.getInt(n4 + 1) != 0) {
                    this.error(string, n);
                }
                ++n;
                if (seq.size() != n11 + n4) {
                    this.error(string, n);
                }
                ++n;
                if (seq.getInt(n11) != n5 - n4 - 1) {
                    this.error(string, n);
                }
                ++n4;
            }
            n = 900;
            seq = model.createSeq();
            seq.add(model.createResource());
            seq.add(1, bl);
            ++n;
            if (seq.getBoolean(1) != bl) {
                this.error(string, n);
            }
            seq.add(1, by);
            ++n;
            if (seq.getByte(1) != by) {
                this.error(string, n);
            }
            seq.add(1, s);
            ++n;
            if (seq.getShort(1) != s) {
                this.error(string, n);
            }
            seq.add(1, n6);
            ++n;
            if (seq.getInt(1) != n6) {
                this.error(string, n);
            }
            seq.add(1, l);
            ++n;
            if (seq.getLong(1) != l) {
                this.error(string, n);
            }
            seq.add(1, c);
            ++n;
            if (seq.getChar(1) != c) {
                this.error(string, n);
            }
            seq.add(1, f);
            ++n;
            if (seq.getFloat(1) != f) {
                this.error(string, n);
            }
            seq.add(1, d);
            ++n;
            if (seq.getDouble(1) != d) {
                this.error(string, n);
            }
            seq.add(1, string2);
            ++n;
            if (!seq.getString(1).equals(string2)) {
                this.error(string, n);
            }
            seq.add(1, resource2);
            ++n;
            if (!seq.getResource(1).equals(resource2)) {
                this.error(string, n);
            }
            seq.add(1, literal);
            ++n;
            if (!seq.getLiteral(1).equals(literal)) {
                this.error(string, n);
            }
            seq.add(1, litTestObj);
            ++n;
            if (!seq.getObject(1, new LitTestObjF()).equals(litTestObj)) {
                this.error(string, n);
            }
            n = 1000;
            ++n;
            if (seq.indexOf(litTestObj) != 1) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(literal) != 2) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(resource2) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(string2) != 4) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(d) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(f) != 6) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(c) != 7) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(l) != 8) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(n6) != 9) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(s) != 10) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(by) != 11) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(bl) != 12) {
                this.error(string, n);
            }
            ++n;
            if (seq.indexOf(1234543L) != 0) {
                this.error(string, n);
            }
            n = 1100;
            seq = model.createSeq();
            n2 = 0;
            while (n2 < n5) {
                seq.add(n2);
                ++n2;
            }
            n = 1110;
            seq.set(5, bl);
            ++n;
            if (seq.getBoolean(5) != bl) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1120;
            seq.set(5, by);
            ++n;
            if (seq.getByte(5) != by) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1130;
            seq.set(5, s);
            ++n;
            if (seq.getShort(5) != s) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1140;
            seq.set(5, n6);
            ++n;
            if (seq.getInt(5) != n6) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1150;
            seq.set(5, l);
            ++n;
            if (seq.getLong(5) != l) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1160;
            seq.set(5, c);
            ++n;
            if (seq.getChar(5) != c) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1170;
            seq.set(5, f);
            ++n;
            if (seq.getFloat(5) != f) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1180;
            seq.set(5, d);
            ++n;
            if (seq.getDouble(5) != d) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1190;
            seq.set(5, literal);
            ++n;
            if (!seq.getLiteral(5).equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1200;
            seq.set(5, resource2);
            ++n;
            if (!seq.getResource(5).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1210;
            seq.set(5, litTestObj);
            ++n;
            if (!seq.getObject(5, new LitTestObjF()).equals(litTestObj)) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
            n = 1220;
            seq.set(5, resource);
            ++n;
            if (!seq.getResource(5, new ResTestObjF()).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq.size() != n5) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test17(Model model) {
        String string = "Test17";
        int n = 0;
        try {
            EnhResource enhResource = new EnhResource(model);
            n = 1000;
            this.testResource(model, enhResource, string, n, 0);
            n = 2000;
            this.testResource(model, model.createBag(), string, n, 1);
            n = 3000;
            this.testContainer(model, model.createBag(), model.createBag(), string, n);
            n = 4000;
            this.testBag(model, model.createBag(), model.createBag(), model.createBag(), string, n);
            n = 5000;
            this.testResource(model, model.createAlt(), string, n, 1);
            n = 6000;
            this.testContainer(model, model.createAlt(), model.createAlt(), string, n);
            n = 7000;
            this.testAlt(model, model.createAlt(), model.createAlt(), model.createAlt(), model.createAlt(), string, n);
            n = 8000;
            this.testResource(model, model.createSeq(), string, n, 1);
            n = 9000;
            this.testContainer(model, model.createSeq(), model.createSeq(), string, n);
            n = 10000;
            this.testSeq(model, model.createSeq(), model.createSeq(), model.createSeq(), model.createSeq(), model.createSeq(), model.createSeq(), model.createSeq(), string, n);
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test18(Model model) {
        block16: {
            String string = "Test18";
            String string2 = "http://aldabaran.hpl.hp.com/rdftest/test18/";
            String string3 = string2 + "1";
            String string4 = "<foo bar=\"bar\"><bar>abc<foobar/>def&lt;&gt;&apos;&quot;&amp;</bar></foo>";
            String string5 = "http://lists.w3.org/Archives/Public/www-archive/2001Sep/att-0064/00-rdfschema.rdf";
            int n = 0;
            try {
                model.read(new ResourceReader("modules/rdf/rdfschema.html"), string5);
                ++n;
                if (model.size() != 124L) {
                    this.error(string, n);
                }
                StmtIterator stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.next();
                    stmtIterator.remove();
                }
                model.read(new ResourceReader("modules/rdf/embeddedxml.xml"), "");
                ++n;
                String string6 = model.getResource(string3).getProperty(RDF.value).getString();
                ++n;
                if (string6.indexOf("&lt;") == -1) {
                    this.error(string, n);
                }
                ++n;
                if (string6.indexOf("&gt;") == -1) {
                    this.error(string, n);
                }
                ++n;
                if (string6.indexOf("&amp;") == -1) {
                    this.error(string, n);
                }
                ++n;
                if (string6.indexOf("'bar'") == -1 && string6.indexOf("\"bar\"") == -1) {
                    this.error(string, n);
                }
                model.createResource().addProperty(RDF.value, "can't loose");
                stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.next();
                    stmtIterator.remove();
                }
                ++n;
                model.read(new ResourceReader("modules/rdf/testcollection.rdf"), "");
                if (model.size() != 24L) {
                    this.error(string, (int)model.size());
                }
                stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.next();
                    stmtIterator.remove();
                }
                try {
                    model.read(System.getProperty("com.hp.hpl.jena.regression.testURL", string5));
                    ++n;
                    if (model.size() != 124L && model.size() != 125L) {
                        System.out.println("size = " + model.size());
                        this.error(string, n);
                    }
                    if (!model.contains(RDF.Property, RDF.type, RDFS.Class)) {
                        this.error(string, n);
                    }
                }
                catch (RDFException rDFException) {
                    if (rDFException.getErrorCode() == 10 && (rDFException.getNestedException() instanceof NoRouteToHostException || rDFException.getNestedException() instanceof UnknownHostException || rDFException.getNestedException() instanceof ConnectException)) {
                        Log.warning("Cannot access public internet- part of test not executed", "Regression", "test18");
                        break block16;
                    }
                    throw rDFException;
                }
            }
            catch (Exception exception) {
                ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
                this.errors = true;
            }
        }
    }

    public void test19(Model model, Model model2) {
        String string = "Test19";
        int n = 0;
        try {
            try {
                n = 100;
                Resource resource = model.createResource();
                Resource resource2 = model2.createResource(new ResTestObjF());
                long l = model.size();
                long l2 = model2.size();
                resource.addProperty(RDF.value, 1L);
                ++n;
                if (model.size() != ++l) {
                    this.error(string, n);
                }
                ++n;
                if (model2.size() != l2) {
                    this.error(string, n);
                }
                Statement statement = model2.createStatement(resource, RDF.value, resource2);
                ++n;
                if (statement.getSubject().getModel() != model2) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getResource().getModel() != model2) {
                    this.error(string, n);
                }
                model.add(statement);
                ++n;
                if (model.size() != ++l) {
                    this.error(string, n);
                }
                ++n;
                if (model2.size() != l2) {
                    this.error(string, n);
                }
                StmtIterator stmtIterator = model.listStatements(new SelectorImpl(resource, RDF.value, resource2));
                ++n;
                if (!stmtIterator.hasNext()) {
                    this.error(string, n);
                }
                ++n;
                statement = stmtIterator.next();
                ++n;
                if (statement.getSubject().getModel() != model) {
                    this.error(string, n);
                }
                ++n;
                if (statement.getResource().getModel() != model) {
                    this.error(string, n);
                }
                stmtIterator.close();
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test20(Model model) {
        String string = "Test20";
        int n = 0;
        try {
            Statement statement = null;
            Statement statement2 = null;
            try {
                n = 100;
                ++n;
                statement = model.createStatement(model.createResource(), RDF.type, RDFS.Class);
                ++n;
                if (statement.isReified()) {
                    this.error(string, n);
                }
                ++n;
                model.add(statement);
                ++n;
                if (statement.isReified()) {
                    this.error(string, n);
                }
                ++n;
                statement2 = model.createStatement(model.createResource(), RDF.type, RDFS.Class);
                ++n;
                if (statement2.isReified()) {
                    this.error(string, n);
                }
                ++n;
                model.add(statement2);
                ++n;
                if (statement2.isReified()) {
                    this.error(string, n);
                }
                ++n;
                model.add((Resource)statement, RDF.value, new LiteralImpl("foo"));
                ++n;
                if (!statement.isReified()) {
                    this.error(string, n);
                }
                ++n;
                model.add((Resource)statement, RDF.value, statement2);
                ++n;
                if (!statement2.isReified()) {
                    this.error(string, n);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void test97(Model model) {
        String string = "Test97";
        int n = 0;
        try {
            RDFNode rDFNode;
            n = 100;
            model.query(new SelectorImpl(null, null, new LiteralImpl(null)));
            n = 101;
            model.query(new SelectorImpl(null, null, new LiteralImpl(null, "en")));
            n = 102;
            StmtIterator stmtIterator = model.listStatements(new SelectorImpl(null, null, (String)null));
            while (stmtIterator.hasNext()) {
                rDFNode = stmtIterator.next().getObject();
            }
            n = 103;
            stmtIterator = model.listStatements(new SelectorImpl(null, null, (Object)null));
            while (stmtIterator.hasNext()) {
                rDFNode = stmtIterator.next().getObject();
            }
        }
        catch (Exception exception) {
            this.error(string, n, exception);
        }
    }

    public void test99(Model model) {
        String string = "Test5";
        int n = 0;
        try {
            try {
                n = 100;
                ++n;
                StmtIterator stmtIterator = model.listStatements();
                while (stmtIterator.hasNext()) {
                    stmtIterator.next();
                    ++n;
                    stmtIterator.remove();
                }
                ++n;
                stmtIterator.close();
                ++n;
                if (model.size() != 0L) {
                    this.error(string, 999);
                }
            }
            catch (Exception exception) {
                this.error(string, n, exception);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void testResource(Model model, Resource resource, String string, int n, int n2) {
        try {
            Statement statement;
            Property property;
            block27: {
                boolean bl = true;
                int n4 = 1;
                int n5 = 2;
                int n6 = -1;
                long l = -2L;
                char c = '!';
                float f = 123.456f;
                double d = -123.456;
                String string2 = "test 12 string";
                LitTestObj litTestObj = new LitTestObj(12345L);
                Literal literal = model.createLiteral("test 12 string 2");
                Resource resource2 = model.createResource();
                String string3 = "fr";
                ++n;
                if (!resource.addProperty(RDF.value, n4).hasProperty(RDF.value, n4)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, n5).hasProperty(RDF.value, n5)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, n6).hasProperty(RDF.value, n6)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, l).hasProperty(RDF.value, l)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, c).hasProperty(RDF.value, c)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, f).hasProperty(RDF.value, f)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, d).hasProperty(RDF.value, d)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, string2).hasProperty(RDF.value, string2)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, string2, string3).hasProperty(RDF.value, string2, string3)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, litTestObj).hasProperty(RDF.value, litTestObj)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, literal).hasProperty(RDF.value, literal)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.addProperty(RDF.value, resource2).hasProperty(RDF.value, resource2)) {
                    this.error(string, n);
                }
                ++n;
                if (!resource.getProperty(RDF.value).getSubject().equals(resource)) {
                    this.error(string, n);
                }
                ++n;
                property = model.createProperty("foo/", "bar");
                try {
                    resource.getProperty(property);
                    this.error(string, n);
                }
                catch (RDFException rDFException) {
                    if (rDFException.getErrorCode() == 6) break block27;
                    this.error(string, n);
                }
            }
            ++n;
            StmtIterator stmtIterator = resource.listProperties(RDF.value);
            int n7 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getSubject().equals(resource)) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            if (n7 != 12) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = resource.listProperties(property);
            n7 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getSubject().equals(resource)) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            if (n7 != 0) {
                this.error(string, n);
            }
            ++n;
            stmtIterator = resource.listProperties();
            n7 = 0;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                if (!statement.getSubject().equals(resource)) {
                    this.error(string, n);
                }
                ++n7;
            }
            ++n;
            if (n7 != 12 + n2) {
                this.error(string, n);
            }
            ++n;
            resource.removeProperties();
            ++n;
            Model model2 = model.query(new SelectorImpl(resource, null, (RDFNode)null));
            if (model2.size() != 0L) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void testContainer(Model model, Container container, Container container2, String string, int n) {
        try {
            int n2;
            boolean bl = true;
            int n4 = 1;
            int n5 = 2;
            int n6 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt = model.createAlt();
            Seq seq = model.createSeq();
            String string3 = "en";
            int n7 = 10;
            n = (n / 100 + 1) * 100;
            ++n;
            if (container.size() != 0) {
                this.error(string, n);
            }
            n = (n / 100 + 1) * 100;
            ++n;
            container.add(bl);
            ++n;
            if (!container.contains(bl)) {
                this.error(string, n);
            }
            ++n;
            container.add(n4);
            ++n;
            if (!container.contains(n4)) {
                this.error(string, n);
            }
            ++n;
            container.add(n5);
            ++n;
            if (!container.contains(n5)) {
                this.error(string, n);
            }
            ++n;
            container.add(n6);
            ++n;
            if (!container.contains(n6)) {
                this.error(string, n);
            }
            ++n;
            container.add(l);
            ++n;
            if (!container.contains(l)) {
                this.error(string, n);
            }
            ++n;
            container.add(c);
            ++n;
            if (!container.contains(c)) {
                this.error(string, n);
            }
            ++n;
            container.add(f);
            ++n;
            if (!container.contains(f)) {
                this.error(string, n);
            }
            ++n;
            container.add(d);
            ++n;
            if (!container.contains(d)) {
                this.error(string, n);
            }
            ++n;
            container.add(string2);
            ++n;
            if (!container.contains(string2)) {
                this.error(string, n);
            }
            ++n;
            if (container.contains(string2, string3)) {
                this.error(string, n);
            }
            ++n;
            container.add(string2, string3);
            ++n;
            if (!container.contains(string2, string3)) {
                this.error(string, n);
            }
            ++n;
            container.add(literal);
            ++n;
            if (!container.contains(literal)) {
                this.error(string, n);
            }
            ++n;
            container.add(resource);
            ++n;
            if (!container.contains(resource)) {
                this.error(string, n);
            }
            ++n;
            container.add(litTestObj2);
            ++n;
            if (!container.contains(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (container.size() != 13) {
                this.error(string, n);
            }
            n = (n / 100 + 1) * 100;
            int n8 = 0;
            while (n8 < n7) {
                container2.add(n8);
                ++n8;
            }
            ++n;
            if (container2.size() != n7) {
                this.error(string, n);
            }
            ++n;
            NodeIterator nodeIterator = container2.iterator();
            int n9 = 0;
            while (n9 < n7) {
                if (((Literal)nodeIterator.next()).getInt() != n9) {
                    this.error(string, 320 + n9);
                }
                ++n9;
            }
            nodeIterator.close();
            boolean[] blArray = new boolean[n7];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = container2.iterator();
            int n10 = 0;
            while (n10 < n7) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n10]) {
                    nodeIterator.remove();
                }
                blArray[n10] = false;
                ++n10;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = container2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            n2 = 0;
            while (n2 < n7) {
                ++n;
                if (blArray[n2] != blArray2[n2]) {
                    this.error(string, n);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void testBag(Model model, Bag bag, Bag bag2, Bag bag3, String string, int n) {
        int n2 = 10;
        try {
            int n4;
            boolean[] blArray = new boolean[n2];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            int n5 = 0;
            while (n5 < n2) {
                bag.add(n5);
                ++n5;
            }
            ++n;
            NodeIterator nodeIterator = bag.iterator();
            int n6 = 0;
            while (n6 < n2) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n6]) {
                    nodeIterator.remove();
                }
                blArray[n6] = false;
                ++n6;
            }
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = bag.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            n4 = 0;
            while (n4 < n2) {
                ++n;
                if (blArray[n4] != blArray2[n4]) {
                    this.error(string, n);
                }
                ++n4;
            }
            blArray = new boolean[n2];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = (n / 100 + 1) * 100;
            n5 = 0;
            while (n5 < n2) {
                bag2.add(n5);
                ++n5;
            }
            ++n;
            nodeIterator = bag2.iterator();
            n6 = 0;
            while (n6 < n2) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n6]) {
                    nodeIterator.remove();
                }
                blArray[n6] = false;
                ++n6;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = bag2.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            n4 = 0;
            while (n4 < n2) {
                ++n;
                if (blArray[n4] != blArray2[n4]) {
                    this.error(string, n);
                }
                ++n4;
            }
            blArray = new boolean[n2];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = (n / 100 + 1) * 100;
            n5 = 0;
            while (n5 < n2) {
                bag3.add(n5);
                ++n5;
            }
            ++n;
            nodeIterator = bag3.iterator();
            n6 = 0;
            while (n6 < n2) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n6]) {
                    nodeIterator.remove();
                }
                blArray[n6] = false;
                ++n6;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = bag3.iterator();
            while (nodeIterator.hasNext()) {
                n4 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n4]) {
                    this.error(string, n);
                }
                blArray[n4] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            n4 = 0;
            while (n4 < n2) {
                ++n;
                if (blArray[n4] != blArray2[n4]) {
                    this.error(string, n);
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void testAlt(Model model, Alt alt, Alt alt2, Alt alt3, Alt alt4, String string, int n) {
        try {
            int n2;
            boolean bl = true;
            byte by = 1;
            short s = 2;
            int n4 = -1;
            long l = -2L;
            char c = '!';
            float f = 123.456f;
            double d = -123.456;
            String string2 = "test 12 string";
            LitTestObj litTestObj = new LitTestObj(12345L);
            Literal literal = model.createLiteral("test 12 string 2");
            Resource resource = model.createResource();
            Resource resource2 = model.createResource(new ResTestObjF());
            LitTestObj litTestObj2 = new LitTestObj(1234L);
            Bag bag = model.createBag();
            Alt alt5 = model.createAlt();
            Seq seq = model.createSeq();
            String string3 = "fr";
            int n5 = 10;
            boolean[] blArray = new boolean[n5];
            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = (n / 100 + 1) * 100;
            int n6 = 0;
            while (n6 < n5) {
                alt.add(n6);
                ++n6;
            }
            ++n;
            NodeIterator nodeIterator = alt.iterator();
            int n7 = 0;
            while (n7 < n5) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n7]) {
                    nodeIterator.remove();
                }
                blArray[n7] = false;
                ++n7;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = alt.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            n2 = 0;
            while (n2 < n5) {
                ++n;
                if (blArray[n2] != blArray2[n2]) {
                    this.error(string, n);
                }
                ++n2;
            }
            blArray = new boolean[n5];
            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = (n / 100 + 1) * 100;
            n6 = 0;
            while (n6 < n5) {
                alt2.add(n6);
                ++n6;
            }
            ++n;
            nodeIterator = alt2.iterator();
            n7 = 0;
            while (n7 < n5) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n7]) {
                    nodeIterator.remove();
                }
                blArray[n7] = false;
                ++n7;
            }
            ++n;
            nodeIterator.close();
            n = 550;
            ++n;
            nodeIterator = alt2.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = 580;
            n2 = 0;
            while (n2 < n5) {
                ++n;
                if (blArray[n2] != blArray2[n2]) {
                    this.error(string, n);
                }
                ++n2;
            }
            blArray = new boolean[n5];
            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = (n / 100 + 1) * 100;
            n6 = 0;
            while (n6 < n5) {
                alt3.add(n6);
                ++n6;
            }
            ++n;
            nodeIterator = alt3.iterator();
            n7 = 0;
            while (n7 < n5) {
                ++n;
                nodeIterator.next();
                ++n;
                if (!blArray2[n7]) {
                    nodeIterator.remove();
                }
                blArray[n7] = false;
                ++n7;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nodeIterator = alt3.iterator();
            while (nodeIterator.hasNext()) {
                n2 = ((Literal)nodeIterator.next()).getInt();
                ++n;
                if (blArray[n2]) {
                    this.error(string, n);
                }
                blArray[n2] = true;
            }
            ++n;
            nodeIterator.close();
            n = (n / 100 + 1) * 100;
            n2 = 0;
            while (n2 < n5) {
                ++n;
                if (blArray[n2] != blArray2[n2]) {
                    this.error(string, n);
                }
                ++n2;
            }
            n = (n / 100 + 1) * 100;
            ++n;
            if (!alt4.setDefault(literal).getDefault().equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(literal).getDefaultLiteral().equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(resource).getDefaultResource().equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(by).getDefaultByte() != by) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(s).getDefaultShort() != s) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(n4).getDefaultInt() != n4) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(l).getDefaultLong() != l) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(c).getDefaultChar() != c) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(f).getDefaultFloat() != f) {
                this.error(string, n);
            }
            ++n;
            if (alt4.setDefault(d).getDefaultDouble() != d) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(string2).getDefaultString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.getDefaultLanguage().equals("")) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(string2, string3).getDefaultString().equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.getDefaultLanguage().equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(resource2).getDefaultResource(new ResTestObjF()).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(litTestObj2).getDefaultObject(new LitTestObjF()).equals(litTestObj2)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(alt5).getDefaultAlt().equals(alt5)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(bag).getDefaultBag().equals(bag)) {
                this.error(string, n);
            }
            ++n;
            if (!alt4.setDefault(seq).getDefaultSeq().equals(seq)) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void testSeq(Model model, Seq seq, Seq seq2, Seq seq3, Seq seq4, Seq seq5, Seq seq6, Seq seq7, String string, int n) {
        try {
            int n2;
            int n4;
            int n5;
            String string2;
            LitTestObj litTestObj;
            Resource resource;
            Resource resource2;
            Literal literal;
            String string3;
            double d;
            float f;
            char c;
            long l;
            int n6;
            short s;
            byte by;
            boolean bl;
            block149: {
                block148: {
                    block147: {
                        block146: {
                            int n7;
                            bl = true;
                            by = 1;
                            s = 2;
                            n6 = -1;
                            l = -2L;
                            c = '!';
                            f = 123.456f;
                            d = -123.456;
                            string3 = "test 12 string";
                            LitTestObj litTestObj2 = new LitTestObj(12345L);
                            literal = model.createLiteral("test 12 string 2");
                            resource2 = model.createResource();
                            resource = model.createResource(new ResTestObjF());
                            litTestObj = new LitTestObj(1234L);
                            Bag bag = model.createBag();
                            Alt alt = model.createAlt();
                            Seq seq8 = model.createSeq();
                            string2 = "fr";
                            n5 = 10;
                            int n8 = 0;
                            while (n8 < n5) {
                                seq.add(n8);
                                ++n8;
                            }
                            ++n;
                            if (seq.size() != n5) {
                                this.error(string, n);
                            }
                            ++n;
                            NodeIterator nodeIterator = seq.iterator();
                            int n9 = 0;
                            while (n9 < n5) {
                                if (((Literal)nodeIterator.next()).getInt() != n9) {
                                    this.error(string, 320 + n9);
                                }
                                ++n9;
                            }
                            nodeIterator.close();
                            boolean[] blArray = new boolean[n5];
                            boolean[] blArray2 = new boolean[]{true, true, true, false, false, false, false, false, true, true};
                            n = n / 100 * 100 + 100;
                            ++n;
                            nodeIterator = seq.iterator();
                            n4 = 0;
                            while (n4 < n5) {
                                ++n;
                                nodeIterator.next();
                                ++n;
                                if (!blArray2[n4]) {
                                    nodeIterator.remove();
                                }
                                blArray[n4] = false;
                                ++n4;
                            }
                            ++n;
                            nodeIterator.close();
                            n = n / 100 * 100 + 100;
                            ++n;
                            nodeIterator = seq.iterator();
                            while (nodeIterator.hasNext()) {
                                n2 = ((Literal)nodeIterator.next()).getInt();
                                ++n;
                                if (blArray[n2]) {
                                    this.error(string, n);
                                }
                                blArray[n2] = true;
                            }
                            ++n;
                            nodeIterator.close();
                            n = n / 100 * 100 + 100;
                            n2 = 0;
                            while (n2 < n5) {
                                ++n;
                                if (blArray[n2] != blArray2[n2]) {
                                    this.error(string, n);
                                }
                                ++n2;
                            }
                            blArray = new boolean[n5];
                            blArray2 = new boolean[]{false, true, true, false, false, false, false, false, true, false};
                            n = n / 100 * 100 + 100;
                            n4 = 0;
                            while (n4 < n5) {
                                seq2.add(n4);
                                ++n4;
                            }
                            ++n;
                            nodeIterator = seq2.iterator();
                            n2 = 0;
                            while (n2 < n5) {
                                ++n;
                                nodeIterator.next();
                                ++n;
                                if (!blArray2[n2]) {
                                    nodeIterator.remove();
                                }
                                blArray[n2] = false;
                                ++n2;
                            }
                            ++n;
                            nodeIterator.close();
                            n = n / 100 * 100 + 100;
                            ++n;
                            nodeIterator = seq2.iterator();
                            while (nodeIterator.hasNext()) {
                                n7 = ((Literal)nodeIterator.next()).getInt();
                                ++n;
                                if (blArray[n7]) {
                                    this.error(string, n);
                                }
                                blArray[n7] = true;
                            }
                            ++n;
                            nodeIterator.close();
                            n = n / 100 * 100 + 100;
                            n7 = 0;
                            while (n7 < n5) {
                                ++n;
                                if (blArray[n7] != blArray2[n7]) {
                                    this.error(string, n);
                                }
                                ++n7;
                            }
                            blArray = new boolean[n5];
                            blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false, false};
                            n = n / 100 * 100 + 100;
                            n4 = 0;
                            while (n4 < n5) {
                                seq3.add(n4);
                                ++n4;
                            }
                            ++n;
                            nodeIterator = seq3.iterator();
                            n2 = 0;
                            while (n2 < n5) {
                                ++n;
                                nodeIterator.next();
                                ++n;
                                if (!blArray2[n2]) {
                                    nodeIterator.remove();
                                }
                                blArray[n2] = false;
                                ++n2;
                            }
                            ++n;
                            nodeIterator.close();
                            n = n / 100 * 100 + 100;
                            ++n;
                            nodeIterator = seq3.iterator();
                            while (nodeIterator.hasNext()) {
                                n7 = ((Literal)nodeIterator.next()).getInt();
                                ++n;
                                if (blArray[n7]) {
                                    this.error(string, n);
                                }
                                blArray[n7] = true;
                            }
                            ++n;
                            nodeIterator.close();
                            n = n / 100 * 100 + 100;
                            n7 = 0;
                            while (n7 < n5) {
                                ++n;
                                if (blArray[n7] != blArray2[n7]) {
                                    this.error(string, n);
                                }
                                ++n7;
                            }
                            n = n / 100 * 100 + 100;
                            ++n;
                            seq4.add(bl);
                            ++n;
                            if (seq4.getBoolean(1) != bl) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(by);
                            ++n;
                            if (seq4.getByte(2) != by) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(s);
                            ++n;
                            if (seq4.getShort(3) != s) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(n6);
                            ++n;
                            if (seq4.getInt(4) != n6) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(l);
                            ++n;
                            if (seq4.getLong(5) != l) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(c);
                            ++n;
                            if (seq4.getChar(6) != c) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(f);
                            ++n;
                            if (seq4.getFloat(7) != f) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(d);
                            ++n;
                            if (seq4.getDouble(8) != d) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(string3);
                            ++n;
                            if (!seq4.getString(9).equals(string3)) {
                                this.error(string, n);
                            }
                            ++n;
                            if (!seq4.getLanguage(9).equals("")) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(string3, string2);
                            ++n;
                            if (!seq4.getString(10).equals(string3)) {
                                this.error(string, n);
                            }
                            ++n;
                            if (!seq4.getLanguage(10).equals(string2)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(litTestObj);
                            ++n;
                            if (!seq4.getObject(11, new LitTestObjF()).equals(litTestObj)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(resource2);
                            ++n;
                            if (!seq4.getResource(12).equals(resource2)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(literal);
                            ++n;
                            if (!seq4.getLiteral(13).equals(literal)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(resource);
                            ++n;
                            if (!seq4.getResource(14, new ResTestObjF()).equals(resource)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(bag);
                            ++n;
                            if (!seq4.getBag(15).equals(bag)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(alt);
                            ++n;
                            if (!seq4.getAlt(16).equals(alt)) {
                                this.error(string, n);
                            }
                            ++n;
                            seq4.add(seq8);
                            ++n;
                            if (!seq4.getSeq(17).equals(seq8)) {
                                this.error(string, n);
                            }
                            ++n;
                            try {
                                seq4.getInt(18);
                                this.error(string, n);
                            }
                            catch (RDFException rDFException) {
                                ++n;
                                if (rDFException.getErrorCode() == 18) break block146;
                                this.error(string, n);
                            }
                        }
                        ++n;
                        try {
                            seq4.getInt(0);
                            this.error(string, n);
                        }
                        catch (RDFException rDFException) {
                            ++n;
                            if (rDFException.getErrorCode() == 18) break block147;
                            this.error(string, n);
                        }
                    }
                    n = n / 100 * 100 + 100;
                    int n10 = 0;
                    while (n10 < n5) {
                        seq5.add(n10);
                        ++n10;
                    }
                    try {
                        seq5.add(0, false);
                        this.error(string, ++n);
                    }
                    catch (RDFException rDFException) {
                        ++n;
                        if (rDFException.getErrorCode() == 18) break block148;
                        this.error(string, n);
                    }
                }
                seq5.add(n5 + 1, false);
                if (seq5.size() != n5 + 1) {
                    this.error(string, n);
                }
                seq5.remove(n5 + 1);
                try {
                    seq5.add(n5 + 2, false);
                    this.error(string, ++n);
                }
                catch (RDFException rDFException) {
                    ++n;
                    if (rDFException.getErrorCode() == 18) break block149;
                    this.error(string, n);
                }
            }
            n = n / 100 * 100 + 100;
            int n11 = seq5.size();
            n4 = 1;
            while (n4 <= n5 - 1) {
                ++n;
                seq5.add(n4, 1000 + n4);
                ++n;
                if (seq5.getInt(n4) != 1000 + n4) {
                    this.error(string, n);
                }
                ++n;
                if (seq5.getInt(n4 + 1) != 0) {
                    this.error(string, n);
                }
                ++n;
                if (seq5.size() != n11 + n4) {
                    this.error(string, n);
                }
                ++n;
                if (seq5.getInt(n11) != n5 - n4 - 1) {
                    this.error(string, n);
                }
                ++n4;
            }
            n = n / 100 * 100 + 100;
            seq6.add(model.createResource());
            seq6.add(1, bl);
            ++n;
            if (seq6.getBoolean(1) != bl) {
                this.error(string, n);
            }
            seq6.add(1, by);
            ++n;
            if (seq6.getByte(1) != by) {
                this.error(string, n);
            }
            seq6.add(1, s);
            ++n;
            if (seq6.getShort(1) != s) {
                this.error(string, n);
            }
            seq6.add(1, n6);
            ++n;
            if (seq6.getInt(1) != n6) {
                this.error(string, n);
            }
            seq6.add(1, l);
            ++n;
            if (seq6.getLong(1) != l) {
                this.error(string, n);
            }
            seq6.add(1, c);
            ++n;
            if (seq6.getChar(1) != c) {
                this.error(string, n);
            }
            seq6.add(1, f);
            ++n;
            if (seq6.getFloat(1) != f) {
                this.error(string, n);
            }
            seq6.add(1, d);
            ++n;
            if (seq6.getDouble(1) != d) {
                this.error(string, n);
            }
            seq6.add(1, string3);
            ++n;
            if (!seq6.getString(1).equals(string3)) {
                this.error(string, n);
            }
            seq6.add(1, string3, string2);
            ++n;
            if (!seq6.getString(1).equals(string3)) {
                this.error(string, n);
            }
            seq6.add(1, resource2);
            ++n;
            if (!seq6.getResource(1).equals(resource2)) {
                this.error(string, n);
            }
            seq6.add(1, literal);
            ++n;
            if (!seq6.getLiteral(1).equals(literal)) {
                this.error(string, n);
            }
            seq6.add(1, litTestObj);
            ++n;
            if (!seq6.getObject(1, new LitTestObjF()).equals(litTestObj)) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            ++n;
            if (seq6.indexOf(litTestObj) != 1) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(literal) != 2) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(resource2) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(string3, string2) != 4) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(string3) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(d) != 6) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(f) != 7) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(c) != 8) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(l) != 9) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(n6) != 10) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(s) != 11) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(by) != 12) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(bl) != 13) {
                this.error(string, n);
            }
            ++n;
            if (seq6.indexOf(1234543L) != 0) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            n2 = 0;
            while (n2 < n5) {
                seq7.add(n2);
                ++n2;
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, bl);
            ++n;
            if (seq7.getBoolean(5) != bl) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, by);
            ++n;
            if (seq7.getByte(5) != by) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, s);
            ++n;
            if (seq7.getShort(5) != s) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, n6);
            ++n;
            if (seq7.getInt(5) != n6) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, l);
            ++n;
            if (seq7.getLong(5) != l) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, c);
            ++n;
            if (seq7.getChar(5) != c) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, f);
            ++n;
            if (seq7.getFloat(5) != f) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, d);
            ++n;
            if (seq7.getDouble(5) != d) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, string3);
            ++n;
            if (!seq7.getString(5).equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (!seq7.getLanguage(5).equals("")) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            seq7.set(5, string3, string2);
            ++n;
            if (!seq7.getString(5).equals(string3)) {
                this.error(string, n);
            }
            ++n;
            if (!seq7.getLanguage(5).equals(string2)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, literal);
            ++n;
            if (!seq7.getLiteral(5).equals(literal)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, resource2);
            ++n;
            if (!seq7.getResource(5).equals(resource2)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, litTestObj);
            ++n;
            if (!seq7.getObject(5, new LitTestObjF()).equals(litTestObj)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, resource);
            ++n;
            if (!seq7.getResource(5, new ResTestObjF()).equals(resource)) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(string, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(string, n);
            }
            ++n;
            if (seq7.size() != n5) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName() + " test " + string, n, exception);
            this.errors = true;
        }
    }

    public void error(String string, int n) {
        System.out.println("Test Failed: " + string + " " + n + " ");
        this.errors = true;
    }

    public void error(String string, int n, long l) {
        System.out.println("Test Failed: " + string + " " + n + " " + Long.toString(l));
        this.errors = true;
    }

    public void error(String string, int n, Exception exception) {
        System.out.println("Test Failed: " + string + " " + n + " " + exception.toString());
        this.errors = true;
    }

    public boolean getErrors() {
        return this.errors;
    }

    public boolean setErrors(boolean bl) {
        boolean bl2 = this.errors;
        this.errors = bl;
        return bl2;
    }

    public class ResTestObjF
    implements ResourceF {
        public Resource createResource(Resource resource) throws Exception {
            return new ResTestObj(resource);
        }
    }

    public class LitTestObjF
    implements ObjectF {
        public Object createObject(String string) {
            return new LitTestObj(string);
        }
    }

    public class LitTestObj {
        protected long content;

        public LitTestObj(long l) {
            this.content = l;
        }

        public LitTestObj(String string) {
            this.content = Long.parseLong(string.substring(1, string.length() - 1));
        }

        public String toString() {
            return "[" + Long.toString(this.content) + "]";
        }

        public boolean equals(Object object) {
            if (object instanceof LitTestObj) {
                return this.content == ((LitTestObj)object).content;
            }
            return false;
        }
    }
}

