/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.prettywriter;

import com.hp.hpl.mesa.rdf.jena.common.RDFDefaultErrorHandler;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.DAML;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.Unparser;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.readers.MIME2Java;

public class PrettyWriter
implements RDFWriter,
RDFErrorHandler {
    private static RDFDefaultErrorHandler defaultErrorHandler = new RDFDefaultErrorHandler();
    private RDFErrorHandler errorHandler = defaultErrorHandler;
    private Map nameSpacePrefices = new HashMap();
    private String xmlBase;
    private Boolean showXmlDeclaration = null;
    private Resource[] types = new Resource[]{DAML.Ontology, DAML.Datatype, DAML.Class, RDFS.Class, DAML.Property, DAML.ObjectProperty, DAML.DatatypeProperty, DAML.TransitiveProperty, DAML.UnambigousProperty, DAML.UniqueProperty};

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        if (rDFErrorHandler2 == defaultErrorHandler) {
            rDFErrorHandler2 = null;
        }
        this.errorHandler = rDFErrorHandler == null ? defaultErrorHandler : rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public void setNsPrefix(String string, String string2) {
        this.nameSpacePrefices.put(string, string2);
    }

    public Object setProperty(String string, Object object) throws RDFException {
        if (string.equalsIgnoreCase("showXmlDeclaration")) {
            String string2 = this.showXmlDeclaration == null ? null : this.showXmlDeclaration.toString();
            if (object == null) {
                this.showXmlDeclaration = null;
            } else if (object instanceof Boolean) {
                this.showXmlDeclaration = (Boolean)object;
            } else if (object instanceof String) {
                String string3 = (String)object;
                if (string3.equalsIgnoreCase("default")) {
                    this.showXmlDeclaration = null;
                }
                if (string3.equalsIgnoreCase("true")) {
                    this.showXmlDeclaration = Boolean.TRUE;
                } else if (string3.equalsIgnoreCase("false")) {
                    this.showXmlDeclaration = Boolean.FALSE;
                } else {
                    throw new RDFException(11);
                }
            }
            return string2;
        }
        if (string.equalsIgnoreCase("xmlbase")) {
            String string4 = this.xmlBase;
            this.xmlBase = (String)object;
            return string4;
        }
        if (string.equalsIgnoreCase("prettyTypes")) {
            Resource[] resourceArray = this.types;
            this.types = (Resource[])object;
            return resourceArray;
        }
        throw new RDFException(22);
    }

    public void write(Model model, Writer writer, String string) throws RDFException {
        PrintWriter printWriter = new PrintWriter(writer);
        Unparser unparser = new Unparser(this, string, model, printWriter);
        unparser.setTopLevelTypes(this.types);
        unparser.useNameSpaceDecl(this.nameSpacePrefices);
        if (this.xmlBase != null) {
            unparser.setXMLBase(this.xmlBase);
        }
        if (!Boolean.FALSE.equals(this.showXmlDeclaration)) {
            String string2;
            String string3 = null;
            if (writer instanceof OutputStreamWriter && !(string2 = ((OutputStreamWriter)writer).getEncoding()).equals("UTF8")) {
                string3 = "<?xml version='1.0' encoding='" + MIME2Java.reverse((String)string2) + "'?>";
            }
            if (string3 == null && this.showXmlDeclaration != null) {
                string3 = "<?xml version='1.0'?>";
            }
            if (string3 != null) {
                unparser.setDeclaration(string3);
            }
        }
        unparser.write();
        printWriter.flush();
    }

    public void write(Model model, OutputStream outputStream, String string) throws RDFException {
        try {
            this.write(model, new OutputStreamWriter(outputStream, "UTF-8"), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Java installation broken: does not support UTF-8 encoding.");
        }
    }

    public void error(Exception exception) {
        this.errorHandler.error(exception);
    }

    public void warning(Exception exception) {
        this.errorHandler.warning(exception);
    }

    public void fatalError(Exception exception) {
        this.errorHandler.fatalError(exception);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Test code for bug 77");
        ModelMem modelMem = new ModelMem();
        modelMem.read(new FileReader("modules/rdf/regression/arp/bug51_0.rdf"), "http://example.org/file");
        RDFWriter rDFWriter = modelMem.getWriter("RDF/XML-ABBREV");
        rDFWriter.setNsPrefix("eg", "http://example.org/");
        rDFWriter.setNsPrefix("eg2", "http://example.org/foo#");
        rDFWriter.write(modelMem, new OutputStreamWriter(System.out), "http://example.org/file");
    }
}

