/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.Util;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFReader;
import com.hp.hpl.mesa.rdf.jena.model.RDFReaderF;
import java.util.Properties;

public class RDFReaderFImpl
implements RDFReaderF {
    protected static Properties langToClassName = null;
    protected static final String[] LANGS = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N3"};
    protected static final String[] DEFAULTREADERS = new String[]{"com.hp.hpl.jena.rdf.arp.JenaReader", "com.hp.hpl.jena.rdf.arp.JenaReader", "com.hp.hpl.mesa.rdf.jena.common.NTripleReader", "com.hp.hpl.jena.n3.N3JenaReader"};
    protected static final String DEFAULTLANG = LANGS[0];
    protected static final String PROPNAMEBASE = "com.hp.hpl.mesa.rdf.jena.reader.";

    public RDFReader getReader() throws RDFException {
        return this.getReader(DEFAULTLANG);
    }

    public RDFReader getReader(String string) throws RDFException {
        String string2;
        if (string == null || string.equals("")) {
            string = LANGS[0];
        }
        if ((string2 = langToClassName.getProperty(string)) == null || string2.equals("")) {
            throw new RDFException(20);
        }
        try {
            return (RDFReader)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public String setReaderClassName(String string, String string2) {
        String string3 = langToClassName.getProperty(string);
        langToClassName.setProperty(string, string2);
        return string3;
    }

    static {
        langToClassName = new Properties();
        int n = 0;
        while (n < LANGS.length) {
            langToClassName.setProperty(LANGS[n], Util.getProperty(PROPNAMEBASE + LANGS[n], DEFAULTREADERS[n]));
            ++n;
        }
    }
}

