/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.IStream;
import com.hp.hpl.mesa.rdf.jena.common.RDFDefaultErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.RDFReader;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;

public class NTripleReader
implements RDFReader {
    Model model = null;
    Hashtable anons = new Hashtable();
    IStream in = null;
    boolean inErr = false;
    int errCount = 0;
    private static final int sbLength = 200;
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    NTripleReader() {
    }

    public void read(Model model, Reader reader, String string) throws RDFException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.model = model;
        this.in = new IStream(reader);
        this.readRDF();
        if (this.errCount != 0) {
            throw new RDFException(24);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(Model model, String string) throws RDFException {
        try {
            try {
                this.read(model, new InputStreamReader(new URL(string).openStream()), string);
            }
            catch (Exception exception) {
                throw new RDFException(exception);
            }
            Object var5_3 = null;
            if (this.errCount == 0) return;
            throw new RDFException(24);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.errCount == 0) throw throwable;
            throw new RDFException(24);
        }
    }

    public Object setProperty(String string, Object object) throws RDFException {
        this.errorHandler.error(new RDFException(22));
        return null;
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    /*
     * Unable to fully structure code
     */
    protected void readRDF() throws RDFException {
        var2_1 = null;
        ** GOTO lbl33
        {
            this.inErr = false;
            this.skipWhiteSpace();
            if (this.in.eof()) {
                return;
            }
            var1_2 = this.readResource();
            if (this.inErr) ** GOTO lbl29
            this.skipWhiteSpace();
            try {
                var2_1 = this.model.createProperty(this.readResource().getURI());
            }
            catch (Exception var4_5) {
                this.errorHandler.fatalError(var4_5);
            }
            if (this.inErr) ** GOTO lbl29
            this.skipWhiteSpace();
            var3_3 = this.readNode();
            if (this.inErr) ** GOTO lbl29
            this.skipWhiteSpace();
            if (this.badEOF() || !this.expect(".")) ** GOTO lbl29
            try {
                this.model.add(var1_2, var2_1, var3_3);
            }
            catch (Exception var4_6) {
                this.errorHandler.fatalError(var4_6);
            }
            do {
                if (!this.in.eof()) continue block4;
lbl29:
                // 5 sources

                if (!this.inErr) continue;
                ++this.errCount;
                while (!this.in.eof() && this.in.readChar() != '\n') {
                }
lbl33:
                // 3 sources

            } while (!this.in.eof());
        }
    }

    public Resource readResource() throws RDFException {
        char c = this.in.readChar();
        if (this.badEOF()) {
            return null;
        }
        if (c == '_') {
            if (!this.expect(":")) {
                return null;
            }
            String string = this.readName();
            if (string == null) {
                this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("expected bNode label", this.in.getLinepos(), this.in.getCharpos())));
                this.inErr = true;
                return null;
            }
            return this.lookupResource(string);
        }
        if (c == '<') {
            String string = this.readURI();
            if (string == null) {
                this.inErr = true;
                return null;
            }
            c = this.in.readChar();
            if (c != '>') {
                this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("expected '>'", this.in.getLinepos(), this.in.getCharpos())));
                this.inErr = true;
                return null;
            }
            return this.model.createResource(string);
        }
        this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("unexpected input", this.in.getLinepos(), this.in.getCharpos())));
        this.inErr = true;
        return null;
    }

    public RDFNode readNode() throws RDFException {
        this.skipWhiteSpace();
        switch (this.in.nextChar()) {
            case '\"': {
                return this.readLiteral(false);
            }
            case 'x': {
                return this.readLiteral(true);
            }
            case '<': 
            case '_': {
                return this.readResource();
            }
        }
        this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("unexpected input", this.in.getLinepos(), this.in.getCharpos())));
        this.inErr = true;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Literal readLiteral(boolean bl) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (bl && !this.expect("xml")) {
            return null;
        }
        if (!this.expect("\"")) {
            return null;
        }
        while (true) {
            int n;
            block13: {
                block14: {
                    char c;
                    block16: {
                        block15: {
                            n = this.in.readChar();
                            if (this.badEOF()) {
                                return null;
                            }
                            if (n != 92) break block14;
                            c = this.in.readChar();
                            if (this.in.eof()) {
                                this.inErr = true;
                                return null;
                            }
                            if (c != 'n') break block15;
                            n = 10;
                            break block13;
                        }
                        if (c != 'r') break block16;
                        n = 13;
                        break block13;
                    }
                    if (c == 't') {
                        n = 9;
                        break block13;
                    } else if (c == '\\' || c == '\"') {
                        n = c;
                        break block13;
                    } else {
                        if (c != 'u') {
                            this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("illegal escape sequence '" + c + "'", this.in.getLinepos(), this.in.getCharpos())));
                            this.inErr = true;
                            return null;
                        }
                        n = this.readUnicode4Escape();
                        if (this.inErr) {
                            return null;
                        }
                    }
                    break block13;
                }
                if (n == 34) {
                    String string;
                    if ('-' == this.in.nextChar()) {
                        string = this.readLang();
                        return this.model.createLiteral(stringBuffer.toString(), string, bl);
                    }
                    string = "";
                    return this.model.createLiteral(stringBuffer.toString(), string, bl);
                }
            }
            stringBuffer = stringBuffer.append((char)n);
        }
    }

    private char readUnicode4Escape() {
        char[] cArray = new char[]{this.in.readChar(), this.in.readChar(), this.in.readChar(), this.in.readChar()};
        if (this.badEOF()) {
            return '\u0000';
        }
        try {
            return (char)Integer.parseInt(new String(cArray), 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.inErr = true;
            this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("bad unicode escape sequence", this.in.getLinepos(), this.in.getCharpos())));
            return '\u0000';
        }
    }

    private String readLang() {
        StringBuffer stringBuffer = new StringBuffer(15);
        if (!this.expect("-")) {
            return null;
        }
        char c;
        while (!Character.isWhitespace(c = this.in.nextChar()) && c != '.') {
            stringBuffer = stringBuffer.append(this.in.readChar());
        }
        return stringBuffer.toString();
    }

    private boolean badEOF() {
        if (this.in.eof()) {
            this.inErr = true;
            this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("premature end of file", this.in.getLinepos(), this.in.getCharpos())));
        }
        return this.inErr;
    }

    protected String readURI() {
        StringBuffer stringBuffer = new StringBuffer(200);
        while (this.in.nextChar() != '>') {
            char c = this.in.readChar();
            if (c == '\\') {
                this.expect("u");
                c = this.readUnicode4Escape();
            }
            if (this.badEOF()) {
                return null;
            }
            stringBuffer = stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected String readName() {
        StringBuffer stringBuffer = new StringBuffer(200);
        while (!Character.isWhitespace(this.in.nextChar())) {
            stringBuffer = stringBuffer.append(this.in.readChar());
            if (!this.badEOF()) continue;
            return null;
        }
        return stringBuffer.toString();
    }

    private boolean expect(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (this.badEOF()) {
                return false;
            }
            char c2 = this.in.readChar();
            if (c2 != c) {
                System.err.println("N-triple reader error");
                this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("expected \"" + string + "\"", this.in.getLinepos(), this.in.getCharpos())));
                this.inErr = true;
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void skipWhiteSpace() {
        while (Character.isWhitespace(this.in.nextChar()) || this.in.nextChar() == '#') {
            char c = this.in.readChar();
            if (this.in.eof()) {
                return;
            }
            if (c != '#') continue;
            while (c != '\n') {
                c = this.in.readChar();
                if (!this.in.eof()) continue;
                return;
            }
        }
    }

    protected Resource lookupResource(String string) throws RDFException {
        Resource resource = (Resource)this.anons.get(string);
        if (resource == null) {
            resource = this.model.createResource();
            this.anons.put(string, resource);
        }
        return resource;
    }

    protected String syntaxErrorMessage(String string, int n, int n2) {
        return "syntax error at line " + n + " position " + n2 + ": " + string;
    }
}

