/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.model.JenaConfig;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.ObjectF;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;

public class LiteralImpl
implements Literal {
    String literal;
    String language = "";
    boolean wellFormed = false;

    public LiteralImpl(boolean bl) {
        this.literal = String.valueOf(bl);
    }

    public LiteralImpl(long l) {
        this.literal = String.valueOf(l);
    }

    public LiteralImpl(char c) {
        this.literal = String.valueOf(c);
    }

    public LiteralImpl(float f) {
        this.literal = String.valueOf(f);
    }

    public LiteralImpl(double d) {
        this.literal = String.valueOf(d);
    }

    public LiteralImpl(String string) {
        this.literal = string == null ? "" : string;
    }

    public LiteralImpl(String string, String string2) {
        this.literal = string == null ? "" : string;
        this.language = string2;
    }

    public LiteralImpl(String string, boolean bl) {
        this.literal = string == null ? "" : string;
        this.wellFormed = bl;
    }

    public LiteralImpl(String string, String string2, boolean bl) {
        this.literal = string == null ? "" : string;
        this.language = string2;
        this.wellFormed = bl;
    }

    public LiteralImpl(Object object) {
        this.literal = object.toString();
    }

    public String toString() {
        return this.literal;
    }

    public int hashCode() {
        return this.literal == null ? 0 : this.literal.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (JenaConfig.getOldLiteralCompare() && object instanceof String) {
            object = new LiteralImpl((String)object);
        }
        if (object instanceof Literal) {
            return this.literal.equals(((Literal)object).toString()) && (this.wellFormed == ((Literal)object).getWellFormed() || JenaConfig.getOldLiteralCompare()) && this.language.equalsIgnoreCase(((Literal)object).getLanguage());
        }
        return false;
    }

    public boolean getBoolean() throws RDFException {
        if (this.literal.equals("true")) {
            return true;
        }
        if (this.literal.equals("false")) {
            return false;
        }
        throw new RDFException(11);
    }

    public byte getByte() throws RDFException {
        return Byte.parseByte(this.literal);
    }

    public short getShort() throws RDFException {
        return Short.parseShort(this.literal);
    }

    public int getInt() throws RDFException {
        return Integer.parseInt(this.literal);
    }

    public long getLong() throws RDFException {
        return Long.parseLong(this.literal);
    }

    public char getChar() throws RDFException {
        if (this.literal.length() == 1) {
            return this.literal.charAt(0);
        }
        throw new RDFException(12);
    }

    public float getFloat() throws RDFException {
        return Float.parseFloat(this.literal);
    }

    public double getDouble() throws RDFException {
        return Double.parseDouble(this.literal);
    }

    public String getString() throws RDFException {
        return this.literal;
    }

    public Object getObject(ObjectF objectF) throws RDFException {
        try {
            return objectF.createObject(this.literal);
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean getWellFormed() {
        return this.wellFormed;
    }
}

