/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.test;

import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryEngine;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.QueryResultsFormatter;
import com.hp.hpl.jena.rdf.query.QueryResultsMem;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.util.tuple.TupleItem;
import com.hp.hpl.jena.util.tuple.TupleSet;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QueryTestScripts
extends TestSuite {
    static final String testSetName = "RDQL - Query - Scripts";
    public static final String defaultControlFilename = "_control_";
    public static final String defaultTestDirectory = "modules/rdf/regression/testRDQL";
    public String basename = null;
    public static boolean printDetails = false;
    public static boolean displayTime = false;
    static Writer outputFile = null;
    String controlFilename = null;
    String testDirectory = null;

    public static TestSuite suite() {
        return QueryTestScripts.suite(testSetName, null);
    }

    public static TestSuite suite(String string, Model model) {
        return QueryTestScripts.suite(string, model, defaultTestDirectory, defaultControlFilename);
    }

    public static TestSuite suite(String string, Model model, String string2, String string3) {
        return new QueryTestScripts(string, model, string2, string3);
    }

    private QueryTestScripts(String string, Model model, String string2, String string3) {
        super(string);
        this.testDirectory = string2;
        this.controlFilename = string3;
        String string4 = this.testDirectory == null ? this.controlFilename : this.testDirectory + "/" + this.controlFilename;
        this.addTests(model, string4);
    }

    public static void doTests(String string, boolean bl, boolean bl2) {
        displayTime = bl2;
        printDetails = bl || bl2;
        QueryTestScripts.init();
        TestSuite testSuite = QueryTestScripts.suite("RDQL-Scripts", null, null, string);
        TestRunner.run((Test)testSuite);
    }

    public void addTests(Model model, String string) {
        PrintWriter printWriter = new PrintWriter(System.out);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string), 1024);
            TupleSet tupleSet = new TupleSet(bufferedReader);
            while (tupleSet.hasNext()) {
                TupleItem tupleItem;
                List list = (List)tupleSet.next();
                if (list == null || list.size() != 3) {
                    Log.severe("QueryTest: error in test file, line " + tupleSet.lineNumber + "\n" + tupleSet.line);
                    System.exit(1);
                }
                if (!(tupleItem = (TupleItem)list.get(0)).isURI()) {
                    Log.warning("Not a URI: " + tupleItem.asQuotedString() + " :: " + tupleSet.line);
                    continue;
                }
                TupleItem tupleItem2 = (TupleItem)list.get(1);
                if (!tupleItem2.isURI()) {
                    Log.warning("Not a URI: " + tupleItem2.asQuotedString() + " :: " + tupleSet.line);
                    continue;
                }
                TupleItem tupleItem3 = (TupleItem)list.get(2);
                if (!tupleItem3.isURI()) {
                    Log.warning("Not a URI: " + tupleItem3.asQuotedString() + " :: " + tupleSet.line);
                    continue;
                }
                String string2 = tupleItem.get();
                int n = string2.lastIndexOf(47);
                String string3 = n <= 0 ? string2 : string2.substring(n + 1);
                this.addTest((Test)new RDQLTest(model, printWriter, "RDQL:" + string3, this.testDirectory, tupleItem.get(), tupleItem2.get(), tupleItem3.get()));
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Log.warning("Exception during control file processing", "rdf.query.Test", "doTests", iOException);
            return;
        }
    }

    private static void emptyModel(Model model) {
        if (model == null) {
            return;
        }
        try {
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.next();
                stmtIterator.remove();
            }
            stmtIterator.close();
        }
        catch (RDFException rDFException) {
            Log.severe("Failed to empty model", "com.hp.hpl.jena.rdf.query.Test.QueryTest", "emptyModel", rDFException);
        }
    }

    private static void init() {
        String string = "SELECT * WHERE (?x, ?y, ?z)";
        Query query = new Query(string);
        query.setSource(new ModelMem());
        QueryEngine queryEngine = new QueryEngine(query);
        QueryResults queryResults = queryEngine.exec();
        QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResults);
        queryResultsFormatter.consume();
    }

    static String formatlong(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Long.toString(l));
        int n = stringBuffer.length();
        while (n < 4) {
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    static class RDQLTest
    extends TestCase {
        static int testCounter = 1;
        Model model;
        PrintWriter pw;
        int testNumber = testCounter++;
        String queryFile;
        String dataFile;
        String resultsFile;
        String directory;

        RDQLTest(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5) {
            this(null, printWriter, string, string2, string3, string4, string5);
        }

        RDQLTest(Model model, PrintWriter printWriter, String string, String string2, String string3, String string4, String string5) {
            super(string);
            this.model = model;
            this.pw = printWriter;
            this.queryFile = string3;
            this.dataFile = string4;
            this.resultsFile = string5;
            this.directory = string2;
        }

        protected void runTest() throws Throwable {
            block24: {
                Query query = null;
                try {
                    block23: {
                        try {
                            boolean bl;
                            if (printDetails) {
                                if (this.testNumber != 1) {
                                    this.pw.println();
                                    this.pw.println("------------------------------------------------------------------------");
                                    this.pw.println();
                                }
                                this.pw.println("Test " + this.testNumber + " :: QueryFile=" + this.queryFile + ", DataFile=" + this.dataFile + ", ResultsFile=" + this.resultsFile);
                            }
                            String string = this.directory == null ? this.queryFile : this.directory + "/" + this.queryFile;
                            String string2 = FileUtils.readWholeFile(string);
                            if (printDetails) {
                                this.pw.println("Query:");
                                this.pw.println(string2);
                                if (!string2.endsWith("\n")) {
                                    this.pw.println();
                                }
                            }
                            long l = System.currentTimeMillis();
                            query = new Query(string2);
                            if (printDetails) {
                                this.pw.println("Parsed query:");
                                this.pw.println(query.toString());
                            }
                            if (this.model == null) {
                                if (this.dataFile != null && !this.dataFile.equals("")) {
                                    ModelLoader.setFileBase(this.directory);
                                    long l2 = System.currentTimeMillis();
                                    query.setSource(ModelLoader.loadModel(this.dataFile, null));
                                    query.loadTime = System.currentTimeMillis() - l2;
                                    ModelLoader.setFileBase(null);
                                }
                            } else {
                                QueryTestScripts.emptyModel(this.model);
                                String string3 = this.dataFile;
                                if (this.dataFile == null || this.dataFile.equals("")) {
                                    string3 = query.getSourceURL();
                                }
                                ModelLoader.setFileBase(this.directory);
                                long l3 = System.currentTimeMillis();
                                query.setSource(ModelLoader.loadModel(this.model, string3, null));
                                query.loadTime = System.currentTimeMillis() - l3;
                                ModelLoader.setFileBase(null);
                            }
                            QueryEngine queryEngine = new QueryEngine(query);
                            ModelLoader.setFileBase(this.directory);
                            queryEngine.init();
                            ModelLoader.setFileBase(null);
                            QueryResults queryResults = queryEngine.exec();
                            boolean bl2 = bl = this.resultsFile != null && !this.resultsFile.equals("");
                            if (bl) {
                                queryResults = new QueryResultsMem(queryResults);
                            }
                            QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResults);
                            if (printDetails) {
                                queryResultsFormatter.printAll(this.pw, " | ");
                                this.pw.println();
                                int n = queryResultsFormatter.numRows();
                                this.pw.println("Results: " + (n < 0 ? "unknown (one pass format)" : n + ""));
                            } else {
                                queryResultsFormatter.consume();
                            }
                            long l4 = System.currentTimeMillis();
                            long l5 = l4 - l;
                            queryResultsFormatter.close();
                            queryResults.close();
                            if (printDetails && displayTime) {
                                this.pw.println();
                                this.pw.println("Query parse:     " + QueryTestScripts.formatlong(query.parseTime) + " ms");
                                this.pw.println("Query build:     " + QueryTestScripts.formatlong(query.buildTime) + " ms");
                                this.pw.println("Data load time:  " + QueryTestScripts.formatlong(query.loadTime) + " ms");
                                this.pw.println("Query execute:   " + QueryTestScripts.formatlong(query.executeTime) + " ms");
                                this.pw.println("Query misc:      " + QueryTestScripts.formatlong(l5 - query.parseTime - query.buildTime - query.loadTime - query.executeTime) + " ms");
                                this.pw.println("Query total:     " + QueryTestScripts.formatlong(l5) + " ms");
                            }
                            if (!bl) break block23;
                            this.resultsFile = this.directory == null ? this.resultsFile : this.directory + "/" + this.resultsFile;
                            QueryResultsMem queryResultsMem = (QueryResultsMem)queryResults;
                            queryResultsMem.reset();
                            QueryResultsMem queryResultsMem2 = new QueryResultsMem(this.resultsFile);
                            if (QueryResultsMem.equivalent(queryResultsMem, queryResultsMem2)) break block23;
                            this.pw.println();
                            this.pw.println("Failure: " + this.queryFile);
                            this.pw.println("Got:");
                            queryResultsMem.list(this.pw);
                            this.pw.flush();
                            this.pw.println("Expected:");
                            queryResultsMem2.list(this.pw);
                            this.pw.flush();
                            Assert.assertTrue((String)this.queryFile, (boolean)false);
                        }
                        catch (QueryException queryException) {
                            this.pw.flush();
                            throw queryException;
                        }
                        catch (IOException iOException) {
                            this.pw.println("IOException: " + iOException);
                            iOException.printStackTrace(this.pw);
                            this.pw.flush();
                            Object var17_21 = null;
                            if (this.model == null && query.getSource() != null) {
                                query.getSource().close();
                            }
                            this.pw.flush();
                            break block24;
                        }
                        catch (Exception exception) {
                            this.pw.println("Exception: " + exception);
                            exception.printStackTrace(this.pw);
                            this.pw.flush();
                            Object var17_22 = null;
                            if (this.model == null && query.getSource() != null) {
                                query.getSource().close();
                            }
                            this.pw.flush();
                        }
                    }
                    Object var17_20 = null;
                    if (this.model == null && query.getSource() != null) {
                        query.getSource().close();
                    }
                    this.pw.flush();
                }
                catch (Throwable throwable) {
                    Object var17_23 = null;
                    if (this.model == null && query.getSource() != null) {
                        query.getSource().close();
                    }
                    this.pw.flush();
                    throw throwable;
                }
            }
        }
    }
}

