/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.parser.Literal;
import com.hp.hpl.jena.rdf.query.parser.Q_Query;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;

class Q_URI
extends Literal {
    String seen = "";
    boolean isAbsolute = false;
    static final String prefixOperator = ":";

    Q_URI(int n) {
        super(n);
    }

    Q_URI(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    void accumulate(String string) {
        this.seen = this.seen + string;
    }

    public void jjtClose() {
        super.setURI(this.seen);
    }

    public static String processEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (true) {
            int n4;
            if ((n4 = string.indexOf("%", n2)) < 0 || n4 + 2 >= n) {
                stringBuffer.append(string.substring(n2));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n2, n4));
            int n5 = Character.digit(string.charAt(n4 + 1), 16);
            int n6 = Character.digit(string.charAt(n4 + 2), 16);
            stringBuffer.append((char)(n5 * 16 + n6));
            n2 = n4 + 3;
        }
    }

    public void fixup(Q_Query q_Query) {
        if (!this.isAbsolute) {
            this.absolute(q_Query);
        }
    }

    private void absolute(Q_Query q_Query) {
        int n = this.seen.indexOf(prefixOperator);
        if (n < 0) {
            this.isAbsolute = true;
            return;
        }
        String string = this.seen.substring(0, n);
        String string2 = q_Query.getPrefix(string);
        if (string2 == null) {
            this.isAbsolute = true;
            return;
        }
        String string3 = this.seen.substring(n + prefixOperator.length());
        super.setURI(string2 + string3);
        this.isAbsolute = true;
    }

    public static Q_URI makeURI(String string) {
        Q_URI q_URI = new Q_URI(0);
        q_URI.seen = string;
        q_URI.setURI(string);
        return q_URI;
    }

    public String asQuotedString() {
        return "<" + this.seen + ">";
    }

    public String asUnquotedString() {
        return this.seen;
    }

    public String valueString() {
        return super.getURI();
    }

    public String toString() {
        return this.seen;
    }
}

