/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.EvalTypeException;
import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.QueryPrintUtils;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Settable;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.WorkingVar;
import com.hp.hpl.jena.rdf.query.parser.Expr;
import com.hp.hpl.jena.rdf.query.parser.ExprNumeric;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;
import com.hp.hpl.jena.rdf.query.parser.SimpleNode;
import java.io.PrintWriter;

class Q_LeftShift
extends SimpleNode
implements Expr,
ExprNumeric {
    Expr left;
    Expr right;
    private String printName = "lshift";
    private String opSymbol = "<<";

    Q_LeftShift(int n) {
        super(n);
    }

    Q_LeftShift(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        int n = this.jjtGetNumChildren();
        Value value = this.left.eval(query, resultBinding);
        Value value2 = this.right.eval(query, resultBinding);
        if (!value.isNumber()) {
            throw new EvalTypeException("Q_LeftShift: Wanted a number: " + value);
        }
        if (!value2.isNumber()) {
            throw new EvalTypeException("Q_LeftShift: Wanted a number: " + value2);
        }
        Settable settable = value instanceof Settable ? (Settable)value : (value2 instanceof Settable ? (Settable)value2 : new WorkingVar());
        if (!value.isInt() || !value2.isInt()) {
            throw new EvalTypeException("Q_LeftShift: one or both operands are doubles: " + value + " << " + value2);
        }
        settable.setInt(value.getInt() << (int)value2.getInt());
        return settable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_LeftShift: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.left, this.right, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

