/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.QueryResultsFormatter;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.parser.Literal;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.tuple.TupleItem;
import com.hp.hpl.jena.util.tuple.TupleSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class QueryResultsMem
implements QueryResults {
    static boolean DEBUG = false;
    List rows;
    List varNames;
    int rowNumber;
    Iterator iterator;
    boolean isEmpty;

    public QueryResultsMem(QueryResultsMem queryResultsMem) {
        this(queryResultsMem, false);
    }

    public QueryResultsMem(QueryResultsMem queryResultsMem, boolean bl) {
        this.rows = new ArrayList();
        this.varNames = null;
        this.rowNumber = 0;
        this.isEmpty = false;
        this.varNames = queryResultsMem.varNames;
        if (bl) {
            Iterator iterator = queryResultsMem.rows.iterator();
            while (iterator.hasNext()) {
                this.rows.add((ResultBinding)iterator.next());
            }
        } else {
            this.rows = queryResultsMem.rows;
        }
        this.iterator = this.rows.iterator();
        this.reset();
    }

    /*
     * Unable to fully structure code
     */
    public QueryResultsMem(QueryResults var1_1) {
        block1: {
            super();
            this.rows = new ArrayList<E>();
            this.varNames = null;
            this.rowNumber = 0;
            this.isEmpty = false;
            if (!(var1_1 instanceof QueryResultsMem)) ** GOTO lbl13
            var2_2 = (QueryResultsMem)var1_1;
            this.rows = var2_2.rows;
            break block1;
lbl-1000:
            // 1 sources

            {
                var2_3 = (ResultBinding)var1_1.next();
                this.rows.add(var2_3);
lbl13:
                // 2 sources

                ** while (var1_1.hasNext())
            }
        }
        this.varNames = var1_1.getResultVars();
        var1_1.close();
        this.reset();
    }

    public QueryResultsMem(Reader reader) {
        this.rows = new ArrayList();
        this.varNames = null;
        this.rowNumber = 0;
        this.isEmpty = false;
        this.buildFromDumpFormat(reader);
    }

    public QueryResultsMem(String string) throws FileNotFoundException {
        this.rows = new ArrayList();
        this.varNames = null;
        this.rowNumber = 0;
        this.isEmpty = false;
        BufferedReader bufferedReader = null;
        try {
            URL uRL = new URL(string);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = string;
            FileReader fileReader = new FileReader(string2);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (IOException iOException) {
            Log.severe("IOException: " + iOException, "QueryResultsUtils", "", iOException);
            return;
        }
        this.buildFromDumpFormat(bufferedReader);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("QueryResultsMem: Attempt to remove an element");
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        ++this.rowNumber;
        return this.iterator.next();
    }

    public void close() {
    }

    public void reset() {
        this.iterator = this.rows.iterator();
        this.rowNumber = 0;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int size() {
        return this.rows.size();
    }

    public List getResultVars() {
        return this.varNames;
    }

    public List getAll() {
        return this.rows;
    }

    private void buildFromDumpFormat(Reader reader) {
        Object object;
        Object object2;
        this.varNames = new ArrayList();
        TupleSet tupleSet = new TupleSet(reader);
        if (!tupleSet.hasNext()) {
            this.varNames = new ArrayList();
            this.isEmpty = true;
            return;
        }
        List list = (List)tupleSet.next();
        if (list.size() == 0) {
            Log.severe("No variable names yet result set is not empty");
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (TupleItem)iterator.next();
            object = ((TupleItem)object2).get().substring(1);
            this.varNames.add(object);
        }
        while (tupleSet.hasNext()) {
            object2 = (List)tupleSet.next();
            object = new ResultBinding();
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                TupleItem tupleItem = (TupleItem)iterator2.next();
                if (!iterator2.hasNext()) {
                    Log.severe("Odd number of items in dumped result set", "QueryResult2", "");
                    return;
                }
                TupleItem tupleItem2 = (TupleItem)iterator2.next();
                if (!tupleItem.get().startsWith("?")) {
                    Log.severe("Variable name does not start with a ?", "QueryResult2", "");
                    return;
                }
                String string = tupleItem.get().substring(1);
                if (!this.varNames.contains(string)) {
                    Log.severe("Variable " + string + " is unknown");
                    return;
                }
                Literal literal = null;
                literal = tupleItem2.isURI() ? Literal.makeURI(tupleItem2.get()) : Literal.makeString(tupleItem2.get());
                ((ResultBinding)object).add(string, literal);
            }
            this.rows.add(object);
        }
        this.reset();
    }

    public static boolean equivalent(QueryResultsMem queryResultsMem, QueryResultsMem queryResultsMem2) {
        Object object;
        if (queryResultsMem.rows.size() != queryResultsMem2.rows.size()) {
            if (DEBUG) {
                System.err.println("Not equivalent: different row sizes: (" + queryResultsMem.rows.size() + ", " + queryResultsMem2.rows.size() + ")");
            }
            return false;
        }
        if (queryResultsMem.varNames.size() != queryResultsMem2.varNames.size()) {
            if (DEBUG) {
                System.err.println("Not equivalent: different numbers of variables: (" + queryResultsMem.varNames.size() + ", " + queryResultsMem2.varNames.size() + ")");
            }
            return false;
        }
        List list = queryResultsMem.varNames;
        Iterator iterator = queryResultsMem.varNames.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (queryResultsMem2.varNames.contains(object)) continue;
            return false;
        }
        queryResultsMem2 = new QueryResultsMem(queryResultsMem2, true);
        object = queryResultsMem.rows.iterator();
        while (object.hasNext()) {
            ResultBinding resultBinding;
            Iterator iterator2;
            if (DEBUG) {
                System.err.println("Set 1");
                int n = 0;
                Iterator iterator3 = queryResultsMem.rows.iterator();
                while (iterator3.hasNext()) {
                    iterator2 = (ResultBinding)iterator3.next();
                    System.err.println(++n + " " + iterator2);
                }
                System.err.println("Set 2");
                n = 0;
                iterator2 = queryResultsMem2.rows.iterator();
                while (iterator2.hasNext()) {
                    resultBinding = (ResultBinding)iterator2.next();
                    System.err.println(++n + " " + resultBinding);
                }
            }
            ResultBinding resultBinding2 = (ResultBinding)object.next();
            boolean bl = false;
            iterator2 = queryResultsMem2.rows.iterator();
            while (iterator2.hasNext()) {
                resultBinding = (ResultBinding)iterator2.next();
                if (!QueryResultsMem.sameRow(list, resultBinding2, resultBinding)) continue;
                bl = true;
                iterator2.remove();
                break;
            }
            if (bl) continue;
            return false;
        }
        if (queryResultsMem2.rows.size() != 0) {
            System.err.println("Warning: still got some rows left");
            System.err.println(queryResultsMem2.toString());
        }
        return true;
    }

    private static boolean sameRow(List list, ResultBinding resultBinding, ResultBinding resultBinding2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (DEBUG) {
            System.err.println("Row1 = " + resultBinding.toString());
            System.err.println("Row2 = " + resultBinding2.toString());
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = resultBinding.get(string);
            Object object2 = resultBinding2.get(string);
            Value value = resultBinding.getValue(string);
            Value value2 = resultBinding2.getValue(string);
            if (DEBUG) {
                System.err.println("Compare: ?" + string);
                System.err.println("    " + value.asQuotedString());
                System.err.println("    " + value2.asQuotedString());
            }
            if (value.asQuotedString().startsWith("<anon:") && value2.asQuotedString().startsWith("<anon:")) {
                String string2 = value.asQuotedString();
                String string3 = value2.asQuotedString();
                if (hashMap.containsKey(string2)) {
                    if (!hashMap.get(string2).equals(string3)) {
                        return false;
                    }
                    if (!DEBUG) continue;
                    System.err.println("BNodes the same");
                    continue;
                }
                hashMap.put(string2, string3);
                continue;
            }
            if (value.asQuotedString().equals(value2.asQuotedString())) continue;
            return false;
        }
        return true;
    }

    public void list(PrintWriter printWriter) {
        QueryResultsMem queryResultsMem = new QueryResultsMem(this);
        QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(this);
        queryResultsFormatter.dump(printWriter, false);
        queryResultsMem.close();
    }
}

