/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.test.ARPTestInputStreamFactory;
import com.hp.hpl.jena.rdf.arp.test.LazyInputStream;
import com.hp.hpl.jena.rdf.arp.test.URI;
import com.hp.hpl.mesa.rdf.jena.common.PropertyImpl;
import com.hp.hpl.mesa.rdf.jena.common.ResourceImpl;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class WGTestSuite
extends TestSuite
implements ARPErrorNumbers {
    public static boolean checkMessages = false;
    private static boolean inDevelopment = false;
    static String testNS = "http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema/";
    static String jjcNS = "http://jcarroll.hpl.hp.com/testSchema#";
    private static String approved = "APPROVED";
    private static Property status;
    private static Property input;
    private static Property output;
    private static Property warning;
    private static Property errorCodes;
    private static Resource rdfxml;
    private static Resource ntriple;
    private URI testDir;
    private Act noop = new Act(){

        public void act(Resource resource) {
        }
    };
    ARPTestInputStreamFactory factory;
    private static Collection misc;
    private Map behaviours = new HashMap();
    private ZipFile zip;
    private Map parts;
    private static String[] errorLevelName;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$test$WGTestSuite;

    static Reader getReader(String string) throws IOException {
        return new InputStreamReader(WGTestSuite.getInputStream(string), "utf-8");
    }

    static InputStream getInputStream(String string) {
        ClassLoader classLoader = (class$com$hp$hpl$jena$rdf$arp$test$WGTestSuite == null ? (class$com$hp$hpl$jena$rdf$arp$test$WGTestSuite = WGTestSuite.class$("com.hp.hpl.jena.rdf.arp.test.WGTestSuite")) : class$com$hp$hpl$jena$rdf$arp$test$WGTestSuite).getClassLoader();
        if (classLoader == null) {
            throw new SecurityException("Cannot access class loader");
        }
        InputStream inputStream = classLoader.getResourceAsStream("com/hp/hpl/jena/rdf/arp/test/data/" + string);
        if (inputStream == null) {
            throw new IllegalArgumentException("Resource: " + string + " not found on class path.");
        }
        return inputStream;
    }

    Model loadRDF(InputStream inputStream, RDFErrorHandler rDFErrorHandler, String string) throws IOException, RDFException {
        ModelMem modelMem = new ModelMem();
        JenaReader jenaReader = new JenaReader();
        if (rDFErrorHandler != null) {
            jenaReader.setErrorHandler(rDFErrorHandler);
        }
        jenaReader.setProperty("error-mode", "strict");
        jenaReader.read((Model)modelMem, inputStream, string);
        inputStream.close();
        return modelMem;
    }

    static Model loadNT(InputStream inputStream) throws IOException, RDFException {
        ModelMem modelMem = new ModelMem();
        modelMem.read(new InputStreamReader(inputStream, "ASCII"), "", "N-TRIPLE");
        inputStream.close();
        return modelMem;
    }

    private Model loadRDF(ARPTestInputStreamFactory aRPTestInputStreamFactory, String string) {
        Model model;
        block5: {
            model = null;
            String string2 = aRPTestInputStreamFactory.getBase().toString();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            try {
                InputStream inputStream = aRPTestInputStreamFactory.open(string);
                if (inputStream instanceof LazyInputStream && !((LazyInputStream)inputStream).connect()) {
                    return null;
                }
                model = this.loadRDF(inputStream, null, string2 + string);
            }
            catch (RDFException rDFException) {
                throw new RuntimeException(rDFException.getMessage());
            }
            catch (Exception exception) {
                if (!string.equals("Manifest.rdf")) break block5;
                System.err.println("Failed to open Manifest.rdf");
                exception.printStackTrace();
            }
        }
        return model;
    }

    WGTestSuite(ARPTestInputStreamFactory aRPTestInputStreamFactory, String string) {
        super(string);
        this.behaviours.put(new ResourceImpl(testNS + "PositiveParserTest"), new Act(){

            public void act(Resource resource) throws RDFException {
                if (resource.hasProperty(warning)) {
                    WGTestSuite.this.addTest(resource, new WarningTest(resource));
                } else {
                    WGTestSuite.this.addTest(resource, new PositiveTest(resource));
                }
            }
        });
        this.behaviours.put(new ResourceImpl(testNS + "NegativeParserTest"), new Act(){

            public void act(Resource resource) throws RDFException {
                WGTestSuite.this.addTest(resource, new NegativeTest(resource));
            }
        });
        this.behaviours.put(new ResourceImpl(testNS + "RDF-XML-Document"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "NT-Document"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "PositiveEntailmentTest"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "NegativeEntailmentTest"), this.noop);
        this.behaviours.put(new ResourceImpl(testNS + "MiscellaneousTest"), new Act(){

            public void act(Resource resource) {
                String string = resource.getURI();
                if (!misc.contains(string)) {
                    System.err.println("MiscellaneousTest: " + string + " - ignored!");
                }
            }
        });
        this.parts = new HashMap();
        this.factory = aRPTestInputStreamFactory;
        this.testDir = aRPTestInputStreamFactory.getBase();
        try {
            Model model = this.loadRDF(aRPTestInputStreamFactory, "Manifest.rdf");
            Model model2 = this.loadRDF(aRPTestInputStreamFactory, "Manifest-extra.rdf");
            Model model3 = this.loadRDF(aRPTestInputStreamFactory, "Manifest-wrong.rdf");
            if (model2 != null) {
                model = model.add(model2);
            }
            if (model3 != null) {
                model = model.difference(model3);
            }
            StmtIterator stmtIterator = model.listStatements(new SelectorImpl(null, RDF.type, (RDFNode)null));
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.next();
                Act act = (Act)this.behaviours.get(statement.getObject());
                if (act == null) {
                    System.err.println("Unknown test class: " + ((Resource)statement.getObject()).getURI());
                    continue;
                }
                act.act(statement.getSubject());
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    static TestSuite suite(URI uRI, String string, String string2) {
        try {
            return new WGTestSuite(new ARPTestInputStreamFactory(uRI, string), string2);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException(runtimeException.getMessage());
        }
    }

    static TestSuite suite(URI uRI, URI uRI2, String string) {
        try {
            return new WGTestSuite(new ARPTestInputStreamFactory(uRI, uRI2), string);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException(runtimeException.getMessage());
        }
    }

    private void addTest(Resource resource, TestCase testCase) throws RDFException {
        String string = resource.hasProperty(status) ? resource.getProperty(status).getString() : "no status";
        TestSuite testSuite = (TestSuite)this.parts.get(string);
        if (testSuite == null) {
            testSuite = new TestSuite();
            testSuite.setName(string);
            this.parts.put(string, testSuite);
            this.addTest((junit.framework.Test)testSuite);
        }
        testSuite.addTest((junit.framework.Test)testCase);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            status = new PropertyImpl(testNS, "status");
            input = new PropertyImpl(testNS, "inputDocument");
            output = new PropertyImpl(testNS, "outputDocument");
            warning = new PropertyImpl(testNS, "warning");
            errorCodes = new PropertyImpl(jjcNS, "error");
        }
        catch (RDFException rDFException) {
            throw new RuntimeException(rDFException.getMessage());
        }
        rdfxml = new ResourceImpl(testNS, "RDF-XML-Document");
        ntriple = new ResourceImpl(testNS, "NT-Document");
        misc = Arrays.asList("http://www.w3.org/2000/10/rdf-tests/rdfcore/rdfms-uri-substructure/error001");
        errorLevelName = new String[]{"warning", "error", "fatal error"};
    }

    class NegativeTest
    extends Test {
        Model m1;
        Set expected;
        int expectedLevel = 1;
        private Set found = new HashSet();
        private int[] errorCnt = new int[]{0, 0, 0};

        NegativeTest(Resource resource) throws RDFException {
            super(resource);
            this.initExpected();
        }

        void save(Property property) throws RDFException {
            if (WGTestSuite.this.factory.savable()) {
                String string = this.testID.getProperty(property).getResource().getURI();
                int n = string.lastIndexOf(46);
                String string2 = string.substring(0, n) + ".ntx";
                try {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(WGTestSuite.this.factory.openOutput(string2), "utf-8");
                    this.m1.write(outputStreamWriter, "N-TRIPLE");
                    ((Writer)outputStreamWriter).close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage());
                }
            }
        }

        void initExpectedFromModel() throws RDFException {
            StmtIterator stmtIterator = this.testID.listProperties(errorCodes);
            if (stmtIterator.hasNext()) {
                this.expected = new HashSet();
                while (stmtIterator.hasNext()) {
                    String string = stmtIterator.next().getResource().getURI();
                    String string2 = string.substring(string.lastIndexOf(35) + 1);
                    this.expected.add(new Integer(JenaReader.errorCode(string2)));
                }
            }
        }

        void initExpected() throws RDFException {
            this.initExpectedFromModel();
        }

        protected void runTest() {
            try {
                this.m1 = this.read(input);
                if (this.expectedLevel == 1 && this.expected == null && this.errorCnt[2] == 0 && this.errorCnt[1] == 0) {
                    this.save(input);
                }
            }
            catch (RDFException rDFException) {
                if (rDFException.getErrorCode() != 10 || rDFException.toString().indexOf("SAXException") == -1) {
                    Assert.fail((String)rDFException.getMessage());
                }
            }
            catch (IOException iOException) {
                Assert.fail((String)iOException.getMessage());
            }
            if (this.expected != null && !this.expected.equals(this.found)) {
                HashSet hashSet = new HashSet();
                hashSet.addAll(this.found);
                hashSet.removeAll(this.expected);
                this.expected.removeAll(this.found);
                Iterator iterator = this.expected.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    String string = "Expected error  " + JenaReader.errorCodeName(n) + ", was not detected.";
                    if (this.errorCnt[2] == 0) {
                        Assert.fail((String)string);
                        continue;
                    }
                    if (n == 201 && this.getName().startsWith("rdf-nnn/67_") && "1234".indexOf(this.getName().charAt("rdf-nnn/67_".length())) != -1) continue;
                    System.err.println("Test: " + this.getName());
                    System.err.println(string);
                }
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    Assert.fail((String)("Detected error  " + JenaReader.errorCodeName((Integer)iterator.next()) + ", was not expected."));
                }
            }
            int n = 2;
            while (n >= 0) {
                if (n == this.expectedLevel) {
                    if (this.errorCnt[n] == 0 && (n != 1 || this.errorCnt[2] == 0)) {
                        Assert.fail((String)("No " + errorLevelName[this.expectedLevel] + " in input file of class " + this.getClass().getName()));
                    }
                } else if (this.expected == null && this.errorCnt[n] != 0) {
                    Assert.fail((String)("Inappropriate " + errorLevelName[n] + " in input file of class " + this.getClass().getName()));
                }
                --n;
            }
        }

        void onError(int n, int n2) {
            Integer n4 = new Integer(n2);
            this.found.add(n4);
            int n5 = n;
            this.errorCnt[n5] = this.errorCnt[n5] + 1;
            if (this.expected != null) {
                if (!this.expected.contains(n4)) {
                    super.onError(n, n2);
                }
            } else if (inDevelopment) {
                System.err.println("<rdf:Description rdf:about='" + this.testID.getURI() + "'>\n" + "<jjc:error rdf:resource='" + jjcNS + JenaReader.errorCodeName(n2) + "'/>\n</rdf:Description>");
            }
        }
    }

    class WarningTest
    extends PositiveTest {
        WarningTest(Resource resource) throws RDFException {
            super(resource);
            this.expectedLevel = 0;
        }

        void initExpected() throws RDFException {
            this.initExpectedFromModel();
        }
    }

    class PositiveTest
    extends NegativeTest {
        PositiveTest(Resource resource) throws RDFException {
            super(resource);
            this.expectedLevel = -1;
        }

        protected void runTest() {
            try {
                Model model = this.read(output);
                super.runTest();
                if (!this.m1.equals(model)) {
                    this.save(output);
                    Assert.assertEquals((Object)this.m1, (Object)model);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Assert.fail((String)exception.getMessage());
            }
        }

        void initExpected() throws RDFException {
            this.expected = new HashSet();
        }
    }

    class Test
    extends TestCase
    implements RDFErrorHandler {
        Resource testID;

        Test(Resource resource) {
            super(WGTestSuite.this.testDir.relativize(URI.create(resource.getURI())).toString());
            this.testID = resource;
        }

        Model read(Property property) throws RDFException, IOException {
            Resource resource = this.testID.getProperty(property).getResource();
            Resource resource2 = resource.getProperty(RDF.type).getResource();
            if (ntriple.equals(resource2)) {
                return WGTestSuite.loadNT(WGTestSuite.this.factory.open(resource.getURI()));
            }
            if (rdfxml.equals(resource2)) {
                String string = resource.getURI();
                return WGTestSuite.this.loadRDF(WGTestSuite.this.factory.open(string), this, string);
            }
            Assert.fail((String)("Unrecognized file type: " + resource2));
            return null;
        }

        public void warning(Exception exception) {
            this.error(0, exception);
        }

        public void error(Exception exception) {
            this.error(1, exception);
        }

        public void fatalError(Exception exception) {
            this.error(2, exception);
        }

        private void error(int n, Exception exception) {
            if (exception instanceof ParseException) {
                int n2 = ((ParseException)exception).getErrorNumber();
                if (n2 == 201) {
                    String string = exception.getMessage();
                    if (string.indexOf("Unusual") != -1 || string.indexOf("Internal") != -1) {
                        System.err.println(this.testID.getURI());
                        System.err.println(string);
                        Assert.fail((String)string);
                    }
                    if (checkMessages) {
                        System.err.println(this.testID.getURI());
                        System.err.println(string);
                    }
                }
                this.onError(n, n2);
            } else if (exception instanceof SAXParseException) {
                this.onError(n, 111);
            } else if (exception instanceof SAXException) {
                Assert.fail((String)("Not expecting a SAXException: " + exception.getMessage()));
            } else {
                Assert.fail((String)("Not expecting an Exception: " + exception.getMessage()));
            }
        }

        private void println(String string) {
            System.err.println(string);
        }

        void onError(int n, int n2) {
            String string = "Parser reports unexpected " + errorLevelName[n] + ": " + JenaReader.errorCodeName(n2);
            this.println(string);
            Assert.fail((String)string);
        }
    }

    static interface Act {
        public void act(Resource var1) throws RDFException;
    }
}

