/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.ParserSupport;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.URI;
import java.util.HashMap;
import java.util.Map;

class XMLContext {
    private final String base;
    private final String lang;
    private final URI uri;
    private final Map namespaces;
    private XMLContext document;

    XMLContext(String string, String string2) throws MalformedURIException {
        this(null, string, string2, ParserSupport.xmlNameSpace());
        this.document = this;
    }

    private XMLContext(XMLContext xMLContext, String string, String string2, Map map) throws MalformedURIException {
        this(xMLContext, new URI(string), string, string2, map);
    }

    private XMLContext(XMLContext xMLContext, URI uRI, String string, String string2, Map map) {
        this.base = string != null ? string : "http://error.com/no-xml-base-specified";
        this.lang = string2;
        this.uri = uRI;
        this.document = xMLContext;
        this.namespaces = map;
    }

    XMLContext withBase(String string) throws MalformedURIException {
        return new XMLContext(this.document, string, this.lang, this.namespaces);
    }

    XMLContext revertToDocument() {
        return this.document.withLang(this.lang);
    }

    XMLContext withLang(String string) {
        return new XMLContext(this.document, this.uri, this.base, string, this.namespaces);
    }

    String getLang() {
        return this.lang;
    }

    String getBase() {
        return this.base;
    }

    Map getNamespaces() {
        return this.namespaces;
    }

    XMLContext addNamespace(Token token, Token token2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.namespaces);
        hashMap.put(((StrToken)token).value, ((StrToken)token2).value);
        return new XMLContext(this.document, this.uri, this.base, this.lang, hashMap);
    }

    URI getURI() {
        return this.uri;
    }

    boolean isSameAsDocument() {
        return this == this.document || this.uri.equals(this.document.uri);
    }

    XMLContext getDocument() {
        return this.document;
    }
}

