/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPFilter;
import com.hp.hpl.jena.rdf.arp.ARPQname;
import com.hp.hpl.jena.rdf.arp.ARPResource;
import com.hp.hpl.jena.rdf.arp.ARPString;
import com.hp.hpl.jena.rdf.arp.BadURIReference;
import com.hp.hpl.jena.rdf.arp.CharacterModel;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.arp.URIReference;
import com.hp.hpl.jena.rdf.arp.XMLContext;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTag;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagCodes;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagSyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.xerces.utils.XMLCharacterProperties;

class ParserSupport
implements ARPErrorNumbers,
RDFParserConstants,
LanguageTagCodes {
    Map idsUsed = new HashMap();
    ARPFilter arp;

    ParserSupport(ARPFilter aRPFilter) {
        this.arp = aRPFilter;
    }

    void checkWhite(StrToken strToken) throws ParseException {
        String string = strToken.value;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2++)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    throw new ParseException(202, strToken.location, "Expected whitespace found: '" + string + "'.");
                }
            }
        }
    }

    void checkIdSymbol(XMLContext xMLContext, StrToken strToken, String string) throws ParseException {
        Location location = (Location)this.idsUsed.get(string);
        if (location != null) {
            this.arp.parseWarning(105, strToken.location, "Redefinition of ID: " + strToken.value);
            this.arp.parseWarning(105, location, "Previous definition of '" + strToken.value + "'.");
        } else {
            this.idsUsed.put(string, strToken.location);
            location = (Location)this.idsUsed.get(strToken.value);
            if (location != null) {
                this.arp.parseWarning(120, strToken.location, "The ID: " + strToken.value + " is reused in different xml:base contexts; this may be confusing.");
            }
            this.idsUsed.put(strToken.value, strToken.location);
        }
        if (!xMLContext.isSameAsDocument()) {
            this.arp.parseWarning(3, strToken.location, "The use of xml:base changes the meaning of ID '" + strToken.value + "'.");
        }
        this.checkXMLName(strToken, strToken.value);
    }

    private void checkXMLName(StrToken strToken, String string) throws ParseException {
        if (!XMLCharacterProperties.validNCName((String)string)) {
            this.arp.parseWarning(108, strToken.location, "Not an XML Name: '" + string + "'");
        }
    }

    String checkNodeID(Token token) throws ParseException {
        String string = ((StrToken)token).value;
        if (!XMLCharacterProperties.validNCName((String)string)) {
            this.arp.parseWarning(108, token.location, "Not an XML Name: '" + string + "'");
        }
        return string;
    }

    void checkString(Token token) throws ParseException {
        if (!CharacterModel.isNormalFormC(((StrToken)token).value)) {
            this.arp.parseWarning(207, token.location, "String not in Unicode Normal Form C: " + ((StrToken)token).value);
        }
        this.checkComposingChar(token);
    }

    void checkComposingChar(Token token) throws ParseException {
        if (CharacterModel.startsWithComposingCharacter(((StrToken)token).value)) {
            this.arp.parseWarning(121, token.location, "String is not legal in XML 1.1; starts with composing char: " + ((StrToken)token).value);
        }
    }

    void checkNormalFormC(Token token, ARPString aRPString) throws ParseException {
        if (!CharacterModel.isNormalFormC(aRPString.toString())) {
            this.arp.parseWarning(207, token.location, "String not in Unicode Normal Form C: " + aRPString.toString());
        }
    }

    void processingInstruction(Token token) throws ParseException {
        this.arp.parseWarning(119, token.location, "A processing instruction is in RDF content. No processing was done.");
    }

    void checkXMLLang(StrToken strToken) throws ParseException {
        String string = strToken.value;
        try {
            LanguageTag languageTag = new LanguageTag(string);
            int n = languageTag.tagType();
            if (n == 32768) {
                this.arp.parseWarning(116, strToken.location, languageTag.errorMessage());
            }
            if ((n & 0x200) == 512) {
                this.arp.parseWarning(116, strToken.location, "Unnecessary use of language tag \"und\" prohibited by RFC3066");
            }
            if ((n & 0x2000) == 8192) {
                this.arp.parseWarning(117, strToken.location, "Use of deprecated language tag \"" + string + "\".");
            }
            if ((n & 2) == 2) {
                this.arp.parseWarning(1, strToken.location, "Use of (IANA) private language tag \"" + string + "\".");
            } else if ((n & 0x800) == 2048) {
                this.arp.parseWarning(1, strToken.location, "Use of (ISO639-2) local use language tag \"" + string + "\".");
            } else if ((n & 0x80) == 128) {
                this.arp.parseWarning(1, strToken.location, "Use of additional private subtags on language \"" + string + "\".");
            }
        }
        catch (LanguageTagSyntaxException languageTagSyntaxException) {
            this.arp.parseWarning(115, strToken.location, languageTagSyntaxException.getMessage());
        }
    }

    private String truncateXMLBase(StrToken strToken) {
        return ParserSupport.truncateXMLBase(strToken.value);
    }

    static String truncateXMLBase(String string) {
        int n = string.indexOf(35);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    XMLContext changeXMLBase(XMLContext xMLContext, Token token) throws ParseException {
        this.arp.parseWarning(2, token.location, "Use of attribute xml:base is not envisaged in RDF Model&Syntax.");
        StrToken strToken = (StrToken)token;
        String string = this.truncateXMLBase(strToken);
        try {
            xMLContext = xMLContext.withBase(string);
        }
        catch (MalformedURIException malformedURIException) {
            this.arp.parseWarning(107, token.location, "Bad URI <" + ((StrToken)token).value + ">: " + malformedURIException.getMessage());
            xMLContext = xMLContext.revertToDocument();
        }
        return xMLContext;
    }

    URIReference makeURIReference(XMLContext xMLContext, Token token) throws ParseException {
        boolean bl;
        StrToken strToken = (StrToken)token;
        String string = strToken.value;
        if (!CharacterModel.isNormalFormC(string)) {
            this.arp.parseWarning(208, token.location, "<" + string + "> not in Unicode Normal Form C.");
        }
        if (bl = CharacterModel.startsWithComposingCharacter(string)) {
            this.arp.parseWarning(123, token.location, "Relative URI reference <" + string + "> starts with composing char.");
        }
        try {
            URIReference uRIReference = new URIReference(xMLContext, string);
            if (bl && !CharacterModel.isNormalFormC(uRIReference.getURI())) {
                this.arp.parseWarning(208, token.location, "<" + uRIReference.getURI() + "> not in Unicode Normal Form C.");
            }
            if (string.indexOf(58) == -1) {
                URIReference uRIReference2;
                if (!(xMLContext.getURI().isNormalFormC() || bl || CharacterModel.isNormalFormC(uRIReference.getURI()))) {
                    this.arp.parseWarning(208, token.location, "<" + uRIReference.getURI() + "> not in Unicode Normal Form C.");
                }
                if (!xMLContext.isSameAsDocument() && !(uRIReference2 = new URIReference(xMLContext.getDocument(), string)).equals(uRIReference)) {
                    this.arp.parseWarning(3, token.location, "Use of attribute xml:base changes interpretation of relative URI: \"" + string + "\".");
                }
            }
            return uRIReference;
        }
        catch (MalformedURIException malformedURIException) {
            this.arp.parseWarning(107, token.location, "Bad URI <" + strToken.value + ">: " + malformedURIException.getMessage());
            return new BadURIReference(string);
        }
    }

    void createTriple(ARPResource aRPResource, Token token, Object object, String string) throws ParseException {
        switch (token.kind) {
            case 15: 
            case 17: {
                aRPResource.setPredicateObject(((ARPQname)token).asURIReference(this.arp), object, string);
                break;
            }
            case 16: {
                aRPResource.setLiObject(object, string);
                break;
            }
            default: {
                throw new RuntimeException("Assertion failure in ParserSupport.createTriple");
            }
        }
    }

    private void useNameSpace(Map map, ARPQname aRPQname) {
        this.useNameSpace(map, aRPQname.prefix(), aRPQname.nameSpace);
    }

    private void useNameSpace(Map map, String string, String string2) {
        map.put(string, string2);
    }

    void startLitElement(StringBuffer stringBuffer, Token token, Map map) {
        ARPQname aRPQname = (ARPQname)token;
        stringBuffer.append("<" + aRPQname.qName);
        this.useNameSpace(map, aRPQname);
    }

    void checkNamespaceURI(Token token) throws ParseException {
        this.checkNamespaceURI(((StrToken)token).value, token);
    }

    private void checkNamespaceURI(String string, Token token) throws ParseException {
        if (string.length() != 0) {
            try {
                URI uRI = new URI(string);
            }
            catch (MalformedURIException malformedURIException) {
                this.arp.parseWarning(124, token.location, "Illegal URI in xmlns declaration: " + string);
            }
        }
    }

    private void checkNamespace(Map map, String string, String string2, Token token) throws ParseException {
        this.checkNamespaceURI(string2, token);
        if (!map.get(string).equals(string2)) {
            this.arp.parseWarning(200, token.location, "Namespaces have screwed up, please report to jjc@hpl.hp.com.");
        }
    }

    Map litAttributes(StringBuffer stringBuffer, SortedMap sortedMap, SortedMap sortedMap2, Map hashMap, Map map, Token token) throws ParseException {
        boolean bl = false;
        Iterator iterator = sortedMap2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            this.checkNamespace(map, string, string2, token);
            if (string2.equals(hashMap.get(string))) continue;
            if (!bl) {
                hashMap = new HashMap<String, String>(hashMap);
                bl = true;
            }
            hashMap.put(string, string2);
            String string3 = string.equals("") ? "xmlns" : "xmlns:" + string;
            stringBuffer.append(" " + string3 + "=\"" + ParserSupport.encodeAttributeText(string2) + "\"");
        }
        iterator = sortedMap.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)((Object)iterator.next()));
        }
        return hashMap;
    }

    Map litNamespace(Token token, Token token2, Map map, Map map2) {
        String string = ((StrToken)token2).value;
        String string2 = ((StrToken)token).value;
        this.useNameSpace(map2, string2, string);
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put(string2, string);
        return hashMap;
    }

    String litAttrName(Token token, Map map) {
        ARPQname aRPQname = (ARPQname)token;
        if (!aRPQname.prefix().equals("")) {
            this.useNameSpace(map, aRPQname);
        }
        return aRPQname.qName;
    }

    String litAttribute(Token token, Token token2) {
        ARPQname aRPQname = (ARPQname)token;
        return " " + aRPQname.qName + "=\"" + ParserSupport.encodeAttributeText(((StrToken)token2).value) + "\"";
    }

    void litComment(StringBuffer stringBuffer, Token token) {
        stringBuffer.append("<!--" + ((StrToken)token).value + "-->");
    }

    void litProcessingInstruction(StringBuffer stringBuffer, Token token) {
        stringBuffer.append("<?" + ((StrToken)token).value + "?>");
    }

    void endLitElement(StringBuffer stringBuffer, Token token) {
        String string = ((ARPQname)token).qName;
        stringBuffer.append("</" + string + ">");
    }

    void litText(StringBuffer stringBuffer, Token token) {
        stringBuffer.append(ParserSupport.encodeTextNode(((StrToken)token).value));
    }

    static Map xmlNameSpace() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("xml", ARPFilter.xmlns);
        hashMap.put("", "");
        return hashMap;
    }

    private static String encodeAttributeText(String string) {
        StringBuffer stringBuffer = null;
        int n = 0;
        while (n < string.length()) {
            String string2;
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '\t': {
                    string2 = "&#x9;";
                    break;
                }
                case '\n': {
                    string2 = "&#xA;";
                    break;
                }
                case '\r': {
                    string2 = "&#xD;";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            if (string2 != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, n));
                }
                stringBuffer.append(string2);
            } else if (stringBuffer != null) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private static String encodeTextNode(String string) {
        StringBuffer stringBuffer = null;
        int n = 0;
        while (n < string.length()) {
            String string2;
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\r': {
                    string2 = "&#xD;";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            if (string2 != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, n));
                }
                stringBuffer.append(string2);
            } else if (stringBuffer != null) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }
}

