/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class NTriple
implements ARPErrorNumbers {
    private static ARP arp;
    private static String xmlBase;
    private static boolean[] okURIChars;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$NTriple;

    public static void main(String[] stringArray) {
        NTriple.mainEh(stringArray, null);
    }

    public static void mainEh(String[] stringArray, ErrorHandler errorHandler) {
        boolean bl = false;
        SH sH = new SH();
        arp = new ARP();
        arp.setStatementHandler(sH);
        if (errorHandler != null) {
            arp.setErrorHandler(errorHandler);
        }
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n].startsWith("-")) {
                n += NTriple.processOpts(stringArray[n].substring(1), stringArray[n + 1]);
            } else {
                bl = true;
                NTriple.process(stringArray[n]);
            }
            ++n;
        }
        if (stringArray.length > 0) {
            if (stringArray[n].startsWith("-")) {
                if (bl || NTriple.processOpts(stringArray[n].substring(1), "100") == 1) {
                    NTriple.usage();
                }
            } else {
                bl = true;
                NTriple.process(stringArray[n]);
            }
        }
        if (!bl) {
            NTriple.process(System.in, "http://example.org/stdin", "standard input");
        }
    }

    static void usage() {
        System.err.println("java <class-path> " + (class$com$hp$hpl$jena$rdf$arp$NTriple == null ? (class$com$hp$hpl$jena$rdf$arp$NTriple = NTriple.class$("com.hp.hpl.jena.rdf.arp.NTriple")) : class$com$hp$hpl$jena$rdf$arp$NTriple).getName() + " ( [ -[xstfu]][ -b xmlBase -[eiw] NNN[,NNN...] ] [ file ] [ url ] )... ");
        System.err.println("    All options, files and URLs can be intemingled in any order.");
        System.err.println("    They are processed from left-to-right.");
        System.err.println("    file      Converts (embedded) RDF in XML file into N-triples");
        System.err.println("    url       Converts (embedded) RDF from URL into N-triples");
        System.err.println("    -b uri    Sets XML Base to the absolute URI.");
        System.err.println("    -r        Content is RDF (no embedding, rdf:RDF tag may be omitted).");
        System.err.println("    -t        No n-triple output, error checking only.");
        System.err.println("    -x        Lax mode - warnings are suppressed.");
        System.err.println("    -s        Strict mode - most warnings are errors.");
        System.err.println("    -u        Allow unqualified attributes (defaults to warning).");
        System.err.println("    -f        All errors are fatal - report first one only.");
        System.err.println("    -b url    Sets XML Base to the absolute url.");
        System.err.println("    -e NNN[,NNN...]");
        System.err.println("              Treats numbered warning conditions as errrors.");
        System.err.println("    -w NNN[,NNN...]");
        System.err.println("              Treats numbered error conditions as warnings.");
        System.err.println("    -i NNN[,NNN...]");
        System.err.println("              Ignores numbered error/warning conditions.");
        System.exit(1);
    }

    private static int processOpts(String string, String string2) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ("beiw".indexOf(c) != -1) {
                if (bl) {
                    NTriple.usage();
                }
                bl = true;
            }
            switch (c) {
                case 'x': {
                    arp.setLaxErrorMode();
                    break;
                }
                case 's': {
                    arp.setStrictErrorMode();
                    break;
                }
                case 't': {
                    arp.setStatementHandler(new NoSH());
                    break;
                }
                case 'r': {
                    arp.setEmbedding(false);
                    break;
                }
                case 'b': {
                    xmlBase = string2;
                    break;
                }
                case 'e': {
                    NTriple.setErrorMode(string2, 2);
                    break;
                }
                case 'i': {
                    NTriple.setErrorMode(string2, 0);
                    break;
                }
                case 'w': {
                    NTriple.setErrorMode(string2, 1);
                    break;
                }
                case 'f': {
                    int n2 = 0;
                    while (n2 < 400) {
                        if (arp.setErrorMode(n2, -1) == 2) {
                            arp.setErrorMode(n2, 3);
                        }
                        ++n2;
                    }
                    break;
                }
                case 'u': {
                    arp.setErrorMode(102, 0);
                    arp.setErrorMode(101, 0);
                    break;
                }
                default: {
                    NTriple.usage();
                }
            }
            ++n;
        }
        return bl ? 1 : 0;
    }

    private static void setErrorMode(String string, int n) {
        int[] nArray = new int[3];
        int n2 = 0;
        string = string + ",";
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            block0 : switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (n2 == 3) {
                        NTriple.usage();
                    }
                    nArray[n2++] = c - 48;
                    break;
                }
                case ' ': 
                case ',': 
                case ';': {
                    if (n4 == 0) {
                        NTriple.usage();
                    }
                    switch (n2) {
                        case 0: {
                            break block0;
                        }
                        case 3: {
                            arp.setErrorMode(nArray[0] * 100 + nArray[1] * 10 + nArray[2], n);
                            n2 = 0;
                            break block0;
                        }
                    }
                    NTriple.usage();
                    break;
                }
                default: {
                    NTriple.usage();
                }
            }
            ++n4;
        }
    }

    private static void process(String string) {
        URL uRL;
        InputStream inputStream;
        try {
            File file = new File(string);
            inputStream = new FileInputStream(file);
            uRL = file.toURL();
        }
        catch (Exception exception) {
            try {
                uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            catch (Exception exception2) {
                System.err.println("ARP: Failed to open: " + string);
                System.err.println("    " + ParseException.formatMessage(exception));
                System.err.println("    " + ParseException.formatMessage(exception2));
                return;
            }
        }
        NTriple.process(inputStream, uRL.toExternalForm(), string);
    }

    private static void process(InputStream inputStream, String string, String string2) {
        String string3 = xmlBase == null ? string : xmlBase;
        try {
            arp.load(inputStream, string3);
        }
        catch (IOException iOException) {
            System.err.println("Error: " + string2 + ": " + ParseException.formatMessage(iOException));
        }
        catch (SAXException sAXException) {
            System.err.println("Error: " + string2 + ": " + ParseException.formatMessage(sAXException));
        }
    }

    private static void resource(AResource aResource) {
        if (aResource.isAnonymous()) {
            System.out.print("_:j" + aResource.getAnonymousID() + " ");
        } else {
            System.out.print("<");
            NTriple.escapeURI(aResource.getURI());
            System.out.print("> ");
        }
    }

    private static void escape(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '\\': {
                    System.out.print("\\\\");
                    break;
                }
                case '\"': {
                    System.out.print("\\\"");
                    break;
                }
                case '\n': {
                    System.out.print("\\n");
                    break;
                }
                case '\r': {
                    System.out.print("\\r");
                    break;
                }
                case '\t': {
                    System.out.print("\\t");
                    break;
                }
                default: {
                    if (cArray[n] >= ' ' && cArray[n] <= '~') {
                        System.out.print(cArray[n]);
                        break;
                    }
                    System.out.print("\\u");
                    String string2 = Integer.toHexString(cArray[n]).toUpperCase();
                    int n2 = 4 - string2.length();
                    while (n2 > 0) {
                        System.out.print("0");
                        --n2;
                    }
                    System.out.print(string2);
                }
            }
            ++n;
        }
    }

    private static void escapeURI(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] < okURIChars.length && okURIChars[cArray[n]]) {
                System.out.print(cArray[n]);
            } else {
                System.out.print("\\u");
                String string2 = Integer.toHexString(cArray[n]).toUpperCase();
                int n2 = 4 - string2.length();
                while (n2 > 0) {
                    System.out.print("0");
                    --n2;
                }
                System.out.print(string2);
            }
            ++n;
        }
    }

    private static void literal(ALiteral aLiteral) {
        if (aLiteral.isWellFormedXML()) {
            System.out.print("xml");
        }
        System.out.print("\"");
        NTriple.escape(aLiteral.toString());
        System.out.print("\"");
        String string = aLiteral.getLang();
        if (string != null && !string.equals("")) {
            System.out.print("-" + string);
        }
        System.out.print(" ");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        xmlBase = null;
        okURIChars = new boolean[128];
        int n = 32;
        while (n < 127) {
            NTriple.okURIChars[n] = true;
            ++n;
        }
        NTriple.okURIChars[60] = false;
        NTriple.okURIChars[62] = false;
        NTriple.okURIChars[92] = false;
    }

    private static class SH
    implements StatementHandler {
        private SH() {
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            NTriple.resource(aResource);
            NTriple.resource(aResource2);
            NTriple.resource(aResource3);
            System.out.println(".");
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            String string = aLiteral.getLang();
            String string2 = aLiteral.getParseType();
            if (string2 != null) {
                System.out.print("# ");
                if (string2 != null) {
                    System.out.print("'" + string2 + "'");
                }
                System.out.println();
            }
            NTriple.resource(aResource);
            NTriple.resource(aResource2);
            NTriple.literal(aLiteral);
            System.out.println(".");
        }
    }

    private static class NoSH
    implements StatementHandler {
        private NoSH() {
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
        }
    }
}

