/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.n3.NullN3EventHandler;
import java.io.PrintWriter;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class N3InternalTests
extends TestSuite {
    public static final String QUOTE3 = "\"\"\"";
    public static boolean VERBOSE = false;
    PrintWriter pw = null;

    N3InternalTests() {
        super("N3 Parser Syntactic tests");
        if (VERBOSE) {
            this.pw = new PrintWriter(System.out);
        }
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d ."));
        this.addTest((junit.framework.Test)new Test("a: _: 1:."));
        this.addTest((junit.framework.Test)new Test("_:a :1 :_1."));
        this.addTest((junit.framework.Test)new Test("rdf: rdf:type :_."));
        this.addTest((junit.framework.Test)new Test("@prefix start: <somewhere>."));
        this.addTest((junit.framework.Test)new Test("<http://here/subj> <http://here/prep> <http://here/obj>."));
        this.addTest((junit.framework.Test)new Test("a:subj\ta:prop\ta:d.\t"));
        this.addTest((junit.framework.Test)new Test("       a:subj\ta:prop\ta:d.     "));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d.  "));
        this.addTest((junit.framework.Test)new Test(""));
        this.addTest((junit.framework.Test)new Test(" #Comment"));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d.  # Comment"));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d.# Comment"));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'string1'."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop \"string2\"."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '''string3'''."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop \"\"\"string3\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'string1'^^x:dt."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'string1'^^<uriref>."));
        this.addTest((junit.framework.Test)new Test("a:subj 'prop'^^<uriref> 'string'."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'string1'^^'stringDT'."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop \"\\'string2\\'\"."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop \"\\\"string2\\\"\"."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '\\'string1\\''."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '\\\"string1\\\"'."));
        this.addTest((junit.framework.Test)new Test("a:q21 a:prop \"\"\"start\"finish\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:q22 a:prop \"\"\"start\"\"finish\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:q2e3 a:prop \"\"\"start\\\"\\\"\\\"finish\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:q13 a:prop \"\"\"start'''finish\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:q11 a:prop '''start'finish'''."));
        this.addTest((junit.framework.Test)new Test("a:q12 a:prop '''start''finish'''."));
        this.addTest((junit.framework.Test)new Test("a:q12 a:prop '''start\\'\\'\\'finish'''."));
        this.addTest((junit.framework.Test)new Test("a:q23 a:prop '''start\"\"\"finish'''."));
        this.addTest((junit.framework.Test)new Test("this a:prop x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  a   x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  =   x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  =>  x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  <=  x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  >- x:y -> 'value' ."));
        this.addTest((junit.framework.Test)new Test("a:subj  >- x:y -> 'value1', 'value2' ."));
        this.addTest((junit.framework.Test)new Test("a:subj <a>  x:y ."));
        this.addTest((junit.framework.Test)new Test("<this>  a   x:y ."));
        this.addTest((junit.framework.Test)new Test("@prefix has: <uri>."));
        this.addTest((junit.framework.Test)new Test("has:s a:a :of."));
        this.addTest((junit.framework.Test)new Test("<>   has a:prop  x:y ."));
        this.addTest((junit.framework.Test)new Test("x:v  is a:prop of  <>."));
        this.addTest((junit.framework.Test)new Test("x:v  is a:prop of  a:s1, a:s2."));
        this.addTest((junit.framework.Test)new Test("<>   a:prop  x:y ."));
        this.addTest((junit.framework.Test)new Test("<#>  a:prop  x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d, a:e."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d, '123'."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '123', a:e."));
        this.addTest((junit.framework.Test)new Test("a:subj a:p1 a:v1 ;  a:p2 a:v2 ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:p1 a:v1, a:v2 ;  a:p2 a:v2 ; a:p3 'v4' ,'v5' ."));
        this.addTest((junit.framework.Test)new Test("[a:prop a:val]."));
        this.addTest((junit.framework.Test)new Test("[] a:prop a:val."));
        this.addTest((junit.framework.Test)new Test("[] a:prop []."));
        this.addTest((junit.framework.Test)new Test("{ this a \"string2\" . } => { this a 'string1' .} ."));
        this.addTest((junit.framework.Test)new Test("?who ?knows ?what ."));
        this.addTest((junit.framework.Test)new Test("{?who ?knows ?what} => {'somesort' 'of' 'logic'}."));
        this.addTest((junit.framework.Test)new Test("{ this a \"string2\". } => { this a 'string1'} ."));
        this.addTest((junit.framework.Test)new Test("{ @prefix : <a> } => { this a 'string1'} ."));
        this.addTest((junit.framework.Test)new Test("{ @prefix : <a> . a:x <b> 'c'} => { this a 'string1'} ."));
        this.addTest((junit.framework.Test)new Test("() a daml:list."));
        this.addTest((junit.framework.Test)new Test("<here> <list> ()."));
        this.addTest((junit.framework.Test)new Test(" ( a:i1 a:i2 a:i3 ) a daml:list."));
        this.addTest((junit.framework.Test)new Test(":x!:y <prop> []."));
        this.addTest((junit.framework.Test)new Test(":x!:y!:z <prop> []."));
        this.addTest((junit.framework.Test)new Test(":x^:y <prop> []."));
        this.addTest((junit.framework.Test)new Test(":x^:y^:z <prop> []."));
        this.addTest((junit.framework.Test)new Test("[] <prop> :x!:y^:z."));
        this.addTest((junit.framework.Test)new Test("[] :x^:y!:z []."));
        this.addTest((junit.framework.Test)new Test("_:anon :- [a:p a:v] ."));
        this.addTest((junit.framework.Test)new Test("<uri> :- [a:p [ a:p a:v] ] ."));
        this.addTest((junit.framework.Test)new Test("_:anon :- (\"1\") ."));
        this.addTest((junit.framework.Test)new Test("_:anon :- { ?a ?b ?c } ."));
    }

    class Test
    extends TestCase {
        N3ParserEventHandler handler;
        String testString;

        Test(String string) {
            super("N3 Internal test: " + (string != null ? string : "<skipped test>"));
            this.testString = string;
            this.handler = VERBOSE ? new N3EventPrinter(N3InternalTests.this.pw) : new NullN3EventHandler();
        }

        protected void runTest() throws Throwable {
            if (this.testString == null) {
                if (N3InternalTests.this.pw != null) {
                    N3InternalTests.this.pw.println("Skipped test");
                }
                return;
            }
            if (N3InternalTests.this.pw != null) {
                N3InternalTests.this.pw.println("Input: " + this.testString);
            }
            N3Parser n3Parser = new N3Parser(new StringReader(this.testString), this.handler);
            n3Parser.parse();
            if (N3InternalTests.this.pw != null) {
                N3InternalTests.this.pw.println();
                N3InternalTests.this.pw.flush();
            }
        }
    }
}

