/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import antlr.collections.AST;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class N3EventPrinter
implements N3ParserEventHandler {
    public boolean printStartFinish = false;
    static final String NL = System.getProperty("line.separator", "\n");
    Writer out = null;

    public N3EventPrinter(OutputStream outputStream) {
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public N3EventPrinter(Writer writer) {
        this.out = writer;
    }

    public void error(Exception exception, String string) {
        N3EventPrinter.println(this.out, "Error: " + string);
        N3EventPrinter.flush(this.out);
    }

    public void startDocument() {
        if (this.printStartFinish) {
            N3EventPrinter.println(this.out, "Document start");
            N3EventPrinter.flush(this.out);
        }
    }

    public void endDocument() {
        if (this.printStartFinish) {
            N3EventPrinter.println(this.out, "Document end");
            N3EventPrinter.flush(this.out);
        }
    }

    public void startFormula(int n, String string) {
        if (this.printStartFinish) {
            N3EventPrinter.print(this.out, "Formula start: " + string);
            N3EventPrinter.flush(this.out);
        }
    }

    public void endFormula(int n, String string) {
        if (this.printStartFinish) {
            N3EventPrinter.print(this.out, "Formula finish: " + string);
            N3EventPrinter.flush(this.out);
        }
    }

    public void directive(int n, AST aST, AST[] aSTArray, String string) {
        if (string != null) {
            N3EventPrinter.print(this.out, string + " ");
        }
        N3EventPrinter.print(this.out, aST.getText());
        int n2 = 0;
        while (n2 < aSTArray.length) {
            N3EventPrinter.print(this.out, " ");
            N3EventPrinter.printSlot(this.out, aSTArray[n2]);
            ++n2;
        }
        N3EventPrinter.println(this.out);
        N3EventPrinter.flush(this.out);
    }

    public void quad(int n, AST aST, AST aST2, AST aST3, String string) {
        if (string != null) {
            N3EventPrinter.print(this.out, string + " ");
        }
        N3EventPrinter.print(this.out, "[ ");
        N3EventPrinter.printSlot(this.out, aST);
        N3EventPrinter.print(this.out, " , ");
        N3EventPrinter.printSlot(this.out, aST2);
        N3EventPrinter.print(this.out, " , ");
        N3EventPrinter.printSlot(this.out, aST3);
        N3EventPrinter.println(this.out, " ]");
        N3EventPrinter.flush(this.out);
    }

    public static String formatSlot(AST aST) {
        try {
            StringWriter stringWriter = new StringWriter();
            N3EventPrinter.printSlot(stringWriter, aST);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void printSlot(Writer writer, AST aST) {
        try {
            if (aST == null) {
                writer.write("<null>");
                return;
            }
            int n = aST.getType();
            String string = aST.toString();
            if (n == 15) {
                writer.write(34);
                N3EventPrinter.printString(writer, string);
                writer.write(34);
                AST aST2 = aST.getFirstChild();
                if (aST2 != null) {
                    writer.write("^^");
                    N3EventPrinter.printSlot(writer, aST2);
                }
                return;
            }
            if (string.equals("")) {
                string = "<empty string>";
            }
            writer.write(string);
            writer.write(40);
            writer.write(N3Parser.getTokenNames()[n]);
            writer.write(41);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printString(Writer writer, String string) {
        try {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\\' || c == '\"') {
                    writer.write(92);
                    writer.write(c);
                } else if (c == '\n') {
                    writer.write("\\n");
                } else if (c == '\r') {
                    writer.write("\\r");
                } else if (c == '\t') {
                    writer.write("\\t");
                } else if (c >= ' ' && c < '\u007f') {
                    writer.write(c);
                } else {
                    String string2 = Integer.toHexString(c).toUpperCase();
                    int n2 = 4 - string2.length();
                    writer.write("\\u");
                    while (n2 > 0) {
                        writer.write("0");
                        --n2;
                    }
                    writer.write(string2);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void print(Writer writer, String string) {
        try {
            writer.write(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void println(Writer writer, String string) {
        try {
            writer.write(string);
            writer.write(NL);
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void println(Writer writer) {
        try {
            writer.write(NL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void flush(Writer writer) {
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

