/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.test;

import com.hp.hpl.jena.daml.DAMLClass;
import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.DAMLDataInstance;
import com.hp.hpl.jena.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.daml.DAMLInstance;
import com.hp.hpl.jena.daml.DAMLList;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.DAMLObjectProperty;
import com.hp.hpl.jena.daml.DAMLProperty;
import com.hp.hpl.jena.daml.DAMLRestriction;
import com.hp.hpl.jena.daml.PropertyAccessor;
import com.hp.hpl.jena.daml.common.DAMLDatatypeImpl;
import com.hp.hpl.jena.daml.common.DAMLModelImpl;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.StatementSubjectIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class DAMLTest
extends TestCase {
    private static boolean m_firstRun = true;
    static /* synthetic */ Class class$java$lang$String;

    public DAMLTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new DAMLTest("testLoadOntology"));
        testSuite.addTest((Test)new DAMLTest("testRDFType"));
        testSuite.addTest((Test)new DAMLTest("testClass"));
        testSuite.addTest((Test)new DAMLTest("testEquivalence"));
        testSuite.addTest((Test)new DAMLTest("testProperty"));
        testSuite.addTest((Test)new DAMLTest("testList"));
        testSuite.addTest((Test)new DAMLTest("testDatatype"));
        testSuite.addTest((Test)new DAMLTest("testInstance"));
        testSuite.addTest((Test)new DAMLTest("testRemove"));
        testSuite.addTest((Test)new DAMLTest("testCreate"));
        testSuite.addTest((Test)new DAMLTest("testRestriction"));
        testSuite.addTest((Test)new DAMLTest("testModelAdd"));
        testSuite.addTest((Test)new DAMLTest("testSyntaxError"));
        testSuite.addTest((Test)new DAMLTest("testDatatypeProperty"));
        testSuite.addTest((Test)new DAMLTest("testPropertyEq"));
        testSuite.addTest((Test)new DAMLTest("testObjectProperty"));
        testSuite.addTest((Test)new DAMLTest("testDatatypeEq1"));
        testSuite.addTest((Test)new DAMLTest("testDatatypeEq2"));
        testSuite.addTest((Test)new DAMLTest("testDatatypeRange"));
        return testSuite;
    }

    public void setUp() {
        try {
            Log.getInstance().setDefaultFileHandler(!m_firstRun);
        }
        catch (IOException iOException) {
            System.err.println("Could not open log file " + iOException);
        }
        Log.finest("Test suite setting up");
        m_firstRun = false;
    }

    public void tearDown() {
        Log.debug("Test suite tearing down");
    }

    public void testLoadOntology() throws RDFException {
        Log.debug("Starting loadOntology tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        Log.debug("Test: loading (2000/12, import, standard block)");
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2000_12/daml+oil-ex.daml", "http://www.daml.org/2000/12/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store", (int)36, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store", (int)44, (int)this.countProperties(dAMLModelImpl));
        Log.debug("Test: loading (2000/12, no import)");
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2000_12/daml+oil-ex.daml", "http://www.daml.org/2000/12/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store (2000/12, no import)", (int)20, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store (2000/12, no import)", (int)8, (int)this.countProperties(dAMLModelImpl));
        Log.debug("Test: loading (2000/12, import, added to block list)");
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().addImportBlock("file:modules/rdf/regression/testDAML/daml_oil_2000_12/daml-local-ex.daml");
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2000_12/daml+oil-ex.daml", "http://www.daml.org/2000/12/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store (2000/12, import block)", (int)34, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store (2000/12, import block)", (int)44, (int)this.countProperties(dAMLModelImpl));
        Log.debug("Test: loading (2001/03, import, standard block)");
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store (2001/03, import)", (int)43, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store (2001/03, import) ", (int)50, (int)this.countProperties(dAMLModelImpl));
        Log.debug("Test: loading (2001/03, no import)");
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store (2001/03, no import)", (int)28, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store (2001/03, no import)", (int)12, (int)this.countProperties(dAMLModelImpl));
        if (System.getProperty("proxySet") != null && System.getProperty("proxySet").equals("true")) {
            Log.debug("Test: loading (2001/03, http)");
            dAMLModelImpl = new DAMLModelImpl();
            dAMLModelImpl.read("http://www.daml.org/2001/03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
            Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
            Assert.assertEquals((String)"Count of number of classes in daml store (2001/03, http)", (int)28, (int)this.countClasses(dAMLModelImpl));
            Assert.assertEquals((String)"Count of number of properties in daml store (2001/03, http)", (int)12, (int)this.countProperties(dAMLModelImpl));
        } else {
            Log.finest("HTTP proxy is not set, so skipping HTTP read test 1");
        }
        if (System.getProperty("proxySet") != null) {
            Log.debug("Test: loading (2001/03, http, block removed)");
            dAMLModelImpl = new DAMLModelImpl();
            dAMLModelImpl.getLoader().removeImportBlock("http://www.daml.org/2001/03/daml+oil");
            dAMLModelImpl.read("http://www.daml.org/2001/03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
            Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
            Assert.assertEquals((String)"Count of number of classes in daml store (2001/03, http, block removed)", (int)43, (int)this.countClasses(dAMLModelImpl));
            Assert.assertEquals((String)"Count of number of properties in daml store (2001/03, http, block removed)", (int)50, (int)this.countProperties(dAMLModelImpl));
        } else {
            Log.finest("HTTP proxy is not set, so skipping HTTP read test 2");
        }
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/test-instance-load.daml");
        Assert.assertTrue((String)"Load status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Resource resource = dAMLModelImpl.getResource("http://dickinson-i-4/daml/tests/test-instance-load.daml#pugh");
        Assert.assertNotNull((String)"Resource for officer Pugh should not be null", (Object)resource);
        Assert.assertTrue((String)"Resource for Pugh should be recognised as a DAML instance", (boolean)(resource instanceof DAMLInstance));
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModelImpl.getProperty("http://www.daml.org/2001/03/daml+oil-ex#shoesize");
        Assert.assertNotNull((String)"Failed to find shoesize property in example ontology", (Object)dAMLProperty);
        Assert.assertEquals((String)"shoesize should be a unique property", (boolean)true, (boolean)dAMLProperty.isUnique());
        Assert.assertEquals((String)"shoesize should be a datatype property", (boolean)true, (boolean)(dAMLProperty instanceof DAMLDatatypeProperty));
    }

    public void testRDFType() throws RDFException {
        String string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        Log.debug("Starting rdf:type tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLInstance dAMLInstance = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "fido");
        Assert.assertNotNull((String)"fido instance should not be null", (Object)dAMLInstance);
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Dog");
        Assert.assertNotNull((String)"Dog class should not be null", (Object)dAMLClass);
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Vertebrate");
        Assert.assertNotNull((String)"Vertebrate class should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Pet");
        Assert.assertNotNull((String)"Pet class should not be null", (Object)dAMLClass3);
        Assert.assertTrue((String)"fido should be member of class Dog", (boolean)dAMLInstance.hasRDFType(dAMLClass));
        Assert.assertTrue((String)"fido should be member of class Vertebrate", (boolean)dAMLInstance.hasRDFType(dAMLClass2));
        Assert.assertTrue((String)"fido should be member of class Vertebrate (by URL)", (boolean)dAMLInstance.hasRDFType(string + "Vertebrate"));
        Assert.assertTrue((String)"fido should be member of class Pet", (boolean)dAMLInstance.hasRDFType(dAMLClass3));
        Assert.assertTrue((String)"fido should not be a class", (!dAMLInstance.hasRDFType(DAML_OIL.Class) ? 1 : 0) != 0);
        Assert.assertTrue((String)"fido should be a companion", (boolean)dAMLInstance.hasRDFType(string + "Companion"));
        Assert.assertTrue((String)"fido should be a thing", (boolean)dAMLInstance.hasRDFType(DAML_OIL.Thing));
        DAMLClass dAMLClass4 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "A");
        Assert.assertNotNull((String)"Class A should not be null", (Object)dAMLClass4);
        DAMLClass dAMLClass5 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "B");
        Assert.assertNotNull((String)"Class B should not be null", (Object)dAMLClass5);
        DAMLInstance dAMLInstance2 = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "ab");
        Assert.assertNotNull((String)"Instance ab should not be null", (Object)dAMLInstance2);
        Assert.assertTrue((String)"ab should be an A", (boolean)dAMLInstance2.hasRDFType(dAMLClass4));
        Assert.assertTrue((String)"ab should be a B", (boolean)dAMLInstance2.hasRDFType(dAMLClass5));
        Assert.assertEquals((String)"Number of classes fido belongs to (closure) should be 7", (int)7, (int)this.countIteration(dAMLInstance.getRDFTypes(true), true, "fido member of class "));
        Assert.assertEquals((String)"Number of classes fido belongs to (non-closure) should be 2", (int)2, (int)this.countIteration(dAMLInstance.getRDFTypes(false), true, "fido member of non-closed class "));
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "queen-of");
        Assert.assertNotNull((String)"queen-of property should be defined", (Object)dAMLProperty);
        Assert.assertTrue((String)"an UnabmbiguousProperty should be an ObjectProperty", (boolean)dAMLProperty.hasRDFType(DAML_OIL.UnambiguousProperty));
        Assert.assertTrue((String)"an UnabmbiguousProperty should be an ObjectProperty", (boolean)dAMLProperty.hasRDFType(DAML_OIL.ObjectProperty));
        Assert.assertTrue((String)"an UnabmbiguousProperty should be an rdf:Property", (boolean)dAMLProperty.hasRDFType(RDF.Property));
    }

    public void testClass() throws RDFException {
        Log.debug("Starting DAML class tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Person");
        Assert.assertNotNull((String)"Person class should not be null", (Object)dAMLClass);
        Assert.assertTrue((String)"Person should be a named class", (boolean)dAMLClass.isNamedClass());
        int n = this.countIteration(dAMLClass.prop_subClassOf().getAll(false), true, "super-class of Person (prop_subClassOf) ");
        int n2 = this.countIteration(dAMLClass.getSuperClasses(), true, "super-class of Person (getSuperClasses) ");
        Assert.assertEquals((String)"person should have 7 super-classes (by prop_subClassOf)", (int)7, (int)n);
        Assert.assertEquals((String)"person should have 9 super-classes (by getSuperClasses)", (int)9, (int)n2);
        Assert.assertEquals((String)"person should have 2 sub-classes", (int)2, (int)this.countIteration(dAMLClass.getSubClasses(), true, "Person super-class of: "));
        Assert.assertTrue((String)"Person should be a disjoint union", (boolean)dAMLClass.isDisjointUnion());
        DAMLList dAMLList = (DAMLList)dAMLClass.prop_disjointUnionOf().get();
        Assert.assertNotNull((String)"Value of disjoint union should not be null", (Object)dAMLList);
        Assert.assertEquals((String)"Person should be a disjoint union of size 2", (int)2, (int)dAMLList.getCount());
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Female");
        Assert.assertNotNull((String)"Class Female should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Male");
        Assert.assertNotNull((String)"Class Male should not be null", (Object)dAMLClass3);
        Assert.assertTrue((String)"Female should be disjoint with male", (boolean)dAMLClass2.prop_disjointWith().hasValue(dAMLClass3));
        DAMLClass dAMLClass4 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "HumanBeing");
        Assert.assertNotNull((String)"Class humanBeing should not be null", (Object)dAMLClass4);
        Assert.assertTrue((String)"Person should be same class as HumanBeing", (boolean)dAMLClass4.prop_sameClassAs().hasValue(dAMLClass));
        DAMLClass dAMLClass5 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "TallMan");
        Assert.assertNotNull((String)"Class TallMan should not be null", (Object)dAMLClass5);
        DAMLList dAMLList2 = (DAMLList)dAMLClass5.prop_intersectionOf().get();
        Assert.assertNotNull((String)"Value of intersection should not be null", (Object)dAMLList2);
        Assert.assertEquals((String)"Tall man should be an intersection of size 2", (int)2, (int)dAMLList2.getCount());
        DAMLClass dAMLClass6 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Car");
        Assert.assertNotNull((String)"Class Car should not be null", (Object)dAMLClass6);
        DAMLClass dAMLClass7 = (DAMLClass)dAMLClass6.getSuperClasses().next();
        Assert.assertNotNull((String)"Car should have a super-class", (Object)dAMLClass7);
        Assert.assertTrue((String)"Car super-class should be a complement", (boolean)dAMLClass7.isComplement());
        Assert.assertTrue((String)"Car super-class should be a complement of Person", (boolean)dAMLClass7.prop_complementOf().hasValue(dAMLClass));
        DAMLClass dAMLClass8 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Height");
        Assert.assertNotNull((String)"Class Height should not be null", (Object)dAMLClass8);
        Assert.assertTrue((String)"Height should be an enumeration", (boolean)dAMLClass8.isEnumeration());
        Assert.assertEquals((String)"Height should be an enumeration of 3 elements", (int)3, (int)((DAMLList)dAMLClass8.prop_oneOf().get()).getCount());
        DAMLModelImpl dAMLModelImpl2 = new DAMLModelImpl();
        dAMLModelImpl2.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl2.read("file:modules/rdf/regression/testDAML/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        String string2 = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass dAMLClass9 = (DAMLClass)dAMLModelImpl2.getDAMLValue(string2 + "SubClassBug0");
        DAMLClass dAMLClass10 = (DAMLClass)dAMLModelImpl2.getDAMLValue(string2 + "SubClassBug1");
        Assert.assertNotNull((String)"Class SubClassBug0 should not be null", (Object)dAMLClass9);
        Assert.assertNotNull((String)"Class SubClassBug1 should not be null", (Object)dAMLClass10);
        Assert.assertTrue((String)"SubClassBug1 should have SubClassBug0 as a super-class", (boolean)dAMLClass10.hasSuperClass(dAMLClass9));
        Assert.assertTrue((String)"SubClassBug0 should have SubClassBug1 as a sub-class", (boolean)dAMLClass9.hasSubClass(dAMLClass10));
        DAMLClass dAMLClass11 = (DAMLClass)dAMLModelImpl2.getDAMLValue(string2 + "DefProp0");
        DAMLClass dAMLClass12 = (DAMLClass)dAMLModelImpl2.getDAMLValue(string2 + "DefProp1");
        DAMLClass dAMLClass13 = (DAMLClass)dAMLModelImpl2.getDAMLValue(string2 + "DefProp2");
        Assert.assertNotNull((String)"Class DefProp0 should not be null", (Object)dAMLClass11);
        Assert.assertNotNull((String)"Class DefProp1 should not be null", (Object)dAMLClass12);
        Assert.assertNotNull((String)"Class DefProp2 should not be null", (Object)dAMLClass13);
        int n4 = this.countIteration(dAMLClass11.getDefinedProperties(), true, "Defined property of DefProp0, closed");
        int n5 = this.countIteration(dAMLClass11.getDefinedProperties(false), true, "Defined property of DefProp0, not closed");
        int n6 = this.countIteration(dAMLClass12.getDefinedProperties(), true, "Defined property of DefProp1, closed");
        int n7 = this.countIteration(dAMLClass12.getDefinedProperties(false), true, "Defined property of DefProp1, not closed");
        int n8 = this.countIteration(dAMLClass13.getDefinedProperties(), true, "Defined property of DefProp2, closed");
        int n9 = this.countIteration(dAMLClass13.getDefinedProperties(false), true, "Defined property of DefProp2, not closed");
        Assert.assertEquals((String)"Defined properties of DefProp0 should number 1", (int)1, (int)n4);
        Assert.assertEquals((String)"Defined properties of DefProp0 (non-closed) should number 1", (int)1, (int)n5);
        Assert.assertEquals((String)"Defined properties of DefProp1 should number 1", (int)1, (int)n6);
        Assert.assertEquals((String)"Defined properties of DefProp1 (non-closed) should number 0", (int)0, (int)n7);
        Assert.assertEquals((String)"Defined properties of DefProp2 should number 3", (int)2, (int)n8);
        Assert.assertEquals((String)"Defined properties of DefProp2 (non-closed) should number 2", (int)1, (int)n9);
        DAMLClass dAMLClass14 = (DAMLClass)dAMLModelImpl2.getDAMLValue(string2 + "tl_one");
        Assert.assertNotNull((String)"Class tl_one should not be null", (Object)dAMLClass14);
        int n10 = this.countIteration(dAMLClass14.prop_subClassOf().getAll(false), false, null);
        int n11 = this.countIteration(dAMLClass14.getSuperClasses(false), false, null);
        int n12 = this.countIteration(new StatementSubjectIterator(dAMLClass14.listProperties(RDFS.subClassOf)), false, null);
        Assert.assertEquals((String)"Should be two super-classes of tl_one by prop_subClassOf", (int)2, (int)n10);
        Assert.assertEquals((String)"Should be two super-classes of tl_one by getSuperClasses", (int)2, (int)n11);
        Assert.assertEquals((String)"Should be one super-class of tl_one by listProperties", (int)1, (int)n12);
        DAMLClass dAMLClass15 = (DAMLClass)dAMLModelImpl2.getDAMLValue(string2 + "Researcher");
        Assert.assertNotNull((String)"Class Researcher should not be null", (Object)dAMLClass15);
        int n13 = this.countIteration(dAMLClass15.getSuperClasses(false), true, "Super-class of researcher");
        Assert.assertEquals((String)"Should be 2 super-classes of researcher", (int)2, (int)n13);
    }

    public void testEquivalence() throws RDFException {
        String string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        Log.debug("Starting equivalence tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLInstance dAMLInstance = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "x0");
        Assert.assertNotNull((String)"Instance x0 should not be null", (Object)dAMLInstance);
        Assert.assertEquals((String)"Number of elements in equivalence class should be 4", (int)4, (int)this.countIteration(dAMLInstance.getEquivalentValues(), true, "Member of equivalence class to x0: "));
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "C0");
        Assert.assertNotNull((String)"Class C0 should not be null", (Object)dAMLClass);
        Assert.assertEquals((String)"Number of elements in equivalence class should be 4", (int)4, (int)this.countIteration(dAMLClass.getSameClasses(), true, "sameClass as C0: "));
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "p0");
        Assert.assertNotNull((String)"Property p0 should not be null", (Object)dAMLProperty);
        Assert.assertEquals((String)"Number of elements in equivalence class should be 4", (int)4, (int)this.countIteration(dAMLProperty.getSameProperties(), true, "sameProperty as p0: "));
        Resource resource = dAMLModelImpl.getResource(string + "CDaml");
        Assert.assertNotNull((String)"Resource dClass should not be null", (Object)resource);
        Assert.assertTrue((String)"Resource dClass should be a daml class", (boolean)(resource instanceof DAMLClass));
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "D0");
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "D1");
        DAMLInstance dAMLInstance2 = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "d1");
        Assert.assertNotNull((String)"Class D0 should not be null", (Object)dAMLClass2);
        Assert.assertNotNull((String)"Class D1 should not be null", (Object)dAMLClass3);
        Assert.assertNotNull((String)"Instance d1 should not be null", (Object)dAMLInstance2);
        Assert.assertTrue((String)"Instance d1 should have class D1", (boolean)dAMLInstance2.hasRDFType(dAMLClass3));
        Assert.assertTrue((String)"Instance d1 should have class D0", (boolean)dAMLInstance2.hasRDFType(dAMLClass2));
        DAMLProperty dAMLProperty2 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "pd0");
        DAMLProperty dAMLProperty3 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "pd1");
        Assert.assertNotNull((String)"Property pd0 should not be null", (Object)dAMLProperty2);
        Assert.assertNotNull((String)"Property pd1 should not be null", (Object)dAMLProperty3);
        DAMLInstance dAMLInstance3 = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "d2");
        Assert.assertNotNull((String)"Instance d2 should not be null", (Object)dAMLInstance3);
        Assert.assertTrue((String)"d2 should have d1 as a value for pd0", (boolean)dAMLInstance3.accessProperty(dAMLProperty2).hasValue(dAMLInstance2));
        Assert.assertTrue((String)"d2 should have d1 as a value for pd1", (boolean)dAMLInstance3.accessProperty(dAMLProperty3).hasValue(dAMLInstance2));
        DAMLProperty dAMLProperty4 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "pd2");
        DAMLProperty dAMLProperty5 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "pd3");
        Assert.assertNotNull((String)"Property pd2 should not be null", (Object)dAMLProperty4);
        Assert.assertNotNull((String)"Property pd3 should not be null", (Object)dAMLProperty5);
        Assert.assertTrue((String)"d2 should have d1 as a value for pd3", (boolean)dAMLInstance3.accessProperty(dAMLProperty5).hasValue(dAMLInstance2));
        Assert.assertTrue((String)"d2 should have d1 as a value for pd2", (boolean)dAMLInstance3.accessProperty(dAMLProperty4).hasValue(dAMLInstance2));
    }

    public void testProperty() throws RDFException {
        Object object;
        Object object2;
        Log.debug("Starting DAML property tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "hasMother");
        Assert.assertNotNull((String)"hasMother property should not be null", (Object)dAMLProperty);
        Assert.assertTrue((String)"hasMother property should be a unique property", (boolean)dAMLProperty.isUnique());
        DAMLProperty dAMLProperty2 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "hasParent");
        Assert.assertNotNull((String)"hasParent property should not be null", (Object)dAMLProperty2);
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Female");
        Assert.assertNotNull((String)"Class Female should not be null", (Object)dAMLClass);
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Animal");
        Assert.assertNotNull((String)"Class Animal should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Person");
        Assert.assertNotNull((String)"Class Person should not be null", (Object)dAMLClass3);
        Assert.assertTrue((String)"Mother should have Female as range", (boolean)dAMLProperty.prop_range().hasValue(dAMLClass));
        Assert.assertTrue((String)"Mother should not have Animal as local domain (prop_domain)", (!dAMLProperty.prop_domain().hasValue(dAMLClass2) ? 1 : 0) != 0);
        boolean bl = false;
        Iterator iterator = dAMLProperty.getDomainClasses();
        while (!bl && iterator.hasNext()) {
            object2 = iterator.next();
            bl = ((DAMLClass)object2).equals(dAMLClass2);
        }
        Assert.assertTrue((String)"Mother should have Animal as domain (getDomainClasses)", (boolean)bl);
        object2 = (DAMLObjectProperty)dAMLModelImpl.getDAMLValue(string + "hasAncestor");
        Assert.assertNotNull((String)"hasAncestor should not be null", object2);
        Assert.assertTrue((String)"hasAncestor should be transitive", (boolean)object2.isTransitive());
        DAMLInstance dAMLInstance = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "Peter");
        Assert.assertNotNull((String)"Instance Peter should not be null", (Object)dAMLInstance);
        DAMLProperty dAMLProperty3 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "shoesize");
        Assert.assertNotNull((String)"Property shoesize should not be null", (Object)dAMLProperty3);
        PropertyAccessor propertyAccessor = dAMLInstance.accessProperty(dAMLProperty3);
        Iterator iterator2 = propertyAccessor.getAll(false);
        Assert.assertEquals((String)"iShoes iterator should have at least one value", (boolean)true, (boolean)iterator2.hasNext());
        Object e = iterator2.next();
        Assert.assertNotNull((String)"size returned from property accessor iterator should not be null", e);
        Assert.assertTrue((String)"size object should be a literal", (boolean)(e instanceof Literal));
        boolean bl2 = false;
        try {
            object = iterator2.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            bl2 = true;
        }
        Assert.assertEquals((String)"Accessing past end of property iterator should throw no such element exception", (boolean)true, (boolean)bl2);
        object = dAMLClass3.prop_subClassOf().getAll(false);
        Assert.assertNotNull((String)"Iterator over subClassOf values should not be null", object);
        Assert.assertTrue((String)"Iteration of subClassOf should have at least one value", (boolean)object.hasNext());
        int n = this.countIteration((Iterator)object, true, "direct super-class of Person = ");
        Assert.assertEquals((String)"Should be 7 direct super-classes of Person", (int)7, (int)n);
        DAMLClass dAMLClass4 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Male");
        Assert.assertNotNull((String)"Class Male should not be null", (Object)dAMLClass4);
        DAMLCommon dAMLCommon = (DAMLCommon)dAMLClass.prop_disjointWith().get();
        Assert.assertNotNull((String)"Value for female.disjointWith should not be null", (Object)dAMLCommon);
        Assert.assertTrue((String)"female.disjointWith should be male", (boolean)dAMLClass4.equals(dAMLCommon));
        dAMLModelImpl.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass dAMLClass5 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "subClassCheck3");
        Assert.assertNotNull((String)"Class subClassCheck3 should not be null", (Object)dAMLClass5);
        Iterator iterator3 = dAMLClass5.prop_subClassOf().getAll(false);
        Assert.assertNotNull((String)"Iterator over subClassOf values should not be null", (Object)object);
        Assert.assertTrue((String)"Iteration of subClassOf should have at least one value", (boolean)iterator3.hasNext());
        n = this.countIteration(iterator3, true, "property access on subClassCheck3 with closed = false ");
        Assert.assertEquals((String)"Should be 1 non-closed super-classes of subClassCheck3", (int)1, (int)n);
        iterator3 = dAMLClass5.prop_subClassOf().getAll(true);
        Assert.assertNotNull((String)"Iterator over subClassOf values should not be null", (Object)object);
        Assert.assertTrue((String)"Iteration of subClassOf should have at least one value", (boolean)iterator3.hasNext());
        n = this.countIteration(iterator3, true, "property access on subClassCheck3 with closed = true ");
        Assert.assertEquals((String)"Should be 2 closed super-classes of subClassCheck3", (int)2, (int)n);
        DAMLProperty dAMLProperty4 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "q");
        Assert.assertNotNull((String)"Property q should not be null", (Object)dAMLProperty4);
        DAMLInstance dAMLInstance2 = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "qX");
        Assert.assertNotNull((String)"Instance qX should not be null", (Object)dAMLInstance2);
        int n2 = dAMLInstance2.accessProperty(dAMLProperty4).count();
        Assert.assertEquals((String)"There should be 4 values for q of qX (equivalence on)", (int)4, (int)n2);
        dAMLModelImpl.setUseEquivalence(false);
        n2 = dAMLInstance2.accessProperty(dAMLProperty4).count();
        Assert.assertEquals((String)"There should be 1 values for q of qX (equivalence off)", (int)1, (int)n2);
        dAMLModelImpl.setUseEquivalence(true);
        DAMLObjectProperty dAMLObjectProperty = (DAMLObjectProperty)dAMLModelImpl.getDAMLValue(string + "TL_PropertyTest");
        Assert.assertNotNull((String)"Property should not be null", (Object)dAMLObjectProperty);
        Iterator iterator4 = dAMLObjectProperty.prop_domain().getAll(false);
        Assert.assertEquals((String)"Property TL_PropertyTest should have a domain of two classes", (int)2, (int)this.countIteration(iterator4, false, null));
        Iterator iterator5 = dAMLObjectProperty.prop_range().getAll(false);
        Assert.assertEquals((String)"Property TL_PropertyTest should have a range of two classes", (int)2, (int)this.countIteration(iterator5, false, null));
        DAMLClass dAMLClass6 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "HumanBody");
        Assert.assertNotNull((String)"Class humanBody should not be null", (Object)dAMLClass6);
        PropertyAccessor propertyAccessor2 = dAMLClass6.prop_unionOf();
        Assert.assertNotNull((String)"Property accessor should not be null", (Object)propertyAccessor2);
        Assert.assertEquals((String)"Should be two value in union", (int)1, (int)propertyAccessor2.count());
        DAMLCommon dAMLCommon2 = propertyAccessor2.getDAMLValue();
        Assert.assertNotNull((String)"Union should not be null", (Object)dAMLCommon2);
        Assert.assertTrue((String)"Union value should be a list", (boolean)(dAMLCommon2 instanceof DAMLList));
        Assert.assertEquals((String)"Should be two values in list", (int)2, (int)((DAMLList)dAMLCommon2).getCount());
    }

    public void testList() throws RDFException {
        Log.debug("Starting DAML list tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Person");
        Assert.assertNotNull((String)"Person class should not be null", (Object)dAMLClass);
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Man");
        Assert.assertNotNull((String)"Man class should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Woman");
        Assert.assertNotNull((String)"Woman class should not be null", (Object)dAMLClass3);
        DAMLList dAMLList = (DAMLList)dAMLClass.prop_disjointUnionOf().get();
        Assert.assertNotNull((String)"union should not be null", (Object)dAMLList);
        Assert.assertEquals((String)"union should have two values", (int)2, (int)dAMLList.getCount());
        DAMLCommon dAMLCommon = dAMLList.getFirst();
        Assert.assertEquals((String)"Man should be the first element in the list", (Object)dAMLClass2, (Object)dAMLCommon);
        DAMLList dAMLList2 = dAMLList.getRest();
        Assert.assertNotNull((String)"Tail of list should not be null", (Object)dAMLList2);
        DAMLCommon dAMLCommon2 = dAMLList2.getFirst();
        Assert.assertNotNull((String)"head of tail should not be null", (Object)dAMLCommon2);
        Assert.assertEquals((String)"Woman should be the first element in the tail of the list", (Object)dAMLClass3, (Object)dAMLCommon2);
        DAMLList dAMLList3 = dAMLList2.getRest();
        Assert.assertNotNull((String)"Tail of tail should not be null", (Object)dAMLList3);
        Assert.assertTrue((String)"Remainder of list should be empty", (boolean)dAMLList3.isEmpty());
        DAMLClass dAMLClass4 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Car");
        Assert.assertNotNull((String)"Class Car should not be null", (Object)dAMLClass4);
        dAMLList.add(dAMLClass4);
        Assert.assertEquals((String)"Union should contain three elements", (int)3, (int)dAMLList.getCount());
        DAMLModelImpl dAMLModelImpl2 = new DAMLModelImpl();
        DAMLModelImpl dAMLModelImpl3 = new DAMLModelImpl();
        DAMLClass dAMLClass5 = dAMLModelImpl3.createDAMLClass("A");
        DAMLClass dAMLClass6 = dAMLModelImpl3.createDAMLClass("B");
        DAMLClass dAMLClass7 = dAMLModelImpl2.createDAMLClass("A");
        DAMLClass dAMLClass8 = dAMLModelImpl2.createDAMLClass("B");
        DAMLClass dAMLClass9 = dAMLModelImpl2.createDAMLClass("C");
        DAMLList dAMLList4 = dAMLModelImpl2.createDAMLList(null);
        DAMLList dAMLList5 = dAMLModelImpl3.createDAMLList(null);
        dAMLList4.add(dAMLClass7);
        dAMLList4.add(dAMLClass8);
        dAMLList4.add(dAMLClass9);
        dAMLList5.add(dAMLClass5);
        dAMLList5.add(dAMLClass6);
        dAMLList4.remove(dAMLClass9);
        dAMLClass9.remove();
        Assert.assertEquals((String)"Model should be equal to model 1 after removing C", (Object)dAMLModelImpl2, (Object)dAMLModelImpl3);
        dAMLModelImpl2 = new DAMLModelImpl();
        dAMLClass7 = dAMLModelImpl2.createDAMLClass("A");
        dAMLClass8 = dAMLModelImpl2.createDAMLClass("B");
        dAMLClass9 = dAMLModelImpl2.createDAMLClass("C");
        DAMLClass dAMLClass10 = dAMLModelImpl2.createDAMLClass("D");
        dAMLList4 = dAMLModelImpl2.createDAMLList(null);
        dAMLList4.add(dAMLClass10);
        dAMLList4.add(dAMLClass7);
        dAMLList4.add(dAMLClass8);
        dAMLList4.add(dAMLClass9);
        dAMLList4.remove(dAMLClass10);
        dAMLList4.remove(dAMLClass9);
        dAMLClass9.remove();
        dAMLClass10.remove();
        Assert.assertEquals((String)"Model should be equal to model 1 after removing C and D", (Object)dAMLModelImpl2, (Object)dAMLModelImpl3);
        dAMLModelImpl2 = new DAMLModelImpl();
        dAMLClass7 = dAMLModelImpl2.createDAMLClass("A");
        dAMLList4 = dAMLModelImpl2.createDAMLList(null);
        dAMLList4.add(dAMLClass7);
        dAMLList4.remove(dAMLClass7);
        dAMLClass7.remove();
        Assert.assertEquals((String)"List should have length 0", (int)0, (int)dAMLList4.getCount());
    }

    public void testInstance() throws RDFException {
        Log.debug("Starting DAML instance tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        Assert.assertEquals((String)"Number of instances should be 12", (int)12, (int)this.countIteration(dAMLModelImpl.listDAMLInstances(), false, " instance = "));
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Person");
        Assert.assertNotNull((String)"Person DAML class should not be null", (Object)dAMLClass);
        int n = this.countIteration(dAMLClass.getInstances(), true, "instance of person");
        Assert.assertEquals((String)"There should be 4 instances of Person in the model", (int)4, (int)n);
    }

    public void testDatatype() throws RDFException {
        Log.debug("Starting DAML datatype tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLInstance dAMLInstance = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "Ian");
        Assert.assertNotNull((String)"Instance Ian should not be null", (Object)dAMLInstance);
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "shirtsize");
        Assert.assertNotNull((String)"Property shirtsize should not be null", (Object)dAMLProperty);
        DAMLProperty dAMLProperty2 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "shoesize");
        Assert.assertNotNull((String)"Property shoesize should not be null", (Object)dAMLProperty2);
        DAMLDataInstance dAMLDataInstance = (DAMLDataInstance)dAMLInstance.getProperty(dAMLProperty).getObject();
        Assert.assertNotNull((String)"Object ian should have a shirtsize", (Object)dAMLDataInstance);
        Object object = dAMLDataInstance.getValue();
        Assert.assertNotNull((String)"Value of shirtsize should not be null", (Object)object);
        Assert.assertEquals((String)"Shirt size should be a string", (Object)(class$java$lang$String == null ? (class$java$lang$String = DAMLTest.class$("java.lang.String")) : class$java$lang$String), object.getClass());
        Assert.assertEquals((String)"Shirt size should be \"12\"", (Object)"12", (Object)object);
    }

    public void testRemove() throws RDFException {
        Log.debug("Starting DAML remove test");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        boolean bl = false;
        while (!bl) {
            Object object;
            Object object2;
            Object object3 = null;
            StmtIterator stmtIterator = dAMLModelImpl.listStatements();
            while (stmtIterator.hasNext()) {
                object2 = stmtIterator.next().getSubject();
                if (!(object2 instanceof DAMLCommon)) continue;
                object3 = object2;
                break;
            }
            if (object3 == null) {
                bl = true;
                continue;
            }
            object2 = object3.getURI();
            boolean bl2 = object3 instanceof DAMLClass;
            Log.debug("Removing DAML resource " + object3);
            ((DAMLCommon)object3).remove();
            if (bl2) {
                Iterator iterator = dAMLModelImpl.listDAMLClasses();
                while (iterator.hasNext()) {
                    object = ((DAMLClass)iterator.next()).getURI();
                    if (object == null) continue;
                    Assert.assertTrue((String)("DAML class " + (String)object2 + " should have been removed from the index"), (!((String)object).equals(object2) ? 1 : 0) != 0);
                }
            }
            int n = 0;
            object = dAMLModelImpl.listStatements(new SelectorImpl((Resource)object3, null, (RDFNode)null));
            while (object.hasNext()) {
                object.next();
                ++n;
            }
            Assert.assertEquals((String)("DAML value " + (String)object2 + " should have been removed from the model"), (int)0, (int)n);
        }
        Assert.assertEquals((String)"Model should now be empty", (long)0L, (long)dAMLModelImpl.size());
    }

    public void testCreate() throws RDFException {
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        String string = "http://dickinson-i-4/daml/tests/gen#A";
        DAMLClass dAMLClass = dAMLModelImpl.createDAMLClass(string);
        Assert.assertNotNull((String)("Failed to create new DAML Class " + string), (Object)dAMLClass);
        boolean bl = false;
        Iterator iterator = dAMLModelImpl.listDAMLClasses();
        while (iterator.hasNext()) {
            if (!((DAMLClass)iterator.next()).equals(dAMLClass)) continue;
            bl = true;
        }
        Assert.assertTrue((String)"Could not see class after it was created", (boolean)bl);
        DAMLInstance dAMLInstance = (DAMLInstance)dAMLModelImpl.createDAMLValue("http://dickinson-i-4/daml/tests/gen#x", dAMLClass, null);
        Assert.assertNotNull((String)"Failed to create new DAML instance", (Object)dAMLInstance);
        bl = false;
        Iterator iterator2 = dAMLModelImpl.listDAMLInstances();
        while (iterator2.hasNext()) {
            if (!((DAMLInstance)iterator2.next()).equals(dAMLInstance)) continue;
            bl = true;
        }
        Assert.assertTrue((String)"Could not see instance after it was created", (boolean)bl);
    }

    public void testRestriction() throws RDFException {
        Log.debug("Starting DAML restriction tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Person");
        Iterator iterator = dAMLClass.getSuperClasses();
        while (iterator.hasNext()) {
            DAMLRestriction dAMLRestriction;
            PropertyAccessor propertyAccessor;
            int n;
            Resource resource = (Resource)iterator.next();
            if (!(resource instanceof DAMLRestriction) || (n = (propertyAccessor = (dAMLRestriction = (DAMLRestriction)resource).prop_onProperty()).count()) < 1) continue;
            RDFNode rDFNode = propertyAccessor.get();
            Object e = propertyAccessor.getAll(false).next();
            Assert.assertNotNull((String)"Failed to access value of property accessor on restriction", (Object)rDFNode);
            Assert.assertNotNull((String)"Failed to access value of property accessor on restriction", e);
        }
    }

    public void testModelAdd() throws RDFException {
        Log.debug("Starting model add test");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/test-add-0.daml");
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://dickinson-i-4/daml/tests/test-add-0.daml#";
        ModelMem modelMem = new ModelMem();
        modelMem.read("file:modules/rdf/regression/testDAML/test-add-1.daml");
        Assert.assertEquals((String)"Instance count in DAML model should be 0", (int)0, (int)this.countIteration(dAMLModelImpl.listDAMLInstances(), true, "instance in test add"));
        dAMLModelImpl.add(modelMem);
        Assert.assertEquals((String)"Instance count in DAML model should be 1", (int)1, (int)this.countIteration(dAMLModelImpl.listDAMLInstances(), true, "instance in test add"));
    }

    public void testSyntaxError() throws RDFException {
        Log.debug("Starting syntax error test");
        PrintStream printStream = System.err;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
            System.setOut(printStream2);
            DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
            dAMLModelImpl.read("file:modules/rdf/regression/testDAML/test-syntax-error.daml");
            Assert.assertTrue((String)"loadStatus should be false for unsuccessful load", (!dAMLModelImpl.getLoadSuccessful() ? 1 : 0) != 0);
            Assert.assertTrue((String)"A syntax error should be reported.", (byteArrayOutputStream.toString().indexOf("syntax error") != -1 ? 1 : 0) != 0);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            System.setOut(printStream);
            throw throwable;
        }
        System.setOut(printStream);
    }

    public void testDatatypeProperty() throws RDFException {
        this.eqTest(new EqualityTest("DatatypeProperty"){

            String xml() {
                return "<daml:DatatypeProperty/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLDatatypeProperty(null);
            }
        });
    }

    public void testObjectProperty() throws RDFException {
        this.eqTest(new EqualityTest("ObjectProperty"){

            String xml() {
                return "<daml:ObjectProperty/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLObjectProperty(null);
            }
        });
    }

    public void testPropertyEq() throws RDFException {
        this.eqTest(new EqualityTest("Property"){

            String xml() {
                return "<daml:Property/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLProperty(null);
            }
        });
    }

    public void testDatatypeEq1() throws RDFException {
        this.eqTest(new EqualityTest("Datatype"){

            String xml() {
                return "<daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#string'/>";
            }

            void java(DAMLModel dAMLModel) {
                new DAMLDatatypeImpl("http://www.w3.org/2000/10/XMLSchema#", "string", dAMLModel, null);
            }
        });
    }

    public void testDatatypeEq2() throws RDFException {
        this.eqTest(new EqualityTest("Datatype"){

            String xml() {
                return "<daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#string'/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#string");
            }
        });
    }

    public void testDatatypeRange() throws RDFException {
        this.eqTest(new EqualityTest("Datatype Range"){

            String xml() {
                return "<daml:DatatypeProperty rdf:ID='shoesize'> <rdf:type rdf:resource='http://www.daml.org/2001/03/daml+oil#UniqueProperty'/> <daml:range rdf:resource='http://www.w3.org/2000/10/XMLSchema#decimal'/></daml:DatatypeProperty><daml:Property rdf:about='http://www.daml.org/2001/03/daml+oil#range' /><daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#decimal'/>";
            }

            void java(DAMLModel dAMLModel) {
                DAMLDatatypeProperty dAMLDatatypeProperty = dAMLModel.createDAMLDatatypeProperty("http://example.org/#shoesize");
                dAMLDatatypeProperty.setIsUnique(true);
                dAMLDatatypeProperty.prop_range().add(dAMLModel.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#decimal"));
            }
        });
    }

    private void eqTest(EqualityTest equalityTest) throws RDFException {
        Log.debug("Starting DAML equality test for " + equalityTest.toString());
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        equalityTest.java(dAMLModelImpl);
        ModelMem modelMem = new ModelMem();
        StringReader stringReader = new StringReader("<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#' xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>" + equalityTest.xml() + "</rdf:RDF>");
        modelMem.read(stringReader, "http://example.org/");
        if (!dAMLModelImpl.equals(modelMem)) {
            System.out.println("Java:");
            dAMLModelImpl.write(new OutputStreamWriter(System.out), "RDF/XML-ABBREV");
            System.out.println("XML:");
            modelMem.write(new OutputStreamWriter(System.out), "RDF/XML-ABBREV");
        }
        Assert.assertEquals((String)"java code and xml should be equivalent", (Object)dAMLModelImpl, (Object)modelMem);
    }

    public static void dumpModel(Model model) {
        DAMLTest.dumpModel(model, "model-out.rdf");
    }

    public static void dumpModel(Model model, String string) {
        Log.debug("Dumping model to " + string);
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            model.write(printWriter, "RDF/XML-ABBREV");
            printWriter.close();
        }
        catch (Exception exception) {
            Log.severe("Exception while dumping model: " + exception, exception);
        }
    }

    private int countIteration(Iterator iterator, boolean bl, String string) {
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (bl) {
                Log.finest("counting iteration, " + string + e);
            }
            ++n;
        }
        return n;
    }

    private int countIteration(ResIterator resIterator, boolean bl, String string) {
        int n = 0;
        try {
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                if (bl) {
                    Log.finest("counting iteration, " + string + resource);
                }
                ++n;
            }
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception: " + rDFException, rDFException);
        }
        return n;
    }

    private int countClasses(DAMLModel dAMLModel) {
        return this.countIteration(dAMLModel.listDAMLClasses(), false, null);
    }

    private int countProperties(DAMLModel dAMLModel) {
        return this.countIteration(dAMLModel.listDAMLProperties(), false, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static abstract class EqualityTest {
        String name;

        EqualityTest(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        abstract void java(DAMLModel var1);

        abstract String xml();
    }
}

