/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLClass;
import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.common.DAMLDataInstanceImpl;
import com.hp.hpl.jena.daml.common.DAMLDatatypeImpl;
import com.hp.hpl.jena.daml.common.DAMLHierarchy;
import com.hp.hpl.jena.daml.common.DAMLInstanceImpl;
import com.hp.hpl.jena.daml.common.DAMLModelImpl;
import com.hp.hpl.jena.daml.common.VocabularyManager;
import com.hp.hpl.jena.util.ConcatenatedIterator;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.DAML_OIL_2000_12;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.common.Util;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.RDFReader;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class DAMLLoader {
    public static final String FILE_URI_PREFIX = "file://";
    public static final long STATUS_OK = 0L;
    public static final long STATUS_INPUT_UNAVAILABLE = 1L;
    public static final long STATUS_IO_ERROR = 2L;
    public static final long STATUS_SYNTAX_ERROR = 4L;
    public static final long STATUS_MISC_ERROR = 8L;
    static Class[] s_constructSig = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DAMLLoader.class$("java.lang.String")) : class$java$lang$String, class$com$hp$hpl$jena$daml$DAMLModel == null ? (class$com$hp$hpl$jena$daml$DAMLModel = DAMLLoader.class$("com.hp.hpl.jena.daml.DAMLModel")) : class$com$hp$hpl$jena$daml$DAMLModel, class$com$hp$hpl$jena$vocabulary$DAMLVocabulary == null ? (class$com$hp$hpl$jena$vocabulary$DAMLVocabulary = DAMLLoader.class$("com.hp.hpl.jena.vocabulary.DAMLVocabulary")) : class$com$hp$hpl$jena$vocabulary$DAMLVocabulary};
    private long m_status = 0L;
    private DAMLModel m_damlModel = null;
    private Vector m_sources = new Vector();
    private boolean m_loadImportedOntologies = true;
    private Vector m_importBlockList = new Vector();
    private boolean m_useImportBlocking = true;
    private Hashtable m_rdfDamlMap = new Hashtable();
    private HashSet m_postCheckResources = new HashSet();
    private ResourceDispatcher[] m_dispatchTable = new ResourceDispatcher[]{new ResourceDispatcher(DAML_OIL.Class, class$com$hp$hpl$jena$daml$common$DAMLClassImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLClassImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLClassImpl")) : class$com$hp$hpl$jena$daml$common$DAMLClassImpl), new ResourceDispatcher(DAML_OIL_2000_12.Class, class$com$hp$hpl$jena$daml$common$DAMLClassImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLClassImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLClassImpl")) : class$com$hp$hpl$jena$daml$common$DAMLClassImpl), new ResourceDispatcher(RDFS.Class, class$com$hp$hpl$jena$daml$common$DAMLClassImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLClassImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLClassImpl")) : class$com$hp$hpl$jena$daml$common$DAMLClassImpl), new ResourceDispatcher(DAML_OIL_2000_12.Disjoint, class$com$hp$hpl$jena$daml$common$DAMLDisjointImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLDisjointImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLDisjointImpl")) : class$com$hp$hpl$jena$daml$common$DAMLDisjointImpl), new ResourceDispatcher(DAML_OIL.Restriction, class$com$hp$hpl$jena$daml$common$DAMLRestrictionImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLRestrictionImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLRestrictionImpl")) : class$com$hp$hpl$jena$daml$common$DAMLRestrictionImpl), new ResourceDispatcher(DAML_OIL_2000_12.Restriction, class$com$hp$hpl$jena$daml$common$DAMLRestrictionImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLRestrictionImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLRestrictionImpl")) : class$com$hp$hpl$jena$daml$common$DAMLRestrictionImpl), new ResourceDispatcher(DAML_OIL.List, class$com$hp$hpl$jena$daml$common$DAMLListImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLListImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLListImpl")) : class$com$hp$hpl$jena$daml$common$DAMLListImpl), new ResourceDispatcher(DAML_OIL_2000_12.List, class$com$hp$hpl$jena$daml$common$DAMLListImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLListImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLListImpl")) : class$com$hp$hpl$jena$daml$common$DAMLListImpl), new ResourceDispatcher(DAML_OIL.Ontology, class$com$hp$hpl$jena$daml$common$DAMLOntologyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLOntologyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLOntologyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLOntologyImpl), new ResourceDispatcher(DAML_OIL_2000_12.Ontology, class$com$hp$hpl$jena$daml$common$DAMLOntologyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLOntologyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLOntologyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLOntologyImpl), new ResourceDispatcher(DAML_OIL.Property, class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl), new ResourceDispatcher(DAML_OIL_2000_12.Property, class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl), new ResourceDispatcher(RDF.Property, class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl), new ResourceDispatcher(DAML_OIL.DatatypeProperty, class$com$hp$hpl$jena$daml$common$DAMLDatatypePropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLDatatypePropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLDatatypePropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLDatatypePropertyImpl), new ResourceDispatcher(DAML_OIL.ObjectProperty, class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLObjectPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl), new ResourceDispatcher(DAML_OIL_2000_12.UniqueProperty, class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl), new ResourceDispatcher(DAML_OIL_2000_12.TransitiveProperty, class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl), new ResourceDispatcher(DAML_OIL_2000_12.UnambiguousProperty, class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl), new ResourceDispatcher(DAML_OIL.UniqueProperty, class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl), new ResourceDispatcher(DAML_OIL.TransitiveProperty, class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLObjectPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl), new ResourceDispatcher(DAML_OIL.UnambiguousProperty, class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLObjectPropertyImpl")) : class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl), new ResourceDispatcher(DAML_OIL.Thing, class$com$hp$hpl$jena$daml$common$DAMLInstanceImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLInstanceImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLInstanceImpl")) : class$com$hp$hpl$jena$daml$common$DAMLInstanceImpl), new ResourceDispatcher(DAML_OIL_2000_12.Thing, class$com$hp$hpl$jena$daml$common$DAMLInstanceImpl == null ? (class$com$hp$hpl$jena$daml$common$DAMLInstanceImpl = DAMLLoader.class$("com.hp.hpl.jena.daml.common.DAMLInstanceImpl")) : class$com$hp$hpl$jena$daml$common$DAMLInstanceImpl)};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$DAMLModel;
    static /* synthetic */ Class class$com$hp$hpl$jena$vocabulary$DAMLVocabulary;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$common$DAMLClassImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$common$DAMLDisjointImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$common$DAMLRestrictionImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$common$DAMLListImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$common$DAMLOntologyImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$common$DAMLPropertyImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$common$DAMLDatatypePropertyImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$common$DAMLObjectPropertyImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$daml$common$DAMLInstanceImpl;

    DAMLLoader(DAMLModel dAMLModel) {
        this.m_damlModel = dAMLModel;
        this.initialiseImportBlockList();
    }

    public DAMLModel getDAMLModel() {
        return this.m_damlModel;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void read(URL uRL, String string, String string2) {
        InputStream inputStream = null;
        this.addSource(uRL.toString());
        inputStream = uRL.openStream();
        this.read(new InputStreamReader(inputStream), string, string2);
        Object var7_5 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Log.severe("IO error while reading URL: " + uRL, iOException);
                this.setStatus(2L);
                Object var7_6 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    void read(String string, String string2, String string3) {
        try {
            this.read(new URL(string), string2, string3);
        }
        catch (MalformedURLException malformedURLException) {
            Log.severe("Could not parse URI: " + string, malformedURLException);
        }
        catch (RuntimeException runtimeException) {
            Log.severe("Saw runtime exception: " + runtimeException, runtimeException);
        }
    }

    void read(Reader reader, String string, String string2) {
        try {
            ModelMem modelMem = new ModelMem();
            this.collectRDFSources((Model)modelMem, reader, string, string2);
            this.processRDFStatements(modelMem);
        }
        catch (RDFException rDFException) {
            Log.severe("Error occurred in reading RDF source: " + rDFException, rDFException);
            this.setStatus(4L);
        }
    }

    void add(Model model) {
        this.processRDFStatements(model);
    }

    protected void initialiseImportBlockList() {
        this.m_importBlockList.add(this.getURIRoot("http://www.daml.org/2000/12/daml+oil#"));
        this.m_importBlockList.add(this.getURIRoot("http://www.daml.org/2001/03/daml+oil#"));
        this.m_importBlockList.add(this.getURIRoot(RDFS.getURI()));
    }

    public Iterator getImportBlockList() {
        return ((AbstractList)this.m_importBlockList).iterator();
    }

    public boolean isBlockedImport(String string) {
        return this.m_useImportBlocking && this.m_importBlockList.contains(string);
    }

    public void addImportBlock(String string) {
        if (!this.m_importBlockList.contains(string)) {
            this.m_importBlockList.add(string);
        }
    }

    public void removeImportBlock(String string) {
        this.m_importBlockList.remove(string);
    }

    public boolean getLoadImportedOntologies() {
        return this.m_loadImportedOntologies;
    }

    public void setLoadImportedOntologies(boolean bl) {
        this.m_loadImportedOntologies = bl;
    }

    public void setUseImportBlocking(boolean bl) {
        this.m_useImportBlocking = bl;
    }

    public boolean getUseImportBlocking() {
        return this.m_useImportBlocking;
    }

    public boolean isLoadedOntology(String string) {
        return this.getSourcePosition(string) != -1;
    }

    public long getStatus() {
        return this.m_status;
    }

    public void resetStatus() {
        this.m_status = 0L;
    }

    protected void setStatus(long l) {
        this.m_status |= l;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void collectRDFSources(Model model, String string, String string2, String string3) throws RDFException {
        this.addSource(string);
        InputStream inputStream = null;
        URL uRL = new URL(string);
        inputStream = uRL.openStream();
        this.collectRDFSources(model, new InputStreamReader(inputStream), string2, string3);
        Object var8_8 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Log.severe("IO error while reading URL: " + string, iOException);
                this.setStatus(2L);
                Object var8_9 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void collectRDFSources(Model model, Reader reader, String string, String string2) throws RDFException {
        RDFReader rDFReader = string2 == null ? model.getReader() : model.getReader(string2);
        WrapErrorHandler wrapErrorHandler = new WrapErrorHandler();
        RDFErrorHandler rDFErrorHandler = rDFReader.setErrorHandler(wrapErrorHandler);
        wrapErrorHandler.setWrap(rDFErrorHandler);
        rDFReader.read(model, reader, string);
        this.loadImportedOntologies(model, DAML_OIL.Ontology);
        this.loadImportedOntologies(model, DAML_OIL_2000_12.Ontology);
    }

    protected void loadImportedOntologies(Model model, DAMLClass dAMLClass) throws RDFException {
        if (this.getLoadImportedOntologies()) {
            Object object;
            Object object2;
            ResIterator resIterator = model.query(new SelectorImpl(null, RDF.type, dAMLClass)).listSubjects();
            ResIterator resIterator2 = model.query(new SelectorImpl(null, DAML_OIL.type, dAMLClass)).listSubjects();
            Vector<String> vector = new Vector<String>();
            ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(resIterator, resIterator2);
            while (concatenatedIterator.hasNext()) {
                object2 = (Resource)concatenatedIterator.next();
                object = model.listObjectsOfProperty((Resource)object2, dAMLClass.getVocabulary().imports());
                while (object.hasNext()) {
                    vector.add(object.next().toString());
                }
            }
            object2 = ((AbstractList)vector).iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (this.getSourcePosition((String)object) >= 0 || this.isBlockedImport((String)object)) continue;
                this.collectRDFSources(model, (String)object, (String)object, null);
            }
        }
    }

    protected void processRDFStatements(Model model) {
        try {
            this.mapRDFValuesToDAML(model);
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.next();
                this.getDAMLModel().add((Resource)this.mapDAMLNode(statement.getSubject()), (Property)this.mapDAMLNode(statement.getPredicate()), this.mapDAMLNode(statement.getObject()));
            }
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception while processing DAML statements: " + rDFException, rDFException);
            this.setStatus(8L);
        }
    }

    protected void mapRDFValuesToDAML(Model model) {
        try {
            Resource resource;
            Resource resource2;
            Object object;
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                object = stmtIterator.next();
                resource2 = object.getSubject();
                resource = object.getPredicate();
                RDFNode rDFNode = object.getObject();
                this.mapRDFResourceToDAML(model, resource2);
                this.mapRDFResourceToDAML(model, resource);
                if (!(rDFNode instanceof Resource)) continue;
                this.mapRDFResourceToDAML(model, (Resource)rDFNode);
            }
            object = this.m_postCheckResources.iterator();
            while (object.hasNext()) {
                resource2 = (Resource)object.next();
                resource = this.findType(model, resource2);
                if (resource == null) continue;
                if (this.isDAMLClass(resource)) {
                    this.m_rdfDamlMap.put(resource2, ((DAMLModelImpl)this.getDAMLModel()).index(new DAMLInstanceImpl(resource2.getURI(), this.getDAMLModel(), VocabularyManager.getVocabulary(resource.getURI()))));
                    continue;
                }
                if (this.isDAMLDatatype(resource)) {
                    this.m_rdfDamlMap.put(resource2, ((DAMLModelImpl)this.getDAMLModel()).index(new DAMLDataInstanceImpl(resource2.getURI(), this.getDAMLModel(), VocabularyManager.getVocabulary(resource2.getURI()))));
                    if (this.m_rdfDamlMap.containsKey(resource)) continue;
                    this.m_rdfDamlMap.put(resource, new DAMLDatatypeImpl(resource.getURI(), this.getDAMLModel(), VocabularyManager.getVocabulary(resource.getURI())));
                    continue;
                }
                Log.debug("Failed to match resource <" + resource2.getURI() + "> of type <" + (resource == null ? "unknown" : resource.getURI()) + "> in dispatch table");
            }
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception while processing DAML statements: " + rDFException, rDFException);
            this.setStatus(8L);
        }
    }

    protected void mapRDFResourceToDAML(Model model, Resource resource) {
        if (this.m_rdfDamlMap.containsKey(resource)) {
            return;
        }
        DAMLCommon dAMLCommon = this.getDAMLModel().getDAMLValue(resource.getURI());
        if (dAMLCommon != null) {
            this.m_rdfDamlMap.put(resource, dAMLCommon);
        } else {
            Resource resource2 = this.findType(model, resource);
            if (resource2 != null) {
                boolean bl = false;
                int n = 0;
                while (!bl && n < this.m_dispatchTable.length) {
                    bl = this.m_dispatchTable[n].dispatch(resource, resource2);
                    ++n;
                }
                if (!bl) {
                    this.m_postCheckResources.add(resource);
                }
            }
        }
    }

    protected RDFNode mapDAMLNode(RDFNode rDFNode) {
        Resource resource = (Resource)this.m_rdfDamlMap.get(rDFNode);
        return resource == null ? rDFNode : resource;
    }

    protected boolean isDAMLClass(Resource resource) {
        DAMLCommon dAMLCommon = this.getDAMLModel().getDAMLValue(resource.getURI());
        if (dAMLCommon != null && dAMLCommon instanceof DAMLClass) {
            return true;
        }
        dAMLCommon = (DAMLCommon)this.m_rdfDamlMap.get(resource);
        return dAMLCommon != null && dAMLCommon instanceof DAMLClass;
    }

    protected boolean isDAMLDatatype(Resource resource) {
        return this.getDAMLModel().getDatatypeRegistry().isRegisteredType(resource.getURI());
    }

    protected int getSourcePosition(String string) {
        return this.m_sources.indexOf(string);
    }

    protected void addSource(String string) {
        this.m_sources.add(string);
    }

    private String getURIRoot(String string) {
        int n = Util.splitNamespace(string);
        return n < 0 ? string : string.substring(0, n - 1);
    }

    private Resource findType(Model model, Resource resource) {
        Iterator iterator;
        Object object;
        Object object2;
        Object object3;
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            object3 = resource.listProperties(RDF.type);
            while (object3.hasNext()) {
                object2 = object3.next().getObject();
                if (!(object2 instanceof Resource)) continue;
                hashSet.add(object2);
            }
        }
        catch (RDFException rDFException) {
            // empty catch block
        }
        object3 = DAMLHierarchy.getInstance().getEquivalentValues(RDF.type);
        while (object3.hasNext()) {
            object2 = (Property)object3.next();
            try {
                object = resource.listProperties((Property)object2);
                while (object.hasNext()) {
                    iterator = object.next().getObject();
                    if (!(iterator instanceof Resource)) continue;
                    hashSet.add(iterator);
                }
            }
            catch (RDFException rDFException) {
                // empty catch block
            }
        }
        object2 = new HashSet();
        object = hashSet.iterator();
        while (object.hasNext()) {
            iterator = DAMLHierarchy.getInstance();
            Resource resource2 = (Resource)object.next();
            String string = resource2.getURI();
            boolean bl = false;
            Iterator iterator2 = hashSet.iterator();
            while (!bl && iterator2.hasNext()) {
                bl = ((DAMLHierarchy)((Object)iterator)).isDAMLSubClassOf(((Resource)iterator2.next()).getURI(), string);
            }
            boolean bl2 = bl = bl || resource2.equals(DAML_OIL.UniqueProperty) && hashSet.contains(DAML_OIL.DatatypeProperty);
            if (bl) continue;
            ((HashSet)object2).add(resource2);
        }
        iterator = ((HashSet)object2).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class WrapErrorHandler
    implements RDFErrorHandler {
        RDFErrorHandler wrap;

        private WrapErrorHandler() {
        }

        void setWrap(RDFErrorHandler rDFErrorHandler) {
            this.wrap = rDFErrorHandler;
        }

        public void warning(Exception exception) {
            this.wrap.warning(exception);
        }

        public void error(Exception exception) {
            DAMLLoader.this.setStatus(4L);
            this.wrap.error(exception);
        }

        public void fatalError(Exception exception) {
            DAMLLoader.this.setStatus(4L);
            this.wrap.fatalError(exception);
        }
    }

    protected class ResourceDispatcher {
        protected Resource m_typeRes = null;
        protected Class m_defaultClass = null;

        protected ResourceDispatcher(Resource resource, Class clazz) {
            this.m_typeRes = resource;
            this.m_defaultClass = clazz;
        }

        protected ResourceDispatcher() {
        }

        protected boolean dispatch(Resource resource, Resource resource2) {
            if (this.matches(resource, resource2)) {
                Resource resource3 = this.handleResource(resource, DAMLLoader.this.getDAMLModel(), resource2);
                DAMLLoader.this.m_rdfDamlMap.put(resource, resource3);
                return true;
            }
            return false;
        }

        protected boolean matches(Resource resource, Resource resource2) {
            if (this.m_typeRes == null) {
                Log.warning("Attempting default match in resource dispatcher, but with null type URI!");
                return false;
            }
            return this.m_typeRes.equals(resource2);
        }

        protected Resource handleResource(Resource resource, DAMLModel dAMLModel, Resource resource2) {
            if (this.m_defaultClass != null) {
                return ((DAMLModelImpl)dAMLModel).index(this.makeInstance(this.m_defaultClass, resource.getURI(), dAMLModel, resource2.getURI()));
            }
            Log.warning("Default dispatcher attempted to create a DAML value with no class available.");
            return null;
        }

        protected DAMLCommon makeInstance(Class clazz, String string, DAMLModel dAMLModel, String string2) {
            try {
                return (DAMLCommon)clazz.getDeclaredConstructor(s_constructSig).newInstance(string, dAMLModel, VocabularyManager.getVocabulary(string2));
            }
            catch (Exception exception) {
                Log.debug("Failed to construct DAML value " + clazz.getName(), exception);
                throw new RuntimeException("Unexpected error while constructing DAML value from RDF model: " + exception);
            }
        }
    }
}

