/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml;

import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.DAMLProperty;
import com.hp.hpl.jena.util.ConcatenatedIterator;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.NodeIteratorWrapper;
import com.hp.hpl.jena.util.ResIteratorWrapper;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class PropertyIterator
implements Iterator {
    protected LinkedList m_nodeQueue = new LinkedList();
    protected Property m_pred = null;
    protected Property m_inverse = null;
    protected HashSet m_predEquivs = new HashSet();
    protected HashSet m_inverseEquivs = new HashSet();
    protected boolean m_transitive = false;
    protected boolean m_isReflexive = false;
    protected HashMap m_seen = new HashMap();
    protected ArrayList m_roots = new ArrayList();
    protected Object m_defaultValue = null;
    protected boolean m_defaultValueSeen = false;
    protected boolean m_useEquivalence = true;
    protected Model m_model = null;

    public PropertyIterator(Resource resource, Property property, Property property2, boolean bl, boolean bl2) {
        this(resource, property, property2, bl, bl2, true);
    }

    public PropertyIterator(Resource resource, Property property, Property property2, boolean bl, boolean bl2, boolean bl3) {
        this(resource, property, property2, bl, bl2, bl3, null);
    }

    public PropertyIterator(Resource resource, Property property, Property property2, boolean bl, boolean bl2, boolean bl3, Model model) {
        this.initialise(resource, property, property2, bl, bl2, bl3, model);
        this.traverse(resource);
    }

    public PropertyIterator(Iterator iterator, Property property, Property property2, boolean bl, boolean bl2) {
        this(iterator, property, property2, bl, bl2, true);
    }

    public PropertyIterator(Iterator iterator, Property property, Property property2, boolean bl, boolean bl2, boolean bl3) {
        this(iterator, property, property2, bl, bl2, bl3, null);
    }

    public PropertyIterator(Iterator iterator, Property property, Property property2, boolean bl, boolean bl2, boolean bl3, Model model) {
        this.initialise(null, property, property2, bl, bl2, bl3, model);
        this.traverse(iterator);
    }

    public boolean hasNext() {
        return !this.m_nodeQueue.isEmpty() || this.hasDefaultValue() && !this.m_defaultValueSeen;
    }

    public Object next() {
        if (!this.m_nodeQueue.isEmpty()) {
            RDFNode rDFNode = (RDFNode)this.m_nodeQueue.removeFirst();
            if (this.hasDefaultValue() && this.m_defaultValue.equals(rDFNode)) {
                this.m_defaultValueSeen = true;
            }
            if (rDFNode instanceof Resource) {
                this.expandQueue((Resource)rDFNode);
            }
            return rDFNode;
        }
        if (this.hasDefaultValue() && !this.m_defaultValueSeen) {
            this.m_defaultValueSeen = true;
            return this.m_defaultValue;
        }
        throw new NoSuchElementException("Tried to access next() element from empty property iterator");
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a property iterator");
    }

    public void setDefaultValue(Object object) {
        this.m_defaultValue = object;
    }

    public boolean hasDefaultValue() {
        return this.m_defaultValue != null;
    }

    private void enqueue(RDFNode rDFNode) {
        if (!this.m_seen.containsKey(rDFNode)) {
            this.m_seen.put(rDFNode, Boolean.TRUE);
            this.m_nodeQueue.addLast(rDFNode);
            if (this.getUseEquivalence() && rDFNode instanceof DAMLCommon) {
                Iterator iterator = ((DAMLCommon)rDFNode).getEquivalentValues();
                while (iterator.hasNext()) {
                    this.enqueue((RDFNode)iterator.next());
                }
            }
        }
    }

    protected void expandQueue(Resource resource) {
        try {
            Iterator iterator;
            if (this.m_pred != null && (this.m_transitive || this.isRoot(resource))) {
                iterator = this.getStatementObjects(resource);
                while (iterator.hasNext()) {
                    this.enqueue((RDFNode)iterator.next());
                }
            }
            if (this.m_inverse != null && (this.m_transitive || this.isRoot(resource))) {
                iterator = this.getStatementSubjects(resource);
                while (iterator.hasNext()) {
                    this.enqueue((RDFNode)iterator.next());
                }
            }
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception while traversing graph: " + rDFException, rDFException);
        }
    }

    protected boolean isRoot(Resource resource) {
        boolean bl = false;
        return this.m_roots.contains(resource);
    }

    protected Iterator getStatementObjects(Resource resource) throws RDFException {
        Iterator iterator = null;
        if (this.getUseEquivalence() && resource instanceof DAMLCommon) {
            Iterator iterator2 = this.m_predEquivs.iterator();
            while (iterator2.hasNext()) {
                PropertyIterator propertyIterator = new PropertyIterator(resource, (Property)iterator2.next(), null, this.m_transitive, false, false, this.m_model);
                Iterator iterator3 = iterator = iterator == null ? propertyIterator : new ConcatenatedIterator(propertyIterator, iterator);
            }
        } else {
            iterator = this.m_model != null ? new NodeIteratorWrapper(this.m_model.listObjectsOfProperty(resource, this.m_pred)) : new LinkedList().iterator();
        }
        return iterator;
    }

    protected Iterator getStatementSubjects(Resource resource) throws RDFException {
        Iterator iterator = null;
        if (this.getUseEquivalence() && resource instanceof DAMLCommon) {
            Iterator iterator2 = this.m_inverseEquivs.iterator();
            while (iterator2.hasNext()) {
                PropertyIterator propertyIterator = new PropertyIterator(resource, null, (Property)iterator2.next(), this.m_transitive, false, false, this.m_model);
                Iterator iterator3 = iterator = iterator == null ? propertyIterator : new ConcatenatedIterator(propertyIterator, iterator);
            }
        } else {
            iterator = this.m_model != null ? new ResIteratorWrapper(this.m_model.listSubjectsWithProperty(this.m_inverse, resource)) : new LinkedList().iterator();
        }
        return iterator;
    }

    protected void cachePropertyEquivs() {
        if (this.getUseEquivalence()) {
            Iterator iterator;
            if (this.m_pred != null) {
                if (this.m_pred instanceof DAMLProperty) {
                    iterator = ((DAMLProperty)this.m_pred).getEquivalentValues();
                    while (iterator.hasNext()) {
                        this.cacheProperty(this.m_predEquivs, (Property)iterator.next());
                    }
                } else {
                    this.cacheProperty(this.m_predEquivs, this.m_pred);
                }
            }
            if (this.m_inverse != null) {
                if (this.m_inverse instanceof DAMLProperty) {
                    iterator = ((DAMLProperty)this.m_inverse).getEquivalentValues();
                    while (iterator.hasNext()) {
                        this.cacheProperty(this.m_inverseEquivs, (Property)iterator.next());
                    }
                } else {
                    this.cacheProperty(this.m_inverseEquivs, this.m_inverse);
                }
            }
        }
    }

    protected void cacheProperty(HashSet hashSet, Property property) {
        hashSet.add(property);
        if (property instanceof DAMLProperty && !property.getLocalName().equals(DAML_OIL.subPropertyOf.getLocalName())) {
            Iterator iterator = ((DAMLProperty)property).getSubProperties();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
    }

    protected void setModel(Model model, Resource resource, Property property, Property property2) {
        if (model != null) {
            this.m_model = model;
        } else if (resource != null && resource.getModel() != null) {
            this.m_model = resource.getModel();
        } else if (property != null && property.getModel() != null) {
            this.m_model = property.getModel();
        } else if (property2 != null && property2.getModel() != null) {
            this.m_model = property2.getModel();
        }
    }

    protected boolean getUseEquivalence() {
        boolean bl = this.m_model == null || !(this.m_model instanceof DAMLModel) || ((DAMLModel)this.m_model).getUseEquivalence();
        return this.m_useEquivalence && bl;
    }

    protected void traverse(Resource resource) {
        this.m_roots.add(resource);
        if (this.m_model == null && resource.getModel() != null) {
            this.m_model = resource.getModel();
        }
        if (this.m_isReflexive) {
            this.enqueue(resource);
        } else {
            this.expandQueue(resource);
        }
    }

    protected void traverse(Iterator iterator) {
        while (iterator.hasNext()) {
            this.traverse((Resource)iterator.next());
        }
    }

    protected void initialise(Resource resource, Property property, Property property2, boolean bl, boolean bl2, boolean bl3, Model model) {
        this.m_pred = property;
        this.m_inverse = property2;
        this.m_transitive = bl;
        this.m_useEquivalence = bl3;
        this.m_isReflexive = bl2;
        this.setModel(model, resource, property, property2);
        this.cachePropertyEquivs();
    }
}

