unit mwPasLexTypes;

interface

uses SysUtils, TypInfo;

{$ifndef VER130} {$ifndef VER140} {$ifndef VER150} {$ObjExportAll on} {$endif} {$endif} {$endif}

var
  CompTable: array[#0..#255] of byte;

type
  TCommentState = (csAnsi, csBor, csNo);

  TptTokenKind = (
    ptAbsolute,
    ptAbstract,
    ptAddressOp,
    ptAmpersand,
    ptAnd,
    ptAnsiComment,
    ptAnsiString,
    ptArray,
    ptAs,
    ptAsciiChar,
    ptAsm,
    ptAssembler,
    ptAssign,
    ptAutomated,
    ptBegin,
    ptBoolean,
    ptBorComment,
    ptBraceClose,
    ptBraceOpen,
    ptByte,
    ptByteBool,
    ptCardinal,
    ptCase,
    ptCdecl,
    ptClass,
    ptClassForward,
    ptClassFunction,
    ptClassProcedure,
    ptColon,
    ptComma,
    ptComp,
    ptCompDirect,
    ptConst,
    ptConstructor,
    ptContains,
    ptCRLF,
    ptCRLFCo,
    ptCurrency,
    ptDefault,
    ptDefineDirect,
    ptDestructor,
    ptDispid,
    ptDispinterface,
    ptDiv,
    ptDo,
    ptDotDot,
    ptDouble,
    ptDoubleAddressOp,
    ptDownto,
    ptDWORD,
    ptDynamic,
    ptElse,
    ptElseDirect,
    ptEnd,
    ptEndIfDirect,
    ptEqual,
    ptError,
    ptExcept,
    ptExport,
    ptExports,
    ptExtended,
    ptExternal,
    ptFar,
    ptFile,
    ptFinalization,
    ptFinally,
    ptFloat,
    ptFor,
    ptForward,
    ptFunction,
    ptGoto,
    ptGreater,
    ptGreaterEqual,
    ptIdentifier,
    ptIf,
    ptIfDefDirect,
    ptIfNDefDirect,
    ptIfOptDirect,
    ptImplementation,
    ptImplements,
    ptIn,
    ptIncludeDirect,
    ptIndex,
    ptInherited,
    ptInitialization,
    ptInline,
    ptInt64,
    ptInteger,
    ptIntegerConst,
    ptInterface,
    ptInterfaceStart,
    ptIs,
    ptLabel,
    ptLibrary,
    ptLongBool,
    ptLongint,
    ptLongword,
    ptLower,
    ptLowerEqual,
    ptMessage,
    ptMinus,
    ptMod,
    ptName,
    ptNear,
    ptNil,
    ptNodefault,
    ptNone,
    ptNot,
    ptNotEqual,
    ptNull,
    ptObject,
    ptOf,
    ptOleVariant,
    ptOr,
    ptOut,
    ptOverload,
    ptOverride,
    ptPackage,
    ptPacked,
    ptPascal,
    ptPChar,
    ptPlus,
    ptPoint,
    ptPointerSymbol,
    ptPrivate,
    ptProcedure,
    ptProgram,
    ptProperty,
    ptProtected,
    ptPublic,
    ptPublished,
    ptRaise,
    ptRead,
    ptReadonly,
    ptReal,
    ptReal48,
    ptRecord,
    ptRegister,
    ptReintroduce,
    ptRepeat,
    ptRequires,
    ptResident,
    ptResourceDirect,
    ptResourcestring,
    ptRoundClose,
    ptRoundOpen,
    ptSafecall,
    ptSemiColon,
    ptSet,
    ptShl,
    ptShortint,
    ptShortString,
    ptShr,
    ptSingle,
    ptSlash,
    ptSlashesComment,
    ptSmallint,
    ptSpace,
    ptSquareClose,
    ptSquareOpen,
    ptStar,
    ptStdcall,
    ptStored,
    ptString,
    ptStringConst,
    ptStringresource,
    ptSymbol,
    ptTheEnd,
    ptThen,
    ptThreadvar,
    ptTo,
    ptTry,
    ptType,
    ptUndefDirect,
    ptUnit,
    ptUnknown,
    ptUntil,
    ptUses,
    ptVar,
    ptVariant,
    ptVirtual,
    ptWhile,
    ptWideString,
    ptWith,
    ptWord,
    ptWordBool,
    ptWrite,
    ptWriteonly,
    ptXor);

  TmwPasLexStatus = Record
    CommentState: TCommentState;
    ExID: TptTokenKind;
    LastIdentPos: Integer;
    LastNoJunk: TptTokenKind;
    LastNoJunkPos: Integer;
    LineNumber: Integer;
    LinePos: Integer;
    Origin: PChar;
    RunPos: Integer;
    TokenPos: Integer;
    TokenID: TptTokenKind;
  end;

function ptTokenName(Value: TptTokenKind): String;

implementation

function ptTokenName(Value: TptTokenKind): String;
begin
  result := GetEnumName(TypeInfo(TptTokenKind),Integer(Value));
end;

end.

