unit HSMDataModule;

interface

uses
  SysUtils, Classes, InferenceEngine, HSMMain, IEDialogs, IEInterfaces, IEConsts,
  IEFacts, Dialogs;

type
  TDataModule1 = class(TDataModule)
    InferenceEngine1: TInferenceEngine;
    ConsoleDialog1: TConsoleDialog;
    FactSet1: TFactSet;
    OpenDialog1: TOpenDialog;
    procedure DataModuleCreate(Sender: TObject);
    procedure InferenceEngine1PrintOut(Sender: TObject; OutID,
      Text: String);
    procedure InferenceEngine1Assertion(Sender: TObject;
      const Fact: IFact);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ItemIterated( Sender: TObject; Item: TMnemonic ); virtual;
    procedure Iterating( Sender: TObject ); virtual;
    procedure Iterated( Sender: TObject ); virtual;
  end;

var
  DataModule1: TDataModule1;

implementation

uses
    IEValue;

{$R *.dfm}

procedure TDataModule1.DataModuleCreate(Sender: TObject);
var
   i: Integer;
   NumSciMnems: Integer;
begin
     // at this point, the mnemonics have been created
     // create the metadata facts
     if not FileExists(EXPERT_SYSTEM) then
     begin
          OpenDialog1.FileName := EXPERT_SYSTEM;
          if OpenDialog1.Execute then
             InferenceEngine1.LoadFromFile(OpenDialog1.FileName)
          else
          begin
               ShowMessage('No Expert System Available');
               Monitor_On := False;
               Exit;
          end;
     end
     else
         InferenceEngine1.LoadFromFile(EXPERT_SYSTEM);
     // add some global variables the expert systems might need
     InferenceEngine1.GlobalVariables.Put('*NUM_SYS*', TIEValue.Create(Ord(High(TSystems))-1));
     InferenceEngine1.GlobalVariables.Put('*NUM_MNEM_PER_SYSTEM*', TIEValue.Create( MNEMONICS_PER_SYSTEM ));
     NumSciMnems := NUM_MNEMONICS-(MNEMONICS_PER_SYSTEM*Ord(High(TSystems)));
     InferenceEngine1.GlobalVariables.Put('*NUM_SCI_MNEMS*', TIEValue.Create(NumSciMnems));
     InferenceEngine1.GlobalVariables.Put('*SCI_BANDWIDTH*', TIEValue.Create(MNEMONICS_PER_SYSTEM*0.6/NumSciMnems));
     FactSet1.Engine := InferenceEngine1; // reattach fact set
     for i := 0 to frmHSM.Mnemonics.Count - 1 do
         with frmHSM.Mnemonics[i] do
         begin
              FactSet1.Facts.Add( Format( '(mnem-metadata (name %s)'+
              ' (yellowhigh %f) (redlow %f) (system %s) (redhigh %f) (yellowlow %f) (subsystem %s))',
              [Name, YellowHigh, RedLow, System, RedHigh, YellowLow, Subsystem] ));
         end;
     InferenceEngine1.Reset;
end;

procedure TDataModule1.ItemIterated(Sender: TObject; Item: TMnemonic);
begin
     InferenceEngine1.Assert(Format('(mnemonic (name %s) (value %f))', [Item.Name,Item.Value]))
end;

procedure TDataModule1.Iterated(Sender: TObject);
var
   i: Integer;
begin
     // all mnemonics have been asserted, run any rules
     if DEBUG_MONITOR_ON then
     begin
          frmHSM.IsSimRunning := False;
          ConsoleDialog1.Execute;
     end;
     InferenceEngine1.Run;
     // After Iteration, get rid of old mnemonics and all
     for i := InferenceEngine1.Facts.Count - 1 downto 0 do
         if (InferenceEngine1.Facts[i].Template.TemplateName = 'mnemonic') then
            InferenceEngine1.Facts.Delete(i);
end;

procedure TDataModule1.InferenceEngine1PrintOut(Sender: TObject; OutID,
  Text: String);
begin
     frmHSM.Log(Text);
end;

procedure TDataModule1.Iterating(Sender: TObject);
var
   i: Integer;
begin
     // before iterating, get rid of old alerts and warnings
     for i := InferenceEngine1.Facts.Count - 1 downto 0 do
         if (InferenceEngine1.Facts[i].Template.TemplateName <> 'mnemonic') and
            (InferenceEngine1.Facts[i].Template.TemplateName <> 'mnem-metadata') and
            (InferenceEngine1.Facts[i].Template.TemplateName <> 'Initial-Fact') then
            InferenceEngine1.Facts.Delete(i);
     for i := 0 to InferenceEngine1.FactSets.Count - 1 do
         if InferenceEngine1.FactSets[i] <> FactSet1 then
            InferenceEngine1.FactSets[i].Reset;
    // InferenceEngine1.Reset;
end;

procedure TDataModule1.InferenceEngine1Assertion(Sender: TObject;
  const Fact: IFact);
begin
     if Fact.Template.TemplateName = 'alert' then
        frmHSM.Alert(Trim(Fact.Value[SDefaultSlotName].ToString))
     else if Fact.Template.TemplateName = 'warning' then
        frmHSM.Alert(Trim(Fact.Value[SDefaultSlotName].ToString), True)
     else if Fact.Template.TemplateName = 'satellite-health' then
        frmHSM.Satellite(Fact.Value[SDefaultSlotName].AsList.Value[0].AsFloat);
end;

end.
