namespace NxBRE.FlowEngine.IO {
	using System;
	using System.IO;
	using System.Reflection;
	using System.Text;
	using System.Xml;
	using System.Xml.XPath;
	using System.Xml.Xsl;
	
	using NxBRE.Util;

	/// <summary>
	/// Driver for loading rules strings valid against xBusinessRules.xsd (simplified NxBRE grammar).
	/// The native NxBRE rules file will be generated by XSLT.
	/// </summary>
	/// <author>David Dossot</author>
	/// <remarks>
	///  xBusinessRules.xsd, transformXRules.xsl and businessRules.xsd must be included in the assembly.
	///  Thanks to Mohsin Ali Sheikh for having decided me to write it!
	/// </remarks>
	public class XBusinessRulesStringDriver : XBusinessRulesStreamDriver {
		
		public XBusinessRulesStringDriver(string xmlFragment):
			base(new MemoryStream(new UTF8Encoding().GetBytes(xmlFragment))) {}
		
	}
}
