namespace NxBRE.FlowEngine.IO {
	using System;
	using System.IO;
	using System.Text;
	using System.Xml;
	using System.Xml.XPath;
	using System.Xml.Xsl;
	
	using NxBRE.FlowEngine;
	using NxBRE.Util;

	/// <summary>
	/// Driver for loading rules streams valid against xBusinessRules.xsd (simplified NxBRE grammar).
	/// The native NxBRE rules file will be generated by XSLT.
	/// </summary>
	/// <author>David Dossot</author>
	public class XBusinessRulesStreamDriver : AbstractRulesDriver {
		Stream xmlStream;
		
		public XBusinessRulesStreamDriver(Stream xmlStream) {
			if (xmlStream == null) throw new BRERuleFatalException("Null is not a valid XML source");

			this.xmlStream = xmlStream;
		}
		
		protected override XmlReader GetReader() {
			//Loading the XSL file in a XSLTransform object
			XslCompiledTransform xslt = Xml.GetCachedCompiledTransform("transformXRules.xsl");
			
		 	//We have the xmlSource in hand, transform it to the native NXBRE XSD Format
			MemoryStream xsltResult = new MemoryStream();
			XmlReader xmlSourceReader = GetXmlInputReader(xmlStream, "xBusinessRules.xsd");
			
			xslt.Transform(new XPathDocument(xmlSourceReader), null, xsltResult);
			
			xmlSourceReader.Close();
			xsltResult.Seek(0, SeekOrigin.Begin);
			
			return GetXmlInputReader(xsltResult, "businessRules.xsd");
		}
	}
}
