//---------------------------------------------------------------------------

#ifndef IntelligenceV01H
#define IntelligenceV01H
//---------------------------------------------------------------------------

#include "IntelligenceInterface.h"

//	   v0.1
class CIntelligenceV01 : public IIntelligenceInterface01 {
public:
	typedef std::vector<unsigned int> TIoLimitsContainer;	//	     IO 
	//  receptorsLimits -     ,
	//	effectorsLimits -     
	CIntelligenceV01( const TIoLimitsContainer& receptorsLimits, const TIoLimitsContainer& effectorsLimits );
	//	IIntelligenceInterface01
	virtual void TimeStep( const TIoDataContainer& receptors, TIoDataContainer& effectors );

private:
	const TIoLimitsContainer receptorsLimits;
	const TIoLimitsContainer effectorsLimits;

	typedef std::vector<double> TDistributionType;	//	   
	typedef std::vector<TDistributionType> TDistributionsContainer;	//	   
	//	   
	struct CCluster {
		CCluster( int receptorsCount, int effectorsCount );

		TDistributionsContainer ReceptorsStatistics;
		TDistributionsContainer EffectorsStatistics;
		TDistributionType ContextStatistics;
		TDistributionType::value_type Weight;
		TDistributionType::value_type Expectation;
	};

	typedef std::vector<CCluster> TClustersContainer;
	TClustersContainer worldModel;
	TDistributionType context;
	TIoDataContainer prevStepEffectors;

	//	    
	struct CEffectorVariant {
		CEffectorVariant( TDistributionType::value_type likelihood, int testedStateIndex,
			TIoDataContainer::value_type variant );

		TDistributionType::value_type Likelihood;
		int TestedStateIndex;
		TIoDataContainer::value_type Variant;
	};

	//	 
	struct CEffectorVariantComparer : public std::binary_function<CEffectorVariant, CEffectorVariant, bool> {
		bool operator()( const CEffectorVariant& left, const CEffectorVariant& right ) const;
	};

	//	  
	typedef std::vector< std::priority_queue<CEffectorVariant, std::vector<CEffectorVariant>,
		CEffectorVariantComparer> > TVariantQueuesContainer;

	//	   
	typedef std::vector< std::vector<bool> > TVariantsContainer;
	class CEffectorsTestedState {
	public:
		CEffectorsTestedState( const TIoDataContainer& effectors, const TIoLimitsContainer& limits );
		//	  
		CEffectorsTestedState( CEffectorsTestedState& baseState,
			int effectorIndex, TIoDataContainer::value_type newVariant );
		const TIoDataContainer& Effectors() const { return effectors; }
		const TVariantsContainer& TestedVariants() const { return testedVariants; }

	private:
		TVariantsContainer testedVariants;	//	 
		TIoDataContainer effectors;	//	 
	};
	typedef std::vector<CEffectorsTestedState> TTestedStatesContainer;

	void calculateNextStepContext( const TIoDataContainer& receptors, TDistributionType& adArchive ) const;
	void updateStatistics( const TIoDataContainer& receptors, const TDistributionType& adArchive );
	void findBestReaction( const TDistributionType& adArchive, TIoDataContainer& effectors ) const;
	void prepareClustersLikelihoods( TDistributionType& clustersLikelihood,
		const TDistributionType& adArchive ) const;
	void prepareFirstApproximation( TIoDataContainer& firstApproximation,
		const TDistributionType& clustersLikelihood ) const;
	TIoDataContainer::value_type prepareVariant( TDistributionType& preservedLikelihoods,
		const TDistributionType& clustersLikelihood, const TIoDataContainer& firstApproximation ) const;
	void effectorVariantsGenerator( TVariantQueuesContainer& queues,
		const TDistributionType& preservedLikelihoods, const TTestedStatesContainer& lastState ) const;
};

inline CIntelligenceV01::CEffectorVariant::CEffectorVariant( TDistributionType::value_type likelihood,
	int testedStateIndex, TIoDataContainer::value_type variant ) :
	Likelihood( likelihood ), TestedStateIndex( testedStateIndex ), Variant( variant )
{
}

inline bool CIntelligenceV01::CEffectorVariantComparer::operator()(
	const CEffectorVariant& left, const CEffectorVariant& right) const
{
	return left.Likelihood < right.Likelihood;
}
#endif
