
S_START = 7fffffffh					;   
S_END = 80000000h					;   
S_STROKE = 800000007fffffffh		;  
BS_STROKE = 8000000080000000h		;     
BE_STROKE = 7fffffff7fffffffh		;     
D_STUB_S = 18h						;     
B_EMPTY = 0ffffffffffffffffh			;  

.CODE
 


;====================================================================================================
;===============					 ""  					=================
;====================================================================================================
andRleRegions	PROC
	push rbx						; 
	push rsi
	push r12
	push r13
	push r14
	push r15

	mov	rsi, r9						;    
	mov r9, r8						;   
	lea r8, [r8 + D_STUB_S]			;    


;========  RLE  ========
stripe_manage:						;   :   rcx  rdx,   r8  r9 
	xor rax, rax					;  
	cmp r8, rsi						;    
	jg	end_proc_fail				; 

	mov r12, r8						;   
	mov r15, r9						;    
	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]
	xor r13, r13					;    
	xor r14, r14
	cmp r10d, r11d					;  
	cmovg r10d, r11d
	cmovg r13, rcx					;    
	cmovl r14, rdx
	mov dword ptr [r8], r10d		;  

	mov r10, S_STROKE				;  
	mov qword ptr[r8 + 4], r10
	lea r8, [r8 + 12]				;   
	lea rcx, [rcx + 12]
	lea rdx, [rdx + 12]
	lea r9, [r9 + 12]

	mov	r10, qword ptr [rcx]		;    rcx
	cmp	r10d, S_START				;    
	je	stroke_1_test				; 

	mov	r11, qword ptr [rdx]		;    rdx
	cmp	r11d, S_START				;    
	jne	stroke_manage				;  
	jmp end_1_preparation			;  - r11

stroke_1_test:						;      
	cmp	dword ptr [rdx], S_START	;    
	jne	end_0_preparation			;  - r10

	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	lea rdx, [rdx + 8]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	jmp end_stripe_manage			;  


;========  RLE    ========
stroke_manage:						;     r10  r11 (  rcx  rdx)
	test rax, rax					;  
	jnz no_test_stroke_manage		;    
	cmp r10d, r11d					;  
	jl	found_1_begin				;    

found_0_begin:						;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	found_01_stroke				;    

found_00_stroke:					;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp save_0_stroke

found_01_stroke:					;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge load_1_stroke				;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

save_1_stroke:						;   r11
	mov	qword ptr [r8], r11			; 
	lea	r8, [r8 + 8]				;     
	xor	r11, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r11					;  

load_1_stroke:						;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp	r11d, S_START				;    
	jne	stroke_manage				;  
	jmp end_1_preparation			; 

found_1_begin:						;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	found_10_stroke				;    
	
found_11_stroke:					;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp save_1_stroke				; 

found_10_stroke:					;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge load_0_stroke				;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

save_0_stroke:						;   r10
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;     
	xor	r10, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r10					;  

load_0_stroke:						;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp	r10d, S_START				;    
	jne	stroke_manage				;  

;========   RLE  ========
end_0_preparation:					;  RLE      rcx
	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz end_stripe_manage			;     

end_0_iteration:					;   
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_START	
	jne end_0_iteration				;   rdx
	lea rdx, [rdx + 8]				;   
	jmp end_stripe_manage
	
end_1_preparation:					;  RLE      rdx
	lea rdx, [rdx + 8]				;   
	test r14, r14
	cmovnz rdx, r14					;     
	
	test r13, r13					
	cmovnz rcx, r13					;     
	jnz end_stripe_manage			;     

end_1_iteration:					;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_START	
	jne end_1_iteration				;   rcx
	lea rcx, [rcx + 8]				;   
	
end_stripe_manage:					;  RLE
	mov r10, S_STROKE				;  

	test rax, rax					;  
	jnz go_to_next_stripe			;  
	cmp	r10, qword ptr [r9]			; 
	jne go_to_next_stripe			;  

	mov r11d, dword ptr [r12]		;   
	mov r8, r12						;    
	mov dword ptr [r15], r11d		;   
	cmp r11d, S_START				;  
	je end_proc
	mov r9, r15						;   
	jmp stripe_manage

go_to_next_stripe:					;      
	mov	qword ptr [r8], r10			;  
	lea	r8, [r8 + 8]				;    
	cmp dword ptr [r12], S_START	;  
	je end_proc
	mov r9, r12						;   
	jmp stripe_manage

;========  RLE    ========
no_test_stroke_manage:				;     r10  r11 (  rcx  rdx)
	lea r9, [r9 + 8]				;    
	cmp r10d, r11d					;  
	jl	no_test_found_1_begin		;    

no_test_found_0_begin:				;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	no_test_found_01_stroke		;    

no_test_found_00_stroke:			;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp no_test_save_0_stroke		; 

no_test_found_01_stroke:			;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge no_test_load_1_stroke		;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

no_test_save_1_stroke:				;   r11
	mov	qword ptr [r8], r11			; 
	lea	r8, [r8 + 8]				;     

no_test_load_1_stroke:				;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp	r11d, S_START				;    
	jne	no_test_stroke_manage		;  
	jmp no_test_end_1_preparation	; 

no_test_found_1_begin:				;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	no_test_found_10_stroke		;    
	
no_test_found_11_stroke:			;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp no_test_save_1_stroke		; 

no_test_found_10_stroke:			;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge no_test_load_0_stroke		;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

no_test_save_0_stroke:				;   r10
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;     

no_test_load_0_stroke:				;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp	r10d, S_START				;    
	jne	no_test_stroke_manage		;  

;========   RLE    ========
no_test_end_0_preparation:			;  RLE      rcx
	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz no_test_end_stripe_manage	;     

no_test_end_0_iteration:			;   
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_START	
	jne no_test_end_0_iteration		;   rdx
	lea rdx, [rdx + 8]				;   
	jmp no_test_end_stripe_manage
	
no_test_end_1_preparation:			;  RLE      rdx  
	lea rdx, [rdx + 8]				;   
	test r14, r14
	cmovnz rdx, r14					;     
	
	test r13, r13					
	cmovnz rcx, r13					;     
	jnz no_test_end_stripe_manage	;     

no_test_end_1_iteration:			;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_START	
	jne no_test_end_1_iteration		;   rcx
	lea rcx, [rcx + 8]				;   
	
no_test_end_stripe_manage:			;  RLE
	mov r10, S_STROKE				;  
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;    
	mov r9, r12						;   

	cmp dword ptr [r12], S_START	;  
	jne stripe_manage

end_proc:							; 
	mov rax, r8						;   
end_proc_fail:
	pop r15							; 
	pop r14
	pop r13
	pop r12
	pop rsi
	pop rbx
	ret

andRleRegions	ENDP



;====================================================================================================
;===============				 ""  					=================
;====================================================================================================
greaterRleRegions	PROC
	push rbx						; 
	push rsi
	push r12
	push r13
	push r14
	push r15

	mov	rsi, r9						;    
	mov r9, r8						;   
	lea r8, [r8 + D_STUB_S]			;    


;========  RLE  ========
stripe_manage:						;   :   rcx  rdx,   r8  r9 
	xor rax, rax					;  
	cmp r8, rsi						;    
	jg	end_proc_fail				; 

	mov r12, r8						;   
	mov r15, r9						;    
	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]
	xor r13, r13					;    
	xor r14, r14
	cmp r10d, r11d					;  
	cmovg r10d, r11d
	cmovg r13, rcx					;    
	cmovl r14, rdx
	mov dword ptr [r8], r10d		;  

	mov r10, S_STROKE				;  
	mov qword ptr[r8 + 4], r10
	lea r8, [r8 + 12]				;   
	lea rcx, [rcx + 12]
	lea rdx, [rdx + 8]
	lea r9, [r9 + 12]

	mov	r10, qword ptr [rcx]		;    rcx
	cmp	r10d, S_START				;    
	je	end_0_preparation			;  - r10

	mov rbx, BS_STROKE				;   
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11, rbx					;    
	jne stroke_manage
	lea rdx, [rdx + 8]				;     
	mov	r11, qword ptr [rdx]		
	cmp r11d, S_START				;    
	je	end_1_stripe_manage			;  - r11


;========  RLE    ========
stroke_manage:						;     r10  r11 (  rcx  rdx)
	test rax, rax					;  
	jnz no_test_stroke_manage		;    
	cmp r10d, r11d					;  
	jl	found_1_begin				;    

found_0_begin:						;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	found_01_stroke				;    

found_00_stroke:					;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp save_0_stroke

found_01_stroke:					;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge load_1_stroke				;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

save_1_stroke:						;   r11
	mov	qword ptr [r8], r11			; 
	lea	r8, [r8 + 8]				;     
	xor	r11, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r11					;  

load_1_stroke:						;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11d, S_START				;    
	je	end_1_stripe_manage			; 
	cmp	r11d, S_END					;    
	jne	stroke_manage				;  
	jmp end_1_preparation			; 

found_1_begin:						;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	found_10_stroke				;    
	
found_11_stroke:					;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp save_1_stroke				; 

found_10_stroke:					;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge load_0_stroke				;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

save_0_stroke:						;   r10
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;     
	xor	r10, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r10					;  

load_0_stroke:						;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp	r10d, S_START				;    
	jne	stroke_manage				;  

;========   RLE  ========
end_0_preparation:					;  RLE      rcx
	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz end_stripe_manage			;     

end_0_iteration:					;   
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_END	
	jne end_0_iteration				;   rdx
	lea rdx, [rdx + 4]				;   
	jmp end_stripe_manage

end_1_stripe_manage:				;  RLE       r11
	lea rdx, [rdx + 8]

end_1_preparation:					;  RLE      rdx
	lea rdx, [rdx + 4]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz end_stripe_manage			;     

end_1_iteration:					;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_START	
	jne end_1_iteration				;   rcx
	lea rcx, [rcx + 8]				;   
	
end_stripe_manage:					;  RLE
	mov r10, S_STROKE				;  

	test rax, rax					;  
	jnz go_to_next_stripe			;  
	cmp	r10, qword ptr [r9]			; 
	jne go_to_next_stripe			;  

	mov r11d, dword ptr [r12]		;   
	mov r8, r12						;    
	mov dword ptr [r15], r11d		;   
	cmp r11d, S_START				;  
	je end_proc
	mov r9, r15						;   
	jmp stripe_manage

go_to_next_stripe:					;      
	mov	qword ptr [r8], r10			;  
	lea	r8, [r8 + 8]				;    
	cmp dword ptr [r12], S_START	;  
	je end_proc
	mov r9, r12						;   
	jmp stripe_manage

;========  RLE    ========
no_test_stroke_manage:				;     r10  r11 (  rcx  rdx)
	lea r9, [r9 + 8]				;    
	cmp r10d, r11d					;  
	jl	no_test_found_1_begin		;    

no_test_found_0_begin:				;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	no_test_found_01_stroke		;    

no_test_found_00_stroke:			;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp no_test_save_0_stroke		; 

no_test_found_01_stroke:			;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge no_test_load_1_stroke		;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

no_test_save_1_stroke:				;   r11
	mov	qword ptr [r8], r11			; 
	lea	r8, [r8 + 8]				;     

no_test_load_1_stroke:				;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11d, S_START				;    
	je	no_test_end_1_stripe_manage	; 
	cmp	r11d, S_END					;    
	jne	no_test_stroke_manage		;  
	jmp no_test_end_1_preparation	; 

no_test_found_1_begin:				;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	no_test_found_10_stroke		;    
	
no_test_found_11_stroke:			;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp no_test_save_1_stroke		; 

no_test_found_10_stroke:			;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge no_test_load_0_stroke		;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

no_test_save_0_stroke:				;   r10
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;     

no_test_load_0_stroke:				;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp	r10d, S_START				;    
	jne	no_test_stroke_manage		;  

;========   RLE    ========
no_test_end_0_preparation:			;  RLE      rcx
	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz no_test_end_stripe_manage	;     

no_test_end_0_iteration:			;   
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_END	
	jne no_test_end_0_iteration		;   rdx
	lea rdx, [rdx + 4]
	jmp no_test_end_stripe_manage

no_test_end_1_stripe_manage:		;  RLE       r11
	lea rdx, [rdx + 8]
	
no_test_end_1_preparation:			;  RLE      rdx  
	lea rdx, [rdx + 4]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz no_test_end_stripe_manage	;     

no_test_end_1_iteration:			;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_START	
	jne no_test_end_1_iteration		;   rcx
	lea rcx, [rcx + 8]
	
no_test_end_stripe_manage:			;  RLE
	mov r10, S_STROKE				;  
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;    
	mov r9, r12						;   

	cmp dword ptr [r12], S_START	;  
	jne stripe_manage

end_proc:							; 
	mov rax, r8						;   
end_proc_fail:
	pop r15							; 
	pop r14
	pop r13
	pop r12
	pop rsi
	pop rbx
	ret

greaterRleRegions	ENDP



;====================================================================================================
;===============				   " "  				=================
;====================================================================================================
orNotRleRegions	PROC
	push rbx						; 
	push rsi
	push r12
	push r13
	push r14
	push r15

	mov	rsi, r9						;    
	mov r9, r8						;   
	lea r8, [r8 + D_STUB_S]			;    


;========  RLE  ========
stripe_manage:						;   :   rcx  rdx,   r8  r9 
	xor rax, rax					;  
	cmp r8, rsi						;    
	jg	end_proc_fail				; 

	mov r12, r8						;   
	mov r15, r9						;    
	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]
	xor r13, r13					;    
	xor r14, r14
	cmp r10d, r11d					;  
	cmovg r10d, r11d
	cmovg r13, rcx					;    
	cmovl r14, rdx
	mov dword ptr [r8], r10d		;  

	mov r10, S_STROKE				;  
	mov qword ptr[r8 + 4], r10
	lea r8, [r8 + 12]				;   
	lea rcx, [rcx + 8]
	lea rdx, [rdx + 8]
	lea r9, [r9 + 12]

	mov rbx, BS_STROKE				;   
	mov	r10, qword ptr [rcx]		;    rcx
	cmp r10, rbx					;    
	jne stroke_1_load
	lea rcx, [rcx + 8]				;     
	mov	r10, qword ptr [rcx]		
	cmp r10d, S_START				;    
	je	end_0_stripe_manage			;  - r10

stroke_1_load:						
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11, rbx					;    
	jne stroke_manage
	lea rdx, [rdx + 8]				;     
	mov	r11, qword ptr [rdx]		
	cmp r11d, S_START				;    
	je	end_1_stripe_manage			;  - r11


;========  RLE    ========
stroke_manage:						;     r10  r11 (  rcx  rdx)
	test rax, rax					;  
	jnz no_test_stroke_manage		;    
	cmp r10d, r11d					;  
	jl	found_1_begin				;    

found_0_begin:						;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	found_01_stroke				;    

found_00_stroke:					;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp save_0_stroke

found_01_stroke:					;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge load_1_stroke				;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

save_1_stroke:						;   r11
	mov	qword ptr [r8], r11			; 
	lea	r8, [r8 + 8]				;     
	xor	r11, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r11					;  

load_1_stroke:						;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11d, S_START				;    
	je	end_1_stripe_manage			; 
	cmp	r11d, S_END					;    
	jne	stroke_manage				;  
	jmp end_1_preparation			; 

found_1_begin:						;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	found_10_stroke				;    
	
found_11_stroke:					;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp save_1_stroke				; 

found_10_stroke:					;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge load_0_stroke				;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

save_0_stroke:						;   r10
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;     
	xor	r10, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r10					;  

load_0_stroke:						;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp r10d, S_START				;    
	je	end_0_stripe_manage			; 
	cmp	r10d, S_END					;    
	jne	stroke_manage				;  
	jmp end_0_preparation			; 


;========   RLE  ========
end_0_stripe_manage:				;  RLE       r10
	lea rcx, [rcx + 8]

end_0_preparation:					;  RLE      rcx
	lea rcx, [rcx + 4]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz	end_stripe_manage			;     

end_0_iteration:					;   	
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_END	
	jne end_0_iteration				;   rdx
	lea rdx, [rdx + 4]				;   
	jmp end_stripe_manage

end_1_stripe_manage:				;  RLE       r11
	lea rdx, [rdx + 8]			

end_1_preparation:					;  RLE      rdx
	lea rdx, [rdx + 4]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz	end_stripe_manage			;     

end_1_iteration:					;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_END	
	jne end_1_iteration				;   rcx
	lea rcx, [rcx + 4]				;   
	
end_stripe_manage:					;  RLE
	mov r10, S_STROKE				;  

	test rax, rax					;  
	jnz go_to_next_stripe			;  
	cmp	r10, qword ptr [r9]			; 
	jne go_to_next_stripe			;  

	mov r11d, dword ptr [r12]		;   
	mov r8, r12						;    
	mov dword ptr [r15], r11d		;   
	cmp r11d, S_START				;  
	je end_proc
	mov r9, r15						;   
	jmp stripe_manage

go_to_next_stripe:					;      
	mov	qword ptr [r8], r10			;  
	lea	r8, [r8 + 8]				;    
	cmp dword ptr [r12], S_START	;  
	je end_proc
	mov r9, r12						;   
	jmp stripe_manage


;========  RLE    ========
no_test_stroke_manage:				;     r10  r11 (  rcx  rdx)
	cmp r10d, r11d					;  
	jl	no_test_found_1_begin		;    

no_test_found_0_begin:				;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	no_test_found_01_stroke		;    

no_test_found_00_stroke:			;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp no_test_save_0_stroke		; 

no_test_found_01_stroke:			;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge no_test_load_1_stroke		;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

no_test_save_1_stroke:				;   r11
	mov	qword ptr [r8], r11			; 
	lea	r8, [r8 + 8]				;     

no_test_load_1_stroke:				;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11d, S_START				;    
	je	no_test_end_1_stripe_manage	; 
	cmp	r11d, S_END					;    
	jne	no_test_stroke_manage		;  
	jmp no_test_end_1_preparation	; 

no_test_found_1_begin:				;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	no_test_found_10_stroke		;    
	
no_test_found_11_stroke:			;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp no_test_save_1_stroke		; 

no_test_found_10_stroke:			;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge no_test_load_0_stroke		;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

no_test_save_0_stroke:				;   r10
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;     

no_test_load_0_stroke:				;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp r10d, S_START				;    
	je	no_test_end_0_stripe_manage	; 
	cmp	r10d, S_END					;    
	jne	no_test_stroke_manage		;  
	jmp no_test_end_0_preparation	; 


;========   RLE    ========
no_test_end_0_stripe_manage:		;  RLE       r10
	lea rcx, [rcx + 8]

no_test_end_0_preparation:			;  RLE      rcx
	lea rcx, [rcx + 4]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz	no_test_end_stripe_manage	;     

no_test_end_0_iteration:			;   	
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_END	
	jne no_test_end_0_iteration		;   rdx
	lea rdx, [rdx + 4]				;   
	jmp no_test_end_stripe_manage

no_test_end_1_stripe_manage:		;  RLE       r11
	lea rdx, [rdx + 8]
	
no_test_end_1_preparation:			;  RLE      rdx
	lea rdx, [rdx + 4]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz	no_test_end_stripe_manage	;     

no_test_end_1_iteration:			;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_END	
	jne no_test_end_1_iteration		;   rcx
	lea rcx, [rcx + 4]				;   
	
no_test_end_stripe_manage:			;  RLE
	mov r10, S_STROKE				;  
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;    
	mov r9, r12						;   

	cmp dword ptr [r12], S_START	;  
	jne stripe_manage

end_proc:							; 
	mov rax, r8						;   
end_proc_fail:
	pop r15							; 
	pop r14
	pop r13
	pop r12
	pop rsi
	pop rbx
	ret

orNotRleRegions	ENDP



;====================================================================================================
;===============				   " "  					=================
;====================================================================================================
andNotRleRegions	PROC
	push rbx						; 
	push rsi
	push r12
	push r13
	push r14
	push r15

	mov	rsi, r9						;    
	mov r9, r8						;   
	lea r8, [r8 + D_STUB_S]			;    


;========  RLE  ========
stripe_manage:						;   :   rcx  rdx,   r8  r9 
	xor rax, rax					;  
	cmp r8, rsi						;    
	jg	end_proc_fail				; 

	mov r12, r8						;   
	mov r15, r9						;    
	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]
	xor r13, r13					;    
	xor r14, r14
	cmp r10d, r11d					;  
	cmovg r10d, r11d
	cmovg r13, rcx					;    
	cmovl r14, rdx
	mov dword ptr [r8], r10d		;  

	mov dword ptr[r8 + 4], S_START	;   
	lea r8, [r8 + 8]				;   
	lea rcx, [rcx + 12]
	lea rdx, [rdx + 12]
	lea r9, [r9 + 8]

	mov	r10, qword ptr [rcx]		;    rcx
	cmp	r10d, S_START				;    
	je	stroke_1_test				; 

	mov	r11, qword ptr [rdx]		;    rdx
	cmp	r11d, S_START				;    
	jne	bad_stroke_query			;  

	mov rbx, BS_STROKE				;   
	mov	qword ptr [r8], rbx			;  
	mov	rax, rbx					;   
	lea	r8, [r8 + 8]				;     
	xor	rax, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	jmp end_1_preparation			;  - r11

stroke_1_test:						;      
	mov rbx, BS_STROKE				;   
	mov	qword ptr [r8], rbx			;  
	mov	rax, rbx					;   
	lea	r8, [r8 + 8]				;     
	xor	rax, qword ptr [r9]			;   
	lea r9, [r9 + 8]				;    

	cmp	dword ptr [rdx], S_START	;    
	jne	end_0_preparation			;  - r10

	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	lea rdx, [rdx + 8]				;   
	test r14, r14					
	cmovnz rdx, r14					;     

	jmp end_bad_addition			;  

bad_stroke_query:					;    
	cmp r10d, S_END					;      
	jne add_bad_stroke				;  
	cmp r11d, S_END					;      
	je	stroke_manage

add_bad_stroke:						;  
	mov rbx, BS_STROKE				;   
	mov	qword ptr [r8], rbx			;  
	mov	rax, rbx					;   
	lea	r8, [r8 + 8]				;     
	xor	rax, qword ptr [r9]			;   
	lea r9, [r9 + 8]				;    


;========  RLE    ========
stroke_manage:						;     r10  r11 (  rcx  rdx)
	test rax, rax					;  
	jnz no_test_stroke_manage		;    
	cmp r10d, r11d					;  
	jl	found_1_begin				;    

found_0_begin:						;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	found_01_stroke				;    

found_00_stroke:					;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp save_0_stroke

found_01_stroke:					;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge load_1_stroke				;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

save_1_stroke:						;   r11
	mov	qword ptr [r8], r11			; 
	mov rbx, r11					;       
	lea	r8, [r8 + 8]				;     
	xor	r11, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r11					;  

load_1_stroke:						;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp	r11d, S_START				;    
	jne	stroke_manage				;  
	jmp end_1_preparation			; 

found_1_begin:						;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	found_10_stroke				;    
	
found_11_stroke:					;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp save_1_stroke				; 

found_10_stroke:					;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge load_0_stroke				;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

save_0_stroke:						;   r10
	mov	qword ptr [r8], r10			; 
	mov rbx, r10					;       
	lea	r8, [r8 + 8]				;     
	xor	r10, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r10					;  

load_0_stroke:						;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp	r10d, S_START				;    
	jne	stroke_manage				;  

;========   RLE  ========
end_0_preparation:
	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz	end_bad_query				;     

end_0_iteration:					;   	
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_START	
	jne end_0_iteration				;   rdx
	lea rdx, [rdx + 8]				;   
	jmp end_bad_query

end_1_preparation:
	lea rdx, [rdx + 8]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz	end_bad_query				;     

end_1_iteration:					;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_START	
	jne end_1_iteration				;   rcx
	lea rcx, [rcx + 8]				;   

end_bad_query:
	shr	rbx, 20h					;    
	cmp ebx, S_START
	je end_stripe_manage			;  

end_bad_addition:
	mov rbx, BE_STROKE				;     
	mov	qword ptr [r8], rbx			;  
	lea	r8, [r8 + 8]				;     
	test rax, rax					;  
	jne end_stripe_manage			;  
	mov	rax, rbx					;   
	xor	rax, qword ptr [r9]			;   
	
end_stripe_manage:					;  RLE
	test rax, rax					;  
	jnz go_to_next_stripe			;  

	mov r11d, dword ptr [r12]		;   
	mov r8, r12						;    
	mov dword ptr [r15], r11d		;   
	cmp r11d, S_START				;  
	je end_proc
	mov r9, r15						;   
	jmp stripe_manage

go_to_next_stripe:
	mov	dword ptr [r8], S_END		; 
	lea r8, [r8 + 4]
	cmp dword ptr [r12], S_START	;  
	je end_proc
	mov r9, r12						;   
	jmp stripe_manage


;========  RLE    ========
no_test_stroke_manage:				;     r10  r11 (  rcx  rdx)
	cmp r10d, r11d					;  
	jl	no_test_found_1_begin		;    

no_test_found_0_begin:				;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	no_test_found_01_stroke		;    

no_test_found_00_stroke:			;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp no_test_save_0_stroke		; 

no_test_found_01_stroke:			;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge no_test_load_1_stroke		;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

no_test_save_1_stroke:				;   r11
	mov	qword ptr [r8], r11			; 
	mov rbx, r11					;       
	lea	r8, [r8 + 8]				;     

no_test_load_1_stroke:				;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp	r11d, S_START				;    
	jne	no_test_stroke_manage		;  
	jmp no_test_end_1_preparation	; 

no_test_found_1_begin:				;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	no_test_found_10_stroke		;    
	
no_test_found_11_stroke:			;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp no_test_save_1_stroke		; 

no_test_found_10_stroke:			;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge no_test_load_0_stroke		;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

no_test_save_0_stroke:				;   r10
	mov	qword ptr [r8], r10			; 
	mov rbx, r10					;       
	lea	r8, [r8 + 8]				;     

no_test_load_0_stroke:				;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp	r10d, S_START				;    
	jne	no_test_stroke_manage		;  

;========   RLE    ========
no_test_end_0_preparation:
	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz	no_test_end_bad_query		;     

no_test_end_0_iteration:			;   	
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_START	
	jne no_test_end_0_iteration		;   rdx
	lea rdx, [rdx + 8]				;   
	jmp no_test_end_bad_query
	
no_test_end_1_preparation:
	lea rdx, [rdx + 8]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz	no_test_end_bad_query		;     

no_test_end_1_iteration:			;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_START	
	jne no_test_end_1_iteration		;   rcx
	lea rcx, [rcx + 8]				;   
	
no_test_end_bad_query:
	shr	rbx, 20h					;    
	cmp ebx, S_START
	je no_test_end_stripe_manage	;  

no_test_end_bad_addition:
	mov rbx, BE_STROKE				;     
	mov	qword ptr [r8], rbx			;  
	lea	r8, [r8 + 8]				;     

no_test_end_stripe_manage:			;  RLE
	mov	dword ptr [r8], S_END		; 
	lea	r8, [r8 + 4]				;    
	mov r9, r12						;   

	cmp dword ptr [r12], S_START	;  
	jne stripe_manage

end_proc:							; 
	mov rax, r8						;   
end_proc_fail:
	pop r15							; 
	pop r14
	pop r13
	pop r12
	pop rsi
	pop rbx
	ret

andNotRleRegions	ENDP



;====================================================================================================
;===============			 "  "  				=================
;====================================================================================================
orLessEqualRegions	PROC
	push rbx						; 
	push rsi
	push r12
	push r13
	push r14
	push r15

	mov	rsi, r9						;    
	mov r9, r8						;   
	lea r8, [r8 + D_STUB_S]			;    


;========  RLE  ========
stripe_manage:						;   :   rcx  rdx,   r8  r9 
	xor rax, rax					;  
	cmp r8, rsi						;    
	jg	end_proc_fail				; 

	mov r12, r8						;   
	mov r15, r9						;    
	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]
	xor r13, r13					;    
	xor r14, r14
	cmp r10d, r11d					;  
	cmovg r10d, r11d
	cmovg r13, rcx					;    
	cmovl r14, rdx
	mov dword ptr [r8], r10d		;  

	mov dword ptr[r8 + 4], S_START	;   
	lea r8, [r8 + 8]				;   
	lea rcx, [rcx + 12]
	lea rdx, [rdx + 8]
	lea r9, [r9 + 8]

	mov rbx, BS_STROKE				;   
	mov	r10, qword ptr [rcx]		;    rcx
	cmp	r10d, S_START				;    
	jne	stroke_1_load				;  ,  

	mov	qword ptr [r8], rbx			;  
	mov	rax, rbx					;   
	lea	r8, [r8 + 8]				;     
	xor	rax, qword ptr [r9]			;   
	lea r9, [r9 + 8]				;    
	jmp	end_0_preparation

stroke_1_load:						
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11, rbx					;    
	jne bad_stroke_query			;  ,  
	lea rdx, [rdx + 8]				;     
	mov	r11, qword ptr [rdx]		
	cmp r11d, S_START				;    
	jne	add_bad_stroke				;  ,  

	mov	qword ptr [r8], rbx			;  
	mov	rax, rbx					;   
	lea	r8, [r8 + 8]				;     
	xor	rax, qword ptr [r9]			;   
	lea r9, [r9 + 8]				;    
	jmp	end_1_stripe_manage

bad_stroke_query:					;    
	cmp r10d, S_END					;      
	je stroke_manage

add_bad_stroke:						;  
	mov rbx, BS_STROKE				;   
	mov	qword ptr [r8], rbx			;  
	mov	rax, rbx					;   
	lea	r8, [r8 + 8]				;     
	xor	rax, qword ptr [r9]			;   
	lea r9, [r9 + 8]				;    


;========  RLE    ========
stroke_manage:						;     r10  r11 (  rcx  rdx)
	test rax, rax					;  
	jnz no_test_stroke_manage		;    
	cmp r10d, r11d					;  
	jl	found_1_begin				;    

found_0_begin:						;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	found_01_stroke				;    

found_00_stroke:					;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp save_0_stroke

found_01_stroke:					;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge load_1_stroke				;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

save_1_stroke:						;   r11
	mov	qword ptr [r8], r11			; 
	mov rbx, r11					;       
	lea	r8, [r8 + 8]				;     
	xor	r11, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r11					;  

load_1_stroke:						;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11d, S_START				;    
	je	end_1_stripe_manage			; 
	cmp	r11d, S_END					;    
	jne	stroke_manage				;  
	jmp end_1_preparation			; 

found_1_begin:						;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	found_10_stroke				;    
	
found_11_stroke:					;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp save_1_stroke				; 

found_10_stroke:					;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge load_0_stroke				;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

save_0_stroke:						;   r10
	mov	qword ptr [r8], r10			; 
	mov rbx, r10					;       
	lea	r8, [r8 + 8]				;     
	xor	r10, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r10					;  

load_0_stroke:						;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp r10d, S_START				;    
	jne	stroke_manage				;  

;========   RLE  ========
end_0_preparation:
	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz	end_bad_query				;     

end_0_iteration:					;   	
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_END	
	jne end_0_iteration				;   rdx
	lea rdx, [rdx + 4]				;   
	jmp end_bad_query

end_1_stripe_manage:				;  RLE       r11
	lea rdx, [rdx + 8]

end_1_preparation:
	lea rdx, [rdx + 4]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz	end_bad_query				;     

end_1_iteration:					;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_START	
	jne end_1_iteration				;   rcx
	lea rcx, [rcx + 8]				;   

end_bad_query:
	shr	rbx, 20h					;    
	cmp ebx, S_START
	je end_stripe_manage			;  

end_bad_addition:
	mov rbx, BE_STROKE				;     
	mov	qword ptr [r8], rbx			;  
	lea	r8, [r8 + 8]				;     
	test rax, rax					;  
	jne end_stripe_manage			;  
	mov	rax, rbx					;   
	xor	rax, qword ptr [r9]			;   
	
end_stripe_manage:					;  RLE
	test rax, rax					;  
	jnz go_to_next_stripe			;  

	mov r11d, dword ptr [r12]		;   
	mov r8, r12						;    
	mov dword ptr [r15], r11d		;   
	cmp r11d, S_START				;  
	je end_proc
	mov r9, r15						;   
	jmp stripe_manage

go_to_next_stripe:
	mov	dword ptr [r8], S_END		; 
	lea r8, [r8 + 4]
	cmp dword ptr [r12], S_START	;  
	je end_proc
	mov r9, r12						;   
	jmp stripe_manage


;========  RLE    ========
no_test_stroke_manage:				;     r10  r11 (  rcx  rdx)
	cmp r10d, r11d					;  
	jl	no_test_found_1_begin		;    

no_test_found_0_begin:				;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	no_test_found_01_stroke		;    

no_test_found_00_stroke:			;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp no_test_save_0_stroke		; 

no_test_found_01_stroke:			;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge no_test_load_1_stroke		;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

no_test_save_1_stroke:				;   r11
	mov	qword ptr [r8], r11			; 
	mov rbx, r11					;       
	lea	r8, [r8 + 8]				;     

no_test_load_1_stroke:				;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11d, S_START				;    
	je	no_test_end_1_stripe_manage	; 
	cmp	r11d, S_END					;    
	jne	no_test_stroke_manage		;  
	jmp no_test_end_1_preparation	; 

no_test_found_1_begin:				;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	no_test_found_10_stroke		;    
	
no_test_found_11_stroke:			;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp no_test_save_1_stroke		; 

no_test_found_10_stroke:			;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge no_test_load_0_stroke		;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

no_test_save_0_stroke:				;   r10
	mov	qword ptr [r8], r10			; 
	mov rbx, r10					;       
	lea	r8, [r8 + 8]				;     

no_test_load_0_stroke:				;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp r10d, S_START				;    
	jne	no_test_stroke_manage		;  

;========   RLE    ========
no_test_end_0_preparation:
	lea rcx, [rcx + 8]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz	no_test_end_bad_query		;     

no_test_end_0_iteration:			;   	
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_END	
	jne no_test_end_0_iteration		;   rdx
	lea rdx, [rdx + 4]				;   
	jmp no_test_end_bad_query
	
no_test_end_1_stripe_manage:		;  RLE       r11
	lea rdx, [rdx + 8]

no_test_end_1_preparation:
	lea rdx, [rdx + 4]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz	no_test_end_bad_query		;     

no_test_end_1_iteration:			;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_END	
	jne no_test_end_1_iteration		;   rcx
	lea rcx, [rcx + 8]				;   
	
no_test_end_bad_query:
	shr	rbx, 20h					;    
	cmp ebx, S_START
	je no_test_end_stripe_manage	;  

no_test_end_bad_addition:
	mov rbx, BE_STROKE				;     
	mov	qword ptr [r8], rbx			;  
	lea	r8, [r8 + 8]				;     

no_test_end_stripe_manage:			;  RLE
	mov	dword ptr [r8], S_END		; 
	lea	r8, [r8 + 4]				;    
	mov r9, r12						;   

	cmp dword ptr [r12], S_START	;  
	jne stripe_manage

end_proc:							; 
	mov rax, r8						;   
end_proc_fail:
	pop r15							; 
	pop r14
	pop r13
	pop r12
	pop rsi
	pop rbx
	ret

orLessEqualRegions	ENDP



;====================================================================================================
;===============				   ""  					=================
;====================================================================================================
orRleRegions	PROC
	push rbx						; 
	push rsi
	push r12
	push r13
	push r14
	push r15

	mov	rsi, r9						;    
	mov r9, r8						;   
	lea r8, [r8 + D_STUB_S]			;    


;========  RLE  ========
stripe_manage:						;   :   rcx  rdx,   r8  r9 
	xor rax, rax					;  
	cmp r8, rsi						;    
	jg	end_proc_fail				; 

	mov r12, r8						;   
	mov r15, r9						;    
	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]
	xor r13, r13					;    
	xor r14, r14
	cmp r10d, r11d					;  
	cmovg r10d, r11d
	cmovg r13, rcx					;    
	cmovl r14, rdx
	mov dword ptr [r8], r10d		;  

	mov dword ptr[r8 + 4], S_START	;   
	lea r8, [r8 + 8]				;   
	lea rcx, [rcx + 8]
	lea rdx, [rdx + 8]
	lea r9, [r9 + 8]

	mov rbx, BS_STROKE				;   
	mov	r10, qword ptr [rcx]		;    rcx
	cmp r10, rbx					;    
	jne stroke_1_load				;  ,  
	lea rcx, [rcx + 8]				;     
	mov	r10, qword ptr [rcx]		
	cmp r10d, S_START				;    
	jne	stroke_1_load				;  ,  

	mov	qword ptr [r8], rbx			;  
	mov	rax, rbx					;   
	lea	r8, [r8 + 8]				;     
	xor	rax, qword ptr [r9]			;   
	lea r9, [r9 + 8]				;    
	jmp	end_0_stripe_manage

stroke_1_load:						
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11, rbx					;    
	jne bad_stroke_query			;  ,  
	lea rdx, [rdx + 8]				;     
	mov	r11, qword ptr [rdx]		
	cmp r11d, S_START				;    
	jne	add_bad_stroke				;  ,  

	mov	qword ptr [r8], rbx			;  
	mov	rax, rbx					;   
	lea	r8, [r8 + 8]				;     
	xor	rax, qword ptr [r9]			;   
	lea r9, [r9 + 8]				;    
	jmp	end_1_stripe_manage

bad_stroke_query:					;    
	cmp r10d, S_END					;      
	je stroke_manage

add_bad_stroke:						;  
	mov rbx, BS_STROKE				;   
	mov	qword ptr [r8], rbx			;  
	mov	rax, rbx					;   
	lea	r8, [r8 + 8]				;     
	xor	rax, qword ptr [r9]			;   
	lea r9, [r9 + 8]				;    


;========  RLE    ========
stroke_manage:						;     r10  r11 (  rcx  rdx)
	test rax, rax					;  
	jnz no_test_stroke_manage		;    
	cmp r10d, r11d					;  
	jl	found_1_begin				;    

found_0_begin:						;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	found_01_stroke				;    

found_00_stroke:					;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp save_0_stroke

found_01_stroke:					;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge load_1_stroke				;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

save_1_stroke:						;   r11
	mov	qword ptr [r8], r11			; 
	mov rbx, r11					;       
	lea	r8, [r8 + 8]				;     
	xor	r11, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r11					;  

load_1_stroke:						;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11d, S_START				;    
	je	end_1_stripe_manage			; 
	cmp	r11d, S_END					;    
	jne	stroke_manage				;  
	jmp end_1_preparation			; 

found_1_begin:						;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	found_10_stroke				;    
	
found_11_stroke:					;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp save_1_stroke				; 

found_10_stroke:					;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge load_0_stroke				;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

save_0_stroke:						;   r10
	mov	qword ptr [r8], r10			; 
	mov rbx, r10					;       
	lea	r8, [r8 + 8]				;     
	xor	r10, qword ptr [r9]			; 
	lea r9, [r9 + 8]				;    
	or	rax, r10					;  

load_0_stroke:						;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp r10d, S_START				;    
	je	end_0_stripe_manage			; 
	cmp	r10d, S_END					;    
	jne	stroke_manage				;  
	jmp end_0_preparation			; 


;========   RLE  ========
end_0_stripe_manage:				;  RLE       r10
	lea rcx, [rcx + 8]

end_0_preparation:
	lea rcx, [rcx + 4]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz	end_bad_query				;     

end_0_iteration:					;   	
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_END	
	jne end_0_iteration				;   rdx
	lea rdx, [rdx + 4]				;   
	jmp end_bad_query

end_1_stripe_manage:				;  RLE       r11
	lea rdx, [rdx + 8]

end_1_preparation:
	lea rdx, [rdx + 4]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz	end_bad_query				;     

end_1_iteration:					;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_END	
	jne end_1_iteration				;   rcx
	lea rcx, [rcx + 4]				;   

end_bad_query:
	shr	rbx, 20h					;    
	cmp ebx, S_START
	je end_stripe_manage			;  

end_bad_addition:
	mov rbx, BE_STROKE				;     
	mov	qword ptr [r8], rbx			;  
	lea	r8, [r8 + 8]				;     
	test rax, rax					;  
	jne end_stripe_manage			;  
	mov	rax, rbx					;   
	xor	rax, qword ptr [r9]			;   
	
end_stripe_manage:					;  RLE
	test rax, rax					;  
	jnz go_to_next_stripe			;  

	mov r11d, dword ptr [r12]		;   
	mov r8, r12						;    
	mov dword ptr [r15], r11d		;   
	cmp r11d, S_START				;  
	je end_proc
	mov r9, r15						;   
	jmp stripe_manage

go_to_next_stripe:
	mov	dword ptr [r8], S_END		; 
	lea r8, [r8 + 4]
	cmp dword ptr [r12], S_START	;  
	je end_proc
	mov r9, r12						;   
	jmp stripe_manage


;========  RLE    ========
no_test_stroke_manage:				;     r10  r11 (  rcx  rdx)
	cmp r10d, r11d					;  
	jl	no_test_found_1_begin		;    

no_test_found_0_begin:				;     r10
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r10d, r11d					;  
	jg	no_test_found_01_stroke		;    

no_test_found_00_stroke:			;     r10
	rol r10, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	rol r11, 20h					;        
	jmp no_test_save_0_stroke		; 

no_test_found_01_stroke:			;     r10    r11
	rol r10, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	cmp r10d, r11d					;    
	jge no_test_load_1_stroke		;      
	mov ebx, r10d					;   r10
	shl r11, 20h					;      
	or r11, rbx						;  

no_test_save_1_stroke:				;   r11
	mov	qword ptr [r8], r11			; 
	mov rbx, r11					;       
	lea	r8, [r8 + 8]				;     

no_test_load_1_stroke:				;     rdx
	mov	r11, qword ptr [rdx]		;    rdx
	cmp r11d, S_START				;    
	je	no_test_end_1_stripe_manage	; 
	cmp	r11d, S_END					;    
	jne	no_test_stroke_manage		;  
	jmp no_test_end_1_preparation	; 

no_test_found_1_begin:				;     r11
	rol	r10, 20h					;     
	rol	r11, 20h
	cmp	r11d, r10d					;  
	jg	no_test_found_10_stroke		;    
	
no_test_found_11_stroke:			;     r11
	rol r11, 20h					;        
	lea	rdx, [rdx + 8]				;       rdx
	rol r10, 20h					;        
	jmp no_test_save_1_stroke		; 

no_test_found_10_stroke:			;     r11    r10
	rol r11, 20h					;        
	lea	rcx, [rcx + 8]				;       rcx
	cmp r11d, r10d					;    
	jge no_test_load_0_stroke		;      
	mov ebx, r11d					;   r11
	shl r10, 20h					;      
	or r10, rbx						;  

no_test_save_0_stroke:				;   r10
	mov	qword ptr [r8], r10			; 
	mov rbx, r10					;       
	lea	r8, [r8 + 8]				;     

no_test_load_0_stroke:				;     rcx
	mov	r10, qword ptr [rcx]		;    rx
	cmp r10d, S_START				;    
	je	no_test_end_0_stripe_manage	; 
	cmp	r10d, S_END					;    
	jne	no_test_stroke_manage		;  
	jmp no_test_end_0_preparation	; 


;========   RLE    ========
no_test_end_0_stripe_manage:		;  RLE       r10
	lea rcx, [rcx + 8]

no_test_end_0_preparation:
	lea rcx, [rcx + 4]				;   
	test r13, r13					
	cmovnz rcx, r13					;     

	test r14, r14
	cmovnz rdx, r14					;     
	jnz	no_test_end_bad_query		;     

no_test_end_0_iteration:			;   	
	lea rdx, [rdx + 8]
	cmp dword ptr [rdx], S_END	
	jne no_test_end_0_iteration		;   rdx
	lea rdx, [rdx + 4]				;   
	jmp no_test_end_bad_query
	
no_test_end_1_stripe_manage:		;  RLE       r11
	lea rdx, [rdx + 8]

no_test_end_1_preparation:
	lea rdx, [rdx + 4]				;   
	test r14, r14
	cmovnz rdx, r14					;     

	test r13, r13					
	cmovnz rcx, r13					;     
	jnz	no_test_end_bad_query		;     

no_test_end_1_iteration:			;   
	lea rcx, [rcx + 8]
	cmp dword ptr [rcx], S_END	
	jne no_test_end_1_iteration		;   rcx
	lea rcx, [rcx + 4]				;   
	
no_test_end_bad_query:
	shr	rbx, 20h					;    
	cmp ebx, S_START
	je no_test_end_stripe_manage	;  

no_test_end_bad_addition:
	mov rbx, BE_STROKE				;     
	mov	qword ptr [r8], rbx			;  
	lea	r8, [r8 + 8]				;     

no_test_end_stripe_manage:			;  RLE
	mov	dword ptr [r8], S_END		; 
	lea	r8, [r8 + 4]				;    
	mov r9, r12						;   

	cmp dword ptr [r12], S_START	;  
	jne stripe_manage

end_proc:							; 
	mov rax, r8						;   
end_proc_fail:
	pop r15							; 
	pop r14
	pop r13
	pop r12
	pop rsi
	pop rbx
	ret

orRleRegions	ENDP



;====================================================================================================
;===============			  " "  				=================
;====================================================================================================
xorRleRegions	PROC
	push rbx						; 
	push rsi
	push r12
	push r13
	push r14
	push r15

	mov	rsi, r9						;    
	mov r9, r8						;   
	lea r8, [r8 + D_STUB_S]			;    


;========  RLE  ========
stripe_manage:						;   :   rcx  rdx,   r8  r9 
	xor rax, rax					;  
	cmp r8, rsi						;    
	jg	end_proc_fail				; 

	mov r12, r8						;   
	mov r15, r9						;    
	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]
	xor r13, r13					;    
	xor r14, r14
	cmp r10d, r11d					;  
	cmovg r10d, r11d
	cmovg r13, rcx					;    
	cmovl r14, rdx
	mov dword ptr [r8], r10d		;  

	mov r10, S_STROKE				;  
	mov qword ptr[r8 + 4], r10
	lea r8, [r8 + 12]				;   
	lea rcx, [rcx + 12]
	lea rdx, [rdx + 12]
	lea r9, [r9 + 12]

	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]	
	mov rbx, B_EMPTY	


;========  RLE    ========
stroke_manage:						;     r10  r11 (  rcx  rdx)
	test rax, rax					;  
	jnz no_test_stroke_manage		;    
	cmp r10d, r11d					;  
	jg	found_1_begin				; 

found_0_begin:						;     rcx
	cmp r10d, S_START				;    
	je end_preparation				; 
	lea rcx, [rcx + 4]				;       rcx
	cmp	rbx, B_EMPTY				;    
	je found_0_on_emty				; 
	cmp ebx, r10d					;  
	je found_0_set_empty			; 
	
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     
	xor	ebx, dword ptr [r9]			; 
	lea r9, [r9 + 4]				;    
	or	eax, ebx					;  
	mov ebx, r10d					; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp stroke_manage

found_0_on_emty:
	mov ebx, r10d					; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp stroke_manage

found_0_set_empty:
	mov rbx, B_EMPTY				; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp stroke_manage

found_1_begin:						;     rcx
	lea rdx, [rdx + 4]				;       rcx
	cmp	rbx, B_EMPTY				;    
	je found_1_on_emty				; 
	cmp ebx, r11d					;  
	je found_1_set_empty			; 
	
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     
	xor	ebx, dword ptr [r9]			; 
	lea r9, [r9 + 4]				;    
	or	eax, ebx					;  
	mov ebx, r11d					; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp stroke_manage

found_1_on_emty:
	mov ebx, r11d					; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp stroke_manage

found_1_set_empty:
	mov rbx, B_EMPTY				; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp stroke_manage


;========   RLE  ========
end_preparation:					;     
	cmp	rbx, B_EMPTY				;    
	je end_finalization
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     

	xor	ebx, dword ptr [r9]			; 
	lea r9, [r9 + 4]				;    
	or	eax, ebx					;  

end_finalization:					; S_START  
	mov r10d, dword ptr [rcx + 4]	;   
	mov r11d, dword ptr [rdx + 4]
	cmp r10d, r11d					;    S_START
	je	end_iteration_0				; 

	mov dword ptr [r8], S_START		; 
	lea	r8, [r8 + 4]				;     
	test eax, eax					;  
	jz end_iteration_0				; 

	mov eax, S_START				;
	xor eax, dword ptr [r9]			; 
	lea r9, [r9 + 4]				;    

end_iteration_0:					;    
	test r14, r14
	cmovnz rdx, r14					;     
	jnz end_iteration_1				;     

	cmp r11d, S_END					;    
	je end_pass_d					;,    8
	lea rdx, [rdx + 4]				;,    12
end_pass_d:
	lea rdx, [rdx + 8]				;rcx 

	test r13, r13					;    
	cmovnz rcx, r13					;     
	jnz end_stripe_manage			;     

end_iteration_1:
	cmp r10d, S_END					;    
	je end_pass_c					;,    8
	lea rcx, [rcx + 4]				;,    12
end_pass_c:
	lea rcx, [rcx + 8]				;rcx 
	
end_stripe_manage:					;  RLE
	mov r10, S_STROKE				;  

	test rax, rax					;  
	jnz go_to_next_stripe			;  
	cmp	r10, qword ptr [r9]			; 
	jne go_to_next_stripe			;  

	mov r11d, dword ptr [r12]		;   
	mov r8, r12						;    
	mov dword ptr [r15], r11d		;   
	cmp r11d, S_START				;  
	je end_proc
	mov r9, r15						;   
	jmp stripe_manage

go_to_next_stripe:					;      
	mov	qword ptr [r8], r10			;  
	lea	r8, [r8 + 8]				;    
	cmp dword ptr [r12], S_START	;  
	je end_proc
	mov r9, r12						;   
	jmp stripe_manage


;========  RLE    ========
no_test_stroke_manage:				;     r10  r11 (  rcx  rdx)
	cmp r10d, r11d					;  
	jg	no_test_found_1_begin		; 

no_test_found_0_begin:				;     rcx
	cmp r10d, S_START				;    
	je no_test_end_preparation		; 
	lea rcx, [rcx + 4]				;       rcx
	cmp	rbx, B_EMPTY				;    
	je no_test_found_0_on_emty		; 
	cmp ebx, r10d					;  
	je no_test_found_0_set_empty	; 
	
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     
	mov ebx, r10d					; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp no_test_stroke_manage

no_test_found_0_on_emty:
	mov ebx, r10d					; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp no_test_stroke_manage

no_test_found_0_set_empty:
	mov rbx, B_EMPTY				; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp no_test_stroke_manage

no_test_found_1_begin:				;     rcx
	lea rdx, [rdx + 4]				;       rcx
	cmp	rbx, B_EMPTY				;    
	je no_test_found_1_on_emty		; 
	cmp ebx, r11d					;  
	je no_test_found_1_set_empty	; 
	
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     
	mov ebx, r11d					; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp no_test_stroke_manage

no_test_found_1_on_emty:
	mov ebx, r11d					; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp no_test_stroke_manage

no_test_found_1_set_empty:
	mov rbx, B_EMPTY				; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp no_test_stroke_manage


;========   RLE    ========
no_test_end_preparation:			;     
	cmp	rbx, B_EMPTY				;    
	je no_test_end_finalization
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     

no_test_end_finalization:			; S_START  
	mov r10d, dword ptr [rcx + 4]	;   
	mov r11d, dword ptr [rdx + 4]
	cmp r10d, r11d					;    S_START
	je	no_test_end_iteration_0		; 

	mov dword ptr [r8], S_START		; 
	lea	r8, [r8 + 4]				;     

no_test_end_iteration_0:			;    
	test r14, r14
	cmovnz rdx, r14					;     
	jnz no_test_end_iteration_1		;     

	cmp r11d, S_END					;    
	je no_test_end_pass_d			;,    8
	lea rdx, [rdx + 4]				;,    12
no_test_end_pass_d:
	lea rdx, [rdx + 8]				;rcx 

	test r13, r13					;    
	cmovnz rcx, r13					;     
	jnz no_test_end_stripe_manage	;     

no_test_end_iteration_1:
	cmp r10d, S_END					;    
	je no_test_end_pass_c			;,    8
	lea rcx, [rcx + 4]				;,    12
no_test_end_pass_c:
	lea rcx, [rcx + 8]				;rcx 
	
no_test_end_stripe_manage:			;  RLE
	mov r10, S_STROKE				;  
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;    
	mov r9, r12						;   

	cmp dword ptr [r12], S_START	;  
	jne stripe_manage

end_proc:							; 
	mov rax, r8						;   
end_proc_fail:
	pop r15							; 
	pop r14
	pop r13
	pop r12
	pop rsi
	pop rbx
	ret

xorRleRegions	ENDP



;====================================================================================================
;===============				 ""  				=================
;====================================================================================================
equalRleRegions	PROC
	push rbx						; 
	push rsi
	push r12
	push r13
	push r14
	push r15

	mov	rsi, r9						;    
	mov r9, r8						;   
	lea r8, [r8 + D_STUB_S]			;    


;========  RLE  ========
stripe_manage:						;   :   rcx  rdx,   r8  r9 
	xor rax, rax					;  
	cmp r8, rsi						;    
	jg	end_proc_fail				; 

	mov r12, r8						;   
	mov r15, r9						;    
	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]
	xor r13, r13					;    
	xor r14, r14
	cmp r10d, r11d					;  
	cmovg r10d, r11d
	cmovg r13, rcx					;    
	cmovl r14, rdx
	mov dword ptr [r8], r10d		;  

	mov r10, S_STROKE				;  
	mov qword ptr[r8 + 4], r10
	lea r8, [r8 + 12]				;   
	lea rcx, [rcx + 12]
	lea rdx, [rdx + 12]
	lea r9, [r9 + 12]

	mov	r10d, dword ptr [rcx]		;  
	mov	r11d, dword ptr [rdx]	
	mov rbx, S_END	


;========  RLE    ========
stroke_manage:						;     r10  r11 (  rcx  rdx)
	test rax, rax					;  
	jnz no_test_stroke_manage		;    
	cmp r10d, r11d					;  
	jg	found_1_begin				; 

found_0_begin:						;     rcx
	cmp r10d, S_START				;    
	je end_preparation				; 
	lea rcx, [rcx + 4]				;       rcx
	cmp	rbx, B_EMPTY				;    
	je found_0_on_emty				; 
	cmp ebx, r10d					;  
	je found_0_set_empty			; 
	
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     
	xor	ebx, dword ptr [r9]			; 
	lea r9, [r9 + 4]				;    
	or	eax, ebx					;  
	mov ebx, r10d					; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp stroke_manage

found_0_on_emty:
	mov ebx, r10d					; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp stroke_manage

found_0_set_empty:
	mov rbx, B_EMPTY				; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp stroke_manage

found_1_begin:						;     rcx
	lea rdx, [rdx + 4]				;       rcx
	cmp	rbx, B_EMPTY				;    
	je found_1_on_emty				; 
	cmp ebx, r11d					;  
	je found_1_set_empty			; 
	
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     
	xor	ebx, dword ptr [r9]			; 
	lea r9, [r9 + 4]				;    
	or	eax, ebx					;  
	mov ebx, r11d					; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp stroke_manage

found_1_on_emty:
	mov ebx, r11d					; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp stroke_manage

found_1_set_empty:
	mov rbx, B_EMPTY				; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp stroke_manage


;========   RLE  ========
end_preparation:					;     
	cmp	rbx, B_EMPTY				;    
	je end_finalization
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     

	xor	ebx, dword ptr [r9]			; 
	lea r9, [r9 + 4]				;    
	or	eax, ebx					;  

end_finalization:					; S_START  
	mov r10d, dword ptr [rcx + 4]	;   
	mov r11d, dword ptr [rdx + 4]
	cmp r10d, r11d					;    S_START
	jne	end_iteration_0				; 

	mov dword ptr [r8], S_START		; 
	lea	r8, [r8 + 4]				;     
	test eax, eax					;  
	jz end_iteration_0				; 

	mov eax, S_START				;
	xor eax, dword ptr [r9]			; 
	lea r9, [r9 + 4]				;    

end_iteration_0:					;    
	test r14, r14
	cmovnz rdx, r14					;     
	jnz end_iteration_1				;     

	cmp r11d, S_END					;    
	je end_pass_d					;,    8
	lea rdx, [rdx + 4]				;,    12
end_pass_d:
	lea rdx, [rdx + 8]				;rcx 

	test r13, r13					;    
	cmovnz rcx, r13					;     
	jnz end_stripe_manage			;     

end_iteration_1:
	cmp r10d, S_END					;    
	je end_pass_c					;,    8
	lea rcx, [rcx + 4]				;,    12
end_pass_c:
	lea rcx, [rcx + 8]				;rcx 
	
end_stripe_manage:					;  RLE
	mov r10, S_STROKE				;  

	test rax, rax					;  
	jnz go_to_next_stripe			;  
	cmp	r10, qword ptr [r9]			; 
	jne go_to_next_stripe			;  

	mov r11d, dword ptr [r12]		;   
	mov r8, r12						;    
	mov dword ptr [r15], r11d		;   
	cmp r11d, S_START				;  
	je end_proc
	mov r9, r15						;   
	jmp stripe_manage

go_to_next_stripe:					;      
	mov	qword ptr [r8], r10			;  
	lea	r8, [r8 + 8]				;    
	cmp dword ptr [r12], S_START	;  
	je end_proc
	mov r9, r12						;   
	jmp stripe_manage


;========  RLE    ========
no_test_stroke_manage:				;     r10  r11 (  rcx  rdx)
	cmp r10d, r11d					;  
	jg	no_test_found_1_begin		; 

no_test_found_0_begin:				;     rcx
	cmp r10d, S_START				;    
	je no_test_end_preparation		; 
	lea rcx, [rcx + 4]				;       rcx
	cmp	rbx, B_EMPTY				;    
	je no_test_found_0_on_emty		; 
	cmp ebx, r10d					;  
	je no_test_found_0_set_empty	; 
	
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     
	mov ebx, r10d					; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp no_test_stroke_manage

no_test_found_0_on_emty:
	mov ebx, r10d					; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp no_test_stroke_manage

no_test_found_0_set_empty:
	mov rbx, B_EMPTY				; 
	mov	r10d, dword ptr [rcx]		;    rx
	jmp no_test_stroke_manage

no_test_found_1_begin:				;     rcx
	lea rdx, [rdx + 4]				;       rcx
	cmp	rbx, B_EMPTY				;    
	je no_test_found_1_on_emty		; 
	cmp ebx, r11d					;  
	je no_test_found_1_set_empty	; 
	
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     
	mov ebx, r11d					; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp no_test_stroke_manage

no_test_found_1_on_emty:
	mov ebx, r11d					; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp no_test_stroke_manage

no_test_found_1_set_empty:
	mov rbx, B_EMPTY				; 
	mov	r11d, dword ptr [rdx]		;    rx
	jmp no_test_stroke_manage


;========   RLE    ========
no_test_end_preparation:			;     
	cmp	rbx, B_EMPTY				;    
	je no_test_end_finalization
	mov dword ptr [r8], ebx			; 
	lea	r8, [r8 + 4]				;     

no_test_end_finalization:			; S_START  
	mov r10d, dword ptr [rcx + 4]	;   
	mov r11d, dword ptr [rdx + 4]
	cmp r10d, r11d					;    S_START
	jne	no_test_end_iteration_0		; 

	mov dword ptr [r8], S_START		; 
	lea	r8, [r8 + 4]				;     

no_test_end_iteration_0:			;    
	test r14, r14
	cmovnz rdx, r14					;     
	jnz no_test_end_iteration_1		;     

	cmp r11d, S_END					;    
	je no_test_end_pass_d			;,    8
	lea rdx, [rdx + 4]				;,    12
no_test_end_pass_d:
	lea rdx, [rdx + 8]				;rcx 

	test r13, r13					;    
	cmovnz rcx, r13					;     
	jnz no_test_end_stripe_manage	;     

no_test_end_iteration_1:
	cmp r10d, S_END					;    
	je no_test_end_pass_c			;,    8
	lea rcx, [rcx + 4]				;,    12
no_test_end_pass_c:
	lea rcx, [rcx + 8]				;rcx 
	
no_test_end_stripe_manage:			;  RLE
	mov r10, S_STROKE				;  
	mov	qword ptr [r8], r10			; 
	lea	r8, [r8 + 8]				;    
	mov r9, r12						;   

	cmp dword ptr [r12], S_START	;  
	jne stripe_manage

end_proc:							; 
	mov rax, r8						;   
end_proc_fail:
	pop r15							; 
	pop r14
	pop r13
	pop r12
	pop rsi
	pop rbx
	ret

equalRleRegions	ENDP


END 
