#pragma once
//	Region
class CRleRegion : public CObject {
public:
	CRleRegion();
	CRleRegion( const CRleRegion& region ) :data( region.data ) {}
	CRleRegion( const CRect& rect );
	~CRleRegion() {}
	CRleRegion& operator= ( const CRleRegion& region ) { data = region.data; return *this; }

	//	 
	void And( const CRleRegion& region );
	void Greater( const CRleRegion& region );
	void Less( const CRleRegion& region );
	void OrNot( const CRleRegion& region );
	void AndNot( const CRleRegion& region );
	void GreaterEqual( const CRleRegion& region );
	void LessEqual( const CRleRegion& region );
	void Or( const CRleRegion& region );
	void Xor( const CRleRegion& region );
	void Equal( const CRleRegion& region );
	void Shift( int dx, int dy );

	void GetRects( std::vector<CRect>& rects ) const;
	virtual void Serialize( CArchive& ar );

private:
	std::vector<int> data;
};
