#include "StdAfx.h"
#include "RleRegion.h"
#include "Poligon.h"

const int SENTINEL_START = 0x7fffffff;
const int SENTINEL_END = 0x80000000;

const size_t destStubSize = 6;

std::vector<int> buffer( 100000, SENTINEL_END );

CRleRegion::CRleRegion()
{
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_END );
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_END );
	data.push_back( SENTINEL_END );
}

CRleRegion::CRleRegion( const CRect& rect )
{
	data.reserve( 18 );
	data.push_back( rect.top );
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_END );
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_END );
	data.push_back( rect.bottom );
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_END );
	data.push_back( rect.left );
	data.push_back( rect.right );
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_END );
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_END );
	data.push_back( SENTINEL_START );
	data.push_back( SENTINEL_END );
	data.push_back( SENTINEL_END );
	data.capacity();
}

extern "C" int* andRleRegions( const int* in1, const int* in2, int* out, const int* end );
extern "C" int* greaterRleRegions( const int* in1, const int* in2, int* out, const int* end );
extern "C" int* orNotRleRegions( const int* in1, const int* in2, int* out, const int* end );
extern "C" int* andNotRleRegions( const int* in1, const int* in2, int* out, const int* end );
extern "C" int* orLessEqualRegions( const int* in1, const int* in2, int* out, const int* end );
extern "C" int* orRleRegions( const int* in1, const int* in2, int* out, const int* end );
extern "C" int* xorRleRegions( const int* in1, const int* in2, int* out, const int* end );
extern "C" int* equalRleRegions( const int* in1, const int* in2, int* out, const int* end );

void CRleRegion::And( const CRleRegion& region )
{
	int* endPtr = andRleRegions( data.data(), region.data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::Greater( const CRleRegion& region )
{
	int* endPtr = greaterRleRegions( data.data(), region.data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::Less( const CRleRegion& region )
{
	int* endPtr = greaterRleRegions( region.data.data(), data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::OrNot( const CRleRegion& region )
{
	int* endPtr = orNotRleRegions( data.data(), region.data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::AndNot( const CRleRegion& region )
{
	int* endPtr = andNotRleRegions( data.data(), region.data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::GreaterEqual( const CRleRegion& region )
{
	int* endPtr = orLessEqualRegions( region.data.data(), data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::LessEqual( const CRleRegion& region )
{
	int* endPtr = orLessEqualRegions( data.data(), region.data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::Or( const CRleRegion& region )
{
	int* endPtr = orRleRegions( data.data(), region.data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::Xor( const CRleRegion& region )
{
	int* endPtr = xorRleRegions( data.data(), region.data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::Equal( const CRleRegion& region )
{
	int* endPtr = equalRleRegions( data.data(), region.data.data(), buffer.data(), buffer.data() + buffer.size() - 10 );
	assert( endPtr != 0 );
	*endPtr++ = SENTINEL_END;
	data.assign( buffer.begin() + destStubSize, buffer.begin() + ( endPtr - buffer.data() ) );
}

void CRleRegion::Shift( int dx, int dy )
{
	std::vector<int>::iterator dataItr = data.begin();
	while( true ) {
		if( *dataItr != SENTINEL_START ) {
			*dataItr += dy;
			dataItr += 3;
			while( *dataItr != SENTINEL_START ) {
				*dataItr++ += dx;
				*dataItr++ += dx;
			}
		} else {
			dataItr += 3;
			while( *dataItr != SENTINEL_START ) {
				*dataItr++ += dx;
				*dataItr++ += dx;
			}
			break;
		}
	}
}


void CRleRegion::GetRects( std::vector<CRect>& rects ) const
{
	std::vector<int>::const_iterator dataItr = data.begin();

	int top = SENTINEL_END;
	while( *dataItr != SENTINEL_END ) {
		int bottom = *dataItr;
		dataItr += 3;
		while( *dataItr != SENTINEL_START ) {
			rects.push_back( CRect( *dataItr++, top, *dataItr++, bottom ) );
		}

		dataItr += 2;
		top = bottom;
	}
}

const int curCRleRegionVersion = 1;
void CRleRegion::Serialize( CArchive& ar )
{
	if ( ar.IsStoring() ) { //	 
		ar << curCRleRegionVersion;

		ar << data;
	} else {//	 
		int version = 0;
		ar >> version;
		assert( version == curCRleRegionVersion );

		ar >> data;
	}
}
