// PoligonPropertySheet.cpp:  
//

#include "stdafx.h"
#include "Poligon.h"
#include "PoligonPropertySheet.h"

// CPoligonPropertySheet
IMPLEMENT_DYNAMIC(CPoligonPropertySheet, CMFCPropertySheet)

CPoligonPropertySheet::CPoligonPropertySheet() :
	CMFCPropertySheet( IDS_MUMLAPROPERTIES, 0, 0 ), m_bNeedInit( true ), m_nMinCX( 0 ), m_nMinCY( 0 )
{
	SetLook( PropSheetLook_Tree, 200 );
	SetIconsList ( IDB_TREE_VIEW, 16 );

	CMFCPropertySheetCategoryInfo* defaultsCategory = AddTreeCategory( GetResString( IDS_PROPERTIES_DEFAULTS ), 0, 1 );
	AddPageToTree( defaultsCategory, &intelligencePage, -1, 2 );
	AddPageToTree( defaultsCategory, &testingAreaPage, -1, 2 );

	CMFCPropertySheetCategoryInfo* commonCategory = AddTreeCategory( GetResString( IDS_COMMON_PROPERTIES ), 0, 1 );
	AddPageToTree( commonCategory, &defaultPage, -1, 2 );
}

CPoligonPropertySheet::~CPoligonPropertySheet()
{
}

BEGIN_MESSAGE_MAP(CPoligonPropertySheet, CMFCPropertySheet)
	ON_WM_SIZE()
	ON_WM_GETMINMAXINFO()
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()

BOOL CPoligonPropertySheet::OnInitDialog()
{
	GetSystemMenu( FALSE );  
	GetSystemMenu( TRUE ); 

	ModifyStyle( 0, WS_THICKFRAME, 0 ); 
	
	return CMFCPropertySheet::OnInitDialog();
}

void CPoligonPropertySheet::OnSize( UINT nType, int cx, int cy )
{
	CRect r1; 
	CMFCPropertySheet::OnSize(nType, cx, cy);

	if( m_bNeedInit ) {
		return;
	}

	int dx = cx - m_rCrt.Width();
	int dy = cy - m_rCrt.Height();
	GetClientRect(&m_rCrt);

	HDWP hDWP = BeginDeferWindowPos( 5 );

	if( IsWindow( m_wndTree ) ) {
		m_wndTree.GetWindowRect( &r1 ); 
		r1.bottom += dy;

		DeferWindowPos( hDWP, m_wndTree.m_hWnd, 0, 0, 0, r1.Width(), r1.Height(),
			SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER );
	}

	// Move all of the buttons with the lower and right sides.
	for( CWnd *pChild = GetWindow( GW_CHILD ); pChild != 0;
		pChild = pChild->GetWindow( GW_HWNDNEXT ) )
	{
		if( pChild->SendMessage( WM_GETDLGCODE ) & DLGC_BUTTON ) {
			pChild->GetWindowRect( &r1 ); 
			ScreenToClient( &r1 ); 
			r1.top += dy; 
			r1.bottom += dy; 
			r1.left+= dx; 
			r1.right += dx;
			DeferWindowPos( hDWP, pChild->m_hWnd, 0, r1.left, r1.top, 0, 0,
				SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER );
		} else if( pChild != static_cast<CWnd*>( &m_wndTree ) ) {
			pChild->GetClientRect( &r1 ); 
			r1.right += dx; 
			r1.bottom += dy;
			DeferWindowPos( hDWP, pChild->m_hWnd, 0, 0, 0, r1.Width(), r1.Height(),
				SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER );
		}
	}

	EndDeferWindowPos( hDWP );
}

void CPoligonPropertySheet::OnGetMinMaxInfo( MINMAXINFO* lpMMI )
{
	CMFCPropertySheet::OnGetMinMaxInfo( lpMMI );

	if( m_bNeedInit ) {
		return;
	}

	lpMMI->ptMinTrackSize.x = m_nMinCX;
	lpMMI->ptMinTrackSize.y = m_nMinCY;
}

void CPoligonPropertySheet::OnShowWindow( BOOL bShow, UINT nStatus )
{
	GetClientRect( &m_rCrt );
	m_nMinCX = m_rCrt.Width();
	m_nMinCY = m_rCrt.Height();
	m_bNeedInit = false;

	CMFCPropertySheet::OnShowWindow( bShow, nStatus );
}
