
// Poligon.h :      Poligon
//
#pragma once

#ifndef __AFXWIN_H__
	#error " stdafx.h      PCH"
#endif

#include "resource.h"       //  

std::vector<double> progression( double first, double max, double incr );
const wchar_t IntelligenceDefaultsRegistryPath[] = L"Properties\\Defaults\\Intelligence";

const double MaxOptimizedReceptorStateWeight = 100.;
const double MinOptimizedReceptorStateWeight = 0.;
const std::vector<double> DefaultOptimizedReceptorStateWeights( progression( 0., 5., 1. ) );
const wchar_t OptimizedReceptorStateWeightsRegistryName[] = L"OptimizedReceptorStateWeights";

const int MaxReceptorsCount = 100;
const int MinReceptorsCount = 0;
const int MaxReceptorResolution = 100;
const int MinReceptorResolution = 2;
const std::vector<int> DefaultReceptorsResolutions( 9, 2 );
const wchar_t ReceptorsResolutionsRegistryName[] = L"ReceptorsResolutions";

const int MaxEffectorsCount = 100;
const int MinEffectorsCount = 0;
const int MaxEffectorResolution = 100;
const int MinEffectorResolution = 2;
const std::vector<int> DefaultEffectorsResolutions( 1, 4 );
const wchar_t EffectorsResolutionsRegistryName[] = L"EffectorsResolutions";

const CString GetResString( UINT uID );
const CString GetResString( UINT uID, int value0 );
const CString GetResString( UINT uID, int value0, int value1 );
const CString GetResString( UINT uID, double value0 );
const CString GetResString( UINT uID, double value0, double value1 );

const wchar_t RegistryArrayCountName[] = L"ValuesCount";
const wchar_t RegistryArrayElementName[] = L"Value_";

void SaveArrayToRegistry( const CString& path, const std::vector<int>& data );
void SaveArrayToRegistry( const CString& path, const std::vector<double>& data );
void LoadArrayFromRegistry( const CString& path, std::vector<int>& data );
void LoadArrayFromRegistry( const CString& path, std::vector<double>& data );

template<class T>
CArchive& operator << ( CArchive& ar, const std::vector<T>& data )
{
	ar << data.size();
	
	for( std::vector<T>::const_iterator itr = data.begin(); itr != data.end(); ++itr ) {
		ar << *itr;
	}
	return ar;
}

template<class T>
CArchive& operator >> ( CArchive& ar, std::vector<T>& data )
{
	std::vector<T>::size_type size;
	ar >> size;
	data.resize( size );

	std::vector<T>::iterator itr = data.begin();
	for( std::vector<T>::size_type i = 0; i < size; ++i, ++itr ) {
		ar >> *itr;
	}

	return ar;
}

extern const UINT MM_NEED_TO_NOTIFY;

template<class T>
class CAutoSwitcher {
public:
	CAutoSwitcher( T& _value, const T& newValue ) : value( _value ), oldValue( _value ) { value = newValue; }
	~CAutoSwitcher() { value = oldValue; }

private:
	T& value;
	const T oldValue;
};

class CMainFrame;

class CPoligonApp : public CWinAppEx {
public:
	CPoligonApp();

	CMainFrame& GetMainFrame();

// 
public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();

// 
	UINT  m_nAppLook;
	BOOL  m_bHiColorIcons;

	virtual void PreLoadState();
	virtual void LoadCustomState();
	virtual void SaveCustomState();

	afx_msg void OnAppAbout();
	DECLARE_MESSAGE_MAP()
	afx_msg void OnMumlaProperties();
};

extern CPoligonApp theApp;
