
// Poligon.cpp :     .
//

#include "stdafx.h"
#include "afxwinappex.h"
#include "afxdialogex.h"
#include "Poligon.h"
#include "MainFrm.h"

#include "ChildFrm.h"
#include "TestingArea.h"
#include "TestingAreaView.h"
#include "Intelligence.h"
#include "IntelligenceView.h"
#include "AgentBody.h"
#include "AgentBodyView.h"
#include "PoligonPropertySheet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


const CString GetResString( UINT uID )
{
	CString string;

	BOOL bNameValid = string.LoadString( uID );
	ASSERT(bNameValid);
	
	return string;
}

const CString GetResString( UINT uID, int value0 )
{
	CString string;
	CString value;

	BOOL bNameValid = string.LoadString( uID );
	ASSERT(bNameValid);
	
	value.Format( L"%d", value0 );
	string.Replace( L"%0", value );
	
	return string;
}

const CString GetResString( UINT uID, int value0, int value1 )
{
	CString string;
	CString value;

	BOOL bNameValid = string.LoadString( uID );
	ASSERT(bNameValid);

	value.Format( L"%d", value0 );
	string.Replace( L"%0", value );

	value.Format( L"%d", value1 );
	string.Replace( L"%1", value );
	
	return string;
}

const CString GetResString( UINT uID, double value0 )
{
	CString string;
	CString value;

	BOOL bNameValid = string.LoadString( uID );
	ASSERT(bNameValid);
	
	value.Format( L"%f", value0 );
	string.Replace( L"%0", value );
	
	return string;
}

const CString GetResString( UINT uID, double value0, double value1 )
{
	CString string;
	CString value;

	BOOL bNameValid = string.LoadString( uID );
	ASSERT(bNameValid);

	value.Format( L"%f", value0 );
	string.Replace( L"%0", value );

	value.Format( L"%f", value1 );
	string.Replace( L"%1", value );
	
	return string;
}

void LoadArrayFromRegistry( const CString& path, std::vector<int>& data );
void LoadArrayFromRegistry( const CString& path, std::vector<double>& data );

void SaveArrayToRegistry( const CString& path, const std::vector<int>& data )
{
	std::vector<int>::const_iterator itr = data.begin();
	int count = 0;

	for( ; itr != data.end(); ++count, ++itr ) {
		CString indexStr;
		indexStr.Format( L"%d", count );
		CString valueStr;
		valueStr.Format( L"%d", *itr );
		theApp.WriteProfileStringW( path, CString( RegistryArrayElementName + indexStr ), valueStr );
	}
		
	theApp.WriteProfileInt( path, RegistryArrayCountName, count );
}

void SaveArrayToRegistry( const CString& path, const std::vector<double>& data )
{
	std::vector<double>::const_iterator itr = data.begin();
	int count = 0;

	for( ; itr != data.end(); ++count, ++itr ) {
		CString indexStr;
		indexStr.Format( L"%d", count );
		CString valueStr;
		valueStr.Format( L"%e", *itr );
		theApp.WriteProfileStringW( path, CString( RegistryArrayElementName + indexStr ), valueStr );
	}
		
	theApp.WriteProfileInt( path, RegistryArrayCountName, count );
}

void LoadArrayFromRegistry( const CString& path, std::vector<int>& data )
{
	int count = theApp.GetProfileIntW( path, RegistryArrayCountName, data.size() );

	data.resize( count, 0 );
	std::vector<int>::iterator itr = data.begin();
	for( int i = 0; i < count; ++i, ++itr ) {
		CString indexStr;
		indexStr.Format( L"%d", i );
		CString valueStr = theApp.GetProfileStringW( path, CString( RegistryArrayElementName + indexStr ) );
		if( !valueStr.IsEmpty() ) {
			*itr = _wtoi( valueStr );
		}
	}
}

void LoadArrayFromRegistry( const CString& path, std::vector<double>& data )
{
	int count = theApp.GetProfileIntW( path, RegistryArrayCountName, data.size() );

	data.resize( count, 0. );
	std::vector<double>::iterator itr = data.begin();
	for( int i = 0; i < count; ++i, ++itr ) {
		CString indexStr;
		indexStr.Format( L"%d", i );
		CString valueStr = theApp.GetProfileStringW( path, CString( RegistryArrayElementName + indexStr ) );
		if( !valueStr.IsEmpty() ) {
			*itr = _wtof( valueStr );
		}
	}
}

extern const UINT MM_NEED_TO_NOTIFY = RegisterWindowMessage( L"NEED TO NOTIFY" );

std::vector<double> progression( double first, double max, double incr )
{
	std::vector<double> result;
	for( double i = first; i < max; i += incr ) {
		result.push_back( i );
	}
	return result;
}

// CPoligonApp

BEGIN_MESSAGE_MAP(CPoligonApp, CWinAppEx)
	ON_COMMAND(ID_APP_ABOUT, &CPoligonApp::OnAppAbout)
	//       
	ON_COMMAND(ID_FILE_NEW, &CWinAppEx::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, &CWinAppEx::OnFileOpen)
	ON_COMMAND(ID_MUMLAPROPERTIES, &CPoligonApp::OnMumlaProperties)
END_MESSAGE_MAP()


//  CPoligonApp

CPoligonApp::CPoligonApp()
{
	m_bHiColorIcons = TRUE;

	//   
	m_dwRestartManagerSupportFlags = AFX_RESTART_MANAGER_SUPPORT_ALL_ASPECTS;
#ifdef _MANAGED
	//       Common Language Runtime (/clr):
	//     1)          .
	//     2)          System.Windows.Forms.
	System::Windows::Forms::Application::SetUnhandledExceptionMode(System::Windows::Forms::UnhandledExceptionMode::ThrowException);
#endif

	// TODO:        ; 
	//   : ...
	SetAppID(_T("Poligon.AppID.NoVersion"));

	// TODO:   ,
	//       InitInstance
}

//   CPoligonApp

CPoligonApp theApp;

CMainFrame& CPoligonApp::GetMainFrame()
{ 
	return *static_cast<CMainFrame*>( GetMainWnd() ); 
}

//  CPoligonApp
BOOL CPoligonApp::InitInstance()
{
	// InitCommonControlsEx()   Windows XP,  
	//   ComCtl32.dll  6      
	//  .          .
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	//         ,   
	//   .
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	CWinAppEx::InitInstance();

	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	EnableTaskbarInteraction();

	//     RichEdit   AfxInitRichEdit2()	
	// AfxInitRichEdit2();

	//  
	//         
	//   ,    
	//   ,   
	SetRegistryKey( L"Mumla" );
	LoadStdProfileSettings( 4 );  //    INI- ( MRU)

	InitContextMenuManager();

	InitKeyboardManager();

	InitTooltipManager();
	CMFCToolTipInfo ttParams;
	ttParams.m_bVislManagerTheme = TRUE;
	theApp.GetTooltipManager()->SetTooltipParams(AFX_TOOLTIP_TYPE_ALL,
		RUNTIME_CLASS(CMFCToolTipCtrl), &ttParams);

	//    .  
	//       ,    
	AddDocTemplate( new CMultiDocTemplate( IDR_TESTINGAREAVIEW_TMPL, RUNTIME_CLASS( CTestingArea ),
		RUNTIME_CLASS( CChildFrame ), RUNTIME_CLASS( CTestingAreaView ) ) );

	AddDocTemplate( new CMultiDocTemplate( IDR_AGENTBODYVIEW_TMPL, RUNTIME_CLASS( CAgentBody ),
		RUNTIME_CLASS( CChildFrame ), RUNTIME_CLASS( CAgentBodyView ) ) );

	AddDocTemplate( new CMultiDocTemplate( IDR_INTELLIGENCEVIEW_TMPL, RUNTIME_CLASS( CIntelligence ),
		RUNTIME_CLASS( CChildFrame ), RUNTIME_CLASS( CIntelligenceView ) ) );

	//     MDI
	CMainFrame* pMainFrame = new CMainFrame;
	if ( pMainFrame == 0 || pMainFrame->LoadFrame( IDR_MAINFRAME ) == 0 ) {
		delete pMainFrame;
		return FALSE;
	}
	m_pMainWnd = pMainFrame;
	//  DragAcceptFiles    
	//    MDI       m_pMainWnd
	//   
	m_pMainWnd->DragAcceptFiles();

	//        , DDE,  
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	//    DDE
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);


	//  ,    .  FALSE  , 
	//      /RegServer, /Register, /Unregserver  /Unregister.
	if ( ProcessShellCommand( cmdInfo ) == 0 ) {
		return FALSE;
	}

	//    ,     
	pMainFrame->ShowWindow( m_nCmdShow );
	pMainFrame->UpdateWindow();

	return TRUE;
}

int CPoligonApp::ExitInstance()
{
	//TODO:   ,    
	return CWinAppEx::ExitInstance();
}

//   CPoligonApp


//   CAboutDlg      

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

//   
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    //  DDX/DDV

// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()

//     
void CPoligonApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

// CPoligonApp     

void CPoligonApp::PreLoadState()
{
	GetContextMenuManager()->AddMenu( GetResString( IDS_EDIT_MENU ), IDR_POPUP_EDIT );
	GetContextMenuManager()->AddMenu( GetResString( IDS_EXPLORER ), IDR_POPUP_EXPLORER );
}

void CPoligonApp::LoadCustomState()
{
}

void CPoligonApp::SaveCustomState()
{
}

//   CPoligonApp
void CPoligonApp::OnMumlaProperties()
{
	std::auto_ptr<CPoligonPropertySheet> pPropSheet( new CPoligonPropertySheet() );
	pPropSheet->DoModal();
}
