#pragma once
#include "afxwin.h"
#include "RleRegion.h"
//	 

class CCustomPropertyGridProperty;
class CBoundedPropertyGridProperty;
class CBoundedPropertyGridVectorProperty;

struct CDefaultIntelligenceGridProperties {
	CDefaultIntelligenceGridProperties();
	void CreateGridPropertiesDefault( CMFCPropertyGridCtrl& m_wndPropList, CWnd* notificationTarget );
	void EmulateActivity( CMFCPropertyGridCtrl& m_wndPropList, CMFCPropertyGridProperty* propertyPtr );
	bool Validate();
	void SaveToRegistry() const;
	void LoadFromRegistry();
	void CreateGridProperties( CMFCPropertyGridCtrl& m_wndPropList, 
		CWnd* notificationTarget, const std::vector<double>& optimizedReceptorStateWeights,
		const std::vector<int>& receptorsResolutions, const std::vector<int>& effectorsResolutions );
	void InitGridProperties( CMFCPropertyGridCtrl& m_wndPropList,
		const std::vector<double>& optimizedReceptorStateWeights,
		const std::vector<int>& receptorsResolutions, const std::vector<int>& effectorsResolutions );

	CBoundedPropertyGridProperty* OptimizedReceptorResolution;
	CBoundedPropertyGridVectorProperty* OptimizedReceptorStateWeights;
	CBoundedPropertyGridProperty* ReceptorsCount;
	CBoundedPropertyGridVectorProperty* ReceptorsResolutions;
	CBoundedPropertyGridProperty* EffectorsCount;
	CBoundedPropertyGridVectorProperty* EffectorsResolutions;

};

class CIntelligenceView : public CFormView {
	DECLARE_DYNCREATE(CIntelligenceView)

protected:
	CIntelligenceView();           //  ,    
	virtual ~CIntelligenceView();

public:
	enum { IDD = IDD_INTELLIGENCEVIEW };
#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    //  DDX/DDV

	DECLARE_MESSAGE_MAP()
	virtual void OnUpdate(CView* /*pSender*/, LPARAM /*lHint*/, CObject* /*pHint*/);
	virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
private:
	CDefaultIntelligenceGridProperties defaultsControls;
	CRleRegion region;
public:
	afx_msg void OnBnClickedButton1();
	virtual void OnDraw(CDC* pDC );
	afx_msg void OnBnClickedButton2();
	afx_msg void OnBnClickedButton3();
	afx_msg void OnBnClickedButton4();
	afx_msg void OnBnClickedButton5();
	afx_msg void OnBnClickedButton6();
	afx_msg void OnBnClickedButton7();
	afx_msg void OnBnClickedButton8();
	afx_msg void OnBnClickedButton9();
	afx_msg void OnBnClickedButton10();
	afx_msg void OnBnClickedButton11();
	afx_msg void OnBnClickedButton12();
	afx_msg void OnBnClickedButton13();
	afx_msg void OnBnClickedButton14();
	afx_msg void OnBnClickedButton15();
};


