﻿// IntelligenceView.cpp: файл реализации
//

#include "stdafx.h"
#include "Poligon.h"
#include "IntelligenceView.h"
#include "MainFrm.h"
#include "CustomPropertyGridProperty.h"
#include "Intelligence.h"

CDefaultIntelligenceGridProperties::CDefaultIntelligenceGridProperties() :
	OptimizedReceptorResolution( 0 ), OptimizedReceptorStateWeights( 0 ), ReceptorsCount( 0 ),
	ReceptorsResolutions( 0 ), EffectorsCount( 0 ), EffectorsResolutions( 0 )
{
}

void CDefaultIntelligenceGridProperties::CreateGridPropertiesDefault( 
	CMFCPropertyGridCtrl& m_wndPropList, CWnd* notificationTarget )
{
	CreateGridProperties( m_wndPropList, notificationTarget, DefaultOptimizedReceptorStateWeights,
		DefaultReceptorsResolutions, DefaultEffectorsResolutions );
}

void CDefaultIntelligenceGridProperties::CreateGridProperties( CMFCPropertyGridCtrl& m_wndPropList, 
		CWnd* notificationTarget, const std::vector<double>& optimizedReceptorStateWeights,
		const std::vector<int>& receptorsResolutions, const std::vector<int>& effectorsResolutions )
{
	std::auto_ptr<CMFCPropertyGridProperty> interfaceGroup( new CMFCPropertyGridProperty( 
		GetResString( IDS_INTERFACE_GROUP_PROPERTY_NAME ) ) );
	interfaceGroup->SetDescription( GetResString( IDS_INTERFACE_GROUP_PROPERTY_DESCRIPTION ) );

	//	Оптимизируемый рецептор
	OptimizedReceptorResolution = new CBoundedPropertyGridProperty( 
		GetResString( IDS_OPTIMIZED_RECEPTOR_RESOLUTION_PROPERTY ),
		optimizedReceptorStateWeights.size(), MinReceptorResolution, MaxReceptorResolution, 
		notificationTarget, L"", L"" );
	interfaceGroup->AddSubItem( OptimizedReceptorResolution );

	OptimizedReceptorStateWeights = new CBoundedPropertyGridVectorProperty( 
		GetResString( IDS_OPTIMIZED_RECEPTOR_STATE_WEIGHTS_PROPERTY ),
		GetResString( IDS_OPTIMIZED_RECEPTOR_CURRENT_STATE_WEIGHT_PROPERTY ),
		optimizedReceptorStateWeights, MinOptimizedReceptorStateWeight, MaxOptimizedReceptorStateWeight, 
		notificationTarget, IntelligenceDefaultsRegistryPath, OptimizedReceptorStateWeightsRegistryName );
	interfaceGroup->AddSubItem( OptimizedReceptorStateWeights );

	//	Рецепторы
	ReceptorsCount = new CBoundedPropertyGridProperty( 
		GetResString( IDS_RECEPTORS_COUNT_PROPERTY ),
		receptorsResolutions.size(), MinReceptorsCount, MaxReceptorsCount, notificationTarget, L"", L"" );
	interfaceGroup->AddSubItem( ReceptorsCount );

	ReceptorsResolutions = new CBoundedPropertyGridVectorProperty( 
		GetResString( IDS_RECEPTORS_RESOLUTIONS_PROPERTY ),
		GetResString( IDS_CURRENT_RECEPTOR_RESOLUTION_PROPERTY ),
		receptorsResolutions, MinReceptorResolution, MaxReceptorResolution, 
		notificationTarget, IntelligenceDefaultsRegistryPath, ReceptorsResolutionsRegistryName );
	interfaceGroup->AddSubItem( ReceptorsResolutions );

	//	Эффекторы
	EffectorsCount = new CBoundedPropertyGridProperty( 
		GetResString( IDS_EFFECTORS_COUNT_PROPERTY ),
		effectorsResolutions.size(), MinEffectorsCount, MaxEffectorsCount, notificationTarget, L"", L"" );
	interfaceGroup->AddSubItem( EffectorsCount );

	EffectorsResolutions = new CBoundedPropertyGridVectorProperty( 
		GetResString( IDS_EFFECTORS_RESOLUTIONS_PROPERTY ),
		GetResString( IDS_CURRENT_EFFECTOR_RESOLUTION_PROPERTY ),
		effectorsResolutions, MinEffectorResolution, MaxEffectorResolution, 
		notificationTarget, IntelligenceDefaultsRegistryPath, EffectorsResolutionsRegistryName );
	interfaceGroup->AddSubItem( EffectorsResolutions );

	m_wndPropList.AddProperty( interfaceGroup.release() );
}

void CDefaultIntelligenceGridProperties::EmulateActivity( 
	CMFCPropertyGridCtrl& m_wndPropList, CMFCPropertyGridProperty* propertyPtr )
{
	if( propertyPtr == static_cast<CMFCPropertyGridProperty*>( OptimizedReceptorResolution ) ) {
		if( OptimizedReceptorResolution->Validate() ) {
			OptimizedReceptorStateWeights->SetNewCount( OptimizedReceptorResolution->GetIntValue(),
				DefaultOptimizedReceptorStateWeights.back() );
			m_wndPropList.AdjustLayout();
		}
	} else if( propertyPtr == static_cast<CMFCPropertyGridProperty*>( OptimizedReceptorStateWeights ) ) {
		OptimizedReceptorStateWeights->Validate();
	} else if( propertyPtr == static_cast<CMFCPropertyGridProperty*>( ReceptorsCount ) ) {
		if( ReceptorsCount->Validate() ) {
			ReceptorsResolutions->SetNewCount( ReceptorsCount->GetIntValue(), DefaultReceptorsResolutions.back() );
			m_wndPropList.AdjustLayout();
		}
	} else if( propertyPtr == static_cast<CMFCPropertyGridProperty*>( ReceptorsResolutions ) ) {
		ReceptorsResolutions->Validate();
	} else if( propertyPtr == static_cast<CMFCPropertyGridProperty*>( EffectorsCount ) ) {
		if( EffectorsCount->Validate() ) {
			EffectorsResolutions->SetNewCount( EffectorsCount->GetIntValue(), DefaultEffectorsResolutions.back() );
			m_wndPropList.AdjustLayout();
		}
	} else if( propertyPtr == static_cast<CMFCPropertyGridProperty*>( EffectorsResolutions ) ) {
		EffectorsResolutions->Validate();
	} 
}

bool CDefaultIntelligenceGridProperties::Validate()
{
	return OptimizedReceptorResolution->Validate() 
		&& OptimizedReceptorStateWeights->Validate() 
		&& ReceptorsCount->Validate() 
		&& ReceptorsResolutions->Validate() 
		&& EffectorsCount->Validate() 
		&& EffectorsResolutions->Validate();
}

void CDefaultIntelligenceGridProperties::SaveToRegistry() const
{
	OptimizedReceptorStateWeights->SaveToRegistry();
	ReceptorsResolutions->SaveToRegistry();
	EffectorsResolutions->SaveToRegistry();
}

void CDefaultIntelligenceGridProperties::LoadFromRegistry()
{
	OptimizedReceptorStateWeights->LoadFromRegistry();
	OptimizedReceptorResolution->SetValue( OptimizedReceptorStateWeights->GetChildrenCount(), true, true );
	ReceptorsResolutions->LoadFromRegistry();
	ReceptorsCount->SetValue( ReceptorsResolutions->GetChildrenCount(), true, true );
	EffectorsResolutions->LoadFromRegistry();
	EffectorsCount->SetValue( ReceptorsResolutions->GetChildrenCount(), true, true );
}

void CDefaultIntelligenceGridProperties::InitGridProperties( CMFCPropertyGridCtrl& m_wndPropList,
	const std::vector<double>& optimizedReceptorStateWeights,
	const std::vector<int>& receptorsResolutions, const std::vector<int>& effectorsResolutions )
{
	OptimizedReceptorResolution->SetValue( int( optimizedReceptorStateWeights.size() ), true, true );
	OptimizedReceptorStateWeights->SetValues( optimizedReceptorStateWeights );
	ReceptorsCount->SetValue( int( receptorsResolutions.size() ), true, true );
	ReceptorsResolutions->SetValues( receptorsResolutions );
	EffectorsCount->SetValue( int( effectorsResolutions.size() ), true, true );
	EffectorsResolutions->SetValues( effectorsResolutions );
}

//---------------------------------------------------------------------------------------------------------------------
IMPLEMENT_DYNCREATE(CIntelligenceView, CFormView)

CIntelligenceView::CIntelligenceView()
	: CFormView(CIntelligenceView::IDD)
{
}

CIntelligenceView::~CIntelligenceView()
{
}

void CIntelligenceView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CIntelligenceView, CFormView)
	ON_BN_CLICKED(IDC_BUTTON1, &CIntelligenceView::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CIntelligenceView::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CIntelligenceView::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CIntelligenceView::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CIntelligenceView::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_BUTTON6, &CIntelligenceView::OnBnClickedButton6)
	ON_BN_CLICKED(IDC_BUTTON7, &CIntelligenceView::OnBnClickedButton7)
	ON_BN_CLICKED(IDC_BUTTON8, &CIntelligenceView::OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON9, &CIntelligenceView::OnBnClickedButton9)
	ON_BN_CLICKED(IDC_BUTTON10, &CIntelligenceView::OnBnClickedButton10)
	ON_BN_CLICKED(IDC_BUTTON11, &CIntelligenceView::OnBnClickedButton11)
	ON_BN_CLICKED(IDC_BUTTON12, &CIntelligenceView::OnBnClickedButton12)
	ON_BN_CLICKED(IDC_BUTTON13, &CIntelligenceView::OnBnClickedButton13)
	ON_BN_CLICKED(IDC_BUTTON14, &CIntelligenceView::OnBnClickedButton14)
	ON_BN_CLICKED(IDC_BUTTON15, &CIntelligenceView::OnBnClickedButton15)
END_MESSAGE_MAP()


// диагностика CIntelligenceView

#ifdef _DEBUG
void CIntelligenceView::AssertValid() const
{
	CFormView::AssertValid();
}

#ifndef _WIN32_WCE
void CIntelligenceView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif
#endif //_DEBUG

// обработчики сообщений CIntelligenceView
void CIntelligenceView::OnUpdate(CView* /*pSender*/, LPARAM /*lHint*/, CObject* /*pHint*/)
{
	CMFCPropertyGridCtrl& propList = theApp.GetMainFrame().GetPropertiesWnd().GetGridCtrl();
	CIntelligence* intelligence = static_cast<CIntelligence*>( GetDocument() );

//	defaultsControls.InitGridProperties( propList, intelligence->GetOptimizedReceptorWeights(),
//		intelligence->GetReceptorsLimits(), intelligence->GetEffectorsLimits() );
}

void CIntelligenceView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView)
{
	if( bActivate ) {
		CPropertiesWnd* propWnd = &theApp.GetMainFrame().GetPropertiesWnd();
		CMFCPropertyGridCtrl& propList = propWnd->GetGridCtrl();
		CIntelligence* intelligence = static_cast<CIntelligence*>( GetDocument() );

		propList.RemoveAll();

		defaultsControls.CreateGridProperties( propList, propWnd, intelligence->GetOptimizedReceptorWeights(),
			intelligence->GetReceptorsLimits(), intelligence->GetEffectorsLimits() );
	}

	CFormView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}


void CIntelligenceView::OnBnClickedButton1()
{
	region = CRleRegion( CRect( 10, 10, 145, 29 ) );
	Invalidate( false );
//	region.NotNotAnd( CRleRegion( CRect( 10, 20, 80, 46 ) ) );
}

void CIntelligenceView::OnDraw( CDC* pDC )
{
	CRleRegion outRegion( CRect( 3, 3, 197, 197 ) );
	outRegion.And( region );

	std::vector<CRect> rects;
	outRegion.GetRects( rects );

	CBrush whiteBrush( RGB( 255, 255, 255 ) );
	CBrush blackBrush( RGB( 0, 0, 0 ) );

	pDC->FillRect( CRect( 0, 0, 200, 200 ), &whiteBrush );

	std::vector<CRect>::const_iterator rectsItr = rects.begin();
	while( rectsItr != rects.end() ) {
		pDC->FillRect( *rectsItr++, &blackBrush );
	}
	
	CString count;
	count.Format( L"%d", rects.size() );
	theApp.GetMainFrame().SetWindowText( count );
}

int fileCounter = 1000;
void saveRegion( CRleRegion& region, const CString& prefix )
{
	CString count;
	count.Format( L"%d", fileCounter++ );
	count += L"_" + prefix;

	CFile file( CString( L"D:\\rez\\" ) + count + L".rn", 
		CFile::modeCreate | CFile::modeWrite | CFile::shareDenyNone );
	CArchive archive( &file, CArchive::store );
	region.Serialize( archive );
}

void loadRegion( CRleRegion& region, const CString& fileName )
{
	CFile file( CString( L"D:\\rez\\" ) + fileName + L".rn", CFile::modeRead | CFile::shareDenyNone );
	CArchive archive( &file, CArchive::load );
	region.Serialize( archive );
}

void CIntelligenceView::OnBnClickedButton2()
{
	region = CRleRegion( CRect( 20, 80, 180, 120 ) );
	Invalidate( false );
	saveRegion( region, L"Button_2_out" );
}

void CIntelligenceView::OnBnClickedButton3()
{
	region = CRleRegion( CRect( 122, 155, 145, 180 ) );
	Invalidate( false );
	saveRegion( region, L"Button_3_out" );
}

void CIntelligenceView::OnBnClickedButton4()
{
	region.OrNot( CRleRegion() );
	Invalidate( false );
	saveRegion( region, L"Not_3_out" );
}

void CIntelligenceView::OnBnClickedButton5()
{
	saveRegion( CRleRegion( CRect( 22, 55, 165, 190 ) ), L"OrNot_in" );
	region.OrNot( CRleRegion( CRect( 22, 55, 165, 190 ) ) );
	Invalidate( false );
	saveRegion( region, L"OrNot_out" );
}

void CIntelligenceView::OnBnClickedButton6()
{
	saveRegion( CRleRegion( CRect( 80, 20, 120, 180 ) ), L"Greater_in" );
	region.Greater( CRleRegion( CRect( 80, 20, 120, 180 ) ) );
	Invalidate( false );
	saveRegion( region, L"Greater_out" );
}

void CIntelligenceView::OnBnClickedButton7()
{
	saveRegion( CRleRegion( CRect( 80, 20, 120, 180 ) ), L"Less_in" );
	region.Less( CRleRegion( CRect( 80, 20, 120, 180 ) ) );
	Invalidate( false );
	saveRegion( region, L"Less_out" );
}

void CIntelligenceView::OnBnClickedButton8()
{
	saveRegion( CRleRegion( CRect( 190, 50, 1065, 19760 ) ), L"Less2_in" );
	region.Less( CRleRegion( CRect( 190, 50, 1065, 19760 ) ) );
	Invalidate( false );
	saveRegion( region, L"Less2_out" );
}

void CIntelligenceView::OnBnClickedButton9()
{
	saveRegion( CRleRegion( CRect( 80, 20, 120, 180 ) ), L"AndNot_in" );
	region.AndNot( CRleRegion( CRect( 80, 20, 120, 180 ) ) );
	Invalidate( false );
	saveRegion( region, L"AndNot_out" );
}

void CIntelligenceView::OnBnClickedButton10()
{
	saveRegion( CRleRegion( CRect( 80, 20, 120, 180 ) ), L"Or_in" );
	region.Or( CRleRegion( CRect( 80, 20, 120, 180 ) ) );
	Invalidate( false );
	saveRegion( region, L"Or_out" );
}

void CIntelligenceView::OnBnClickedButton11()
{
	saveRegion( CRleRegion( CRect( 80, 20, 120, 180 ) ), L"GreaterEqual_in" );
	region.GreaterEqual( CRleRegion( CRect( 80, 20, 120, 180 ) ) );
	Invalidate( false );
	saveRegion( region, L"GreaterEqual_out" );
}

void CIntelligenceView::OnBnClickedButton12()
{
	saveRegion( CRleRegion( CRect( 80, 20, 120, 180 ) ), L"LessEqual_in" );
	region.LessEqual( CRleRegion( CRect( 80, 20, 120, 180 ) ) );
	Invalidate( false );
	saveRegion( region, L"GreaterEqual_out" );
}

void CIntelligenceView::OnBnClickedButton13()
{
	loadRegion( region, L"1005_GreaterEqual_out" );
	CRleRegion region2;
	loadRegion( region2, L"1006_LessEqual_in" );
	region.LessEqual( region2 );
	Invalidate( false );
}


void CIntelligenceView::OnBnClickedButton14()
{
	saveRegion( CRleRegion( CRect( 80, 20, 120, 180 ) ), L"Xor_in" );
	region.Xor( CRleRegion( CRect( 80, 20, 120, 180 ) ) );
	Invalidate( false );
	saveRegion( region, L"Xor_out" );
}


void CIntelligenceView::OnBnClickedButton15()
{
	saveRegion( CRleRegion( CRect( 80, 20, 120, 180 ) ), L"Equal_in" );
	region.Equal( CRleRegion( CRect( 80, 20, 120, 180 ) ) );
	Invalidate( false );
	saveRegion( region, L"Equal_out" );
}
